/*
 * File:   main.c
 * Author: Sourav Gupta
 * By:- circuitdigest.com
 * Created on April 13, 2018, 2:26 PM
 */

// PIC16F877A Configuration Bit Settings

// 'C' source line config statements

// CONFIG
#pragma config FOSC = HS        // Oscillator Selection bits (HS oscillator)
#pragma config WDTE = OFF       // Watchdog Timer Enable bit (WDT disabled)
#pragma config PWRTE = OFF      // Power-up Timer Enable bit (PWRT disabled)
#pragma config BOREN = ON       // Brown-out Reset Enable bit (BOR enabled)
#pragma config LVP = OFF         // Low-Voltage (Single-Supply) In-Circuit Serial Programming Enable bit (RB3/PGM pin has PGM function; low-voltage programming enabled)
#pragma config CPD = OFF        // Data EEPROM Memory Code Protection bit (Data EEPROM code protection off)
#pragma config WRT = OFF        // Flash Program Memory Write Enable bits (Write protection off; all program memory may be written to by EECON control)
#pragma config CP = OFF         // Flash Program Memory Code Protection bit (Code protection off)



#include <xc.h>
#include <stdio.h>
#include <string.h>
#include "supporing_cfile/lcd.h"
#include "supporing_cfile/Keypad.h"

/*
 Hardware related definition
 */
#define _XTAL_FREQ 200000000 //Crystal Frequency, used in delay

/*
 Other Specific definition
 */
void system_init(void);     


void main(void){    
    system_init();
    char Key = 'n';
    lcd_com(0x80);
    lcd_puts("CircuitDigest");
    lcd_com(0xC0);
    while(1){
        Key = switch_press_scan();
        lcd_data(Key);
    }

}

/*
 *  System Init
 */


void system_init(void){
    TRISD = 0x00;
    lcd_init(); // This will initialise the lcd    
    InitKeypad();
}