//**Import the necessary header files**//
import android.content.Intent;
import android.os.Bundle;
import ketai.net.bluetooth.*;
import ketai.ui.*;
import ketai.net.*;
import ketai.camera.*;
import ketai.cv.facedetector.*;
import android.os.Environment;
import android.bluetooth.BluetoothAdapter;
import android.view.KeyEvent;
//__End of imports__//

BluetoothAdapter bluetooth = BluetoothAdapter.getDefaultAdapter();
KetaiBluetooth bt;

KetaiSimpleFace[] faces;
String directory;

KetaiCamera cam;

int posX,posY,i,info;
int pev_posX,pev_posY,pev_sec;
String cninfo = "";
boolean send_flag=true;


//**To start BT when app is launched**// 
void onCreate(Bundle savedInstanceState) {
 super.onCreate(savedInstanceState);
 bt = new KetaiBluetooth(this);
}
void onActivityResult(int requestCode, int resultCode, Intent data) {
  bt.onActivityResult(requestCode, resultCode, data);
}
//__BT launched__//


//**To select bluetooth device if needed**// (not required for our program
void onKetaiListSelection(KetaiList klist)
{
 String selection = klist.getSelection();
 bt.connectToDeviceByName(selection);
 //dispose of list for now
 klist = null;
}
//__End of selection__//


//** To get data from blue tooth**/
void onBluetoothDataEvent(String who, byte[] data)
{
info = (data[0] & 0xFF) ;
}
//__data received_//


//**To get connection status**//
String getBluetoothInformation()
{
  String btInfo = "Connected to :";

  ArrayList<String> devices = bt.getConnectedDeviceNames();
  for (String device: devices)
  {
    btInfo+= device+"\n";
  }

  return btInfo;
}
//--connection status received_//






void settings()
{fullScreen(P2D);
}

void setup() {
  bt.start(); //start listening for BT connections
  bt.getPairedDeviceNames();
  bt.connectToDeviceByName("HC-05"); //Connect to our HC-06 bluetooth module
  delay(2000);
  stroke(0, 255, 0);
  strokeWeight(8);
  noFill();
  textSize(38);
  rectMode(CENTER);
  imageMode(CENTER);
  cam = new KetaiCamera(this, 320, 240, 24);
  directory = new String(Environment.getExternalStorageDirectory().getAbsolutePath());
  
  cam.setCameraID(0);
  cam.setSaveDirectory(directory);
  cam.setPhotoSize(1280,720);
  cam.autoSettings();
  
}

void draw() {
  
 if (cam != null)
 {
       if (!cam.isStarted())
       cam.start();
            
       image(cam, width/2, height/2, width, height); //display CAM on phone screen 
       cam.loadPixels();
           
       faces = KetaiFaceDetector.findFaces(cam, 20);    //detect faces
       
       if(faces.length!=0) //if face found 
       {
       println("Faces found: " + faces.length); //notify the face detection on console 
        pev_posX=posX; posX = int(map(faces[0].location.x,20,300,1,100));
        pev_posY=posY; posY = int(map(faces[0].location.y,20,200,101,201));
        if(posX<=100 && posY>=101)
        {
        fill(#2C1BF5);
        textAlign(LEFT);
        text("X position(1-100): " + posX,(width/12),height/12);
        text("Y position(101-201): " + posY,(width/12),height/8);
        }
       }
        
              
        for ( i=0; i < faces.length; i++) // Box the faces and print its location
        {
        noFill();
        rect((faces[i].location.x)*width/320, (faces[i].location.y)*height/240, (2.5*faces[i].distance)*width/320, (3*faces[i].distance)*height/240);
        println(i,faces[i].location.x,faces[i].location.y); 
        }
        
      
      
}

textfun();




  if (send_flag==true && faces.length!=0 && pev_sec!=second()) //we can send data
  {
    pev_sec=second();
    
  if (pev_posX==posX)
  {
    if (posX<40)
    {byte[] data = {'1'}; bt.broadcast(data); println("LEFT");}
    
    if (posX>60)  
    {byte[] data = {'2'}; bt.broadcast(data); println("RIGHT");}
  }
  delay(500);
    if (pev_posY==posY)
  {
    if (posY<140)
    {byte[] data = {'3'}; bt.broadcast(data); println("UP");}
    
    if (posY>160)
    {byte[] data = {'4'}; bt.broadcast(data); println("DOWN");}
  }
  
  if (posX>40 && posX<60 && posY>140 &&posY<160)
  {byte[] data = {'5'}; bt.broadcast(data); println("No Change");}
  
send_flag=false; 
println("send from BT");
  }
  
  if (pev_sec!=second())
  send_flag=true;
  

  
}



void onCameraPreviewEvent()
{
  cam.read();
}


void onSavePhotoEvent( String filename) {
 cam.addToMediaLibrary(filename); 
 textAlign(CENTER);
}

public void mousePressed(){
  cam.savePhoto("CD_selfie.jpg");
  text("Photo captured",width/2,height/2);
  delay(2000);
}

void textfun()
{ 
  textSize(30);
  textAlign(CENTER);
  fill(255);
  cninfo = getBluetoothInformation();    //get connection information status
  text(cninfo,width/2,height-height/1.03);
  noFill();
}