/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PGraphics;
import processing.opengl.FrameBuffer;
import processing.opengl.PGL;
import processing.opengl.PGraphicsOpenGL;

public class Texture
implements PConstants {
    protected static final int TEX2D = 0;
    protected static final int TEXRECT = 1;
    protected static final int POINT = 2;
    protected static final int LINEAR = 3;
    protected static final int BILINEAR = 4;
    protected static final int TRILINEAR = 5;
    protected static final int MAX_UPDATES = 10;
    protected static final int MIN_MEMORY = 5;
    public int width;
    public int height;
    public int glName;
    public int glTarget;
    public int glFormat;
    public int glMinFilter;
    public int glMagFilter;
    public int glWrapS;
    public int glWrapT;
    public int glWidth;
    public int glHeight;
    private PGraphicsOpenGL.GLResourceTexture glres;
    protected PGraphicsOpenGL pg;
    protected PGL pgl;
    protected int context;
    protected boolean colorBuffer;
    protected boolean usingMipmaps;
    protected boolean usingRepeat;
    protected float maxTexcoordU;
    protected float maxTexcoordV;
    protected boolean bound;
    protected boolean invertedX;
    protected boolean invertedY;
    protected int[] rgbaPixels = null;
    protected IntBuffer pixelBuffer = null;
    protected int[] edgePixels = null;
    protected IntBuffer edgeBuffer = null;
    protected FrameBuffer tempFbo = null;
    protected int pixBufUpdateCount = 0;
    protected int rgbaPixUpdateCount = 0;
    protected boolean modified;
    protected int mx1;
    protected int my1;
    protected int mx2;
    protected int my2;
    protected Object bufferSource;
    protected LinkedList<BufferData> bufferCache = null;
    protected LinkedList<BufferData> usedBuffers = null;
    protected Method disposeBufferMethod;
    public static final int MAX_BUFFER_CACHE_SIZE = 3;

    public Texture(PGraphicsOpenGL pGraphicsOpenGL) {
        this.pg = pGraphicsOpenGL;
        this.pgl = pGraphicsOpenGL.pgl;
        this.context = this.pgl.createEmptyContext();
        this.colorBuffer = false;
        this.glName = 0;
    }

    public Texture(PGraphicsOpenGL pGraphicsOpenGL, int n, int n2) {
        this(pGraphicsOpenGL, n, n2, new Parameters());
    }

    public Texture(PGraphicsOpenGL pGraphicsOpenGL, int n, int n2, Object object) {
        this.pg = pGraphicsOpenGL;
        this.pgl = pGraphicsOpenGL.pgl;
        this.context = this.pgl.createEmptyContext();
        this.colorBuffer = false;
        this.glName = 0;
        this.init(n, n2, (Parameters)object);
    }

    public void init(int n, int n2) {
        Parameters parameters = 0 < this.glName ? this.getParameters() : new Parameters();
        this.init(n, n2, parameters);
    }

    public void init(int n, int n2, Parameters parameters) {
        this.setParameters(parameters);
        this.setSize(n, n2);
        this.allocate();
    }

    public void init(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        this.width = n;
        this.height = n2;
        this.glName = n3;
        this.glTarget = n4;
        this.glFormat = n5;
        this.glWidth = n6;
        this.glHeight = n7;
        this.glMinFilter = n8;
        this.glMagFilter = n9;
        this.glWrapS = n10;
        this.glWrapT = n11;
        this.maxTexcoordU = (float)n / (float)n6;
        this.maxTexcoordV = (float)n2 / (float)n7;
        this.usingMipmaps = n8 == PGL.LINEAR_MIPMAP_NEAREST || n8 == PGL.LINEAR_MIPMAP_LINEAR;
        this.usingRepeat = n10 == PGL.REPEAT || n11 == PGL.REPEAT;
    }

    public void resize(int n, int n2) {
        this.dispose();
        Texture texture = new Texture(this.pg, n, n2, this.getParameters());
        texture.set(this);
        this.copyObject(texture);
        this.tempFbo = null;
    }

    public boolean available() {
        return 0 < this.glName;
    }

    public void set(Texture texture) {
        this.copyTexture(texture, 0, 0, texture.width, texture.height, true);
    }

    public void set(Texture texture, int n, int n2, int n3, int n4) {
        this.copyTexture(texture, n, n2, n3, n4, true);
    }

    public void set(int n, int n2, int n3, int n4, int n5, int n6) {
        this.copyTexture(n, n2, n3, n4, 0, 0, n5, n6, true);
    }

    public void set(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this.copyTexture(n, n2, n3, n4, n7, n8, n9, n10, true);
    }

    public void set(int[] nArray) {
        this.set(nArray, 0, 0, this.width, this.height, 2);
    }

    public void set(int[] nArray, int n) {
        this.set(nArray, 0, 0, this.width, this.height, n);
    }

    public void set(int[] nArray, int n, int n2, int n3, int n4) {
        this.set(nArray, n, n2, n3, n4, 2);
    }

    public void set(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        if (nArray == null) {
            PGraphics.showWarning("The pixels array is null.");
            return;
        }
        if (nArray.length < n3 * n4) {
            PGraphics.showWarning("The pixel array has a length of " + nArray.length + ", but it should be at least " + n3 * n4);
            return;
        }
        if (nArray.length == 0 || n3 == 0 || n4 == 0) {
            return;
        }
        boolean bl = false;
        if (!this.pgl.texturingIsEnabled(this.glTarget)) {
            this.pgl.enableTexturing(this.glTarget);
            bl = true;
        }
        this.pgl.bindTexture(this.glTarget, this.glName);
        this.loadPixels(n3 * n4);
        this.convertToRGBA(nArray, n5, n3, n4);
        this.updatePixelBuffer(this.rgbaPixels);
        this.pgl.texSubImage2D(this.glTarget, 0, n, n2, n3, n4, PGL.RGBA, PGL.UNSIGNED_BYTE, this.pixelBuffer);
        this.fillEdges(n, n2, n3, n4);
        if (this.usingMipmaps) {
            if (PGraphicsOpenGL.autoMipmapGenSupported) {
                this.pgl.generateMipmap(this.glTarget);
            } else {
                this.manualMipmap();
            }
        }
        this.pgl.bindTexture(this.glTarget, 0);
        if (bl) {
            this.pgl.disableTexturing(this.glTarget);
        }
        this.releasePixelBuffer();
        this.releaseRGBAPixels();
        this.updateTexels(n, n2, n3, n4);
    }

    public void setNative(int[] nArray) {
        this.setNative(nArray, 0, 0, this.width, this.height);
    }

    public void setNative(int[] nArray, int n, int n2, int n3, int n4) {
        this.updatePixelBuffer(nArray);
        this.setNative(this.pixelBuffer, n, n2, n3, n4);
        this.releasePixelBuffer();
    }

    public void setNative(IntBuffer intBuffer, int n, int n2, int n3, int n4) {
        if (intBuffer == null) {
            intBuffer = null;
            PGraphics.showWarning("The pixel buffer is null.");
            return;
        }
        if (intBuffer.capacity() < n3 * n4) {
            PGraphics.showWarning("The pixel bufer has a length of " + intBuffer.capacity() + ", but it should be at least " + n3 * n4);
            return;
        }
        if (intBuffer.capacity() == 0) {
            return;
        }
        boolean bl = false;
        if (!this.pgl.texturingIsEnabled(this.glTarget)) {
            this.pgl.enableTexturing(this.glTarget);
            bl = true;
        }
        this.pgl.bindTexture(this.glTarget, this.glName);
        this.pgl.texSubImage2D(this.glTarget, 0, n, n2, n3, n4, PGL.RGBA, PGL.UNSIGNED_BYTE, intBuffer);
        this.fillEdges(n, n2, n3, n4);
        if (this.usingMipmaps) {
            if (PGraphicsOpenGL.autoMipmapGenSupported) {
                this.pgl.generateMipmap(this.glTarget);
            } else {
                this.manualMipmap();
            }
        }
        this.pgl.bindTexture(this.glTarget, 0);
        if (bl) {
            this.pgl.disableTexturing(this.glTarget);
        }
        this.updateTexels(n, n2, n3, n4);
    }

    public void get(int[] nArray) {
        if (nArray == null) {
            throw new RuntimeException("Trying to copy texture to null pixels array");
        }
        if (nArray.length != this.width * this.height) {
            throw new RuntimeException("Trying to copy texture to pixels array of wrong size");
        }
        if (this.tempFbo == null) {
            this.tempFbo = new FrameBuffer(this.pg, this.glWidth, this.glHeight);
        }
        this.tempFbo.setColorBuffer(this);
        this.pg.pushFramebuffer();
        this.pg.setFramebuffer(this.tempFbo);
        this.tempFbo.readPixels();
        this.pg.popFramebuffer();
        this.tempFbo.getPixels(nArray);
        this.convertToARGB(nArray);
        if (this.invertedX) {
            this.flipArrayOnX(nArray, 1);
        }
        if (this.invertedY) {
            this.flipArrayOnY(nArray, 1);
        }
    }

    public void put(Texture texture) {
        this.copyTexture(texture, 0, 0, texture.width, texture.height, false);
    }

    public void put(Texture texture, int n, int n2, int n3, int n4) {
        this.copyTexture(texture, n, n2, n3, n4, false);
    }

    public void put(int n, int n2, int n3, int n4, int n5, int n6) {
        this.copyTexture(n, n2, n3, n4, 0, 0, n5, n6, false);
    }

    public void put(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this.copyTexture(n, n2, n3, n4, n7, n8, n9, n10, false);
    }

    public boolean usingMipmaps() {
        return this.usingMipmaps;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void usingMipmaps(boolean bl, int n) {
        int n2 = this.glMagFilter;
        int n3 = this.glMinFilter;
        if (bl) {
            if (n == 2) {
                this.glMagFilter = PGL.NEAREST;
                this.glMinFilter = PGL.NEAREST;
                this.usingMipmaps = false;
            } else if (n == 3) {
                this.glMagFilter = PGL.NEAREST;
                this.glMinFilter = PGL.MIPMAPS_ENABLED ? PGL.LINEAR_MIPMAP_NEAREST : PGL.LINEAR;
                this.usingMipmaps = true;
            } else if (n == 4) {
                this.glMagFilter = PGL.LINEAR;
                this.glMinFilter = PGL.MIPMAPS_ENABLED ? PGL.LINEAR_MIPMAP_NEAREST : PGL.LINEAR;
                this.usingMipmaps = true;
            } else {
                if (n != 5) throw new RuntimeException("Unknown texture filtering mode");
                this.glMagFilter = PGL.LINEAR;
                this.glMinFilter = PGL.MIPMAPS_ENABLED ? PGL.LINEAR_MIPMAP_LINEAR : PGL.LINEAR;
                this.usingMipmaps = true;
            }
        } else {
            this.usingMipmaps = false;
            if (n == 2) {
                this.glMagFilter = PGL.NEAREST;
                this.glMinFilter = PGL.NEAREST;
            } else if (n == 3) {
                this.glMagFilter = PGL.NEAREST;
                this.glMinFilter = PGL.LINEAR;
            } else {
                if (n != 4 && n != 5) throw new RuntimeException("Unknown texture filtering mode");
                this.glMagFilter = PGL.LINEAR;
                this.glMinFilter = PGL.LINEAR;
            }
        }
        if (n2 == this.glMagFilter && n3 == this.glMinFilter) return;
        this.bind();
        this.pgl.texParameteri(this.glTarget, PGL.TEXTURE_MIN_FILTER, this.glMinFilter);
        this.pgl.texParameteri(this.glTarget, PGL.TEXTURE_MAG_FILTER, this.glMagFilter);
        if (this.usingMipmaps) {
            if (PGraphicsOpenGL.autoMipmapGenSupported) {
                this.pgl.generateMipmap(this.glTarget);
            } else {
                this.manualMipmap();
            }
        }
        this.unbind();
    }

    public boolean usingRepeat() {
        return this.usingRepeat;
    }

    public void usingRepeat(boolean bl) {
        if (bl) {
            this.glWrapS = PGL.REPEAT;
            this.glWrapT = PGL.REPEAT;
            this.usingRepeat = true;
        } else {
            this.glWrapS = PGL.CLAMP_TO_EDGE;
            this.glWrapT = PGL.CLAMP_TO_EDGE;
            this.usingRepeat = false;
        }
        this.bind();
        this.pgl.texParameteri(this.glTarget, PGL.TEXTURE_WRAP_S, this.glWrapS);
        this.pgl.texParameteri(this.glTarget, PGL.TEXTURE_WRAP_T, this.glWrapT);
        this.unbind();
    }

    public float maxTexcoordU() {
        return this.maxTexcoordU;
    }

    public float maxTexcoordV() {
        return this.maxTexcoordV;
    }

    public boolean invertedX() {
        return this.invertedX;
    }

    public void invertedX(boolean bl) {
        this.invertedX = bl;
    }

    public boolean invertedY() {
        return this.invertedY;
    }

    public void invertedY(boolean bl) {
        this.invertedY = bl;
    }

    public int currentSampling() {
        if (this.glMagFilter == PGL.NEAREST && this.glMinFilter == PGL.NEAREST) {
            return 2;
        }
        if (this.glMagFilter == PGL.NEAREST && this.glMinFilter == (PGL.MIPMAPS_ENABLED ? PGL.LINEAR_MIPMAP_NEAREST : PGL.LINEAR)) {
            return 3;
        }
        if (this.glMagFilter == PGL.LINEAR && this.glMinFilter == (PGL.MIPMAPS_ENABLED ? PGL.LINEAR_MIPMAP_NEAREST : PGL.LINEAR)) {
            return 4;
        }
        if (this.glMagFilter == PGL.LINEAR && this.glMinFilter == PGL.LINEAR_MIPMAP_LINEAR) {
            return 5;
        }
        return -1;
    }

    public void bind() {
        if (!this.pgl.texturingIsEnabled(this.glTarget)) {
            this.pgl.enableTexturing(this.glTarget);
        }
        this.pgl.bindTexture(this.glTarget, this.glName);
        this.bound = true;
    }

    public void unbind() {
        if (this.pgl.textureIsBound(this.glTarget, this.glName)) {
            if (!this.pgl.texturingIsEnabled(this.glTarget)) {
                this.pgl.enableTexturing(this.glTarget);
                this.pgl.bindTexture(this.glTarget, 0);
                this.pgl.disableTexturing(this.glTarget);
            } else {
                this.pgl.bindTexture(this.glTarget, 0);
            }
        }
        this.bound = false;
    }

    public boolean bound() {
        return this.bound;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified() {
        this.modified = true;
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public int getModifiedX1() {
        return this.mx1;
    }

    public int getModifiedX2() {
        return this.mx2;
    }

    public int getModifiedY1() {
        return this.my1;
    }

    public int getModifiedY2() {
        return this.my2;
    }

    public void updateTexels() {
        this.updateTexelsImpl(0, 0, this.width, this.height);
    }

    public void updateTexels(int n, int n2, int n3, int n4) {
        this.updateTexelsImpl(n, n2, n3, n4);
    }

    protected void updateTexelsImpl(int n, int n2, int n3, int n4) {
        int n5 = n + n3;
        int n6 = n2 + n4;
        if (!this.modified) {
            this.mx1 = PApplet.max(0, n);
            this.mx2 = PApplet.min(this.width - 1, n5);
            this.my1 = PApplet.max(0, n2);
            this.my2 = PApplet.min(this.height - 1, n6);
            this.modified = true;
        } else {
            if (n < this.mx1) {
                this.mx1 = PApplet.max(0, n);
            }
            if (n > this.mx2) {
                this.mx2 = PApplet.min(this.width - 1, n);
            }
            if (n2 < this.my1) {
                this.my1 = PApplet.max(0, n2);
            }
            if (n2 > this.my2) {
                this.my2 = n2;
            }
            if (n5 < this.mx1) {
                this.mx1 = PApplet.max(0, n5);
            }
            if (n5 > this.mx2) {
                this.mx2 = PApplet.min(this.width - 1, n5);
            }
            if (n6 < this.my1) {
                this.my1 = PApplet.max(0, n6);
            }
            if (n6 > this.my2) {
                this.my2 = PApplet.min(this.height - 1, n6);
            }
        }
    }

    protected void loadPixels(int n) {
        if (this.rgbaPixels == null || this.rgbaPixels.length < n) {
            this.rgbaPixels = new int[n];
        }
    }

    protected void updatePixelBuffer(int[] nArray) {
        this.pixelBuffer = PGL.updateIntBuffer(this.pixelBuffer, nArray, true);
        ++this.pixBufUpdateCount;
    }

    protected void manualMipmap() {
    }

    public void setBufferSource(Object object) {
        this.bufferSource = object;
        this.getSourceMethods();
    }

    public void copyBufferFromSource(Object object, ByteBuffer byteBuffer, int n, int n2) {
        if (this.bufferCache == null) {
            this.bufferCache = new LinkedList();
        }
        if (this.bufferCache.size() + 1 <= 3) {
            this.bufferCache.add(new BufferData(object, byteBuffer.asIntBuffer(), n, n2));
        } else {
            try {
                this.usedBuffers.add(new BufferData(object, byteBuffer.asIntBuffer(), n, n2));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void disposeSourceBuffer() {
        if (this.usedBuffers == null) {
            return;
        }
        while (0 < this.usedBuffers.size()) {
            BufferData bufferData = null;
            try {
                bufferData = this.usedBuffers.remove(0);
            }
            catch (NoSuchElementException noSuchElementException) {
                PGraphics.showWarning("Cannot remove used buffer");
            }
            if (bufferData == null) continue;
            bufferData.dispose();
        }
    }

    public void getBufferPixels(int[] nArray) {
        BufferData bufferData = null;
        if (this.usedBuffers != null && 0 < this.usedBuffers.size()) {
            bufferData = this.usedBuffers.getLast();
        } else if (this.bufferCache != null && 0 < this.bufferCache.size()) {
            bufferData = this.bufferCache.getLast();
        }
        if (bufferData != null) {
            if (bufferData.w != this.width || bufferData.h != this.height) {
                this.init(bufferData.w, bufferData.h);
            }
            bufferData.rgbBuf.rewind();
            bufferData.rgbBuf.get(nArray);
            this.convertToARGB(nArray);
            if (this.usedBuffers == null) {
                this.usedBuffers = new LinkedList();
            }
            while (0 < this.bufferCache.size()) {
                bufferData = this.bufferCache.remove(0);
                this.usedBuffers.add(bufferData);
            }
        }
    }

    public boolean hasBufferSource() {
        return this.bufferSource != null;
    }

    public boolean hasBuffers() {
        return this.bufferSource != null && this.bufferCache != null && 0 < this.bufferCache.size();
    }

    protected boolean bufferUpdate() {
        BufferData bufferData = null;
        try {
            bufferData = this.bufferCache.remove(0);
        }
        catch (NoSuchElementException noSuchElementException) {
            PGraphics.showWarning("Don't have pixel data to copy to texture");
        }
        if (bufferData != null) {
            if (bufferData.w != this.width || bufferData.h != this.height) {
                this.init(bufferData.w, bufferData.h);
            }
            bufferData.rgbBuf.rewind();
            this.setNative(bufferData.rgbBuf, 0, 0, this.width, this.height);
            if (this.usedBuffers == null) {
                this.usedBuffers = new LinkedList();
            }
            this.usedBuffers.add(bufferData);
            return true;
        }
        return false;
    }

    protected void getSourceMethods() {
        try {
            this.disposeBufferMethod = this.bufferSource.getClass().getMethod("disposeBuffer", Object.class);
        }
        catch (Exception exception) {
            throw new RuntimeException("Provided source object doesn't have a disposeBuffer method.");
        }
    }

    protected void flipArrayOnX(int[] nArray, int n) {
        int n2 = 0;
        int n3 = n * (this.width - 1);
        for (int i = 0; i < this.width / 2; ++i) {
            for (int j = 0; j < this.height; ++j) {
                int n4 = n2 + n * j * this.width;
                int n5 = n3 + n * j * this.width;
                for (int k = 0; k < n; ++k) {
                    int n6 = nArray[n4];
                    nArray[n4] = nArray[n5];
                    nArray[n5] = n6;
                    ++n4;
                    ++n5;
                }
            }
            n2 += n;
            n3 -= n;
        }
    }

    protected void flipArrayOnY(int[] nArray, int n) {
        int n2 = 0;
        int n3 = n * (this.height - 1) * this.width;
        for (int i = 0; i < this.height / 2; ++i) {
            for (int j = 0; j < n * this.width; ++j) {
                int n4 = nArray[n2];
                nArray[n2] = nArray[n3];
                nArray[n3] = n4;
                ++n2;
                ++n3;
            }
            n3 -= n * this.width * 2;
        }
    }

    protected void convertToRGBA(int[] nArray, int n, int n2, int n3) {
        block17: {
            block16: {
                if (!PGL.BIG_ENDIAN) break block16;
                switch (n) {
                    case 4: {
                        for (int i = 0; i < nArray.length; ++i) {
                            this.rgbaPixels[i] = 0xFFFFFF00 | nArray[i];
                        }
                        break block17;
                    }
                    case 1: {
                        for (int i = 0; i < nArray.length; ++i) {
                            int n4 = nArray[i];
                            this.rgbaPixels[i] = n4 << 8 | 0xFF;
                        }
                        break block17;
                    }
                    case 2: {
                        for (int i = 0; i < nArray.length; ++i) {
                            int n5 = nArray[i];
                            this.rgbaPixels[i] = n5 << 8 | n5 >> 24 & 0xFF;
                        }
                        break;
                    }
                }
                break block17;
            }
            switch (n) {
                case 4: {
                    for (int i = 0; i < nArray.length; ++i) {
                        this.rgbaPixels[i] = nArray[i] << 24 | 0xFFFFFF;
                    }
                    break;
                }
                case 1: {
                    for (int i = 0; i < nArray.length; ++i) {
                        int n6 = nArray[i];
                        this.rgbaPixels[i] = 0xFF000000 | (n6 & 0xFF) << 16 | (n6 & 0xFF0000) >> 16 | n6 & 0xFF00;
                    }
                    break;
                }
                case 2: {
                    for (int i = 0; i < nArray.length; ++i) {
                        int n7 = nArray[i];
                        this.rgbaPixels[i] = (n7 & 0xFF) << 16 | (n7 & 0xFF0000) >> 16 | n7 & 0xFF00FF00;
                    }
                    break;
                }
            }
        }
        ++this.rgbaPixUpdateCount;
    }

    protected void convertToARGB(int[] nArray) {
        int n = 0;
        int n2 = 0;
        if (PGL.BIG_ENDIAN) {
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    int n3 = nArray[n2++];
                    nArray[n++] = n3 >>> 8 | n3 << 24 & 0xFF000000;
                }
            }
        } else {
            for (int i = 0; i < this.height; ++i) {
                for (int j = 0; j < this.width; ++j) {
                    int n4 = nArray[n2++];
                    nArray[n++] = (n4 & 0xFF) << 16 | (n4 & 0xFF0000) >> 16 | n4 & 0xFF00FF00;
                }
            }
        }
    }

    protected void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
        if (PGraphicsOpenGL.npotTexSupported) {
            this.glWidth = n;
            this.glHeight = n2;
        } else {
            this.glWidth = PGL.nextPowerOfTwo(n);
            this.glHeight = PGL.nextPowerOfTwo(n2);
        }
        if (this.glWidth > PGraphicsOpenGL.maxTextureSize || this.glHeight > PGraphicsOpenGL.maxTextureSize) {
            this.glHeight = 0;
            this.glWidth = 0;
            throw new RuntimeException("Image width and height cannot be larger than " + PGraphicsOpenGL.maxTextureSize + " with this graphics card.");
        }
        this.maxTexcoordU = (float)this.width / (float)this.glWidth;
        this.maxTexcoordV = (float)this.height / (float)this.glHeight;
    }

    protected void allocate() {
        this.dispose();
        boolean bl = false;
        if (!this.pgl.texturingIsEnabled(this.glTarget)) {
            this.pgl.enableTexturing(this.glTarget);
            bl = true;
        }
        this.context = this.pgl.getCurrentContext();
        this.glres = new PGraphicsOpenGL.GLResourceTexture(this);
        this.pgl.bindTexture(this.glTarget, this.glName);
        this.pgl.texParameteri(this.glTarget, PGL.TEXTURE_MIN_FILTER, this.glMinFilter);
        this.pgl.texParameteri(this.glTarget, PGL.TEXTURE_MAG_FILTER, this.glMagFilter);
        this.pgl.texParameteri(this.glTarget, PGL.TEXTURE_WRAP_S, this.glWrapS);
        this.pgl.texParameteri(this.glTarget, PGL.TEXTURE_WRAP_T, this.glWrapT);
        if (PGraphicsOpenGL.anisoSamplingSupported) {
            this.pgl.texParameterf(this.glTarget, PGL.TEXTURE_MAX_ANISOTROPY, PGraphicsOpenGL.maxAnisoAmount);
        }
        this.pgl.texImage2D(this.glTarget, 0, this.glFormat, this.glWidth, this.glHeight, 0, PGL.RGBA, PGL.UNSIGNED_BYTE, null);
        this.pgl.initTexture(this.glTarget, PGL.RGBA, this.width, this.height);
        this.pgl.bindTexture(this.glTarget, 0);
        if (bl) {
            this.pgl.disableTexturing(this.glTarget);
        }
        this.bound = false;
    }

    protected void dispose() {
        if (this.glres != null) {
            this.glres.dispose();
            this.glres = null;
            this.glName = 0;
        }
    }

    protected boolean contextIsOutdated() {
        boolean bl;
        boolean bl2 = bl = !this.pgl.contextIsCurrent(this.context);
        if (bl) {
            this.dispose();
        }
        return bl;
    }

    public void colorBuffer(boolean bl) {
        this.colorBuffer = bl;
    }

    public boolean colorBuffer() {
        return this.colorBuffer;
    }

    protected void copyTexture(Texture texture, int n, int n2, int n3, int n4, boolean bl) {
        if (texture == null) {
            throw new RuntimeException("Source texture is null");
        }
        if (this.tempFbo == null) {
            this.tempFbo = new FrameBuffer(this.pg, this.glWidth, this.glHeight);
        }
        this.tempFbo.setColorBuffer(this);
        this.tempFbo.disableDepthTest();
        this.pg.pushFramebuffer();
        this.pg.setFramebuffer(this.tempFbo);
        this.pg.pushStyle();
        this.pg.blendMode(0);
        if (bl) {
            this.pgl.drawTexture(texture.glTarget, texture.glName, texture.glWidth, texture.glHeight, 0, 0, this.tempFbo.width, this.tempFbo.height, 1, n, n2, n + n3, n2 + n4, 0, 0, this.width, this.height);
        } else {
            this.pgl.drawTexture(texture.glTarget, texture.glName, texture.glWidth, texture.glHeight, 0, 0, this.tempFbo.width, this.tempFbo.height, 1, n, n2, n + n3, n2 + n4, n, n2, n + n3, n2 + n4);
        }
        this.pgl.flush();
        this.pg.popStyle();
        this.pg.popFramebuffer();
        this.updateTexels(n, n2, n3, n4);
    }

    protected void copyTexture(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        if (this.tempFbo == null) {
            this.tempFbo = new FrameBuffer(this.pg, this.glWidth, this.glHeight);
        }
        this.tempFbo.setColorBuffer(this);
        this.tempFbo.disableDepthTest();
        this.pg.pushFramebuffer();
        this.pg.setFramebuffer(this.tempFbo);
        this.pg.pushStyle();
        this.pg.blendMode(0);
        if (bl) {
            this.pgl.drawTexture(n, n2, n3, n4, 0, 0, this.tempFbo.width, this.tempFbo.height, n5, n6, n7, n8, 0, 0, this.width, this.height);
        } else {
            this.pgl.drawTexture(n, n2, n3, n4, 0, 0, this.tempFbo.width, this.tempFbo.height, n5, n6, n7, n8, n5, n6, n7, n8);
        }
        this.pgl.flush();
        this.pg.popStyle();
        this.pg.popFramebuffer();
        this.updateTexels(n5, n6, n7, n8);
    }

    protected void copyObject(Texture texture) {
        this.dispose();
        this.width = texture.width;
        this.height = texture.height;
        this.glName = texture.glName;
        this.glTarget = texture.glTarget;
        this.glFormat = texture.glFormat;
        this.glMinFilter = texture.glMinFilter;
        this.glMagFilter = texture.glMagFilter;
        this.glWidth = texture.glWidth;
        this.glHeight = texture.glHeight;
        this.usingMipmaps = texture.usingMipmaps;
        this.usingRepeat = texture.usingRepeat;
        this.maxTexcoordU = texture.maxTexcoordU;
        this.maxTexcoordV = texture.maxTexcoordV;
        this.invertedX = texture.invertedX;
        this.invertedY = texture.invertedY;
    }

    protected void releasePixelBuffer() {
        double d = (double)Runtime.getRuntime().freeMemory() / 1000000.0;
        if (this.pixBufUpdateCount < 10 || d < 5.0) {
            this.pixelBuffer = null;
        }
    }

    protected void releaseRGBAPixels() {
        double d = (double)Runtime.getRuntime().freeMemory() / 1000000.0;
        if (this.rgbaPixUpdateCount < 10 || d < 5.0) {
            this.rgbaPixels = null;
        }
    }

    public Parameters getParameters() {
        Parameters parameters = new Parameters();
        if (this.glTarget == PGL.TEXTURE_2D) {
            parameters.target = 0;
        }
        if (this.glFormat == PGL.RGB) {
            parameters.format = 1;
        } else if (this.glFormat == PGL.RGBA) {
            parameters.format = 2;
        } else if (this.glFormat == PGL.ALPHA) {
            parameters.format = 4;
        }
        if (this.glMagFilter == PGL.NEAREST && this.glMinFilter == PGL.NEAREST) {
            parameters.sampling = 2;
            parameters.mipmaps = false;
        } else if (this.glMagFilter == PGL.NEAREST && this.glMinFilter == PGL.LINEAR) {
            parameters.sampling = 3;
            parameters.mipmaps = false;
        } else if (this.glMagFilter == PGL.NEAREST && this.glMinFilter == PGL.LINEAR_MIPMAP_NEAREST) {
            parameters.sampling = 3;
            parameters.mipmaps = true;
        } else if (this.glMagFilter == PGL.LINEAR && this.glMinFilter == PGL.LINEAR) {
            parameters.sampling = 4;
            parameters.mipmaps = false;
        } else if (this.glMagFilter == PGL.LINEAR && this.glMinFilter == PGL.LINEAR_MIPMAP_NEAREST) {
            parameters.sampling = 4;
            parameters.mipmaps = true;
        } else if (this.glMagFilter == PGL.LINEAR && this.glMinFilter == PGL.LINEAR_MIPMAP_LINEAR) {
            parameters.sampling = 5;
            parameters.mipmaps = true;
        }
        if (this.glWrapS == PGL.CLAMP_TO_EDGE) {
            parameters.wrapU = 0;
        } else if (this.glWrapS == PGL.REPEAT) {
            parameters.wrapU = 1;
        }
        if (this.glWrapT == PGL.CLAMP_TO_EDGE) {
            parameters.wrapV = 0;
        } else if (this.glWrapT == PGL.REPEAT) {
            parameters.wrapV = 1;
        }
        return parameters;
    }

    protected void setParameters(Parameters parameters) {
        boolean bl;
        if (parameters.target != 0) {
            throw new RuntimeException("Unknown texture target");
        }
        this.glTarget = PGL.TEXTURE_2D;
        if (parameters.format == 1) {
            this.glFormat = PGL.RGB;
        } else if (parameters.format == 2) {
            this.glFormat = PGL.RGBA;
        } else if (parameters.format == 4) {
            this.glFormat = PGL.ALPHA;
        } else {
            throw new RuntimeException("Unknown texture format");
        }
        boolean bl2 = bl = parameters.mipmaps && PGL.MIPMAPS_ENABLED;
        if (bl && !PGraphicsOpenGL.autoMipmapGenSupported) {
            PGraphics.showWarning("Mipmaps were requested but automatic mipmap generation is not supported and manual generation still not implemented, so mipmaps will be disabled.");
            bl = false;
        }
        if (parameters.sampling == 2) {
            this.glMagFilter = PGL.NEAREST;
            this.glMinFilter = PGL.NEAREST;
        } else if (parameters.sampling == 3) {
            this.glMagFilter = PGL.NEAREST;
            this.glMinFilter = bl ? PGL.LINEAR_MIPMAP_NEAREST : PGL.LINEAR;
        } else if (parameters.sampling == 4) {
            this.glMagFilter = PGL.LINEAR;
            this.glMinFilter = bl ? PGL.LINEAR_MIPMAP_NEAREST : PGL.LINEAR;
        } else if (parameters.sampling == 5) {
            this.glMagFilter = PGL.LINEAR;
            this.glMinFilter = bl ? PGL.LINEAR_MIPMAP_LINEAR : PGL.LINEAR;
        } else {
            throw new RuntimeException("Unknown texture filtering mode");
        }
        if (parameters.wrapU == 0) {
            this.glWrapS = PGL.CLAMP_TO_EDGE;
        } else if (parameters.wrapU == 1) {
            this.glWrapS = PGL.REPEAT;
        } else {
            throw new RuntimeException("Unknown wrapping mode");
        }
        if (parameters.wrapV == 0) {
            this.glWrapT = PGL.CLAMP_TO_EDGE;
        } else if (parameters.wrapV == 1) {
            this.glWrapT = PGL.REPEAT;
        } else {
            throw new RuntimeException("Unknown wrapping mode");
        }
        this.usingMipmaps = this.glMinFilter == PGL.LINEAR_MIPMAP_NEAREST || this.glMinFilter == PGL.LINEAR_MIPMAP_LINEAR;
        this.usingRepeat = this.glWrapS == PGL.REPEAT || this.glWrapT == PGL.REPEAT;
        this.invertedX = false;
        this.invertedY = false;
    }

    protected void fillEdges(int n, int n2, int n3, int n4) {
        if (!(this.width >= this.glWidth && this.height >= this.glHeight || n + n3 != this.width && n2 + n4 != this.height)) {
            int n5;
            int n6;
            int n7;
            if (n + n3 == this.width) {
                n7 = this.glWidth - this.width;
                this.edgePixels = new int[n4 * n7];
                for (n6 = 0; n6 < n4; ++n6) {
                    n5 = this.rgbaPixels[n6 * n3 + (n3 - 1)];
                    Arrays.fill(this.edgePixels, n6 * n7, (n6 + 1) * n7, n5);
                }
                this.edgeBuffer = PGL.updateIntBuffer(this.edgeBuffer, this.edgePixels, true);
                this.pgl.texSubImage2D(this.glTarget, 0, this.width, n2, n7, n4, PGL.RGBA, PGL.UNSIGNED_BYTE, this.edgeBuffer);
            }
            if (n2 + n4 == this.height) {
                n7 = this.glHeight - this.height;
                this.edgePixels = new int[n7 * n3];
                for (n6 = 0; n6 < n7; ++n6) {
                    System.arraycopy(this.rgbaPixels, (n4 - 1) * n3, this.edgePixels, n6 * n3, n3);
                }
                this.edgeBuffer = PGL.updateIntBuffer(this.edgeBuffer, this.edgePixels, true);
                this.pgl.texSubImage2D(this.glTarget, 0, n, this.height, n3, n7, PGL.RGBA, PGL.UNSIGNED_BYTE, this.edgeBuffer);
            }
            if (n + n3 == this.width && n2 + n4 == this.height) {
                n7 = this.glWidth - this.width;
                n6 = this.glHeight - this.height;
                n5 = this.rgbaPixels[n3 * n4 - 1];
                this.edgePixels = new int[n6 * n7];
                Arrays.fill(this.edgePixels, 0, n6 * n7, n5);
                this.edgeBuffer = PGL.updateIntBuffer(this.edgeBuffer, this.edgePixels, true);
                this.pgl.texSubImage2D(this.glTarget, 0, this.width, this.height, n7, n6, PGL.RGBA, PGL.UNSIGNED_BYTE, this.edgeBuffer);
            }
        }
    }

    protected class BufferData {
        int w;
        int h;
        Object natBuf;
        IntBuffer rgbBuf;

        BufferData(Object object, IntBuffer intBuffer, int n, int n2) {
            this.natBuf = object;
            this.rgbBuf = intBuffer;
            this.w = n;
            this.h = n2;
        }

        void dispose() {
            try {
                Texture.this.disposeBufferMethod.invoke(Texture.this.bufferSource, this.natBuf);
                this.natBuf = null;
                this.rgbBuf = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static class Parameters {
        public int target;
        public int format;
        public int sampling;
        public boolean mipmaps;
        public int wrapU;
        public int wrapV;

        public Parameters() {
            this.target = 0;
            this.format = 2;
            this.sampling = 4;
            this.mipmaps = true;
            this.wrapU = 0;
            this.wrapV = 0;
        }

        public Parameters(int n) {
            this.target = 0;
            this.format = n;
            this.sampling = 4;
            this.mipmaps = true;
            this.wrapU = 0;
            this.wrapV = 0;
        }

        public Parameters(int n, int n2) {
            this.target = 0;
            this.format = n;
            this.sampling = n2;
            this.mipmaps = true;
            this.wrapU = 0;
            this.wrapV = 0;
        }

        public Parameters(int n, int n2, boolean bl) {
            this.target = 0;
            this.format = n;
            this.mipmaps = bl;
            this.sampling = n2 == 5 && !bl ? 4 : n2;
            this.wrapU = 0;
            this.wrapV = 0;
        }

        public Parameters(int n, int n2, boolean bl, int n3) {
            this.target = 0;
            this.format = n;
            this.mipmaps = bl;
            this.sampling = n2 == 5 && !bl ? 4 : n2;
            this.wrapU = n3;
            this.wrapV = n3;
        }

        public Parameters(Parameters parameters) {
            this.set(parameters);
        }

        public void set(int n) {
            this.format = n;
        }

        public void set(int n, int n2) {
            this.format = n;
            this.sampling = n2;
        }

        public void set(int n, int n2, boolean bl) {
            this.format = n;
            this.sampling = n2;
            this.mipmaps = bl;
        }

        public void set(Parameters parameters) {
            this.target = parameters.target;
            this.format = parameters.format;
            this.sampling = parameters.sampling;
            this.mipmaps = parameters.mipmaps;
            this.wrapU = parameters.wrapU;
            this.wrapV = parameters.wrapV;
        }
    }
}

