/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import java.net.URL;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;
import processing.core.PVector;
import processing.opengl.PGL;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.Texture;

public class PShader
implements PConstants {
    protected static final int POINT = 0;
    protected static final int LINE = 1;
    protected static final int POLY = 2;
    protected static final int COLOR = 3;
    protected static final int LIGHT = 4;
    protected static final int TEXTURE = 5;
    protected static final int TEXLIGHT = 6;
    protected static String pointShaderAttrRegexp = "attribute *vec2 *offset";
    protected static String pointShaderInRegexp = "in *vec2 *offset;";
    protected static String lineShaderAttrRegexp = "attribute *vec4 *direction";
    protected static String lineShaderInRegexp = "in *vec4 *direction";
    protected static String pointShaderDefRegexp = "#define *PROCESSING_POINT_SHADER";
    protected static String lineShaderDefRegexp = "#define *PROCESSING_LINE_SHADER";
    protected static String colorShaderDefRegexp = "#define *PROCESSING_COLOR_SHADER";
    protected static String lightShaderDefRegexp = "#define *PROCESSING_LIGHT_SHADER";
    protected static String texShaderDefRegexp = "#define *PROCESSING_TEXTURE_SHADER";
    protected static String texlightShaderDefRegexp = "#define *PROCESSING_TEXLIGHT_SHADER";
    protected static String polyShaderDefRegexp = "#define *PROCESSING_POLYGON_SHADER";
    protected static String triShaderAttrRegexp = "#define *PROCESSING_TRIANGLES_SHADER";
    protected static String quadShaderAttrRegexp = "#define *PROCESSING_QUADS_SHADER";
    protected PApplet parent;
    protected PGraphicsOpenGL primaryPG;
    protected PGraphicsOpenGL currentPG;
    protected PGL pgl;
    protected int context;
    protected int type;
    public int glProgram;
    public int glVertex;
    public int glFragment;
    private PGraphicsOpenGL.GLResourceShader glres;
    protected URL vertexURL;
    protected URL fragmentURL;
    protected String vertexFilename;
    protected String fragmentFilename;
    protected String[] vertexShaderSource;
    protected String[] fragmentShaderSource;
    protected boolean bound;
    protected HashMap<Integer, UniformValue> uniformValues = null;
    protected HashMap<Integer, Texture> textures;
    protected HashMap<Integer, Integer> texUnits;
    protected IntBuffer intBuffer;
    protected FloatBuffer floatBuffer;
    protected boolean loadedAttributes = false;
    protected boolean loadedUniforms = false;
    protected int transformMatLoc;
    protected int modelviewMatLoc;
    protected int projectionMatLoc;
    protected int ppixelsLoc;
    protected int ppixelsUnit;
    protected int viewportLoc;
    protected int resolutionLoc;
    protected int perspectiveLoc;
    protected int scaleLoc;
    protected int lightCountLoc;
    protected int lightPositionLoc;
    protected int lightNormalLoc;
    protected int lightAmbientLoc;
    protected int lightDiffuseLoc;
    protected int lightSpecularLoc;
    protected int lightFalloffLoc;
    protected int lightSpotLoc;
    protected Texture texture;
    protected int texUnit;
    protected int textureLoc;
    protected int texMatrixLoc;
    protected int texOffsetLoc;
    protected float[] tcmat;
    protected int vertexLoc;
    protected int colorLoc;
    protected int normalLoc;
    protected int texCoordLoc;
    protected int normalMatLoc;
    protected int directionLoc;
    protected int offsetLoc;
    protected int ambientLoc;
    protected int specularLoc;
    protected int emissiveLoc;
    protected int shininessLoc;

    public PShader() {
        this.parent = null;
        this.pgl = null;
        this.context = -1;
        this.vertexURL = null;
        this.fragmentURL = null;
        this.vertexFilename = null;
        this.fragmentFilename = null;
        this.glProgram = 0;
        this.glVertex = 0;
        this.glFragment = 0;
        this.intBuffer = PGL.allocateIntBuffer(1);
        this.floatBuffer = PGL.allocateFloatBuffer(1);
        this.bound = false;
        this.type = -1;
    }

    public PShader(PApplet pApplet) {
        this();
        this.parent = pApplet;
        this.primaryPG = (PGraphicsOpenGL)pApplet.g;
        this.pgl = this.primaryPG.pgl;
        this.context = this.pgl.createEmptyContext();
    }

    public PShader(PApplet pApplet, String string, String string2) {
        this.parent = pApplet;
        this.primaryPG = (PGraphicsOpenGL)pApplet.g;
        this.pgl = this.primaryPG.pgl;
        this.vertexURL = null;
        this.fragmentURL = null;
        this.vertexFilename = string;
        this.fragmentFilename = string2;
        this.fragmentShaderSource = this.pgl.loadFragmentShader(string2);
        this.vertexShaderSource = this.pgl.loadVertexShader(string);
        this.glProgram = 0;
        this.glVertex = 0;
        this.glFragment = 0;
        this.intBuffer = PGL.allocateIntBuffer(1);
        this.floatBuffer = PGL.allocateFloatBuffer(1);
        int n = PShader.getShaderType(this.vertexShaderSource, -1);
        int n2 = PShader.getShaderType(this.fragmentShaderSource, -1);
        if (n == -1 && n2 == -1) {
            this.type = 2;
        } else if (n == -1) {
            this.type = n2;
        } else if (n2 == -1) {
            this.type = n;
        } else if (n2 == n) {
            this.type = n;
        } else {
            PGraphics.showWarning("The vertex and fragment shaders have different types");
        }
    }

    public PShader(PApplet pApplet, URL uRL, URL uRL2) {
        this.parent = pApplet;
        this.primaryPG = (PGraphicsOpenGL)pApplet.g;
        this.pgl = this.primaryPG.pgl;
        this.vertexURL = uRL;
        this.fragmentURL = uRL2;
        this.vertexFilename = null;
        this.fragmentFilename = null;
        this.fragmentShaderSource = this.pgl.loadFragmentShader(uRL2);
        this.vertexShaderSource = this.pgl.loadVertexShader(uRL);
        this.glProgram = 0;
        this.glVertex = 0;
        this.glFragment = 0;
        this.intBuffer = PGL.allocateIntBuffer(1);
        this.floatBuffer = PGL.allocateFloatBuffer(1);
        int n = PShader.getShaderType(this.vertexShaderSource, -1);
        int n2 = PShader.getShaderType(this.fragmentShaderSource, -1);
        if (n == -1 && n2 == -1) {
            this.type = 2;
        } else if (n == -1) {
            this.type = n2;
        } else if (n2 == -1) {
            this.type = n;
        } else if (n2 == n) {
            this.type = n;
        } else {
            PGraphics.showWarning("The vertex and fragment shaders have different types");
        }
    }

    public PShader(PApplet pApplet, String[] stringArray, String[] stringArray2) {
        this.parent = pApplet;
        this.primaryPG = (PGraphicsOpenGL)pApplet.g;
        this.pgl = this.primaryPG.pgl;
        this.vertexURL = null;
        this.fragmentURL = null;
        this.vertexFilename = null;
        this.fragmentFilename = null;
        this.vertexShaderSource = stringArray;
        this.fragmentShaderSource = stringArray2;
        this.glProgram = 0;
        this.glVertex = 0;
        this.glFragment = 0;
        this.intBuffer = PGL.allocateIntBuffer(1);
        this.floatBuffer = PGL.allocateFloatBuffer(1);
        int n = PShader.getShaderType(this.vertexShaderSource, -1);
        int n2 = PShader.getShaderType(this.fragmentShaderSource, -1);
        if (n == -1 && n2 == -1) {
            this.type = 2;
        } else if (n == -1) {
            this.type = n2;
        } else if (n2 == -1) {
            this.type = n;
        } else if (n2 == n) {
            this.type = n;
        } else {
            PGraphics.showWarning("The vertex and fragment shaders have different types");
        }
    }

    public void setVertexShader(String string) {
        this.vertexFilename = string;
        this.vertexShaderSource = this.pgl.loadVertexShader(string);
    }

    public void setVertexShader(URL uRL) {
        this.vertexURL = uRL;
        this.vertexShaderSource = this.pgl.loadVertexShader(uRL);
    }

    public void setVertexShader(String[] stringArray) {
        this.vertexShaderSource = stringArray;
    }

    public void setFragmentShader(String string) {
        this.fragmentFilename = string;
        this.fragmentShaderSource = this.pgl.loadFragmentShader(string);
    }

    public void setFragmentShader(URL uRL) {
        this.fragmentURL = uRL;
        this.fragmentShaderSource = this.pgl.loadFragmentShader(uRL);
    }

    public void setFragmentShader(String[] stringArray) {
        this.fragmentShaderSource = stringArray;
    }

    public void bind() {
        this.init();
        if (!this.bound) {
            this.pgl.useProgram(this.glProgram);
            this.bound = true;
            this.consumeUniforms();
            this.bindTextures();
        }
        if (this.hasType()) {
            this.bindTyped();
        }
    }

    public void unbind() {
        if (this.hasType()) {
            this.unbindTyped();
        }
        if (this.bound) {
            this.unbindTextures();
            this.pgl.useProgram(0);
            this.bound = false;
        }
    }

    public boolean bound() {
        return this.bound;
    }

    public void set(String string, int n) {
        this.setUniformImpl(string, 0, new int[]{n});
    }

    public void set(String string, int n, int n2) {
        this.setUniformImpl(string, 1, new int[]{n, n2});
    }

    public void set(String string, int n, int n2, int n3) {
        this.setUniformImpl(string, 2, new int[]{n, n2, n3});
    }

    public void set(String string, int n, int n2, int n3, int n4) {
        this.setUniformImpl(string, 3, new int[]{n, n2, n3, n4});
    }

    public void set(String string, float f) {
        this.setUniformImpl(string, 4, new float[]{f});
    }

    public void set(String string, float f, float f2) {
        this.setUniformImpl(string, 5, new float[]{f, f2});
    }

    public void set(String string, float f, float f2, float f3) {
        this.setUniformImpl(string, 6, new float[]{f, f2, f3});
    }

    public void set(String string, float f, float f2, float f3, float f4) {
        this.setUniformImpl(string, 7, new float[]{f, f2, f3, f4});
    }

    public void set(String string, PVector pVector) {
        this.setUniformImpl(string, 6, new float[]{pVector.x, pVector.y, pVector.z});
    }

    public void set(String string, boolean bl) {
        this.setUniformImpl(string, 0, new int[]{bl ? 1 : 0});
    }

    public void set(String string, boolean bl, boolean bl2) {
        this.setUniformImpl(string, 1, new int[]{bl ? 1 : 0, bl2 ? 1 : 0});
    }

    public void set(String string, boolean bl, boolean bl2, boolean bl3) {
        this.setUniformImpl(string, 2, new int[]{bl ? 1 : 0, bl2 ? 1 : 0, bl3 ? 1 : 0});
    }

    public void set(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.setUniformImpl(string, 3, new int[]{bl ? 1 : 0, bl2 ? 1 : 0, bl3 ? 1 : 0, bl4 ? 1 : 0});
    }

    public void set(String string, int[] nArray) {
        this.set(string, nArray, 1);
    }

    public void set(String string, int[] nArray, int n) {
        if (n == 1) {
            this.setUniformImpl(string, 8, nArray);
        } else if (n == 2) {
            this.setUniformImpl(string, 9, nArray);
        } else if (n == 3) {
            this.setUniformImpl(string, 10, nArray);
        } else if (n == 4) {
            this.setUniformImpl(string, 11, nArray);
        } else if (4 < n) {
            PGraphics.showWarning("Only up to 4 coordinates per element are supported.");
        } else {
            PGraphics.showWarning("Wrong number of coordinates: it is negative!");
        }
    }

    public void set(String string, float[] fArray) {
        this.set(string, fArray, 1);
    }

    public void set(String string, float[] fArray, int n) {
        if (n == 1) {
            this.setUniformImpl(string, 12, fArray);
        } else if (n == 2) {
            this.setUniformImpl(string, 13, fArray);
        } else if (n == 3) {
            this.setUniformImpl(string, 14, fArray);
        } else if (n == 4) {
            this.setUniformImpl(string, 15, fArray);
        } else if (4 < n) {
            PGraphics.showWarning("Only up to 4 coordinates per element are supported.");
        } else {
            PGraphics.showWarning("Wrong number of coordinates: it is negative!");
        }
    }

    public void set(String string, boolean[] blArray) {
        this.set(string, blArray, 1);
    }

    public void set(String string, boolean[] blArray, int n) {
        int[] nArray = new int[blArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            nArray[i] = blArray[i] ? 1 : 0;
        }
        this.set(string, nArray, n);
    }

    public void set(String string, PMatrix2D pMatrix2D) {
        float[] fArray = new float[]{pMatrix2D.m00, pMatrix2D.m01, pMatrix2D.m10, pMatrix2D.m11};
        this.setUniformImpl(string, 16, fArray);
    }

    public void set(String string, PMatrix3D pMatrix3D) {
        this.set(string, pMatrix3D, false);
    }

    public void set(String string, PMatrix3D pMatrix3D, boolean bl) {
        if (bl) {
            float[] fArray = new float[]{pMatrix3D.m00, pMatrix3D.m01, pMatrix3D.m02, pMatrix3D.m10, pMatrix3D.m11, pMatrix3D.m12, pMatrix3D.m20, pMatrix3D.m21, pMatrix3D.m22};
            this.setUniformImpl(string, 17, fArray);
        } else {
            float[] fArray = new float[]{pMatrix3D.m00, pMatrix3D.m01, pMatrix3D.m02, pMatrix3D.m03, pMatrix3D.m10, pMatrix3D.m11, pMatrix3D.m12, pMatrix3D.m13, pMatrix3D.m20, pMatrix3D.m21, pMatrix3D.m22, pMatrix3D.m23, pMatrix3D.m30, pMatrix3D.m31, pMatrix3D.m32, pMatrix3D.m33};
            this.setUniformImpl(string, 18, fArray);
        }
    }

    public void set(String string, PImage pImage) {
        this.setUniformImpl(string, 19, pImage);
    }

    protected void setup() {
    }

    protected void draw(int n, int n2, int n3) {
        this.pgl.bindBuffer(PGL.ELEMENT_ARRAY_BUFFER, n);
        this.pgl.drawElements(PGL.TRIANGLES, n2, PGL.INDEX_TYPE, n3 * PGL.SIZEOF_INDEX);
        this.pgl.bindBuffer(PGL.ELEMENT_ARRAY_BUFFER, 0);
    }

    protected int getAttributeLoc(String string) {
        this.init();
        return this.pgl.getAttribLocation(this.glProgram, string);
    }

    protected int getUniformLoc(String string) {
        this.init();
        return this.pgl.getUniformLocation(this.glProgram, string);
    }

    protected void setAttributeVBO(int n, int n2, int n3, int n4, boolean bl, int n5, int n6) {
        if (-1 < n) {
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, n2);
            this.pgl.vertexAttribPointer(n, n3, n4, bl, n5, n6);
        }
    }

    protected void setUniformValue(int n, int n2) {
        if (-1 < n) {
            this.pgl.uniform1i(n, n2);
        }
    }

    protected void setUniformValue(int n, int n2, int n3) {
        if (-1 < n) {
            this.pgl.uniform2i(n, n2, n3);
        }
    }

    protected void setUniformValue(int n, int n2, int n3, int n4) {
        if (-1 < n) {
            this.pgl.uniform3i(n, n2, n3, n4);
        }
    }

    protected void setUniformValue(int n, int n2, int n3, int n4, int n5) {
        if (-1 < n) {
            this.pgl.uniform4i(n, n2, n3, n4, n5);
        }
    }

    protected void setUniformValue(int n, float f) {
        if (-1 < n) {
            this.pgl.uniform1f(n, f);
        }
    }

    protected void setUniformValue(int n, float f, float f2) {
        if (-1 < n) {
            this.pgl.uniform2f(n, f, f2);
        }
    }

    protected void setUniformValue(int n, float f, float f2, float f3) {
        if (-1 < n) {
            this.pgl.uniform3f(n, f, f2, f3);
        }
    }

    protected void setUniformValue(int n, float f, float f2, float f3, float f4) {
        if (-1 < n) {
            this.pgl.uniform4f(n, f, f2, f3, f4);
        }
    }

    protected void setUniformVector(int n, int[] nArray, int n2, int n3) {
        if (-1 < n) {
            this.updateIntBuffer(nArray);
            if (n2 == 1) {
                this.pgl.uniform1iv(n, n3, this.intBuffer);
            } else if (n2 == 2) {
                this.pgl.uniform2iv(n, n3, this.intBuffer);
            } else if (n2 == 3) {
                this.pgl.uniform3iv(n, n3, this.intBuffer);
            } else if (n2 == 4) {
                this.pgl.uniform3iv(n, n3, this.intBuffer);
            }
        }
    }

    protected void setUniformVector(int n, float[] fArray, int n2, int n3) {
        if (-1 < n) {
            this.updateFloatBuffer(fArray);
            if (n2 == 1) {
                this.pgl.uniform1fv(n, n3, this.floatBuffer);
            } else if (n2 == 2) {
                this.pgl.uniform2fv(n, n3, this.floatBuffer);
            } else if (n2 == 3) {
                this.pgl.uniform3fv(n, n3, this.floatBuffer);
            } else if (n2 == 4) {
                this.pgl.uniform4fv(n, n3, this.floatBuffer);
            }
        }
    }

    protected void setUniformMatrix(int n, float[] fArray) {
        if (-1 < n) {
            this.updateFloatBuffer(fArray);
            if (fArray.length == 4) {
                this.pgl.uniformMatrix2fv(n, 1, false, this.floatBuffer);
            } else if (fArray.length == 9) {
                this.pgl.uniformMatrix3fv(n, 1, false, this.floatBuffer);
            } else if (fArray.length == 16) {
                this.pgl.uniformMatrix4fv(n, 1, false, this.floatBuffer);
            }
        }
    }

    protected void setUniformTex(int n, Texture texture) {
        if (this.texUnits != null) {
            Integer n2 = this.texUnits.get(n);
            if (n2 != null) {
                this.pgl.activeTexture(PGL.TEXTURE0 + n2);
                texture.bind();
            } else {
                throw new RuntimeException("Cannot find unit for texture " + texture);
            }
        }
    }

    protected void setUniformImpl(String string, int n, Object object) {
        int n2 = this.getUniformLoc(string);
        if (-1 < n2) {
            if (this.uniformValues == null) {
                this.uniformValues = new HashMap();
            }
            this.uniformValues.put(n2, new UniformValue(n, object));
        } else {
            PGraphics.showWarning("The shader doesn't have a uniform called \"" + string + "\" OR the uniform was removed during compilation because it was unused.");
        }
    }

    protected void consumeUniforms() {
        if (this.uniformValues != null && 0 < this.uniformValues.size()) {
            int n = 0;
            for (Integer n2 : this.uniformValues.keySet()) {
                Object object;
                UniformValue uniformValue = this.uniformValues.get(n2);
                if (uniformValue.type == 0) {
                    object = (int[])uniformValue.value;
                    this.pgl.uniform1i(n2, object[0]);
                    continue;
                }
                if (uniformValue.type == 1) {
                    object = (int[])uniformValue.value;
                    this.pgl.uniform2i(n2, object[0], object[1]);
                    continue;
                }
                if (uniformValue.type == 2) {
                    object = (int[])uniformValue.value;
                    this.pgl.uniform3i(n2, object[0], object[1], object[2]);
                    continue;
                }
                if (uniformValue.type == 3) {
                    object = (int[])uniformValue.value;
                    this.pgl.uniform4i(n2, object[0], object[1], object[2], object[3]);
                    continue;
                }
                if (uniformValue.type == 4) {
                    object = (float[])uniformValue.value;
                    this.pgl.uniform1f(n2, object[0]);
                    continue;
                }
                if (uniformValue.type == 5) {
                    object = (float[])uniformValue.value;
                    this.pgl.uniform2f(n2, object[0], object[1]);
                    continue;
                }
                if (uniformValue.type == 6) {
                    object = (float[])uniformValue.value;
                    this.pgl.uniform3f(n2, object[0], object[1], object[2]);
                    continue;
                }
                if (uniformValue.type == 7) {
                    object = (float[])uniformValue.value;
                    this.pgl.uniform4f(n2, object[0], object[1], object[2], object[3]);
                    continue;
                }
                if (uniformValue.type == 8) {
                    object = (int[])uniformValue.value;
                    this.updateIntBuffer((int[])object);
                    this.pgl.uniform1iv(n2, ((int[])object).length, this.intBuffer);
                    continue;
                }
                if (uniformValue.type == 9) {
                    object = (int[])uniformValue.value;
                    this.updateIntBuffer((int[])object);
                    this.pgl.uniform2iv(n2, ((int[])object).length / 2, this.intBuffer);
                    continue;
                }
                if (uniformValue.type == 10) {
                    object = (int[])uniformValue.value;
                    this.updateIntBuffer((int[])object);
                    this.pgl.uniform3iv(n2, ((int[])object).length / 3, this.intBuffer);
                    continue;
                }
                if (uniformValue.type == 11) {
                    object = (int[])uniformValue.value;
                    this.updateIntBuffer((int[])object);
                    this.pgl.uniform4iv(n2, ((int[])object).length / 4, this.intBuffer);
                    continue;
                }
                if (uniformValue.type == 12) {
                    object = (float[])uniformValue.value;
                    this.updateFloatBuffer((float[])object);
                    this.pgl.uniform1fv(n2, ((int[])object).length, this.floatBuffer);
                    continue;
                }
                if (uniformValue.type == 13) {
                    object = (float[])uniformValue.value;
                    this.updateFloatBuffer((float[])object);
                    this.pgl.uniform2fv(n2, ((int[])object).length / 2, this.floatBuffer);
                    continue;
                }
                if (uniformValue.type == 14) {
                    object = (float[])uniformValue.value;
                    this.updateFloatBuffer((float[])object);
                    this.pgl.uniform3fv(n2, ((int[])object).length / 3, this.floatBuffer);
                    continue;
                }
                if (uniformValue.type == 15) {
                    object = (float[])uniformValue.value;
                    this.updateFloatBuffer((float[])object);
                    this.pgl.uniform4fv(n2, ((int[])object).length / 4, this.floatBuffer);
                    continue;
                }
                if (uniformValue.type == 16) {
                    object = (float[])uniformValue.value;
                    this.updateFloatBuffer((float[])object);
                    this.pgl.uniformMatrix2fv(n2, 1, false, this.floatBuffer);
                    continue;
                }
                if (uniformValue.type == 17) {
                    object = (float[])uniformValue.value;
                    this.updateFloatBuffer((float[])object);
                    this.pgl.uniformMatrix3fv(n2, 1, false, this.floatBuffer);
                    continue;
                }
                if (uniformValue.type == 18) {
                    object = (float[])uniformValue.value;
                    this.updateFloatBuffer((float[])object);
                    this.pgl.uniformMatrix4fv(n2, 1, false, this.floatBuffer);
                    continue;
                }
                if (uniformValue.type != 19) continue;
                object = (PImage)uniformValue.value;
                Texture texture = this.currentPG.getTexture((PImage)object);
                if (this.textures == null) {
                    this.textures = new HashMap();
                }
                this.textures.put(n2, texture);
                if (this.texUnits == null) {
                    this.texUnits = new HashMap();
                }
                if (this.texUnits.containsKey(n2)) {
                    n = this.texUnits.get(n2);
                    this.pgl.uniform1i(n2, n);
                } else {
                    this.texUnits.put(n2, n);
                    this.pgl.uniform1i(n2, n);
                }
                ++n;
            }
            this.uniformValues.clear();
        }
    }

    protected void updateIntBuffer(int[] nArray) {
        this.intBuffer = PGL.updateIntBuffer(this.intBuffer, nArray, false);
    }

    protected void updateFloatBuffer(float[] fArray) {
        this.floatBuffer = PGL.updateFloatBuffer(this.floatBuffer, fArray, false);
    }

    protected void bindTextures() {
        if (this.textures != null && this.texUnits != null) {
            for (int n : this.textures.keySet()) {
                Texture texture = this.textures.get(n);
                Integer n2 = this.texUnits.get(n);
                if (n2 != null) {
                    this.pgl.activeTexture(PGL.TEXTURE0 + n2);
                    texture.bind();
                    continue;
                }
                throw new RuntimeException("Cannot find unit for texture " + texture);
            }
        }
    }

    protected void unbindTextures() {
        if (this.textures != null && this.texUnits != null) {
            for (int n : this.textures.keySet()) {
                Texture texture = this.textures.get(n);
                Integer n2 = this.texUnits.get(n);
                if (n2 != null) {
                    this.pgl.activeTexture(PGL.TEXTURE0 + n2);
                    texture.unbind();
                    continue;
                }
                throw new RuntimeException("Cannot find unit for texture " + texture);
            }
            this.pgl.activeTexture(PGL.TEXTURE0);
        }
    }

    public void init() {
        if (this.glProgram == 0 || this.contextIsOutdated()) {
            this.create();
            if (this.compile()) {
                this.pgl.attachShader(this.glProgram, this.glVertex);
                this.pgl.attachShader(this.glProgram, this.glFragment);
                this.setup();
                this.pgl.linkProgram(this.glProgram);
                this.validate();
            }
        }
    }

    protected void create() {
        this.context = this.pgl.getCurrentContext();
        this.glres = new PGraphicsOpenGL.GLResourceShader(this);
    }

    protected boolean compile() {
        boolean bl = true;
        if (this.hasVertexShader()) {
            bl = this.compileVertexShader();
        } else {
            PGraphics.showException("Doesn't have a vertex shader");
        }
        boolean bl2 = true;
        if (this.hasFragmentShader()) {
            bl2 = this.compileFragmentShader();
        } else {
            PGraphics.showException("Doesn't have a fragment shader");
        }
        return bl && bl2;
    }

    protected void validate() {
        boolean bl;
        boolean bl2;
        this.pgl.getProgramiv(this.glProgram, PGL.LINK_STATUS, this.intBuffer);
        boolean bl3 = bl2 = this.intBuffer.get(0) != 0;
        if (!bl2) {
            PGraphics.showException("Cannot link shader program:\n" + this.pgl.getProgramInfoLog(this.glProgram));
        }
        this.pgl.validateProgram(this.glProgram);
        this.pgl.getProgramiv(this.glProgram, PGL.VALIDATE_STATUS, this.intBuffer);
        boolean bl4 = bl = this.intBuffer.get(0) != 0;
        if (!bl) {
            PGraphics.showException("Cannot validate shader program:\n" + this.pgl.getProgramInfoLog(this.glProgram));
        }
    }

    protected boolean contextIsOutdated() {
        boolean bl;
        boolean bl2 = bl = !this.pgl.contextIsCurrent(this.context);
        if (bl) {
            this.dispose();
        }
        return bl;
    }

    protected boolean hasVertexShader() {
        return this.vertexShaderSource != null && 0 < this.vertexShaderSource.length;
    }

    protected boolean hasFragmentShader() {
        return this.fragmentShaderSource != null && 0 < this.fragmentShaderSource.length;
    }

    protected boolean compileVertexShader() {
        boolean bl;
        this.pgl.shaderSource(this.glVertex, PApplet.join(this.vertexShaderSource, "\n"));
        this.pgl.compileShader(this.glVertex);
        this.pgl.getShaderiv(this.glVertex, PGL.COMPILE_STATUS, this.intBuffer);
        boolean bl2 = bl = this.intBuffer.get(0) != 0;
        if (!bl) {
            PGraphics.showException("Cannot compile vertex shader:\n" + this.pgl.getShaderInfoLog(this.glVertex));
            return false;
        }
        return true;
    }

    protected boolean compileFragmentShader() {
        boolean bl;
        this.pgl.shaderSource(this.glFragment, PApplet.join(this.fragmentShaderSource, "\n"));
        this.pgl.compileShader(this.glFragment);
        this.pgl.getShaderiv(this.glFragment, PGL.COMPILE_STATUS, this.intBuffer);
        boolean bl2 = bl = this.intBuffer.get(0) != 0;
        if (!bl) {
            PGraphics.showException("Cannot compile fragment shader:\n" + this.pgl.getShaderInfoLog(this.glFragment));
            return false;
        }
        return true;
    }

    protected void dispose() {
        if (this.glres != null) {
            this.glres.dispose();
            this.glVertex = 0;
            this.glFragment = 0;
            this.glProgram = 0;
            this.glres = null;
        }
    }

    protected static int getShaderType(String[] stringArray, int n) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].trim();
            if (PApplet.match(string, colorShaderDefRegexp) != null) {
                return 3;
            }
            if (PApplet.match(string, lightShaderDefRegexp) != null) {
                return 4;
            }
            if (PApplet.match(string, texShaderDefRegexp) != null) {
                return 5;
            }
            if (PApplet.match(string, texlightShaderDefRegexp) != null) {
                return 6;
            }
            if (PApplet.match(string, polyShaderDefRegexp) != null) {
                return 2;
            }
            if (PApplet.match(string, triShaderAttrRegexp) != null) {
                return 2;
            }
            if (PApplet.match(string, quadShaderAttrRegexp) != null) {
                return 2;
            }
            if (PApplet.match(string, pointShaderDefRegexp) != null) {
                return 0;
            }
            if (PApplet.match(string, lineShaderDefRegexp) != null) {
                return 1;
            }
            if (PApplet.match(string, pointShaderAttrRegexp) != null) {
                return 0;
            }
            if (PApplet.match(string, pointShaderInRegexp) != null) {
                return 0;
            }
            if (PApplet.match(string, lineShaderAttrRegexp) != null) {
                return 1;
            }
            if (PApplet.match(string, lineShaderInRegexp) == null) continue;
            return 1;
        }
        return n;
    }

    protected int getType() {
        return this.type;
    }

    protected void setType(int n) {
        this.type = n;
    }

    protected boolean hasType() {
        return 0 <= this.type && this.type <= 6;
    }

    protected boolean isPointShader() {
        return this.type == 0;
    }

    protected boolean isLineShader() {
        return this.type == 1;
    }

    protected boolean isPolyShader() {
        return 2 <= this.type && this.type <= 6;
    }

    protected boolean checkPolyType(int n) {
        if (this.getType() == 2) {
            return true;
        }
        if (this.getType() != n) {
            if (n == 6) {
                PGraphics.showWarning("Your shader needs to be of TEXLIGHT type to render this geometry properly, using default shader instead.");
            } else if (n == 4) {
                PGraphics.showWarning("Your shader needs to be of LIGHT type to render this geometry properly, using default shader instead.");
            } else if (n == 5) {
                PGraphics.showWarning("Your shader needs to be of TEXTURE type to render this geometry properly, using default shader instead.");
            } else if (n == 3) {
                PGraphics.showWarning("Your shader needs to be of COLOR type to render this geometry properly, using default shader instead.");
            }
            return false;
        }
        return true;
    }

    protected int getLastTexUnit() {
        return this.texUnits == null ? -1 : this.texUnits.size() - 1;
    }

    protected void setRenderer(PGraphicsOpenGL pGraphicsOpenGL) {
        this.currentPG = pGraphicsOpenGL;
    }

    protected void loadAttributes() {
        if (this.loadedAttributes) {
            return;
        }
        this.vertexLoc = this.getAttributeLoc("vertex");
        if (this.vertexLoc == -1) {
            this.vertexLoc = this.getAttributeLoc("position");
        }
        this.colorLoc = this.getAttributeLoc("color");
        this.texCoordLoc = this.getAttributeLoc("texCoord");
        this.normalLoc = this.getAttributeLoc("normal");
        this.ambientLoc = this.getAttributeLoc("ambient");
        this.specularLoc = this.getAttributeLoc("specular");
        this.emissiveLoc = this.getAttributeLoc("emissive");
        this.shininessLoc = this.getAttributeLoc("shininess");
        this.directionLoc = this.getAttributeLoc("direction");
        this.offsetLoc = this.getAttributeLoc("offset");
        this.directionLoc = this.getAttributeLoc("direction");
        this.offsetLoc = this.getAttributeLoc("offset");
        this.loadedAttributes = true;
    }

    protected void loadUniforms() {
        if (this.loadedUniforms) {
            return;
        }
        this.transformMatLoc = this.getUniformLoc("transform");
        if (this.transformMatLoc == -1) {
            this.transformMatLoc = this.getUniformLoc("transformMatrix");
        }
        this.modelviewMatLoc = this.getUniformLoc("modelview");
        if (this.modelviewMatLoc == -1) {
            this.modelviewMatLoc = this.getUniformLoc("modelviewMatrix");
        }
        this.projectionMatLoc = this.getUniformLoc("projection");
        if (this.projectionMatLoc == -1) {
            this.projectionMatLoc = this.getUniformLoc("projectionMatrix");
        }
        this.viewportLoc = this.getUniformLoc("viewport");
        this.resolutionLoc = this.getUniformLoc("resolution");
        this.ppixelsLoc = this.getUniformLoc("ppixels");
        this.normalMatLoc = this.getUniformLoc("normalMatrix");
        this.lightCountLoc = this.getUniformLoc("lightCount");
        this.lightPositionLoc = this.getUniformLoc("lightPosition");
        this.lightNormalLoc = this.getUniformLoc("lightNormal");
        this.lightAmbientLoc = this.getUniformLoc("lightAmbient");
        this.lightDiffuseLoc = this.getUniformLoc("lightDiffuse");
        this.lightSpecularLoc = this.getUniformLoc("lightSpecular");
        this.lightFalloffLoc = this.getUniformLoc("lightFalloff");
        this.lightSpotLoc = this.getUniformLoc("lightSpot");
        this.textureLoc = this.getUniformLoc("texture");
        if (this.textureLoc == -1) {
            this.textureLoc = this.getUniformLoc("texMap");
        }
        this.texMatrixLoc = this.getUniformLoc("texMatrix");
        this.texOffsetLoc = this.getUniformLoc("texOffset");
        this.perspectiveLoc = this.getUniformLoc("perspective");
        this.scaleLoc = this.getUniformLoc("scale");
        this.loadedUniforms = true;
    }

    protected void setCommonUniforms() {
        float f;
        float f2;
        if (-1 < this.transformMatLoc) {
            this.currentPG.updateGLProjmodelview();
            this.setUniformMatrix(this.transformMatLoc, this.currentPG.glProjmodelview);
        }
        if (-1 < this.modelviewMatLoc) {
            this.currentPG.updateGLModelview();
            this.setUniformMatrix(this.modelviewMatLoc, this.currentPG.glModelview);
        }
        if (-1 < this.projectionMatLoc) {
            this.currentPG.updateGLProjection();
            this.setUniformMatrix(this.projectionMatLoc, this.currentPG.glProjection);
        }
        if (-1 < this.viewportLoc) {
            f2 = this.currentPG.viewport.get(0);
            f = this.currentPG.viewport.get(1);
            float f3 = this.currentPG.viewport.get(2);
            float f4 = this.currentPG.viewport.get(3);
            this.setUniformValue(this.viewportLoc, f2, f, f3, f4);
        }
        if (-1 < this.resolutionLoc) {
            f2 = this.currentPG.viewport.get(2);
            f = this.currentPG.viewport.get(3);
            this.setUniformValue(this.resolutionLoc, f2, f);
        }
        if (-1 < this.ppixelsLoc) {
            this.ppixelsUnit = this.getLastTexUnit() + 1;
            this.setUniformValue(this.ppixelsLoc, this.ppixelsUnit);
            this.pgl.activeTexture(PGL.TEXTURE0 + this.ppixelsUnit);
            this.currentPG.bindFrontTexture();
        } else {
            this.ppixelsUnit = -1;
        }
    }

    protected void bindTyped() {
        if (this.currentPG == null) {
            this.setRenderer(this.primaryPG.getCurrentPG());
            this.loadAttributes();
            this.loadUniforms();
        }
        this.setCommonUniforms();
        if (-1 < this.vertexLoc) {
            this.pgl.enableVertexAttribArray(this.vertexLoc);
        }
        if (-1 < this.colorLoc) {
            this.pgl.enableVertexAttribArray(this.colorLoc);
        }
        if (-1 < this.texCoordLoc) {
            this.pgl.enableVertexAttribArray(this.texCoordLoc);
        }
        if (-1 < this.normalLoc) {
            this.pgl.enableVertexAttribArray(this.normalLoc);
        }
        if (-1 < this.normalMatLoc) {
            this.currentPG.updateGLNormal();
            this.setUniformMatrix(this.normalMatLoc, this.currentPG.glNormal);
        }
        if (-1 < this.ambientLoc) {
            this.pgl.enableVertexAttribArray(this.ambientLoc);
        }
        if (-1 < this.specularLoc) {
            this.pgl.enableVertexAttribArray(this.specularLoc);
        }
        if (-1 < this.emissiveLoc) {
            this.pgl.enableVertexAttribArray(this.emissiveLoc);
        }
        if (-1 < this.shininessLoc) {
            this.pgl.enableVertexAttribArray(this.shininessLoc);
        }
        int n = this.currentPG.lightCount;
        this.setUniformValue(this.lightCountLoc, n);
        if (0 < n) {
            this.setUniformVector(this.lightPositionLoc, this.currentPG.lightPosition, 4, n);
            this.setUniformVector(this.lightNormalLoc, this.currentPG.lightNormal, 3, n);
            this.setUniformVector(this.lightAmbientLoc, this.currentPG.lightAmbient, 3, n);
            this.setUniformVector(this.lightDiffuseLoc, this.currentPG.lightDiffuse, 3, n);
            this.setUniformVector(this.lightSpecularLoc, this.currentPG.lightSpecular, 3, n);
            this.setUniformVector(this.lightFalloffLoc, this.currentPG.lightFalloffCoefficients, 3, n);
            this.setUniformVector(this.lightSpotLoc, this.currentPG.lightSpotParameters, 2, n);
        }
        if (-1 < this.directionLoc) {
            this.pgl.enableVertexAttribArray(this.directionLoc);
        }
        if (-1 < this.offsetLoc) {
            this.pgl.enableVertexAttribArray(this.offsetLoc);
        }
        if (-1 < this.perspectiveLoc) {
            if (this.currentPG.getHint(7) && this.currentPG.nonOrthoProjection()) {
                this.setUniformValue(this.perspectiveLoc, 1);
            } else {
                this.setUniformValue(this.perspectiveLoc, 0);
            }
        }
        if (-1 < this.scaleLoc) {
            if (this.currentPG.getHint(6)) {
                this.setUniformValue(this.scaleLoc, 1.0f, 1.0f, 1.0f);
            } else {
                float f = PGL.STROKE_DISPLACEMENT;
                if (this.currentPG.orthoProjection()) {
                    this.setUniformValue(this.scaleLoc, 1.0f, 1.0f, f);
                } else {
                    this.setUniformValue(this.scaleLoc, f, f, f);
                }
            }
        }
    }

    protected void unbindTyped() {
        if (-1 < this.offsetLoc) {
            this.pgl.disableVertexAttribArray(this.offsetLoc);
        }
        if (-1 < this.directionLoc) {
            this.pgl.disableVertexAttribArray(this.directionLoc);
        }
        if (-1 < this.textureLoc && this.texture != null) {
            this.pgl.activeTexture(PGL.TEXTURE0 + this.texUnit);
            this.texture.unbind();
            this.pgl.activeTexture(PGL.TEXTURE0);
            this.texture = null;
        }
        if (-1 < this.ambientLoc) {
            this.pgl.disableVertexAttribArray(this.ambientLoc);
        }
        if (-1 < this.specularLoc) {
            this.pgl.disableVertexAttribArray(this.specularLoc);
        }
        if (-1 < this.emissiveLoc) {
            this.pgl.disableVertexAttribArray(this.emissiveLoc);
        }
        if (-1 < this.shininessLoc) {
            this.pgl.disableVertexAttribArray(this.shininessLoc);
        }
        if (-1 < this.vertexLoc) {
            this.pgl.disableVertexAttribArray(this.vertexLoc);
        }
        if (-1 < this.colorLoc) {
            this.pgl.disableVertexAttribArray(this.colorLoc);
        }
        if (-1 < this.texCoordLoc) {
            this.pgl.disableVertexAttribArray(this.texCoordLoc);
        }
        if (-1 < this.normalLoc) {
            this.pgl.disableVertexAttribArray(this.normalLoc);
        }
        if (-1 < this.ppixelsLoc) {
            this.pgl.enableFBOLayer();
            this.pgl.activeTexture(PGL.TEXTURE0 + this.ppixelsUnit);
            this.currentPG.unbindFrontTexture();
            this.pgl.activeTexture(PGL.TEXTURE0);
        }
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, 0);
    }

    protected void setTexture(Texture texture) {
        this.texture = texture;
        float f = 1.0f;
        float f2 = 1.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (texture != null) {
            if (texture.invertedX()) {
                f = -1.0f;
                f3 = 1.0f;
            }
            if (texture.invertedY()) {
                f2 = -1.0f;
                f4 = 1.0f;
            }
            f *= texture.maxTexcoordU();
            f3 *= texture.maxTexcoordU();
            f2 *= texture.maxTexcoordV();
            f4 *= texture.maxTexcoordV();
            this.setUniformValue(this.texOffsetLoc, 1.0f / (float)texture.width, 1.0f / (float)texture.height);
            if (-1 < this.textureLoc) {
                this.texUnit = -1 < this.ppixelsUnit ? this.ppixelsUnit + 1 : this.getLastTexUnit() + 1;
                this.setUniformValue(this.textureLoc, this.texUnit);
                this.pgl.activeTexture(PGL.TEXTURE0 + this.texUnit);
                texture.bind();
            }
        }
        if (-1 < this.texMatrixLoc) {
            if (this.tcmat == null) {
                this.tcmat = new float[16];
            }
            this.tcmat[0] = f;
            this.tcmat[4] = 0.0f;
            this.tcmat[8] = 0.0f;
            this.tcmat[12] = f3;
            this.tcmat[1] = 0.0f;
            this.tcmat[5] = f2;
            this.tcmat[9] = 0.0f;
            this.tcmat[13] = f4;
            this.tcmat[2] = 0.0f;
            this.tcmat[6] = 0.0f;
            this.tcmat[10] = 0.0f;
            this.tcmat[14] = 0.0f;
            this.tcmat[3] = 0.0f;
            this.tcmat[7] = 0.0f;
            this.tcmat[11] = 0.0f;
            this.tcmat[15] = 0.0f;
            this.setUniformMatrix(this.texMatrixLoc, this.tcmat);
        }
    }

    protected boolean supportsTexturing() {
        return -1 < this.textureLoc;
    }

    protected boolean supportLighting() {
        return -1 < this.lightCountLoc || -1 < this.lightPositionLoc || -1 < this.lightNormalLoc;
    }

    protected boolean accessTexCoords() {
        return -1 < this.texCoordLoc;
    }

    protected boolean accessNormals() {
        return -1 < this.normalLoc;
    }

    protected boolean accessLightAttribs() {
        return -1 < this.ambientLoc || -1 < this.specularLoc || -1 < this.emissiveLoc || -1 < this.shininessLoc;
    }

    protected void setVertexAttribute(int n, int n2, int n3, int n4, int n5) {
        this.setAttributeVBO(this.vertexLoc, n, n2, n3, false, n4, n5);
    }

    protected void setColorAttribute(int n, int n2, int n3, int n4, int n5) {
        this.setAttributeVBO(this.colorLoc, n, n2, n3, true, n4, n5);
    }

    protected void setNormalAttribute(int n, int n2, int n3, int n4, int n5) {
        this.setAttributeVBO(this.normalLoc, n, n2, n3, false, n4, n5);
    }

    protected void setTexcoordAttribute(int n, int n2, int n3, int n4, int n5) {
        this.setAttributeVBO(this.texCoordLoc, n, n2, n3, false, n4, n5);
    }

    protected void setAmbientAttribute(int n, int n2, int n3, int n4, int n5) {
        this.setAttributeVBO(this.ambientLoc, n, n2, n3, true, n4, n5);
    }

    protected void setSpecularAttribute(int n, int n2, int n3, int n4, int n5) {
        this.setAttributeVBO(this.specularLoc, n, n2, n3, true, n4, n5);
    }

    protected void setEmissiveAttribute(int n, int n2, int n3, int n4, int n5) {
        this.setAttributeVBO(this.emissiveLoc, n, n2, n3, true, n4, n5);
    }

    protected void setShininessAttribute(int n, int n2, int n3, int n4, int n5) {
        this.setAttributeVBO(this.shininessLoc, n, n2, n3, false, n4, n5);
    }

    protected void setLineAttribute(int n, int n2, int n3, int n4, int n5) {
        this.setAttributeVBO(this.directionLoc, n, n2, n3, false, n4, n5);
    }

    protected void setPointAttribute(int n, int n2, int n3, int n4, int n5) {
        this.setAttributeVBO(this.offsetLoc, n, n2, n3, false, n4, n5);
    }

    protected static class UniformValue {
        static final int INT1 = 0;
        static final int INT2 = 1;
        static final int INT3 = 2;
        static final int INT4 = 3;
        static final int FLOAT1 = 4;
        static final int FLOAT2 = 5;
        static final int FLOAT3 = 6;
        static final int FLOAT4 = 7;
        static final int INT1VEC = 8;
        static final int INT2VEC = 9;
        static final int INT3VEC = 10;
        static final int INT4VEC = 11;
        static final int FLOAT1VEC = 12;
        static final int FLOAT2VEC = 13;
        static final int FLOAT3VEC = 14;
        static final int FLOAT4VEC = 15;
        static final int MAT2 = 16;
        static final int MAT3 = 17;
        static final int MAT4 = 18;
        static final int SAMPLER2D = 19;
        int type;
        Object value;

        UniformValue(int n, Object object) {
            this.type = n;
            this.value = object;
        }
    }
}

