/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;
import processing.core.PShape;
import processing.core.PVector;
import processing.opengl.FontTexture;
import processing.opengl.FrameBuffer;
import processing.opengl.LinePath;
import processing.opengl.PGL;
import processing.opengl.PGLES;
import processing.opengl.PGraphics2D;
import processing.opengl.PGraphics3D;
import processing.opengl.PShader;
import processing.opengl.PShapeOpenGL;
import processing.opengl.Texture;
import processing.opengl.VertexBuffer;

public class PGraphicsOpenGL
extends PGraphics {
    public PGL pgl;
    public PGraphicsOpenGL currentPG;
    protected WeakHashMap<PFont, FontTexture> fontMap;
    public boolean initialized;
    protected static final int FLUSH_CONTINUOUSLY = 0;
    protected static final int FLUSH_WHEN_FULL = 1;
    protected static final int IMMEDIATE = 0;
    protected static final int RETAINED = 1;
    protected int flushMode = 1;
    protected VertexBuffer bufPolyVertex;
    protected VertexBuffer bufPolyColor;
    protected VertexBuffer bufPolyNormal;
    protected VertexBuffer bufPolyTexcoord;
    protected VertexBuffer bufPolyAmbient;
    protected VertexBuffer bufPolySpecular;
    protected VertexBuffer bufPolyEmissive;
    protected VertexBuffer bufPolyShininess;
    protected VertexBuffer bufPolyIndex;
    protected boolean polyBuffersCreated = false;
    protected int polyBuffersContext;
    protected VertexBuffer bufLineVertex;
    protected VertexBuffer bufLineColor;
    protected VertexBuffer bufLineAttrib;
    protected VertexBuffer bufLineIndex;
    protected boolean lineBuffersCreated = false;
    protected int lineBuffersContext;
    protected VertexBuffer bufPointVertex;
    protected VertexBuffer bufPointColor;
    protected VertexBuffer bufPointAttrib;
    protected VertexBuffer bufPointIndex;
    protected boolean pointBuffersCreated = false;
    protected int pointBuffersContext;
    protected AttributeMap polyAttribs;
    protected static final int INIT_VERTEX_BUFFER_SIZE = 256;
    protected static final int INIT_INDEX_BUFFER_SIZE = 512;
    protected static boolean glParamsRead = false;
    public static boolean npotTexSupported;
    public static boolean autoMipmapGenSupported;
    public static boolean fboMultisampleSupported;
    public static boolean packedDepthStencilSupported;
    public static boolean anisoSamplingSupported;
    public static boolean blendEqSupported;
    public static boolean readBufferSupported;
    public static boolean drawBufferSupported;
    public static int maxTextureSize;
    public static int maxSamples;
    public static float maxAnisoAmount;
    public static int depthBits;
    public static int stencilBits;
    public static String OPENGL_VENDOR;
    public static String OPENGL_RENDERER;
    public static String OPENGL_VERSION;
    public static String OPENGL_EXTENSIONS;
    public static String GLSL_VERSION;
    protected static URL defColorShaderVertURL;
    protected static URL defTextureShaderVertURL;
    protected static URL defLightShaderVertURL;
    protected static URL defTexlightShaderVertURL;
    protected static URL defColorShaderFragURL;
    protected static URL defTextureShaderFragURL;
    protected static URL defLightShaderFragURL;
    protected static URL defTexlightShaderFragURL;
    protected static URL defLineShaderVertURL;
    protected static URL defLineShaderFragURL;
    protected static URL defPointShaderVertURL;
    protected static URL defPointShaderFragURL;
    protected static URL maskShaderFragURL;
    protected PShader defColorShader;
    protected PShader defTextureShader;
    protected PShader defLightShader;
    protected PShader defTexlightShader;
    protected PShader defLineShader;
    protected PShader defPointShader;
    protected PShader maskShader;
    protected PShader polyShader;
    protected PShader lineShader;
    protected PShader pointShader;
    protected InGeometry inGeo;
    protected TessGeometry tessGeo;
    protected TexCache texCache;
    protected Tessellator tessellator;
    protected DepthSorter sorter;
    protected boolean isDepthSortingEnabled;
    protected AsyncPixelReader asyncPixelReader;
    protected boolean asyncPixelReaderInitialized;
    protected static final Set<AsyncPixelReader> ongoingPixelTransfers;
    protected static final List<AsyncPixelReader> ongoingPixelTransfersIterable;
    public float cameraFOV;
    public float cameraX;
    public float cameraY;
    public float cameraZ;
    public float cameraNear;
    public float cameraFar;
    public float cameraAspect;
    public float defCameraFOV;
    public float defCameraX;
    public float defCameraY;
    public float defCameraZ;
    public float defCameraNear;
    public float defCameraFar;
    public float defCameraAspect;
    protected float eyeDist;
    protected boolean manipulatingCamera;
    public PMatrix3D projection;
    public PMatrix3D camera;
    public PMatrix3D cameraInv;
    public PMatrix3D modelview;
    public PMatrix3D modelviewInv;
    public PMatrix3D projmodelview;
    protected float[] glProjection;
    protected float[] glModelview;
    protected float[] glProjmodelview;
    protected float[] glNormal;
    protected static PMatrix3D identity;
    protected boolean sized;
    protected static final int MATRIX_STACK_DEPTH = 32;
    protected int modelviewStackDepth;
    protected int projectionStackDepth;
    protected float[][] modelviewStack = new float[32][16];
    protected float[][] modelviewInvStack = new float[32][16];
    protected float[][] cameraStack = new float[32][16];
    protected float[][] cameraInvStack = new float[32][16];
    protected float[][] projectionStack = new float[32][16];
    public boolean lights;
    public int lightCount = 0;
    public int[] lightType;
    public float[] lightPosition;
    public float[] lightNormal;
    public float[] lightAmbient;
    public float[] lightDiffuse;
    public float[] lightSpecular;
    public float[] lightFalloffCoefficients;
    public float[] lightSpotParameters;
    public float[] currentLightSpecular;
    public float currentLightFalloffConstant;
    public float currentLightFalloffLinear;
    public float currentLightFalloffQuadratic;
    protected int textureWrap = 0;
    protected int textureSampling = 5;
    protected boolean clip = false;
    protected int[] clipRect = new int[]{0, 0, 0, 0};
    FontTexture textTex;
    protected static final int FB_STACK_DEPTH = 16;
    protected int fbStackDepth;
    protected FrameBuffer[] fbStack;
    protected FrameBuffer drawFramebuffer;
    protected FrameBuffer readFramebuffer;
    protected FrameBuffer currentFramebuffer;
    protected FrameBuffer offscreenFramebuffer;
    protected FrameBuffer multisampleFramebuffer;
    protected boolean offscreenMultisample;
    protected boolean pixOpChangedFB;
    protected Texture texture = null;
    protected Texture ptexture = null;
    protected IntBuffer pixelBuffer;
    protected int[] nativePixels;
    protected IntBuffer nativePixelBuffer;
    protected Texture filterTexture = null;
    protected PImage filterImage;
    protected boolean drawing = false;
    protected boolean smoothDisabled = false;
    protected int smoothCallCount = 0;
    protected int lastSmoothCall = -10;
    protected int lastBlendMode = -1;
    protected static final int OP_NONE = 0;
    protected static final int OP_READ = 1;
    protected static final int OP_WRITE = 2;
    protected int pixelsOp = 0;
    protected IntBuffer viewport;
    protected boolean openContour = false;
    protected boolean breakShape = false;
    protected boolean defaultEdges = false;
    protected static final int EDGE_MIDDLE = 0;
    protected static final int EDGE_START = 1;
    protected static final int EDGE_STOP = 2;
    protected static final int EDGE_SINGLE = 3;
    protected static final int EDGE_CLOSE = -1;
    protected static final int MIN_POINT_ACCURACY = 20;
    protected static final int MAX_POINT_ACCURACY = 200;
    protected static final float POINT_ACCURACY_FACTOR = 10.0f;
    protected static final float[][] QUAD_POINT_SIGNS;
    protected static IntBuffer intBuffer;
    protected static FloatBuffer floatBuffer;
    static final String OPENGL_THREAD_ERROR = "Cannot run the OpenGL renderer outside the main thread, change your code\nso the drawing calls are all inside the main thread, \nor use the default renderer instead.";
    static final String BLEND_DRIVER_ERROR = "blendMode(%1$s) is not supported by this hardware (or driver)";
    static final String BLEND_RENDERER_ERROR = "blendMode(%1$s) is not supported by this renderer";
    static final String ALREADY_BEGAN_CONTOUR_ERROR = "Already called beginContour()";
    static final String NO_BEGIN_CONTOUR_ERROR = "Need to call beginContour() first";
    static final String UNSUPPORTED_SMOOTH_LEVEL_ERROR = "Smooth level %1$s is not available. Using %2$s instead";
    static final String UNSUPPORTED_SMOOTH_ERROR = "Smooth is not supported by this hardware (or driver)";
    static final String TOO_MANY_SMOOTH_CALLS_ERROR = "The smooth/noSmooth functions are being called too often.\nThis results in screen flickering, so they will be disabled\nfor the rest of the sketch's execution";
    static final String UNSUPPORTED_SHAPE_FORMAT_ERROR = "Unsupported shape format";
    static final String MISSING_UV_TEXCOORDS_ERROR = "No uv texture coordinates supplied with vertex() call";
    static final String INVALID_FILTER_SHADER_ERROR = "Your shader cannot be used as a filter because is of type POINT or LINES";
    static final String INCONSISTENT_SHADER_TYPES = "The vertex and fragment shaders have different types";
    static final String WRONG_SHADER_TYPE_ERROR = "shader() called with a wrong shader";
    static final String SHADER_NEED_LIGHT_ATTRIBS = "The provided shader needs light attributes (ambient, diffuse, etc.), but the current scene is unlit, so the default shader will be used instead";
    static final String MISSING_FRAGMENT_SHADER = "The fragment shader is missing, cannot create shader object";
    static final String MISSING_VERTEX_SHADER = "The vertex shader is missing, cannot create shader object";
    static final String UNKNOWN_SHADER_KIND_ERROR = "Unknown shader kind";
    static final String NO_TEXLIGHT_SHADER_ERROR = "Your shader needs to be of TEXLIGHT type to render this geometry properly, using default shader instead.";
    static final String NO_LIGHT_SHADER_ERROR = "Your shader needs to be of LIGHT type to render this geometry properly, using default shader instead.";
    static final String NO_TEXTURE_SHADER_ERROR = "Your shader needs to be of TEXTURE type to render this geometry properly, using default shader instead.";
    static final String NO_COLOR_SHADER_ERROR = "Your shader needs to be of COLOR type to render this geometry properly, using default shader instead.";
    static final String TESSELLATION_ERROR = "Tessellation Error: %1$s";
    static final String GL_THREAD_NOT_CURRENT = "You are trying to draw outside OpenGL's animation thread.\nPlace all drawing commands in the draw() function, or inside\nyour own functions as long as they are called from draw(),\nbut not in event handling functions such as keyPressed()\nor mousePressed().";
    private static final int MAX_DRAIN_GLRES_ITERATIONS = 10;

    public PGraphicsOpenGL() {
        this.pgl = this.createPGL(this);
        if (intBuffer == null) {
            intBuffer = PGL.allocateIntBuffer(2);
            floatBuffer = PGL.allocateFloatBuffer(2);
        }
        this.viewport = PGL.allocateIntBuffer(4);
        this.polyAttribs = PGraphicsOpenGL.newAttributeMap();
        this.inGeo = PGraphicsOpenGL.newInGeometry(this, this.polyAttribs, 0);
        this.tessGeo = PGraphicsOpenGL.newTessGeometry(this, this.polyAttribs, 0);
        this.texCache = PGraphicsOpenGL.newTexCache(this);
        this.projection = new PMatrix3D();
        this.camera = new PMatrix3D();
        this.cameraInv = new PMatrix3D();
        this.modelview = new PMatrix3D();
        this.modelviewInv = new PMatrix3D();
        this.projmodelview = new PMatrix3D();
        this.lightType = new int[PGL.MAX_LIGHTS];
        this.lightPosition = new float[4 * PGL.MAX_LIGHTS];
        this.lightNormal = new float[3 * PGL.MAX_LIGHTS];
        this.lightAmbient = new float[3 * PGL.MAX_LIGHTS];
        this.lightDiffuse = new float[3 * PGL.MAX_LIGHTS];
        this.lightSpecular = new float[3 * PGL.MAX_LIGHTS];
        this.lightFalloffCoefficients = new float[3 * PGL.MAX_LIGHTS];
        this.lightSpotParameters = new float[2 * PGL.MAX_LIGHTS];
        this.currentLightSpecular = new float[3];
        this.initialized = false;
    }

    @Override
    public void setParent(PApplet pApplet) {
        super.setParent(pApplet);
        if (this.pgl != null) {
            this.pgl.sketch = pApplet;
        }
    }

    @Override
    public void setPrimary(boolean bl) {
        super.setPrimary(bl);
        this.pgl.setPrimary(bl);
        this.format = 2;
        if (bl) {
            this.fbStack = new FrameBuffer[16];
            this.fontMap = new WeakHashMap();
            this.tessellator = new Tessellator();
        } else {
            this.tessellator = this.getPrimaryPG().tessellator;
        }
    }

    @Override
    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.updatePixelSize();
        this.defCameraFOV = 1.0471976f;
        this.defCameraX = (float)this.width / 2.0f;
        this.defCameraY = (float)this.height / 2.0f;
        this.defCameraZ = this.defCameraY / (float)Math.tan(this.defCameraFOV / 2.0f);
        this.defCameraNear = this.defCameraZ / 10.0f;
        this.defCameraFar = this.defCameraZ * 10.0f;
        this.defCameraAspect = (float)this.width / (float)this.height;
        this.cameraFOV = this.defCameraFOV;
        this.cameraX = this.defCameraX;
        this.cameraY = this.defCameraY;
        this.cameraZ = this.defCameraZ;
        this.cameraNear = this.defCameraNear;
        this.cameraFar = this.defCameraFar;
        this.cameraAspect = this.defCameraAspect;
        this.sized = true;
    }

    @Override
    public void dispose() {
        if (this.asyncPixelReader != null) {
            this.asyncPixelReader.dispose();
            this.asyncPixelReader = null;
        }
        if (!this.primaryGraphics) {
            this.deleteSurfaceTextures();
            FrameBuffer frameBuffer = this.offscreenFramebuffer;
            FrameBuffer frameBuffer2 = this.multisampleFramebuffer;
            if (frameBuffer != null) {
                frameBuffer.dispose();
            }
            if (frameBuffer2 != null) {
                frameBuffer2.dispose();
            }
        }
        this.pgl.dispose();
        super.dispose();
    }

    protected void setFlushMode(int n) {
        this.flushMode = n;
    }

    protected void updatePixelSize() {
        float f = this.pgl.getPixelScale();
        this.pixelWidth = (int)((float)this.width * f);
        this.pixelHeight = (int)((float)this.height * f);
    }

    protected PGL createPGL(PGraphicsOpenGL pGraphicsOpenGL) {
        return new PGLES(pGraphicsOpenGL);
    }

    @Override
    public void setFrameRate(float f) {
        this.pgl.setFrameRate(f);
    }

    @Override
    public boolean canDraw() {
        return this.pgl.canDraw();
    }

    @Override
    public void requestDraw() {
        if (this.primaryGraphics) {
            if (this.initialized) {
                if (this.sized) {
                    this.pgl.reinitSurface();
                }
                if (this.parent.canDraw()) {
                    this.pgl.requestDraw();
                }
            } else {
                this.initPrimary();
            }
        }
    }

    public boolean saveImpl(String string) {
        return super.save(string);
    }

    @Override
    public void setCache(PImage pImage, Object object) {
        if (pImage instanceof PGraphicsOpenGL) {
            this.getPrimaryPG().cacheMap.put(pImage, new WeakReference<Object>(object));
            return;
        }
        this.getPrimaryPG().cacheMap.put(pImage, object);
    }

    @Override
    public Object getCache(PImage pImage) {
        Object v = this.getPrimaryPG().cacheMap.get(pImage);
        if (v != null && v.getClass() == WeakReference.class) {
            return ((WeakReference)v).get();
        }
        return v;
    }

    @Override
    public void removeCache(PImage pImage) {
        this.getPrimaryPG().cacheMap.remove(pImage);
    }

    protected void setFontTexture(PFont pFont, FontTexture fontTexture) {
        this.getPrimaryPG().fontMap.put(pFont, fontTexture);
    }

    protected FontTexture getFontTexture(PFont pFont) {
        return this.getPrimaryPG().fontMap.get(pFont);
    }

    protected void removeFontTexture(PFont pFont) {
        this.getPrimaryPG().fontMap.remove(pFont);
    }

    protected void pushFramebuffer() {
        PGraphicsOpenGL pGraphicsOpenGL = this.getPrimaryPG();
        if (pGraphicsOpenGL.fbStackDepth == 16) {
            throw new RuntimeException("Too many pushFramebuffer calls");
        }
        pGraphicsOpenGL.fbStack[pGraphicsOpenGL.fbStackDepth] = pGraphicsOpenGL.currentFramebuffer;
        ++pGraphicsOpenGL.fbStackDepth;
    }

    protected void setFramebuffer(FrameBuffer frameBuffer) {
        PGraphicsOpenGL pGraphicsOpenGL = this.getPrimaryPG();
        if (pGraphicsOpenGL.currentFramebuffer != frameBuffer) {
            pGraphicsOpenGL.currentFramebuffer = frameBuffer;
            if (pGraphicsOpenGL.currentFramebuffer != null) {
                pGraphicsOpenGL.currentFramebuffer.bind();
            }
        }
    }

    protected void popFramebuffer() {
        PGraphicsOpenGL pGraphicsOpenGL = this.getPrimaryPG();
        if (pGraphicsOpenGL.fbStackDepth == 0) {
            throw new RuntimeException("popFramebuffer call is unbalanced.");
        }
        --pGraphicsOpenGL.fbStackDepth;
        FrameBuffer frameBuffer = pGraphicsOpenGL.fbStack[pGraphicsOpenGL.fbStackDepth];
        if (pGraphicsOpenGL.currentFramebuffer != frameBuffer) {
            pGraphicsOpenGL.currentFramebuffer.finish();
            pGraphicsOpenGL.currentFramebuffer = frameBuffer;
            if (pGraphicsOpenGL.currentFramebuffer != null) {
                pGraphicsOpenGL.currentFramebuffer.bind();
            }
        }
    }

    protected FrameBuffer getCurrentFB() {
        return this.getPrimaryPG().currentFramebuffer;
    }

    protected void createPolyBuffers() {
        if (!this.polyBuffersCreated || this.polyBuffersContextIsOutdated()) {
            this.polyBuffersContext = this.pgl.getCurrentContext();
            this.bufPolyVertex = new VertexBuffer(this, PGL.ARRAY_BUFFER, 3, PGL.SIZEOF_FLOAT);
            this.bufPolyColor = new VertexBuffer(this, PGL.ARRAY_BUFFER, 1, PGL.SIZEOF_INT);
            this.bufPolyNormal = new VertexBuffer(this, PGL.ARRAY_BUFFER, 3, PGL.SIZEOF_FLOAT);
            this.bufPolyTexcoord = new VertexBuffer(this, PGL.ARRAY_BUFFER, 2, PGL.SIZEOF_FLOAT);
            this.bufPolyAmbient = new VertexBuffer(this, PGL.ARRAY_BUFFER, 1, PGL.SIZEOF_INT);
            this.bufPolySpecular = new VertexBuffer(this, PGL.ARRAY_BUFFER, 1, PGL.SIZEOF_INT);
            this.bufPolyEmissive = new VertexBuffer(this, PGL.ARRAY_BUFFER, 1, PGL.SIZEOF_INT);
            this.bufPolyShininess = new VertexBuffer(this, PGL.ARRAY_BUFFER, 1, PGL.SIZEOF_FLOAT);
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, 0);
            this.bufPolyIndex = new VertexBuffer(this, PGL.ELEMENT_ARRAY_BUFFER, 1, PGL.SIZEOF_INDEX, true);
            this.pgl.bindBuffer(PGL.ELEMENT_ARRAY_BUFFER, 0);
            this.polyBuffersCreated = true;
        }
        boolean bl = false;
        for (String string : this.polyAttribs.keySet()) {
            VertexAttribute vertexAttribute = (VertexAttribute)this.polyAttribs.get(string);
            if (vertexAttribute.bufferCreated() && !this.polyBuffersContextIsOutdated()) continue;
            vertexAttribute.createBuffer(this.pgl);
            bl = true;
        }
        if (bl) {
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, 0);
        }
    }

    protected void updatePolyBuffers(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.createPolyBuffers();
        int n = this.tessGeo.polyVertexCount;
        int n2 = n * PGL.SIZEOF_FLOAT;
        int n3 = n * PGL.SIZEOF_INT;
        this.tessGeo.updatePolyVerticesBuffer();
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.bufPolyVertex.glId);
        this.pgl.bufferData(PGL.ARRAY_BUFFER, 4 * n2, this.tessGeo.polyVerticesBuffer, PGL.STATIC_DRAW);
        this.tessGeo.updatePolyColorsBuffer();
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.bufPolyColor.glId);
        this.pgl.bufferData(PGL.ARRAY_BUFFER, n3, this.tessGeo.polyColorsBuffer, PGL.STATIC_DRAW);
        if (bl) {
            this.tessGeo.updatePolyAmbientBuffer();
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.bufPolyAmbient.glId);
            this.pgl.bufferData(PGL.ARRAY_BUFFER, n3, this.tessGeo.polyAmbientBuffer, PGL.STATIC_DRAW);
            this.tessGeo.updatePolySpecularBuffer();
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.bufPolySpecular.glId);
            this.pgl.bufferData(PGL.ARRAY_BUFFER, n3, this.tessGeo.polySpecularBuffer, PGL.STATIC_DRAW);
            this.tessGeo.updatePolyEmissiveBuffer();
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.bufPolyEmissive.glId);
            this.pgl.bufferData(PGL.ARRAY_BUFFER, n3, this.tessGeo.polyEmissiveBuffer, PGL.STATIC_DRAW);
            this.tessGeo.updatePolyShininessBuffer();
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.bufPolyShininess.glId);
            this.pgl.bufferData(PGL.ARRAY_BUFFER, n2, this.tessGeo.polyShininessBuffer, PGL.STATIC_DRAW);
        }
        if (bl || bl3) {
            this.tessGeo.updatePolyNormalsBuffer();
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.bufPolyNormal.glId);
            this.pgl.bufferData(PGL.ARRAY_BUFFER, 3 * n2, this.tessGeo.polyNormalsBuffer, PGL.STATIC_DRAW);
        }
        if (bl2 || bl4) {
            this.tessGeo.updatePolyTexCoordsBuffer();
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.bufPolyTexcoord.glId);
            this.pgl.bufferData(PGL.ARRAY_BUFFER, 2 * n2, this.tessGeo.polyTexCoordsBuffer, PGL.STATIC_DRAW);
        }
        for (String string : this.polyAttribs.keySet()) {
            VertexAttribute vertexAttribute = (VertexAttribute)this.polyAttribs.get(string);
            this.tessGeo.updateAttribBuffer(string);
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, vertexAttribute.buf.glId);
            this.pgl.bufferData(PGL.ARRAY_BUFFER, vertexAttribute.sizeInBytes(n), this.tessGeo.polyAttribBuffers.get(string), PGL.STATIC_DRAW);
        }
        this.tessGeo.updatePolyIndicesBuffer();
        this.pgl.bindBuffer(PGL.ELEMENT_ARRAY_BUFFER, this.bufPolyIndex.glId);
        this.pgl.bufferData(PGL.ELEMENT_ARRAY_BUFFER, this.tessGeo.polyIndexCount * PGL.SIZEOF_INDEX, this.tessGeo.polyIndicesBuffer, PGL.STATIC_DRAW);
    }

    protected void unbindPolyBuffers() {
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, 0);
        this.pgl.bindBuffer(PGL.ELEMENT_ARRAY_BUFFER, 0);
    }

    protected boolean polyBuffersContextIsOutdated() {
        return !this.pgl.contextIsCurrent(this.polyBuffersContext);
    }

    protected void createLineBuffers() {
        if (!this.lineBuffersCreated || this.lineBufferContextIsOutdated()) {
            this.lineBuffersContext = this.pgl.getCurrentContext();
            this.bufLineVertex = new VertexBuffer(this, PGL.ARRAY_BUFFER, 3, PGL.SIZEOF_FLOAT);
            this.bufLineColor = new VertexBuffer(this, PGL.ARRAY_BUFFER, 1, PGL.SIZEOF_INT);
            this.bufLineAttrib = new VertexBuffer(this, PGL.ARRAY_BUFFER, 4, PGL.SIZEOF_FLOAT);
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, 0);
            this.bufLineIndex = new VertexBuffer(this, PGL.ELEMENT_ARRAY_BUFFER, 1, PGL.SIZEOF_INDEX, true);
            this.pgl.bindBuffer(PGL.ELEMENT_ARRAY_BUFFER, 0);
            this.lineBuffersCreated = true;
        }
    }

    protected void updateLineBuffers() {
        this.createLineBuffers();
        int n = this.tessGeo.lineVertexCount;
        int n2 = n * PGL.SIZEOF_FLOAT;
        int n3 = n * PGL.SIZEOF_INT;
        this.tessGeo.updateLineVerticesBuffer();
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.bufLineVertex.glId);
        this.pgl.bufferData(PGL.ARRAY_BUFFER, 4 * n2, this.tessGeo.lineVerticesBuffer, PGL.STATIC_DRAW);
        this.tessGeo.updateLineColorsBuffer();
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.bufLineColor.glId);
        this.pgl.bufferData(PGL.ARRAY_BUFFER, n3, this.tessGeo.lineColorsBuffer, PGL.STATIC_DRAW);
        this.tessGeo.updateLineDirectionsBuffer();
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.bufLineAttrib.glId);
        this.pgl.bufferData(PGL.ARRAY_BUFFER, 4 * n2, this.tessGeo.lineDirectionsBuffer, PGL.STATIC_DRAW);
        this.tessGeo.updateLineIndicesBuffer();
        this.pgl.bindBuffer(PGL.ELEMENT_ARRAY_BUFFER, this.bufLineIndex.glId);
        this.pgl.bufferData(PGL.ELEMENT_ARRAY_BUFFER, this.tessGeo.lineIndexCount * PGL.SIZEOF_INDEX, this.tessGeo.lineIndicesBuffer, PGL.STATIC_DRAW);
    }

    protected void unbindLineBuffers() {
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, 0);
        this.pgl.bindBuffer(PGL.ELEMENT_ARRAY_BUFFER, 0);
    }

    protected boolean lineBufferContextIsOutdated() {
        return !this.pgl.contextIsCurrent(this.lineBuffersContext);
    }

    protected void createPointBuffers() {
        if (!this.pointBuffersCreated || this.pointBuffersContextIsOutdated()) {
            this.pointBuffersContext = this.pgl.getCurrentContext();
            this.bufPointVertex = new VertexBuffer(this, PGL.ARRAY_BUFFER, 3, PGL.SIZEOF_FLOAT);
            this.bufPointColor = new VertexBuffer(this, PGL.ARRAY_BUFFER, 1, PGL.SIZEOF_INT);
            this.bufPointAttrib = new VertexBuffer(this, PGL.ARRAY_BUFFER, 2, PGL.SIZEOF_FLOAT);
            this.pgl.bindBuffer(PGL.ARRAY_BUFFER, 0);
            this.bufPointIndex = new VertexBuffer(this, PGL.ELEMENT_ARRAY_BUFFER, 1, PGL.SIZEOF_INDEX, true);
            this.pgl.bindBuffer(PGL.ELEMENT_ARRAY_BUFFER, 0);
            this.pointBuffersCreated = true;
        }
    }

    protected void updatePointBuffers() {
        this.createPointBuffers();
        int n = this.tessGeo.pointVertexCount;
        int n2 = n * PGL.SIZEOF_FLOAT;
        int n3 = n * PGL.SIZEOF_INT;
        this.tessGeo.updatePointVerticesBuffer();
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.bufPointVertex.glId);
        this.pgl.bufferData(PGL.ARRAY_BUFFER, 4 * n2, this.tessGeo.pointVerticesBuffer, PGL.STATIC_DRAW);
        this.tessGeo.updatePointColorsBuffer();
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.bufPointColor.glId);
        this.pgl.bufferData(PGL.ARRAY_BUFFER, n3, this.tessGeo.pointColorsBuffer, PGL.STATIC_DRAW);
        this.tessGeo.updatePointOffsetsBuffer();
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, this.bufPointAttrib.glId);
        this.pgl.bufferData(PGL.ARRAY_BUFFER, 2 * n2, this.tessGeo.pointOffsetsBuffer, PGL.STATIC_DRAW);
        this.tessGeo.updatePointIndicesBuffer();
        this.pgl.bindBuffer(PGL.ELEMENT_ARRAY_BUFFER, this.bufPointIndex.glId);
        this.pgl.bufferData(PGL.ELEMENT_ARRAY_BUFFER, this.tessGeo.pointIndexCount * PGL.SIZEOF_INDEX, this.tessGeo.pointIndicesBuffer, PGL.STATIC_DRAW);
    }

    protected void unbindPointBuffers() {
        this.pgl.bindBuffer(PGL.ARRAY_BUFFER, 0);
        this.pgl.bindBuffer(PGL.ELEMENT_ARRAY_BUFFER, 0);
    }

    protected boolean pointBuffersContextIsOutdated() {
        return !this.pgl.contextIsCurrent(this.pointBuffersContext);
    }

    @Override
    public void beginDraw() {
        if (this.primaryGraphics) {
            if (!this.initialized) {
                this.initPrimary();
            }
            this.setCurrentPG(this);
        } else {
            this.pgl.getGL(this.getPrimaryPGL());
            this.getPrimaryPG().setCurrentPG(this);
        }
        if (!this.pgl.threadIsCurrent()) {
            PGraphics.showWarning(GL_THREAD_NOT_CURRENT);
            return;
        }
        this.report("top beginDraw()");
        if (!this.checkGLThread()) {
            return;
        }
        if (this.drawing) {
            return;
        }
        if (!this.primaryGraphics && this.getPrimaryPG().texCache.containsTexture(this)) {
            this.getPrimaryPG().flush();
        }
        if (!glParamsRead) {
            this.getGLParameters();
        }
        this.setViewport();
        if (this.primaryGraphics) {
            this.beginOnscreenDraw();
        } else {
            this.beginOffscreenDraw();
        }
        this.checkSettings();
        this.drawing = true;
        this.report("bot beginDraw()");
    }

    @Override
    public void endDraw() {
        this.report("top endDraw()");
        if (!this.drawing) {
            return;
        }
        this.flush();
        if (this.primaryGraphics) {
            this.endOnscreenDraw();
        } else {
            this.endOffscreenDraw();
        }
        if (this.primaryGraphics) {
            this.setCurrentPG(null);
        } else {
            this.getPrimaryPG().setCurrentPG();
        }
        this.drawing = false;
        this.report("bot endDraw()");
    }

    protected PGraphicsOpenGL getPrimaryPG() {
        if (this.primaryGraphics) {
            return this;
        }
        return (PGraphicsOpenGL)this.parent.g;
    }

    protected void setCurrentPG(PGraphicsOpenGL pGraphicsOpenGL) {
        this.currentPG = pGraphicsOpenGL;
    }

    protected void setCurrentPG() {
        this.currentPG = this;
    }

    protected PGraphicsOpenGL getCurrentPG() {
        return this.currentPG;
    }

    protected PGL getPrimaryPGL() {
        if (this.primaryGraphics) {
            return this.pgl;
        }
        return ((PGraphicsOpenGL)this.parent.g).pgl;
    }

    @Override
    public PGL beginPGL() {
        this.flush();
        this.pgl.beginGL();
        return this.pgl;
    }

    @Override
    public void endPGL() {
        this.pgl.endGL();
        this.restoreGL();
    }

    public void updateProjmodelview() {
        this.projmodelview.set(this.projection);
        this.projmodelview.apply(this.modelview);
    }

    protected void restartPGL() {
        this.initialized = false;
    }

    protected void restoreGL() {
        this.blendMode(this.blendMode);
        if (this.hints[2]) {
            this.pgl.disable(PGL.DEPTH_TEST);
        } else {
            this.pgl.enable(PGL.DEPTH_TEST);
        }
        this.pgl.depthFunc(PGL.LEQUAL);
        if (this.smooth < 1) {
            this.pgl.disable(PGL.MULTISAMPLE);
        } else {
            this.pgl.enable(PGL.MULTISAMPLE);
            this.pgl.disable(PGL.POLYGON_SMOOTH);
        }
        this.pgl.viewport(this.viewport.get(0), this.viewport.get(1), this.viewport.get(2), this.viewport.get(3));
        if (this.clip) {
            this.pgl.enable(PGL.SCISSOR_TEST);
            this.pgl.scissor(this.clipRect[0], this.clipRect[1], this.clipRect[2], this.clipRect[3]);
        } else {
            this.pgl.disable(PGL.SCISSOR_TEST);
        }
        this.pgl.frontFace(PGL.CW);
        this.pgl.disable(PGL.CULL_FACE);
        this.pgl.activeTexture(PGL.TEXTURE0);
        if (this.hints[5]) {
            this.pgl.depthMask(false);
        } else {
            this.pgl.depthMask(true);
        }
        FrameBuffer frameBuffer = this.getCurrentFB();
        if (frameBuffer != null) {
            frameBuffer.bind();
            if (drawBufferSupported) {
                this.pgl.drawBuffer(frameBuffer.getDefaultDrawBuffer());
            }
        }
    }

    protected void beginBindFramebuffer(int n, int n2) {
    }

    protected void endBindFramebuffer(int n, int n2) {
        FrameBuffer frameBuffer = this.getCurrentFB();
        if (n2 == 0 && frameBuffer != null && frameBuffer.glFbo != 0) {
            frameBuffer.bind();
        }
    }

    protected void beginReadPixels() {
        this.beginPixelsOp(1);
    }

    protected void endReadPixels() {
        this.endPixelsOp();
    }

    protected void beginPixelsOp(int n) {
        FrameBuffer frameBuffer = null;
        FrameBuffer frameBuffer2 = this.getCurrentFB();
        if (this.primaryGraphics) {
            FrameBuffer frameBuffer3 = this.readFramebuffer;
            FrameBuffer frameBuffer4 = this.drawFramebuffer;
            if (frameBuffer2 == frameBuffer3 || frameBuffer2 == frameBuffer4) {
                if (n == 1) {
                    if (this.pgl.isFBOBacked() && this.pgl.isMultisampled()) {
                        this.pgl.syncBackTexture();
                        frameBuffer = frameBuffer3;
                    } else {
                        frameBuffer = frameBuffer4;
                    }
                } else if (n == 2) {
                    frameBuffer = frameBuffer4;
                }
            }
        } else {
            FrameBuffer frameBuffer5 = this.offscreenFramebuffer;
            FrameBuffer frameBuffer6 = this.multisampleFramebuffer;
            if (frameBuffer2 == frameBuffer5 || frameBuffer2 == frameBuffer6) {
                if (n == 1) {
                    if (this.offscreenMultisample) {
                        int n2 = PGL.COLOR_BUFFER_BIT;
                        if (this.hints[10]) {
                            n2 |= PGL.DEPTH_BUFFER_BIT | PGL.STENCIL_BUFFER_BIT;
                        }
                        if (frameBuffer5 != null && frameBuffer6 != null) {
                            frameBuffer6.copy(frameBuffer5, n2);
                        }
                    }
                    frameBuffer = frameBuffer5;
                } else if (n == 2) {
                    FrameBuffer frameBuffer7 = frameBuffer = this.offscreenMultisample ? frameBuffer6 : frameBuffer5;
                }
            }
        }
        if (frameBuffer != null && frameBuffer != this.getCurrentFB()) {
            this.pushFramebuffer();
            this.setFramebuffer(frameBuffer);
            this.pixOpChangedFB = true;
        }
        if (n == 1) {
            if (readBufferSupported) {
                this.pgl.readBuffer(this.getCurrentFB().getDefaultDrawBuffer());
            }
        } else if (n == 2 && drawBufferSupported) {
            this.pgl.drawBuffer(this.getCurrentFB().getDefaultDrawBuffer());
        }
        this.pixelsOp = n;
    }

    protected void endPixelsOp() {
        if (this.pixOpChangedFB) {
            this.popFramebuffer();
            this.pixOpChangedFB = false;
        }
        if (readBufferSupported) {
            this.pgl.readBuffer(this.getCurrentFB().getDefaultReadBuffer());
        }
        if (drawBufferSupported) {
            this.pgl.drawBuffer(this.getCurrentFB().getDefaultDrawBuffer());
        }
        this.pixelsOp = 0;
    }

    protected void updateGLProjection() {
        if (this.glProjection == null) {
            this.glProjection = new float[16];
        }
        this.glProjection[0] = this.projection.m00;
        this.glProjection[1] = this.projection.m10;
        this.glProjection[2] = this.projection.m20;
        this.glProjection[3] = this.projection.m30;
        this.glProjection[4] = this.projection.m01;
        this.glProjection[5] = this.projection.m11;
        this.glProjection[6] = this.projection.m21;
        this.glProjection[7] = this.projection.m31;
        this.glProjection[8] = this.projection.m02;
        this.glProjection[9] = this.projection.m12;
        this.glProjection[10] = this.projection.m22;
        this.glProjection[11] = this.projection.m32;
        this.glProjection[12] = this.projection.m03;
        this.glProjection[13] = this.projection.m13;
        this.glProjection[14] = this.projection.m23;
        this.glProjection[15] = this.projection.m33;
    }

    protected void updateGLModelview() {
        if (this.glModelview == null) {
            this.glModelview = new float[16];
        }
        this.glModelview[0] = this.modelview.m00;
        this.glModelview[1] = this.modelview.m10;
        this.glModelview[2] = this.modelview.m20;
        this.glModelview[3] = this.modelview.m30;
        this.glModelview[4] = this.modelview.m01;
        this.glModelview[5] = this.modelview.m11;
        this.glModelview[6] = this.modelview.m21;
        this.glModelview[7] = this.modelview.m31;
        this.glModelview[8] = this.modelview.m02;
        this.glModelview[9] = this.modelview.m12;
        this.glModelview[10] = this.modelview.m22;
        this.glModelview[11] = this.modelview.m32;
        this.glModelview[12] = this.modelview.m03;
        this.glModelview[13] = this.modelview.m13;
        this.glModelview[14] = this.modelview.m23;
        this.glModelview[15] = this.modelview.m33;
    }

    protected void updateGLProjmodelview() {
        if (this.glProjmodelview == null) {
            this.glProjmodelview = new float[16];
        }
        this.glProjmodelview[0] = this.projmodelview.m00;
        this.glProjmodelview[1] = this.projmodelview.m10;
        this.glProjmodelview[2] = this.projmodelview.m20;
        this.glProjmodelview[3] = this.projmodelview.m30;
        this.glProjmodelview[4] = this.projmodelview.m01;
        this.glProjmodelview[5] = this.projmodelview.m11;
        this.glProjmodelview[6] = this.projmodelview.m21;
        this.glProjmodelview[7] = this.projmodelview.m31;
        this.glProjmodelview[8] = this.projmodelview.m02;
        this.glProjmodelview[9] = this.projmodelview.m12;
        this.glProjmodelview[10] = this.projmodelview.m22;
        this.glProjmodelview[11] = this.projmodelview.m32;
        this.glProjmodelview[12] = this.projmodelview.m03;
        this.glProjmodelview[13] = this.projmodelview.m13;
        this.glProjmodelview[14] = this.projmodelview.m23;
        this.glProjmodelview[15] = this.projmodelview.m33;
    }

    protected void updateGLNormal() {
        if (this.glNormal == null) {
            this.glNormal = new float[9];
        }
        this.glNormal[0] = this.modelviewInv.m00;
        this.glNormal[1] = this.modelviewInv.m01;
        this.glNormal[2] = this.modelviewInv.m02;
        this.glNormal[3] = this.modelviewInv.m10;
        this.glNormal[4] = this.modelviewInv.m11;
        this.glNormal[5] = this.modelviewInv.m12;
        this.glNormal[6] = this.modelviewInv.m20;
        this.glNormal[7] = this.modelviewInv.m21;
        this.glNormal[8] = this.modelviewInv.m22;
    }

    @Override
    protected void defaultSettings() {
        super.defaultSettings();
        this.manipulatingCamera = false;
        this.textureMode(2);
        this.ambient(255);
        this.specular(125);
        this.emissive(0);
        this.shininess(1.0f);
        this.setAmbient = false;
    }

    @Override
    public void hint(int n) {
        boolean bl = this.hints[PApplet.abs(n)];
        super.hint(n);
        boolean bl2 = this.hints[PApplet.abs(n)];
        if (bl == bl2) {
            return;
        }
        if (n == 2) {
            this.flush();
            this.pgl.disable(PGL.DEPTH_TEST);
        } else if (n == -2) {
            this.flush();
            this.pgl.enable(PGL.DEPTH_TEST);
        } else if (n == 5) {
            this.flush();
            this.pgl.depthMask(false);
        } else if (n == -5) {
            this.flush();
            this.pgl.depthMask(true);
        } else if (n == -6) {
            this.flush();
            this.setFlushMode(1);
        } else if (n == 6) {
            if (this.is2D()) {
                PGraphics.showWarning("Optimized strokes can only be disabled in 3D");
            } else {
                this.flush();
                this.setFlushMode(0);
            }
        } else if (n == -7) {
            if (0 < this.tessGeo.lineVertexCount && 0 < this.tessGeo.lineIndexCount) {
                this.flush();
            }
        } else if (n == 7) {
            if (0 < this.tessGeo.lineVertexCount && 0 < this.tessGeo.lineIndexCount) {
                this.flush();
            }
        } else if (n == 3) {
            if (this.is3D()) {
                this.flush();
                if (this.sorter == null) {
                    this.sorter = new DepthSorter(this);
                }
                this.isDepthSortingEnabled = true;
            } else {
                PGraphics.showWarning("Depth sorting can only be enabled in 3D");
            }
        } else if (n == -3) {
            if (this.is3D()) {
                this.flush();
                this.isDepthSortingEnabled = false;
            }
        } else if (n == 10) {
            this.restartPGL();
        } else if (n == -10) {
            this.restartPGL();
        }
    }

    protected boolean getHint(int n) {
        if (n > 0) {
            return this.hints[n];
        }
        return !this.hints[-n];
    }

    @Override
    protected PShape createShapeFamily(int n) {
        PShapeOpenGL pShapeOpenGL = new PShapeOpenGL(this, n);
        if (this.is3D()) {
            pShapeOpenGL.set3D(true);
        }
        return pShapeOpenGL;
    }

    @Override
    protected PShape createShapePrimitive(int n, float ... fArray) {
        PShapeOpenGL pShapeOpenGL = new PShapeOpenGL(this, n, fArray);
        if (this.is3D()) {
            pShapeOpenGL.set3D(true);
        }
        return pShapeOpenGL;
    }

    @Override
    public void beginShape(int n) {
        this.shape = n;
        this.inGeo.clear();
        this.curveVertexCount = 0;
        this.breakShape = false;
        this.defaultEdges = true;
        super.noTexture();
        this.normalMode = 0;
    }

    @Override
    public void endShape(int n) {
        this.tessellate(n);
        if (this.flushMode == 0 || this.flushMode == 1 && this.tessGeo.isFull()) {
            this.flush();
        } else {
            this.loaded = false;
        }
    }

    protected void endShape(int[] nArray) {
        if (this.shape != 8 && this.shape != 9) {
            throw new RuntimeException("Indices and edges can only be set for TRIANGLE shapes");
        }
        this.tessellate(nArray);
        if (this.flushMode == 0 || this.flushMode == 1 && this.tessGeo.isFull()) {
            this.flush();
        } else {
            this.loaded = false;
        }
    }

    @Override
    public void textureWrap(int n) {
        this.textureWrap = n;
    }

    public void textureSampling(int n) {
        this.textureSampling = n;
    }

    @Override
    public void beginContour() {
        if (this.openContour) {
            PGraphics.showWarning(ALREADY_BEGAN_CONTOUR_ERROR);
            return;
        }
        this.openContour = true;
        this.breakShape = true;
    }

    @Override
    public void endContour() {
        if (!this.openContour) {
            PGraphics.showWarning(NO_BEGIN_CONTOUR_ERROR);
            return;
        }
        this.openContour = false;
    }

    @Override
    public void vertex(float f, float f2) {
        this.vertexImpl(f, f2, 0.0f, 0.0f, 0.0f);
        if (this.textureImage != null) {
            PGraphics.showWarning(MISSING_UV_TEXCOORDS_ERROR);
        }
    }

    @Override
    public void vertex(float f, float f2, float f3, float f4) {
        this.vertexImpl(f, f2, 0.0f, f3, f4);
    }

    @Override
    public void vertex(float f, float f2, float f3) {
        this.vertexImpl(f, f2, f3, 0.0f, 0.0f);
        if (this.textureImage != null) {
            PGraphics.showWarning(MISSING_UV_TEXCOORDS_ERROR);
        }
    }

    @Override
    public void vertex(float f, float f2, float f3, float f4, float f5) {
        this.vertexImpl(f, f2, f3, f4, f5);
    }

    @Override
    public void attribPosition(String string, float f, float f2, float f3) {
        VertexAttribute vertexAttribute = this.attribImpl(string, 0, PGL.FLOAT, 3);
        if (vertexAttribute != null) {
            vertexAttribute.set(f, f2, f3);
        }
    }

    @Override
    public void attribNormal(String string, float f, float f2, float f3) {
        VertexAttribute vertexAttribute = this.attribImpl(string, 1, PGL.FLOAT, 3);
        if (vertexAttribute != null) {
            vertexAttribute.set(f, f2, f3);
        }
    }

    @Override
    public void attribColor(String string, int n) {
        VertexAttribute vertexAttribute = this.attribImpl(string, 2, PGL.INT, 1);
        if (vertexAttribute != null) {
            vertexAttribute.set(new int[]{n});
        }
    }

    @Override
    public void attrib(String string, float ... fArray) {
        VertexAttribute vertexAttribute = this.attribImpl(string, 3, PGL.FLOAT, fArray.length);
        if (vertexAttribute != null) {
            vertexAttribute.set(fArray);
        }
    }

    @Override
    public void attrib(String string, int ... nArray) {
        VertexAttribute vertexAttribute = this.attribImpl(string, 3, PGL.INT, nArray.length);
        if (vertexAttribute != null) {
            vertexAttribute.set(nArray);
        }
    }

    @Override
    public void attrib(String string, boolean ... blArray) {
        VertexAttribute vertexAttribute = this.attribImpl(string, 3, PGL.BOOL, blArray.length);
        if (vertexAttribute != null) {
            vertexAttribute.set(blArray);
        }
    }

    protected VertexAttribute attribImpl(String string, int n, int n2, int n3) {
        if (4 < n3) {
            PGraphics.showWarning("Vertex attributes cannot have more than 4 values");
            return null;
        }
        VertexAttribute vertexAttribute = (VertexAttribute)this.polyAttribs.get(string);
        if (vertexAttribute == null) {
            vertexAttribute = new VertexAttribute(this, string, n, n2, n3);
            this.polyAttribs.put(string, vertexAttribute);
            this.inGeo.initAttrib(vertexAttribute);
            this.tessGeo.initAttrib(vertexAttribute);
        }
        if (vertexAttribute.kind != n) {
            PGraphics.showWarning("The attribute kind cannot be changed after creation");
            return null;
        }
        if (vertexAttribute.type != n2) {
            PGraphics.showWarning("The attribute type cannot be changed after creation");
            return null;
        }
        if (vertexAttribute.size != n3) {
            PGraphics.showWarning("New value for vertex attribute has wrong number of values");
            return null;
        }
        return vertexAttribute;
    }

    protected void vertexImpl(float f, float f2, float f3, float f4, float f5) {
        boolean bl = this.textureImage != null;
        int n = 0;
        if (this.fill || bl) {
            n = !bl ? this.fillColor : (this.tint ? this.tintColor : -1);
        }
        int n2 = 0;
        float f6 = 0.0f;
        if (this.stroke) {
            n2 = this.strokeColor;
            f6 = this.strokeWeight;
        }
        if (bl && this.textureMode == 2) {
            f4 /= (float)this.textureImage.width;
            f5 /= (float)this.textureImage.height;
        }
        this.inGeo.addVertex(f, f2, f3, n, this.normalX, this.normalY, this.normalZ, f4, f5, n2, f6, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess, 0, this.vertexBreak());
    }

    protected boolean vertexBreak() {
        if (this.breakShape) {
            this.breakShape = false;
            return true;
        }
        return false;
    }

    @Override
    protected void clipImpl(float f, float f2, float f3, float f4) {
        this.flush();
        this.pgl.enable(PGL.SCISSOR_TEST);
        float f5 = f4 - f2;
        this.clipRect[0] = (int)f;
        this.clipRect[1] = (int)((float)this.height - f2 - f5);
        this.clipRect[2] = (int)(f3 - f);
        this.clipRect[3] = (int)f5;
        this.pgl.scissor(this.clipRect[0], this.clipRect[1], this.clipRect[2], this.clipRect[3]);
        this.clip = true;
    }

    @Override
    public void noClip() {
        if (this.clip) {
            this.flush();
            this.pgl.disable(PGL.SCISSOR_TEST);
            this.clip = false;
        }
    }

    protected void tessellate(int n) {
        this.tessellator.setInGeometry(this.inGeo);
        this.tessellator.setTessGeometry(this.tessGeo);
        this.tessellator.setFill(this.fill || this.textureImage != null);
        this.tessellator.setTexCache(this.texCache, this.textureImage);
        this.tessellator.setStroke(this.stroke);
        this.tessellator.setStrokeColor(this.strokeColor);
        this.tessellator.setStrokeWeight(this.strokeWeight);
        this.tessellator.setStrokeCap(this.strokeCap);
        this.tessellator.setStrokeJoin(this.strokeJoin);
        this.tessellator.setRenderer(this);
        this.tessellator.setTransform(this.modelview);
        this.tessellator.set3D(this.is3D());
        if (this.shape == 3) {
            this.tessellator.tessellatePoints();
        } else if (this.shape == 5) {
            this.tessellator.tessellateLines();
        } else if (this.shape == 50) {
            this.tessellator.tessellateLineStrip();
        } else if (this.shape == 51) {
            this.tessellator.tessellateLineLoop();
        } else if (this.shape == 8 || this.shape == 9) {
            if (this.stroke && this.defaultEdges) {
                this.inGeo.addTrianglesEdges();
            }
            if (this.normalMode == 0) {
                this.inGeo.calcTrianglesNormals();
            }
            this.tessellator.tessellateTriangles();
        } else if (this.shape == 11) {
            if (this.stroke && this.defaultEdges) {
                this.inGeo.addTriangleFanEdges();
            }
            if (this.normalMode == 0) {
                this.inGeo.calcTriangleFanNormals();
            }
            this.tessellator.tessellateTriangleFan();
        } else if (this.shape == 10) {
            if (this.stroke && this.defaultEdges) {
                this.inGeo.addTriangleStripEdges();
            }
            if (this.normalMode == 0) {
                this.inGeo.calcTriangleStripNormals();
            }
            this.tessellator.tessellateTriangleStrip();
        } else if (this.shape == 16 || this.shape == 17) {
            if (this.stroke && this.defaultEdges) {
                this.inGeo.addQuadsEdges();
            }
            if (this.normalMode == 0) {
                this.inGeo.calcQuadsNormals();
            }
            this.tessellator.tessellateQuads();
        } else if (this.shape == 18) {
            if (this.stroke && this.defaultEdges) {
                this.inGeo.addQuadStripEdges();
            }
            if (this.normalMode == 0) {
                this.inGeo.calcQuadStripNormals();
            }
            this.tessellator.tessellateQuadStrip();
        } else if (this.shape == 20) {
            this.tessellator.tessellatePolygon(true, n == 2, this.normalMode == 0);
        }
    }

    protected void tessellate(int[] nArray) {
        this.tessellator.setInGeometry(this.inGeo);
        this.tessellator.setTessGeometry(this.tessGeo);
        this.tessellator.setFill(this.fill || this.textureImage != null);
        this.tessellator.setStroke(this.stroke);
        this.tessellator.setStrokeColor(this.strokeColor);
        this.tessellator.setStrokeWeight(this.strokeWeight);
        this.tessellator.setStrokeCap(this.strokeCap);
        this.tessellator.setStrokeJoin(this.strokeJoin);
        this.tessellator.setTexCache(this.texCache, this.textureImage);
        this.tessellator.setTransform(this.modelview);
        this.tessellator.set3D(this.is3D());
        if (this.stroke && this.defaultEdges) {
            this.inGeo.addTrianglesEdges();
        }
        if (this.normalMode == 0) {
            this.inGeo.calcTrianglesNormals();
        }
        this.tessellator.tessellateTriangles(nArray);
    }

    @Override
    public void flush() {
        boolean bl;
        boolean bl2 = 0 < this.tessGeo.polyVertexCount && 0 < this.tessGeo.polyIndexCount;
        boolean bl3 = 0 < this.tessGeo.lineVertexCount && 0 < this.tessGeo.lineIndexCount;
        boolean bl4 = 0 < this.tessGeo.pointVertexCount && 0 < this.tessGeo.pointIndexCount;
        boolean bl5 = bl = this.modified && this.pixels != null;
        if (bl) {
            this.flushPixels();
        }
        if (bl4 || bl3 || bl2) {
            PMatrix3D pMatrix3D = null;
            PMatrix3D pMatrix3D2 = null;
            if (this.flushMode == 1) {
                pMatrix3D = this.modelview;
                pMatrix3D2 = this.modelviewInv;
                this.modelview = this.modelviewInv = identity;
                this.projmodelview.set(this.projection);
            }
            if (bl2 && !this.isDepthSortingEnabled) {
                this.flushPolys();
                if (this.raw != null) {
                    this.rawPolys();
                }
            }
            if (this.is3D()) {
                if (bl3) {
                    this.flushLines();
                    if (this.raw != null) {
                        this.rawLines();
                    }
                }
                if (bl4) {
                    this.flushPoints();
                    if (this.raw != null) {
                        this.rawPoints();
                    }
                }
            }
            if (bl2 && this.isDepthSortingEnabled) {
                this.flushSortedPolys();
                if (this.raw != null) {
                    this.rawSortedPolys();
                }
            }
            if (this.flushMode == 1) {
                this.modelview = pMatrix3D;
                this.modelviewInv = pMatrix3D2;
                this.updateProjmodelview();
            }
            this.loaded = false;
        }
        this.tessGeo.clear();
        this.texCache.clear();
    }

    protected void flushPixels() {
        this.drawPixels(this.mx1, this.my1, this.mx2 - this.mx1, this.my2 - this.my1);
        this.modified = false;
    }

    protected void flushPolys() {
        boolean bl = this.polyShader != null;
        boolean bl2 = bl ? this.polyShader.accessNormals() : false;
        boolean bl3 = bl ? this.polyShader.accessTexCoords() : false;
        this.updatePolyBuffers(this.lights, this.texCache.hasTextures, bl2, bl3);
        for (int i = 0; i < this.texCache.size; ++i) {
            Texture texture = this.texCache.getTexture(i);
            PShader pShader = this.getPolyShader(this.lights, texture != null);
            pShader.bind();
            int n = this.texCache.firstCache[i];
            int n2 = this.texCache.lastCache[i];
            IndexCache indexCache = this.tessGeo.polyIndexCache;
            for (int j = n; j <= n2; ++j) {
                int n3 = j == n ? this.texCache.firstIndex[i] : indexCache.indexOffset[j];
                int n4 = j == n2 ? this.texCache.lastIndex[i] - n3 + 1 : indexCache.indexOffset[j] + indexCache.indexCount[j] - n3;
                int n5 = indexCache.vertexOffset[j];
                pShader.setVertexAttribute(this.bufPolyVertex.glId, 4, PGL.FLOAT, 0, 4 * n5 * PGL.SIZEOF_FLOAT);
                pShader.setColorAttribute(this.bufPolyColor.glId, 4, PGL.UNSIGNED_BYTE, 0, 4 * n5 * PGL.SIZEOF_BYTE);
                if (this.lights) {
                    pShader.setNormalAttribute(this.bufPolyNormal.glId, 3, PGL.FLOAT, 0, 3 * n5 * PGL.SIZEOF_FLOAT);
                    pShader.setAmbientAttribute(this.bufPolyAmbient.glId, 4, PGL.UNSIGNED_BYTE, 0, 4 * n5 * PGL.SIZEOF_BYTE);
                    pShader.setSpecularAttribute(this.bufPolySpecular.glId, 4, PGL.UNSIGNED_BYTE, 0, 4 * n5 * PGL.SIZEOF_BYTE);
                    pShader.setEmissiveAttribute(this.bufPolyEmissive.glId, 4, PGL.UNSIGNED_BYTE, 0, 4 * n5 * PGL.SIZEOF_BYTE);
                    pShader.setShininessAttribute(this.bufPolyShininess.glId, 1, PGL.FLOAT, 0, n5 * PGL.SIZEOF_FLOAT);
                }
                if (this.lights || bl2) {
                    pShader.setNormalAttribute(this.bufPolyNormal.glId, 3, PGL.FLOAT, 0, 3 * n5 * PGL.SIZEOF_FLOAT);
                }
                if (texture != null || bl3) {
                    pShader.setTexcoordAttribute(this.bufPolyTexcoord.glId, 2, PGL.FLOAT, 0, 2 * n5 * PGL.SIZEOF_FLOAT);
                    pShader.setTexture(texture);
                }
                for (VertexAttribute vertexAttribute : this.polyAttribs.values()) {
                    if (!vertexAttribute.active(pShader)) continue;
                    vertexAttribute.bind(this.pgl);
                    pShader.setAttributeVBO(vertexAttribute.glLoc, vertexAttribute.buf.glId, vertexAttribute.tessSize, vertexAttribute.type, vertexAttribute.isColor(), 0, vertexAttribute.sizeInBytes(n5));
                }
                pShader.draw(this.bufPolyIndex.glId, n4, n3);
            }
            for (VertexAttribute vertexAttribute : this.polyAttribs.values()) {
                if (!vertexAttribute.active(pShader)) continue;
                vertexAttribute.unbind(this.pgl);
            }
            pShader.unbind();
        }
        this.unbindPolyBuffers();
    }

    protected void flushSortedPolys() {
        boolean bl = this.polyShader != null;
        boolean bl2 = bl ? this.polyShader.accessNormals() : false;
        boolean bl3 = bl ? this.polyShader.accessTexCoords() : false;
        this.sorter.sort(this.tessGeo);
        int n = this.tessGeo.polyIndexCount / 3;
        int[] nArray = this.sorter.texMap;
        int[] nArray2 = this.sorter.voffsetMap;
        int[] nArray3 = this.tessGeo.polyIndexCache.vertexOffset;
        this.updatePolyBuffers(this.lights, this.texCache.hasTextures, bl2, bl3);
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2;
            int n4 = nArray[n2];
            int n5 = nArray2[n2];
            while (++n2 < n && n4 == nArray[n2] && n5 == nArray2[n2]) {
            }
            int n6 = n2;
            Texture texture = this.texCache.getTexture(n4);
            int n7 = nArray3[n5];
            int n8 = 3 * n3;
            int n9 = 3 * (n6 - n3);
            PShader pShader = this.getPolyShader(this.lights, texture != null);
            pShader.bind();
            pShader.setVertexAttribute(this.bufPolyVertex.glId, 4, PGL.FLOAT, 0, 4 * n7 * PGL.SIZEOF_FLOAT);
            pShader.setColorAttribute(this.bufPolyColor.glId, 4, PGL.UNSIGNED_BYTE, 0, 4 * n7 * PGL.SIZEOF_BYTE);
            if (this.lights) {
                pShader.setNormalAttribute(this.bufPolyNormal.glId, 3, PGL.FLOAT, 0, 3 * n7 * PGL.SIZEOF_FLOAT);
                pShader.setAmbientAttribute(this.bufPolyAmbient.glId, 4, PGL.UNSIGNED_BYTE, 0, 4 * n7 * PGL.SIZEOF_BYTE);
                pShader.setSpecularAttribute(this.bufPolySpecular.glId, 4, PGL.UNSIGNED_BYTE, 0, 4 * n7 * PGL.SIZEOF_BYTE);
                pShader.setEmissiveAttribute(this.bufPolyEmissive.glId, 4, PGL.UNSIGNED_BYTE, 0, 4 * n7 * PGL.SIZEOF_BYTE);
                pShader.setShininessAttribute(this.bufPolyShininess.glId, 1, PGL.FLOAT, 0, n7 * PGL.SIZEOF_FLOAT);
            }
            if (this.lights || bl2) {
                pShader.setNormalAttribute(this.bufPolyNormal.glId, 3, PGL.FLOAT, 0, 3 * n7 * PGL.SIZEOF_FLOAT);
            }
            if (texture != null || bl3) {
                pShader.setTexcoordAttribute(this.bufPolyTexcoord.glId, 2, PGL.FLOAT, 0, 2 * n7 * PGL.SIZEOF_FLOAT);
                pShader.setTexture(texture);
            }
            for (VertexAttribute vertexAttribute : this.polyAttribs.values()) {
                if (!vertexAttribute.active(pShader)) continue;
                vertexAttribute.bind(this.pgl);
                pShader.setAttributeVBO(vertexAttribute.glLoc, vertexAttribute.buf.glId, vertexAttribute.tessSize, vertexAttribute.type, vertexAttribute.isColor(), 0, vertexAttribute.sizeInBytes(n7));
            }
            pShader.draw(this.bufPolyIndex.glId, n9, n8);
            for (VertexAttribute vertexAttribute : this.polyAttribs.values()) {
                if (!vertexAttribute.active(pShader)) continue;
                vertexAttribute.unbind(this.pgl);
            }
            pShader.unbind();
        }
        this.unbindPolyBuffers();
    }

    void rawPolys() {
        this.raw.colorMode(1);
        this.raw.noStroke();
        this.raw.beginShape(9);
        float[] fArray = this.tessGeo.polyVertices;
        int[] nArray = this.tessGeo.polyColors;
        float[] fArray2 = this.tessGeo.polyTexCoords;
        short[] sArray = this.tessGeo.polyIndices;
        for (int i = 0; i < this.texCache.size; ++i) {
            PImage pImage = this.texCache.getTextureImage(i);
            int n = this.texCache.firstCache[i];
            int n2 = this.texCache.lastCache[i];
            IndexCache indexCache = this.tessGeo.polyIndexCache;
            for (int j = n; j <= n2; ++j) {
                int n3 = j == n ? this.texCache.firstIndex[i] : indexCache.indexOffset[j];
                int n4 = j == n2 ? this.texCache.lastIndex[i] - n3 + 1 : indexCache.indexOffset[j] + indexCache.indexCount[j] - n3;
                int n5 = indexCache.vertexOffset[j];
                for (int k = n3 / 3; k < (n3 + n4) / 3; ++k) {
                    float f;
                    float f2;
                    float f3;
                    int n6 = n5 + sArray[3 * k + 0];
                    int n7 = n5 + sArray[3 * k + 1];
                    int n8 = n5 + sArray[3 * k + 2];
                    float[] fArray3 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    float[] fArray4 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    float[] fArray5 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    int n9 = PGL.nativeToJavaARGB(nArray[n6]);
                    int n10 = PGL.nativeToJavaARGB(nArray[n7]);
                    int n11 = PGL.nativeToJavaARGB(nArray[n8]);
                    if (this.flushMode == 0) {
                        float[] fArray6 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                        float[] fArray7 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                        float[] fArray8 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                        PApplet.arrayCopy(fArray, 4 * n6, fArray6, 0, 4);
                        PApplet.arrayCopy(fArray, 4 * n7, fArray7, 0, 4);
                        PApplet.arrayCopy(fArray, 4 * n8, fArray8, 0, 4);
                        this.modelview.mult(fArray6, fArray3);
                        this.modelview.mult(fArray7, fArray4);
                        this.modelview.mult(fArray8, fArray5);
                    } else {
                        PApplet.arrayCopy(fArray, 4 * n6, fArray3, 0, 4);
                        PApplet.arrayCopy(fArray, 4 * n7, fArray4, 0, 4);
                        PApplet.arrayCopy(fArray, 4 * n8, fArray5, 0, 4);
                    }
                    if (pImage != null) {
                        this.raw.texture(pImage);
                        if (this.raw.is3D()) {
                            this.raw.fill(n9);
                            this.raw.vertex(fArray3[0], fArray3[1], fArray3[2], fArray2[2 * n6 + 0], fArray2[2 * n6 + 1]);
                            this.raw.fill(n10);
                            this.raw.vertex(fArray4[0], fArray4[1], fArray4[2], fArray2[2 * n7 + 0], fArray2[2 * n7 + 1]);
                            this.raw.fill(n11);
                            this.raw.vertex(fArray5[0], fArray5[1], fArray5[2], fArray2[2 * n8 + 0], fArray2[2 * n8 + 1]);
                            continue;
                        }
                        if (!this.raw.is2D()) continue;
                        float f4 = this.screenXImpl(fArray3[0], fArray3[1], fArray3[2], fArray3[3]);
                        float f5 = this.screenYImpl(fArray3[0], fArray3[1], fArray3[2], fArray3[3]);
                        float f6 = this.screenXImpl(fArray4[0], fArray4[1], fArray4[2], fArray4[3]);
                        f3 = this.screenYImpl(fArray4[0], fArray4[1], fArray4[2], fArray4[3]);
                        f2 = this.screenXImpl(fArray5[0], fArray5[1], fArray5[2], fArray5[3]);
                        f = this.screenYImpl(fArray5[0], fArray5[1], fArray5[2], fArray5[3]);
                        this.raw.fill(n9);
                        this.raw.vertex(f4, f5, fArray2[2 * n6 + 0], fArray2[2 * n6 + 1]);
                        this.raw.fill(n10);
                        this.raw.vertex(f6, f3, fArray2[2 * n7 + 0], fArray2[2 * n7 + 1]);
                        this.raw.fill(n10);
                        this.raw.vertex(f2, f, fArray2[2 * n8 + 0], fArray2[2 * n8 + 1]);
                        continue;
                    }
                    if (this.raw.is3D()) {
                        this.raw.fill(n9);
                        this.raw.vertex(fArray3[0], fArray3[1], fArray3[2]);
                        this.raw.fill(n10);
                        this.raw.vertex(fArray4[0], fArray4[1], fArray4[2]);
                        this.raw.fill(n11);
                        this.raw.vertex(fArray5[0], fArray5[1], fArray5[2]);
                        continue;
                    }
                    if (!this.raw.is2D()) continue;
                    float f7 = this.screenXImpl(fArray3[0], fArray3[1], fArray3[2], fArray3[3]);
                    float f8 = this.screenYImpl(fArray3[0], fArray3[1], fArray3[2], fArray3[3]);
                    float f9 = this.screenXImpl(fArray4[0], fArray4[1], fArray4[2], fArray4[3]);
                    f3 = this.screenYImpl(fArray4[0], fArray4[1], fArray4[2], fArray4[3]);
                    f2 = this.screenXImpl(fArray5[0], fArray5[1], fArray5[2], fArray5[3]);
                    f = this.screenYImpl(fArray5[0], fArray5[1], fArray5[2], fArray5[3]);
                    this.raw.fill(n9);
                    this.raw.vertex(f7, f8);
                    this.raw.fill(n10);
                    this.raw.vertex(f9, f3);
                    this.raw.fill(n11);
                    this.raw.vertex(f2, f);
                }
            }
        }
        this.raw.endShape();
    }

    void rawSortedPolys() {
        this.raw.colorMode(1);
        this.raw.noStroke();
        this.raw.beginShape(9);
        float[] fArray = this.tessGeo.polyVertices;
        int[] nArray = this.tessGeo.polyColors;
        float[] fArray2 = this.tessGeo.polyTexCoords;
        short[] sArray = this.tessGeo.polyIndices;
        this.sorter.sort(this.tessGeo);
        int[] nArray2 = this.sorter.triangleIndices;
        int[] nArray3 = this.sorter.texMap;
        int[] nArray4 = this.sorter.voffsetMap;
        int[] nArray5 = this.tessGeo.polyIndexCache.vertexOffset;
        for (int i = 0; i < this.tessGeo.polyIndexCount / 3; ++i) {
            float f;
            float f2;
            float f3;
            int n = nArray2[i];
            PImage pImage = this.texCache.getTextureImage(nArray3[n]);
            int n2 = nArray5[nArray4[n]];
            int n3 = n2 + sArray[3 * n + 0];
            int n4 = n2 + sArray[3 * n + 1];
            int n5 = n2 + sArray[3 * n + 2];
            float[] fArray3 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            float[] fArray4 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            float[] fArray5 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
            int n6 = PGL.nativeToJavaARGB(nArray[n3]);
            int n7 = PGL.nativeToJavaARGB(nArray[n4]);
            int n8 = PGL.nativeToJavaARGB(nArray[n5]);
            if (this.flushMode == 0) {
                float[] fArray6 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                float[] fArray7 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                float[] fArray8 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                PApplet.arrayCopy(fArray, 4 * n3, fArray6, 0, 4);
                PApplet.arrayCopy(fArray, 4 * n4, fArray7, 0, 4);
                PApplet.arrayCopy(fArray, 4 * n5, fArray8, 0, 4);
                this.modelview.mult(fArray6, fArray3);
                this.modelview.mult(fArray7, fArray4);
                this.modelview.mult(fArray8, fArray5);
            } else {
                PApplet.arrayCopy(fArray, 4 * n3, fArray3, 0, 4);
                PApplet.arrayCopy(fArray, 4 * n4, fArray4, 0, 4);
                PApplet.arrayCopy(fArray, 4 * n5, fArray5, 0, 4);
            }
            if (pImage != null) {
                this.raw.texture(pImage);
                if (this.raw.is3D()) {
                    this.raw.fill(n6);
                    this.raw.vertex(fArray3[0], fArray3[1], fArray3[2], fArray2[2 * n3 + 0], fArray2[2 * n3 + 1]);
                    this.raw.fill(n7);
                    this.raw.vertex(fArray4[0], fArray4[1], fArray4[2], fArray2[2 * n4 + 0], fArray2[2 * n4 + 1]);
                    this.raw.fill(n8);
                    this.raw.vertex(fArray5[0], fArray5[1], fArray5[2], fArray2[2 * n5 + 0], fArray2[2 * n5 + 1]);
                    continue;
                }
                if (!this.raw.is2D()) continue;
                float f4 = this.screenXImpl(fArray3[0], fArray3[1], fArray3[2], fArray3[3]);
                float f5 = this.screenYImpl(fArray3[0], fArray3[1], fArray3[2], fArray3[3]);
                float f6 = this.screenXImpl(fArray4[0], fArray4[1], fArray4[2], fArray4[3]);
                f3 = this.screenYImpl(fArray4[0], fArray4[1], fArray4[2], fArray4[3]);
                f2 = this.screenXImpl(fArray5[0], fArray5[1], fArray5[2], fArray5[3]);
                f = this.screenYImpl(fArray5[0], fArray5[1], fArray5[2], fArray5[3]);
                this.raw.fill(n6);
                this.raw.vertex(f4, f5, fArray2[2 * n3 + 0], fArray2[2 * n3 + 1]);
                this.raw.fill(n7);
                this.raw.vertex(f6, f3, fArray2[2 * n4 + 0], fArray2[2 * n4 + 1]);
                this.raw.fill(n7);
                this.raw.vertex(f2, f, fArray2[2 * n5 + 0], fArray2[2 * n5 + 1]);
                continue;
            }
            if (this.raw.is3D()) {
                this.raw.fill(n6);
                this.raw.vertex(fArray3[0], fArray3[1], fArray3[2]);
                this.raw.fill(n7);
                this.raw.vertex(fArray4[0], fArray4[1], fArray4[2]);
                this.raw.fill(n8);
                this.raw.vertex(fArray5[0], fArray5[1], fArray5[2]);
                continue;
            }
            if (!this.raw.is2D()) continue;
            float f7 = this.screenXImpl(fArray3[0], fArray3[1], fArray3[2], fArray3[3]);
            float f8 = this.screenYImpl(fArray3[0], fArray3[1], fArray3[2], fArray3[3]);
            float f9 = this.screenXImpl(fArray4[0], fArray4[1], fArray4[2], fArray4[3]);
            f3 = this.screenYImpl(fArray4[0], fArray4[1], fArray4[2], fArray4[3]);
            f2 = this.screenXImpl(fArray5[0], fArray5[1], fArray5[2], fArray5[3]);
            f = this.screenYImpl(fArray5[0], fArray5[1], fArray5[2], fArray5[3]);
            this.raw.fill(n6);
            this.raw.vertex(f7, f8);
            this.raw.fill(n7);
            this.raw.vertex(f9, f3);
            this.raw.fill(n8);
            this.raw.vertex(f2, f);
        }
        this.raw.endShape();
    }

    protected void flushLines() {
        this.updateLineBuffers();
        PShader pShader = this.getLineShader();
        pShader.bind();
        IndexCache indexCache = this.tessGeo.lineIndexCache;
        for (int i = 0; i < indexCache.size; ++i) {
            int n = indexCache.indexOffset[i];
            int n2 = indexCache.indexCount[i];
            int n3 = indexCache.vertexOffset[i];
            pShader.setVertexAttribute(this.bufLineVertex.glId, 4, PGL.FLOAT, 0, 4 * n3 * PGL.SIZEOF_FLOAT);
            pShader.setColorAttribute(this.bufLineColor.glId, 4, PGL.UNSIGNED_BYTE, 0, 4 * n3 * PGL.SIZEOF_BYTE);
            pShader.setLineAttribute(this.bufLineAttrib.glId, 4, PGL.FLOAT, 0, 4 * n3 * PGL.SIZEOF_FLOAT);
            pShader.draw(this.bufLineIndex.glId, n2, n);
        }
        pShader.unbind();
        this.unbindLineBuffers();
    }

    void rawLines() {
        this.raw.colorMode(1);
        this.raw.noFill();
        this.raw.strokeCap(this.strokeCap);
        this.raw.strokeJoin(this.strokeJoin);
        this.raw.beginShape(5);
        float[] fArray = this.tessGeo.lineVertices;
        int[] nArray = this.tessGeo.lineColors;
        float[] fArray2 = this.tessGeo.lineDirections;
        short[] sArray = this.tessGeo.lineIndices;
        IndexCache indexCache = this.tessGeo.lineIndexCache;
        for (int i = 0; i < indexCache.size; ++i) {
            int n = indexCache.indexOffset[i];
            int n2 = indexCache.indexCount[i];
            int n3 = indexCache.vertexOffset[i];
            for (int j = n / 6; j < (n + n2) / 6; ++j) {
                int n4 = n3 + sArray[6 * j + 0];
                int n5 = n3 + sArray[6 * j + 5];
                float f = 2.0f * fArray2[4 * n4 + 3];
                float f2 = 2.0f * fArray2[4 * n5 + 3];
                if (PGraphicsOpenGL.zero(f)) continue;
                float[] fArray3 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                float[] fArray4 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                int n6 = PGL.nativeToJavaARGB(nArray[n4]);
                int n7 = PGL.nativeToJavaARGB(nArray[n5]);
                if (this.flushMode == 0) {
                    float[] fArray5 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    float[] fArray6 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    PApplet.arrayCopy(fArray, 4 * n4, fArray5, 0, 4);
                    PApplet.arrayCopy(fArray, 4 * n5, fArray6, 0, 4);
                    this.modelview.mult(fArray5, fArray3);
                    this.modelview.mult(fArray6, fArray4);
                } else {
                    PApplet.arrayCopy(fArray, 4 * n4, fArray3, 0, 4);
                    PApplet.arrayCopy(fArray, 4 * n5, fArray4, 0, 4);
                }
                if (this.raw.is3D()) {
                    this.raw.strokeWeight(f);
                    this.raw.stroke(n6);
                    this.raw.vertex(fArray3[0], fArray3[1], fArray3[2]);
                    this.raw.strokeWeight(f2);
                    this.raw.stroke(n7);
                    this.raw.vertex(fArray4[0], fArray4[1], fArray4[2]);
                    continue;
                }
                if (!this.raw.is2D()) continue;
                float f3 = this.screenXImpl(fArray3[0], fArray3[1], fArray3[2], fArray3[3]);
                float f4 = this.screenYImpl(fArray3[0], fArray3[1], fArray3[2], fArray3[3]);
                float f5 = this.screenXImpl(fArray4[0], fArray4[1], fArray4[2], fArray4[3]);
                float f6 = this.screenYImpl(fArray4[0], fArray4[1], fArray4[2], fArray4[3]);
                this.raw.strokeWeight(f);
                this.raw.stroke(n6);
                this.raw.vertex(f3, f4);
                this.raw.strokeWeight(f2);
                this.raw.stroke(n7);
                this.raw.vertex(f5, f6);
            }
        }
        this.raw.endShape();
    }

    protected void flushPoints() {
        this.updatePointBuffers();
        PShader pShader = this.getPointShader();
        pShader.bind();
        IndexCache indexCache = this.tessGeo.pointIndexCache;
        for (int i = 0; i < indexCache.size; ++i) {
            int n = indexCache.indexOffset[i];
            int n2 = indexCache.indexCount[i];
            int n3 = indexCache.vertexOffset[i];
            pShader.setVertexAttribute(this.bufPointVertex.glId, 4, PGL.FLOAT, 0, 4 * n3 * PGL.SIZEOF_FLOAT);
            pShader.setColorAttribute(this.bufPointColor.glId, 4, PGL.UNSIGNED_BYTE, 0, 4 * n3 * PGL.SIZEOF_BYTE);
            pShader.setPointAttribute(this.bufPointAttrib.glId, 2, PGL.FLOAT, 0, 2 * n3 * PGL.SIZEOF_FLOAT);
            pShader.draw(this.bufPointIndex.glId, n2, n);
        }
        pShader.unbind();
        this.unbindPointBuffers();
    }

    void rawPoints() {
        this.raw.colorMode(1);
        this.raw.noFill();
        this.raw.strokeCap(this.strokeCap);
        this.raw.beginShape(3);
        float[] fArray = this.tessGeo.pointVertices;
        int[] nArray = this.tessGeo.pointColors;
        float[] fArray2 = this.tessGeo.pointOffsets;
        short[] sArray = this.tessGeo.pointIndices;
        IndexCache indexCache = this.tessGeo.pointIndexCache;
        for (int i = 0; i < indexCache.size; ++i) {
            int n;
            int n2 = indexCache.indexOffset[i];
            int n3 = indexCache.indexCount[i];
            int n4 = indexCache.vertexOffset[i];
            for (int j = n2; j < (n2 + n3) / 3; j += n) {
                float f;
                float f2 = fArray2[2 * j + 2];
                if (0.0f < f2) {
                    f = f2 / 0.5f;
                    n = PApplet.min(200, PApplet.max(20, (int)((float)Math.PI * 2 * f / 10.0f))) + 1;
                } else {
                    f = -f2 / 0.5f;
                    n = 5;
                }
                int n5 = n4 + sArray[3 * j];
                int n6 = PGL.nativeToJavaARGB(nArray[n5]);
                float[] fArray3 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                if (this.flushMode == 0) {
                    float[] fArray4 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    PApplet.arrayCopy(fArray, 4 * n5, fArray4, 0, 4);
                    this.modelview.mult(fArray4, fArray3);
                } else {
                    PApplet.arrayCopy(fArray, 4 * n5, fArray3, 0, 4);
                }
                if (this.raw.is3D()) {
                    this.raw.strokeWeight(f);
                    this.raw.stroke(n6);
                    this.raw.vertex(fArray3[0], fArray3[1], fArray3[2]);
                    continue;
                }
                if (!this.raw.is2D()) continue;
                float f3 = this.screenXImpl(fArray3[0], fArray3[1], fArray3[2], fArray3[3]);
                float f4 = this.screenYImpl(fArray3[0], fArray3[1], fArray3[2], fArray3[3]);
                this.raw.strokeWeight(f);
                this.raw.stroke(n6);
                this.raw.vertex(f3, f4);
            }
        }
        this.raw.endShape();
    }

    @Override
    public void bezierVertex(float f, float f2, float f3, float f4, float f5, float f6) {
        this.bezierVertexImpl(f, f2, 0.0f, f3, f4, 0.0f, f5, f6, 0.0f);
    }

    @Override
    public void bezierVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.bezierVertexImpl(f, f2, f3, f4, f5, f6, f7, f8, f9);
    }

    protected void bezierVertexImpl(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.bezierVertexCheck(this.shape, this.inGeo.vertexCount);
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addBezierVertex(f, f2, f3, f4, f5, f6, f7, f8, f9, this.vertexBreak());
    }

    @Override
    public void quadraticVertex(float f, float f2, float f3, float f4) {
        this.quadraticVertexImpl(f, f2, 0.0f, f3, f4, 0.0f);
    }

    @Override
    public void quadraticVertex(float f, float f2, float f3, float f4, float f5, float f6) {
        this.quadraticVertexImpl(f, f2, f3, f4, f5, f6);
    }

    protected void quadraticVertexImpl(float f, float f2, float f3, float f4, float f5, float f6) {
        this.bezierVertexCheck(this.shape, this.inGeo.vertexCount);
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addQuadraticVertex(f, f2, f3, f4, f5, f6, this.vertexBreak());
    }

    @Override
    public void curveVertex(float f, float f2) {
        this.curveVertexImpl(f, f2, 0.0f);
    }

    @Override
    public void curveVertex(float f, float f2, float f3) {
        this.curveVertexImpl(f, f2, f3);
    }

    protected void curveVertexImpl(float f, float f2, float f3) {
        this.curveVertexCheck(this.shape);
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addCurveVertex(f, f2, f3, this.vertexBreak());
    }

    @Override
    public void point(float f, float f2) {
        this.pointImpl(f, f2, 0.0f);
    }

    @Override
    public void point(float f, float f2, float f3) {
        this.pointImpl(f, f2, f3);
    }

    protected void pointImpl(float f, float f2, float f3) {
        this.beginShape(3);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addPoint(f, f2, f3, this.fill, this.stroke);
        this.endShape();
    }

    @Override
    public void line(float f, float f2, float f3, float f4) {
        this.lineImpl(f, f2, 0.0f, f3, f4, 0.0f);
    }

    @Override
    public void line(float f, float f2, float f3, float f4, float f5, float f6) {
        this.lineImpl(f, f2, f3, f4, f5, f6);
    }

    protected void lineImpl(float f, float f2, float f3, float f4, float f5, float f6) {
        this.beginShape(5);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addLine(f, f2, f3, f4, f5, f6, this.fill, this.stroke);
        this.endShape();
    }

    @Override
    public void triangle(float f, float f2, float f3, float f4, float f5, float f6) {
        this.beginShape(9);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addTriangle(f, f2, 0.0f, f3, f4, 0.0f, f5, f6, 0.0f, this.fill, this.stroke);
        this.endShape();
    }

    @Override
    public void quad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.beginShape(17);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addQuad(f, f2, 0.0f, f3, f4, 0.0f, f5, f6, 0.0f, f7, f8, 0.0f, this.stroke);
        this.endShape();
    }

    @Override
    protected void rectImpl(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.beginShape(20);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addRect(f, f2, f3, f4, f5, f6, f7, f8, this.stroke);
        this.endShape(2);
    }

    @Override
    public void ellipseImpl(float f, float f2, float f3, float f4) {
        this.beginShape(11);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addEllipse(f, f2, f3, f4, this.fill, this.stroke);
        this.endShape();
    }

    @Override
    protected void arcImpl(float f, float f2, float f3, float f4, float f5, float f6, int n) {
        this.beginShape(11);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addArc(f, f2, f3, f4, f5, f6, this.fill, this.stroke, n);
        this.endShape();
    }

    @Override
    public void box(float f, float f2, float f3) {
        this.beginShape(17);
        this.defaultEdges = false;
        this.normalMode = 2;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.addBox(f, f2, f3, this.fill, this.stroke);
        this.endShape();
    }

    @Override
    public void sphere(float f) {
        if (this.sphereDetailU < 3 || this.sphereDetailV < 2) {
            this.sphereDetail(30);
        }
        this.beginShape(9);
        this.defaultEdges = false;
        this.normalMode = 2;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        int[] nArray = this.inGeo.addSphere(f, this.sphereDetailU, this.sphereDetailV, this.fill, this.stroke);
        this.endShape(nArray);
    }

    @Override
    protected void shape(PShape pShape, float f, float f2, float f3) {
        if (pShape.isVisible()) {
            this.flush();
            this.pushMatrix();
            if (this.shapeMode == 3) {
                this.translate(f - pShape.getWidth() / 2.0f, f2 - pShape.getHeight() / 2.0f, f3 - pShape.getDepth() / 2.0f);
            } else if (this.shapeMode == 0 || this.shapeMode == 1) {
                this.translate(f, f2, f3);
            }
            pShape.draw(this);
            this.popMatrix();
        }
    }

    @Override
    protected void shape(PShape pShape, float f, float f2, float f3, float f4, float f5, float f6) {
        if (pShape.isVisible()) {
            this.flush();
            this.pushMatrix();
            if (this.shapeMode == 3) {
                this.translate(f - f4 / 2.0f, f2 - f5 / 2.0f, f3 - f6 / 2.0f);
                this.scale(f4 / pShape.getWidth(), f5 / pShape.getHeight(), f6 / pShape.getDepth());
            } else if (this.shapeMode == 0) {
                this.translate(f, f2, f3);
                this.scale(f4 / pShape.getWidth(), f5 / pShape.getHeight(), f6 / pShape.getDepth());
            } else if (this.shapeMode == 1) {
                this.translate(f, f2, f3);
                this.scale((f4 -= f) / pShape.getWidth(), (f5 -= f2) / pShape.getHeight(), (f6 -= f3) / pShape.getDepth());
            }
            pShape.draw(this);
            this.popMatrix();
        }
    }

    @Override
    public PShape loadShape(String string) {
        String string2 = PApplet.getExtension(string);
        if (PGraphics2D.isSupportedExtension(string2)) {
            return PGraphics2D.loadShapeImpl(this, string, string2);
        }
        if (PGraphics3D.isSupportedExtension(string2)) {
            return PGraphics3D.loadShapeImpl(this, string, string2);
        }
        PGraphics.showWarning(UNSUPPORTED_SHAPE_FORMAT_ERROR);
        return null;
    }

    @Override
    protected boolean textModeCheck(int n) {
        return n == 4 || n == 5 && PGL.SHAPE_TEXT_SUPPORTED;
    }

    @Override
    public float textAscent() {
        if (this.textFont == null) {
            this.defaultFontOrDeath("textAscent");
        }
        Object object = this.textFont.getNative();
        float f = 0.0f;
        if (object != null) {
            f = this.pgl.getFontAscent(object);
        }
        if (f == 0.0f) {
            f = super.textAscent();
        }
        return f;
    }

    @Override
    public float textDescent() {
        if (this.textFont == null) {
            this.defaultFontOrDeath("textDescent");
        }
        Object object = this.textFont.getNative();
        float f = 0.0f;
        if (object != null) {
            f = this.pgl.getFontDescent(object);
        }
        if (f == 0.0f) {
            f = super.textDescent();
        }
        return f;
    }

    @Override
    protected float textWidthImpl(char[] cArray, int n, int n2) {
        Object object = this.textFont.getNative();
        float f = 0.0f;
        if (object != null) {
            f = this.pgl.getTextWidth(object, cArray, n, n2);
        }
        if (f == 0.0f) {
            f = super.textWidthImpl(cArray, n, n2);
        }
        return f;
    }

    @Override
    protected void handleTextSize(float f) {
        Object object = this.textFont.getNative();
        if (object != null) {
            Object object2 = this.pgl.getDerivedFont(object, f);
            this.textFont.setNative(object2);
        }
        super.handleTextSize(f);
    }

    @Override
    protected void textLineImpl(char[] cArray, int n, int n2, float f, float f2) {
        if (this.textMode == 4) {
            this.textTex = this.getFontTexture(this.textFont);
            if (this.textTex == null || this.textTex.contextIsOutdated()) {
                this.textTex = new FontTexture(this, this.textFont, this.is3D());
                this.setFontTexture(this.textFont, this.textTex);
            }
            this.textTex.begin();
            int n3 = this.textureMode;
            boolean bl = this.stroke;
            float f3 = this.normalX;
            float f4 = this.normalY;
            float f5 = this.normalZ;
            boolean bl2 = this.tint;
            int n4 = this.tintColor;
            int n5 = this.blendMode;
            this.textureMode = 1;
            this.stroke = false;
            this.normalX = 0.0f;
            this.normalY = 0.0f;
            this.normalZ = 1.0f;
            this.tint = true;
            this.tintColor = this.fillColor;
            this.blendMode(1);
            super.textLineImpl(cArray, n, n2, f, f2);
            this.textureMode = n3;
            this.stroke = bl;
            this.normalX = f3;
            this.normalY = f4;
            this.normalZ = f5;
            this.tint = bl2;
            this.tintColor = n4;
            this.blendMode(n5);
            this.textTex.end();
        } else if (this.textMode == 5) {
            super.textLineImpl(cArray, n, n2, f, f2);
        }
    }

    @Override
    protected void textCharImpl(char c, float f, float f2) {
        PFont.Glyph glyph = this.textFont.getGlyph(c);
        if (glyph != null) {
            if (this.textMode == 4) {
                FontTexture.TextureInfo textureInfo = this.textTex.getTexInfo(glyph);
                if (textureInfo == null) {
                    textureInfo = this.textTex.addToTexture(this, glyph);
                }
                float f3 = (float)glyph.height / (float)this.textFont.getSize();
                float f4 = (float)glyph.width / (float)this.textFont.getSize();
                float f5 = (float)glyph.leftExtent / (float)this.textFont.getSize();
                float f6 = (float)glyph.topExtent / (float)this.textFont.getSize();
                float f7 = f + f5 * this.textSize;
                float f8 = f2 - f6 * this.textSize;
                float f9 = f7 + f4 * this.textSize;
                float f10 = f8 + f3 * this.textSize;
                this.textCharModelImpl(textureInfo, f7, f8, f9, f10);
            } else if (this.textMode == 5) {
                this.textCharShapeImpl(c, f, f2);
            }
        }
    }

    protected void textCharModelImpl(FontTexture.TextureInfo textureInfo, float f, float f2, float f3, float f4) {
        this.beginShape(17);
        this.texture(this.textTex.getTexture(textureInfo));
        this.vertex(f, f2, textureInfo.u0, textureInfo.v0);
        this.vertex(f3, f2, textureInfo.u1, textureInfo.v0);
        this.vertex(f3, f4, textureInfo.u1, textureInfo.v1);
        this.vertex(f, f4, textureInfo.u0, textureInfo.v1);
        this.endShape();
    }

    protected void textCharShapeImpl(char c, float f, float f2) {
        boolean bl = this.stroke;
        this.stroke = false;
        PGL.FontOutline fontOutline = this.pgl.createFontOutline(c, this.textFont.getNative());
        float[] fArray = new float[6];
        float f3 = 0.0f;
        float f4 = 0.0f;
        boolean bl2 = false;
        this.beginShape();
        while (!fontOutline.isDone()) {
            float f5;
            int n;
            int n2 = fontOutline.currentSegment(fArray);
            if (!bl2) {
                this.beginContour();
                bl2 = true;
            }
            if (n2 == PGL.SEG_MOVETO || n2 == PGL.SEG_LINETO) {
                this.vertex(f + fArray[0], f2 + fArray[1]);
                f3 = fArray[0];
                f4 = fArray[1];
            } else if (n2 == PGL.SEG_QUADTO) {
                for (n = 1; n < this.bezierDetail; ++n) {
                    f5 = (float)n / (float)this.bezierDetail;
                    this.vertex(f + this.bezierPoint(f3, f3 + (float)((double)((fArray[0] - f3) * 2.0f) / 3.0), fArray[2] + (float)((double)((fArray[0] - fArray[2]) * 2.0f) / 3.0), fArray[2], f5), f2 + this.bezierPoint(f4, f4 + (float)((double)((fArray[1] - f4) * 2.0f) / 3.0), fArray[3] + (float)((double)((fArray[1] - fArray[3]) * 2.0f) / 3.0), fArray[3], f5));
                }
                f3 = fArray[2];
                f4 = fArray[3];
            } else if (n2 == PGL.SEG_CUBICTO) {
                for (n = 1; n < this.bezierDetail; ++n) {
                    f5 = (float)n / (float)this.bezierDetail;
                    this.vertex(f + this.bezierPoint(f3, fArray[0], fArray[2], fArray[4], f5), f2 + this.bezierPoint(f4, fArray[1], fArray[3], fArray[5], f5));
                }
                f3 = fArray[4];
                f4 = fArray[5];
            } else if (n2 == PGL.SEG_CLOSE) {
                this.endContour();
                bl2 = false;
            }
            fontOutline.next();
        }
        this.endShape();
        this.stroke = bl;
    }

    @Override
    public void pushMatrix() {
        if (this.modelviewStackDepth == 32) {
            throw new RuntimeException("Too many calls to pushMatrix().");
        }
        this.modelview.get(this.modelviewStack[this.modelviewStackDepth]);
        this.modelviewInv.get(this.modelviewInvStack[this.modelviewStackDepth]);
        this.camera.get(this.cameraStack[this.modelviewStackDepth]);
        this.cameraInv.get(this.cameraInvStack[this.modelviewStackDepth]);
        ++this.modelviewStackDepth;
    }

    @Override
    public void popMatrix() {
        if (this.modelviewStackDepth == 0) {
            throw new RuntimeException("Too many calls to popMatrix(), and not enough to pushMatrix().");
        }
        --this.modelviewStackDepth;
        this.modelview.set(this.modelviewStack[this.modelviewStackDepth]);
        this.modelviewInv.set(this.modelviewInvStack[this.modelviewStackDepth]);
        this.camera.set(this.cameraStack[this.modelviewStackDepth]);
        this.cameraInv.set(this.cameraInvStack[this.modelviewStackDepth]);
        this.updateProjmodelview();
    }

    @Override
    public void translate(float f, float f2) {
        this.translateImpl(f, f2, 0.0f);
    }

    @Override
    public void translate(float f, float f2, float f3) {
        this.translateImpl(f, f2, f3);
    }

    protected void translateImpl(float f, float f2, float f3) {
        this.modelview.translate(f, f2, f3);
        PGraphicsOpenGL.invTranslate(this.modelviewInv, f, f2, f3);
        this.projmodelview.translate(f, f2, f3);
    }

    protected static void invTranslate(PMatrix3D pMatrix3D, float f, float f2, float f3) {
        pMatrix3D.preApply(1.0f, 0.0f, 0.0f, -f, 0.0f, 1.0f, 0.0f, -f2, 0.0f, 0.0f, 1.0f, -f3, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    protected static float matrixScale(PMatrix pMatrix) {
        float f = 1.0f;
        if (pMatrix != null) {
            if (pMatrix instanceof PMatrix2D) {
                PMatrix2D pMatrix2D = (PMatrix2D)pMatrix;
                float f2 = Math.abs(pMatrix2D.m00 * pMatrix2D.m11 - pMatrix2D.m01 * pMatrix2D.m10);
                f = (float)Math.sqrt(f2);
            } else if (pMatrix instanceof PMatrix3D) {
                PMatrix3D pMatrix3D = (PMatrix3D)pMatrix;
                float f3 = Math.abs(pMatrix3D.m00 * (pMatrix3D.m11 * pMatrix3D.m22 - pMatrix3D.m12 * pMatrix3D.m21) + pMatrix3D.m01 * (pMatrix3D.m12 * pMatrix3D.m20 - pMatrix3D.m10 * pMatrix3D.m22) + pMatrix3D.m02 * (pMatrix3D.m10 * pMatrix3D.m21 - pMatrix3D.m11 * pMatrix3D.m20));
                f = (float)Math.pow(f3, 0.3333333432674408);
            }
        }
        return f;
    }

    @Override
    public void rotate(float f) {
        this.rotateImpl(f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void rotateX(float f) {
        this.rotateImpl(f, 1.0f, 0.0f, 0.0f);
    }

    @Override
    public void rotateY(float f) {
        this.rotateImpl(f, 0.0f, 1.0f, 0.0f);
    }

    @Override
    public void rotateZ(float f) {
        this.rotateImpl(f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void rotate(float f, float f2, float f3, float f4) {
        this.rotateImpl(f, f2, f3, f4);
    }

    protected void rotateImpl(float f, float f2, float f3, float f4) {
        float f5 = f2 * f2 + f3 * f3 + f4 * f4;
        if (PGraphicsOpenGL.zero(f5)) {
            return;
        }
        if (PGraphicsOpenGL.diff(f5, 1.0f)) {
            float f6 = PApplet.sqrt(f5);
            f2 /= f6;
            f3 /= f6;
            f4 /= f6;
        }
        this.modelview.rotate(f, f2, f3, f4);
        PGraphicsOpenGL.invRotate(this.modelviewInv, f, f2, f3, f4);
        this.updateProjmodelview();
    }

    private static void invRotate(PMatrix3D pMatrix3D, float f, float f2, float f3, float f4) {
        float f5 = PApplet.cos(-f);
        float f6 = PApplet.sin(-f);
        float f7 = 1.0f - f5;
        pMatrix3D.preApply(f7 * f2 * f2 + f5, f7 * f2 * f3 - f6 * f4, f7 * f2 * f4 + f6 * f3, 0.0f, f7 * f2 * f3 + f6 * f4, f7 * f3 * f3 + f5, f7 * f3 * f4 - f6 * f2, 0.0f, f7 * f2 * f4 - f6 * f3, f7 * f3 * f4 + f6 * f2, f7 * f4 * f4 + f5, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void scale(float f) {
        this.scaleImpl(f, f, f);
    }

    @Override
    public void scale(float f, float f2) {
        this.scaleImpl(f, f2, 1.0f);
    }

    @Override
    public void scale(float f, float f2, float f3) {
        this.scaleImpl(f, f2, f3);
    }

    protected void scaleImpl(float f, float f2, float f3) {
        this.modelview.scale(f, f2, f3);
        PGraphicsOpenGL.invScale(this.modelviewInv, f, f2, f3);
        this.projmodelview.scale(f, f2, f3);
    }

    protected static void invScale(PMatrix3D pMatrix3D, float f, float f2, float f3) {
        pMatrix3D.preApply(1.0f / f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f / f2, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f / f3, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void shearX(float f) {
        float f2 = (float)Math.tan(f);
        this.applyMatrixImpl(1.0f, f2, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void shearY(float f) {
        float f2 = (float)Math.tan(f);
        this.applyMatrixImpl(1.0f, 0.0f, 0.0f, 0.0f, f2, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void resetMatrix() {
        this.modelview.reset();
        this.modelviewInv.reset();
        this.projmodelview.set(this.projection);
        this.camera.reset();
        this.cameraInv.reset();
    }

    @Override
    public void applyMatrix(PMatrix2D pMatrix2D) {
        this.applyMatrixImpl(pMatrix2D.m00, pMatrix2D.m01, 0.0f, pMatrix2D.m02, pMatrix2D.m10, pMatrix2D.m11, 0.0f, pMatrix2D.m12, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6) {
        this.applyMatrixImpl(f, f2, 0.0f, f3, f4, f5, 0.0f, f6, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void applyMatrix(PMatrix3D pMatrix3D) {
        this.applyMatrixImpl(pMatrix3D.m00, pMatrix3D.m01, pMatrix3D.m02, pMatrix3D.m03, pMatrix3D.m10, pMatrix3D.m11, pMatrix3D.m12, pMatrix3D.m13, pMatrix3D.m20, pMatrix3D.m21, pMatrix3D.m22, pMatrix3D.m23, pMatrix3D.m30, pMatrix3D.m31, pMatrix3D.m32, pMatrix3D.m33);
    }

    @Override
    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.applyMatrixImpl(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
    }

    protected void applyMatrixImpl(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.modelview.apply(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
        this.modelviewInv.set(this.modelview);
        this.modelviewInv.invert();
        this.projmodelview.apply(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
    }

    protected void begin2D() {
    }

    protected void end2D() {
    }

    @Override
    public PMatrix getMatrix() {
        return this.modelview.get();
    }

    @Override
    public PMatrix3D getMatrix(PMatrix3D pMatrix3D) {
        if (pMatrix3D == null) {
            pMatrix3D = new PMatrix3D();
        }
        pMatrix3D.set(this.modelview);
        return pMatrix3D;
    }

    @Override
    public void setMatrix(PMatrix2D pMatrix2D) {
        this.resetMatrix();
        this.applyMatrix(pMatrix2D);
    }

    @Override
    public void setMatrix(PMatrix3D pMatrix3D) {
        this.resetMatrix();
        this.applyMatrix(pMatrix3D);
    }

    @Override
    public void printMatrix() {
        this.modelview.print();
    }

    public void pushProjection() {
        if (this.projectionStackDepth == 32) {
            throw new RuntimeException("Too many calls to pushMatrix().");
        }
        this.projection.get(this.projectionStack[this.projectionStackDepth]);
        ++this.projectionStackDepth;
    }

    public void popProjection() {
        this.flush();
        if (this.projectionStackDepth == 0) {
            throw new RuntimeException("Too many calls to popMatrix(), and not enough to pushMatrix().");
        }
        --this.projectionStackDepth;
        this.projection.set(this.projectionStack[this.projectionStackDepth]);
        this.updateProjmodelview();
    }

    public void resetProjection() {
        this.flush();
        this.projection.reset();
        this.updateProjmodelview();
    }

    public void applyProjection(PMatrix3D pMatrix3D) {
        this.flush();
        this.projection.apply(pMatrix3D);
        this.updateProjmodelview();
    }

    public void applyProjection(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.flush();
        this.projection.apply(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
        this.updateProjmodelview();
    }

    public void setProjection(PMatrix3D pMatrix3D) {
        this.flush();
        this.projection.set(pMatrix3D);
        this.updateProjmodelview();
    }

    protected boolean orthoProjection() {
        return PGraphicsOpenGL.zero(this.projection.m01) && PGraphicsOpenGL.zero(this.projection.m02) && PGraphicsOpenGL.zero(this.projection.m10) && PGraphicsOpenGL.zero(this.projection.m12) && PGraphicsOpenGL.zero(this.projection.m20) && PGraphicsOpenGL.zero(this.projection.m21) && PGraphicsOpenGL.zero(this.projection.m30) && PGraphicsOpenGL.zero(this.projection.m31) && PGraphicsOpenGL.zero(this.projection.m32) && PGraphicsOpenGL.same(this.projection.m33, 1.0f);
    }

    protected boolean nonOrthoProjection() {
        return PGraphicsOpenGL.nonZero(this.projection.m01) || PGraphicsOpenGL.nonZero(this.projection.m02) || PGraphicsOpenGL.nonZero(this.projection.m10) || PGraphicsOpenGL.nonZero(this.projection.m12) || PGraphicsOpenGL.nonZero(this.projection.m20) || PGraphicsOpenGL.nonZero(this.projection.m21) || PGraphicsOpenGL.nonZero(this.projection.m30) || PGraphicsOpenGL.nonZero(this.projection.m31) || PGraphicsOpenGL.nonZero(this.projection.m32) || PGraphicsOpenGL.diff(this.projection.m33, 1.0f);
    }

    protected static boolean same(float f, float f2) {
        return Math.abs(f - f2) < PGL.FLOAT_EPS;
    }

    protected static boolean diff(float f, float f2) {
        return PGL.FLOAT_EPS <= Math.abs(f - f2);
    }

    protected static boolean zero(float f) {
        return Math.abs(f) < PGL.FLOAT_EPS;
    }

    protected static boolean nonZero(float f) {
        return PGL.FLOAT_EPS <= Math.abs(f);
    }

    @Override
    public void beginCamera() {
        if (this.manipulatingCamera) {
            throw new RuntimeException("beginCamera() cannot be called again before endCamera()");
        }
        this.manipulatingCamera = true;
    }

    @Override
    public void endCamera() {
        if (!this.manipulatingCamera) {
            throw new RuntimeException("Cannot call endCamera() without first calling beginCamera()");
        }
        this.camera.set(this.modelview);
        this.cameraInv.set(this.modelviewInv);
        this.manipulatingCamera = false;
    }

    @Override
    public void camera() {
        this.camera(this.defCameraX, this.defCameraY, this.defCameraZ, this.defCameraX, this.defCameraY, 0.0f, 0.0f, 1.0f, 0.0f);
    }

    @Override
    public void camera(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10;
        this.cameraX = f;
        this.cameraY = f2;
        this.cameraZ = f3;
        float f11 = f - f4;
        float f12 = f2 - f5;
        float f13 = f3 - f6;
        this.eyeDist = PApplet.sqrt(f11 * f11 + f12 * f12 + f13 * f13);
        if (PGraphicsOpenGL.nonZero(this.eyeDist)) {
            f11 /= this.eyeDist;
            f12 /= this.eyeDist;
            f13 /= this.eyeDist;
        }
        float f14 = f7;
        float f15 = f8;
        float f16 = f9;
        float f17 = f15 * f13 - f16 * f12;
        float f18 = -f14 * f13 + f16 * f11;
        float f19 = f14 * f12 - f15 * f11;
        f14 = f12 * f19 - f13 * f18;
        f15 = -f11 * f19 + f13 * f17;
        f16 = f11 * f18 - f12 * f17;
        float f20 = PApplet.sqrt(f17 * f17 + f18 * f18 + f19 * f19);
        if (PGraphicsOpenGL.nonZero(f20)) {
            f17 /= f20;
            f18 /= f20;
            f19 /= f20;
        }
        if (PGraphicsOpenGL.nonZero(f10 = PApplet.sqrt(f14 * f14 + f15 * f15 + f16 * f16))) {
            f14 /= f10;
            f15 /= f10;
            f16 /= f10;
        }
        this.modelview.set(f17, f18, f19, 0.0f, f14, f15, f16, 0.0f, f11, f12, f13, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        float f21 = -f;
        float f22 = -f2;
        float f23 = -f3;
        this.modelview.translate(f21, f22, f23);
        this.modelviewInv.set(this.modelview);
        this.modelviewInv.invert();
        this.camera.set(this.modelview);
        this.cameraInv.set(this.modelviewInv);
        this.updateProjmodelview();
    }

    @Override
    public void printCamera() {
        this.camera.print();
    }

    protected void defaultCamera() {
        this.camera();
    }

    @Override
    public void ortho() {
        this.ortho((float)(-this.width) / 2.0f, (float)this.width / 2.0f, (float)(-this.height) / 2.0f, (float)this.height / 2.0f, 0.0f, this.eyeDist * 10.0f);
    }

    @Override
    public void ortho(float f, float f2, float f3, float f4) {
        this.ortho(f, f2, f3, f4, 0.0f, this.eyeDist * 10.0f);
    }

    @Override
    public void ortho(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = f2 - f;
        float f8 = f4 - f3;
        float f9 = f6 - f5;
        this.flush();
        float f10 = 2.0f / f7;
        float f11 = 2.0f / f8;
        float f12 = -2.0f / f9;
        float f13 = -(f2 + f) / f7;
        float f14 = -(f4 + f3) / f8;
        float f15 = -(f6 + f5) / f9;
        this.projection.set(f10, 0.0f, 0.0f, f13, 0.0f, -f11, 0.0f, f14, 0.0f, 0.0f, f12, f15, 0.0f, 0.0f, 0.0f, 1.0f);
        this.updateProjmodelview();
    }

    @Override
    public void perspective() {
        this.perspective(this.defCameraFOV, this.defCameraAspect, this.defCameraNear, this.defCameraFar);
    }

    @Override
    public void perspective(float f, float f2, float f3, float f4) {
        float f5 = f3 * (float)Math.tan(f / 2.0f);
        float f6 = -f5;
        float f7 = f6 * f2;
        float f8 = f5 * f2;
        this.frustum(f7, f8, f6, f5, f3, f4);
    }

    @Override
    public void frustum(float f, float f2, float f3, float f4, float f5, float f6) {
        this.flush();
        this.cameraFOV = 2.0f * (float)Math.atan2(f4, f5);
        this.cameraAspect = f / f3;
        this.cameraNear = f5;
        this.cameraFar = f6;
        float f7 = 2.0f * f5;
        float f8 = f2 - f;
        float f9 = f4 - f3;
        float f10 = f6 - f5;
        this.projection.set(f7 / f8, 0.0f, (f2 + f) / f8, 0.0f, 0.0f, -f7 / f9, (f4 + f3) / f9, 0.0f, 0.0f, 0.0f, -(f6 + f5) / f10, -(f7 * f6) / f10, 0.0f, 0.0f, -1.0f, 0.0f);
        this.updateProjmodelview();
    }

    @Override
    public void printProjection() {
        this.projection.print();
    }

    protected void defaultPerspective() {
        this.perspective();
    }

    @Override
    public float screenX(float f, float f2) {
        return this.screenXImpl(f, f2, 0.0f);
    }

    @Override
    public float screenY(float f, float f2) {
        return this.screenYImpl(f, f2, 0.0f);
    }

    @Override
    public float screenX(float f, float f2, float f3) {
        return this.screenXImpl(f, f2, f3);
    }

    @Override
    public float screenY(float f, float f2, float f3) {
        return this.screenYImpl(f, f2, f3);
    }

    @Override
    public float screenZ(float f, float f2, float f3) {
        return this.screenZImpl(f, f2, f3);
    }

    protected float screenXImpl(float f, float f2, float f3) {
        float f4 = this.modelview.m00 * f + this.modelview.m01 * f2 + this.modelview.m02 * f3 + this.modelview.m03;
        float f5 = this.modelview.m10 * f + this.modelview.m11 * f2 + this.modelview.m12 * f3 + this.modelview.m13;
        float f6 = this.modelview.m20 * f + this.modelview.m21 * f2 + this.modelview.m22 * f3 + this.modelview.m23;
        float f7 = this.modelview.m30 * f + this.modelview.m31 * f2 + this.modelview.m32 * f3 + this.modelview.m33;
        return this.screenXImpl(f4, f5, f6, f7);
    }

    protected float screenXImpl(float f, float f2, float f3, float f4) {
        float f5 = this.projection.m00 * f + this.projection.m01 * f2 + this.projection.m02 * f3 + this.projection.m03 * f4;
        float f6 = this.projection.m30 * f + this.projection.m31 * f2 + this.projection.m32 * f3 + this.projection.m33 * f4;
        if (PGraphicsOpenGL.nonZero(f6)) {
            f5 /= f6;
        }
        float f7 = (float)this.width * (1.0f + f5) / 2.0f;
        return f7;
    }

    protected float screenYImpl(float f, float f2, float f3) {
        float f4 = this.modelview.m00 * f + this.modelview.m01 * f2 + this.modelview.m02 * f3 + this.modelview.m03;
        float f5 = this.modelview.m10 * f + this.modelview.m11 * f2 + this.modelview.m12 * f3 + this.modelview.m13;
        float f6 = this.modelview.m20 * f + this.modelview.m21 * f2 + this.modelview.m22 * f3 + this.modelview.m23;
        float f7 = this.modelview.m30 * f + this.modelview.m31 * f2 + this.modelview.m32 * f3 + this.modelview.m33;
        return this.screenYImpl(f4, f5, f6, f7);
    }

    protected float screenYImpl(float f, float f2, float f3, float f4) {
        float f5 = this.projection.m10 * f + this.projection.m11 * f2 + this.projection.m12 * f3 + this.projection.m13 * f4;
        float f6 = this.projection.m30 * f + this.projection.m31 * f2 + this.projection.m32 * f3 + this.projection.m33 * f4;
        if (PGraphicsOpenGL.nonZero(f6)) {
            f5 /= f6;
        }
        float f7 = (float)this.height * (1.0f + f5) / 2.0f;
        f7 = (float)this.height - f7;
        return f7;
    }

    protected float screenZImpl(float f, float f2, float f3) {
        float f4 = this.modelview.m00 * f + this.modelview.m01 * f2 + this.modelview.m02 * f3 + this.modelview.m03;
        float f5 = this.modelview.m10 * f + this.modelview.m11 * f2 + this.modelview.m12 * f3 + this.modelview.m13;
        float f6 = this.modelview.m20 * f + this.modelview.m21 * f2 + this.modelview.m22 * f3 + this.modelview.m23;
        float f7 = this.modelview.m30 * f + this.modelview.m31 * f2 + this.modelview.m32 * f3 + this.modelview.m33;
        return this.screenZImpl(f4, f5, f6, f7);
    }

    protected float screenZImpl(float f, float f2, float f3, float f4) {
        float f5 = this.projection.m20 * f + this.projection.m21 * f2 + this.projection.m22 * f3 + this.projection.m23 * f4;
        float f6 = this.projection.m30 * f + this.projection.m31 * f2 + this.projection.m32 * f3 + this.projection.m33 * f4;
        if (PGraphicsOpenGL.nonZero(f6)) {
            f5 /= f6;
        }
        float f7 = (f5 + 1.0f) / 2.0f;
        return f7;
    }

    @Override
    public float modelX(float f, float f2, float f3) {
        float f4 = this.modelview.m00 * f + this.modelview.m01 * f2 + this.modelview.m02 * f3 + this.modelview.m03;
        float f5 = this.modelview.m10 * f + this.modelview.m11 * f2 + this.modelview.m12 * f3 + this.modelview.m13;
        float f6 = this.modelview.m20 * f + this.modelview.m21 * f2 + this.modelview.m22 * f3 + this.modelview.m23;
        float f7 = this.modelview.m30 * f + this.modelview.m31 * f2 + this.modelview.m32 * f3 + this.modelview.m33;
        float f8 = this.cameraInv.m00 * f4 + this.cameraInv.m01 * f5 + this.cameraInv.m02 * f6 + this.cameraInv.m03 * f7;
        float f9 = this.cameraInv.m30 * f4 + this.cameraInv.m31 * f5 + this.cameraInv.m32 * f6 + this.cameraInv.m33 * f7;
        return PGraphicsOpenGL.nonZero(f9) ? f8 / f9 : f8;
    }

    @Override
    public float modelY(float f, float f2, float f3) {
        float f4 = this.modelview.m00 * f + this.modelview.m01 * f2 + this.modelview.m02 * f3 + this.modelview.m03;
        float f5 = this.modelview.m10 * f + this.modelview.m11 * f2 + this.modelview.m12 * f3 + this.modelview.m13;
        float f6 = this.modelview.m20 * f + this.modelview.m21 * f2 + this.modelview.m22 * f3 + this.modelview.m23;
        float f7 = this.modelview.m30 * f + this.modelview.m31 * f2 + this.modelview.m32 * f3 + this.modelview.m33;
        float f8 = this.cameraInv.m10 * f4 + this.cameraInv.m11 * f5 + this.cameraInv.m12 * f6 + this.cameraInv.m13 * f7;
        float f9 = this.cameraInv.m30 * f4 + this.cameraInv.m31 * f5 + this.cameraInv.m32 * f6 + this.cameraInv.m33 * f7;
        return PGraphicsOpenGL.nonZero(f9) ? f8 / f9 : f8;
    }

    @Override
    public float modelZ(float f, float f2, float f3) {
        float f4 = this.modelview.m00 * f + this.modelview.m01 * f2 + this.modelview.m02 * f3 + this.modelview.m03;
        float f5 = this.modelview.m10 * f + this.modelview.m11 * f2 + this.modelview.m12 * f3 + this.modelview.m13;
        float f6 = this.modelview.m20 * f + this.modelview.m21 * f2 + this.modelview.m22 * f3 + this.modelview.m23;
        float f7 = this.modelview.m30 * f + this.modelview.m31 * f2 + this.modelview.m32 * f3 + this.modelview.m33;
        float f8 = this.cameraInv.m20 * f4 + this.cameraInv.m21 * f5 + this.cameraInv.m22 * f6 + this.cameraInv.m23 * f7;
        float f9 = this.cameraInv.m30 * f4 + this.cameraInv.m31 * f5 + this.cameraInv.m32 * f6 + this.cameraInv.m33 * f7;
        return PGraphicsOpenGL.nonZero(f9) ? f8 / f9 : f8;
    }

    @Override
    public void popStyle() {
        boolean bl = this.setAmbient;
        super.popStyle();
        if (!bl) {
            this.setAmbient = false;
        }
    }

    @Override
    public void strokeWeight(float f) {
        this.strokeWeight = f;
    }

    @Override
    public void strokeJoin(int n) {
        this.strokeJoin = n;
    }

    @Override
    public void strokeCap(int n) {
        this.strokeCap = n;
    }

    @Override
    protected void fillFromCalc() {
        super.fillFromCalc();
        if (!this.setAmbient) {
            this.ambientFromCalc();
            this.setAmbient = false;
        }
    }

    @Override
    public void lights() {
        this.enableLighting();
        this.lightCount = 0;
        int n = this.colorMode;
        this.colorMode = 1;
        this.lightFalloff(1.0f, 0.0f, 0.0f);
        this.lightSpecular(0.0f, 0.0f, 0.0f);
        this.ambientLight(this.colorModeX * 0.5f, this.colorModeY * 0.5f, this.colorModeZ * 0.5f);
        this.directionalLight(this.colorModeX * 0.5f, this.colorModeY * 0.5f, this.colorModeZ * 0.5f, 0.0f, 0.0f, -1.0f);
        this.colorMode = n;
    }

    @Override
    public void noLights() {
        this.disableLighting();
        this.lightCount = 0;
    }

    @Override
    public void ambientLight(float f, float f2, float f3) {
        this.ambientLight(f, f2, f3, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public void ambientLight(float f, float f2, float f3, float f4, float f5, float f6) {
        this.enableLighting();
        if (this.lightCount == PGL.MAX_LIGHTS) {
            throw new RuntimeException("can only create " + PGL.MAX_LIGHTS + " lights");
        }
        this.lightType[this.lightCount] = 0;
        this.lightPosition(this.lightCount, f4, f5, f6, false);
        this.lightNormal(this.lightCount, 0.0f, 0.0f, 0.0f);
        this.lightAmbient(this.lightCount, f, f2, f3);
        this.noLightDiffuse(this.lightCount);
        this.noLightSpecular(this.lightCount);
        this.noLightSpot(this.lightCount);
        this.lightFalloff(this.lightCount, this.currentLightFalloffConstant, this.currentLightFalloffLinear, this.currentLightFalloffQuadratic);
        ++this.lightCount;
    }

    @Override
    public void directionalLight(float f, float f2, float f3, float f4, float f5, float f6) {
        this.enableLighting();
        if (this.lightCount == PGL.MAX_LIGHTS) {
            throw new RuntimeException("can only create " + PGL.MAX_LIGHTS + " lights");
        }
        this.lightType[this.lightCount] = 1;
        this.lightPosition(this.lightCount, 0.0f, 0.0f, 0.0f, true);
        this.lightNormal(this.lightCount, f4, f5, f6);
        this.noLightAmbient(this.lightCount);
        this.lightDiffuse(this.lightCount, f, f2, f3);
        this.lightSpecular(this.lightCount, this.currentLightSpecular[0], this.currentLightSpecular[1], this.currentLightSpecular[2]);
        this.noLightSpot(this.lightCount);
        this.noLightFalloff(this.lightCount);
        ++this.lightCount;
    }

    @Override
    public void pointLight(float f, float f2, float f3, float f4, float f5, float f6) {
        this.enableLighting();
        if (this.lightCount == PGL.MAX_LIGHTS) {
            throw new RuntimeException("can only create " + PGL.MAX_LIGHTS + " lights");
        }
        this.lightType[this.lightCount] = 2;
        this.lightPosition(this.lightCount, f4, f5, f6, false);
        this.lightNormal(this.lightCount, 0.0f, 0.0f, 0.0f);
        this.noLightAmbient(this.lightCount);
        this.lightDiffuse(this.lightCount, f, f2, f3);
        this.lightSpecular(this.lightCount, this.currentLightSpecular[0], this.currentLightSpecular[1], this.currentLightSpecular[2]);
        this.noLightSpot(this.lightCount);
        this.lightFalloff(this.lightCount, this.currentLightFalloffConstant, this.currentLightFalloffLinear, this.currentLightFalloffQuadratic);
        ++this.lightCount;
    }

    @Override
    public void spotLight(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        this.enableLighting();
        if (this.lightCount == PGL.MAX_LIGHTS) {
            throw new RuntimeException("can only create " + PGL.MAX_LIGHTS + " lights");
        }
        this.lightType[this.lightCount] = 3;
        this.lightPosition(this.lightCount, f4, f5, f6, false);
        this.lightNormal(this.lightCount, f7, f8, f9);
        this.noLightAmbient(this.lightCount);
        this.lightDiffuse(this.lightCount, f, f2, f3);
        this.lightSpecular(this.lightCount, this.currentLightSpecular[0], this.currentLightSpecular[1], this.currentLightSpecular[2]);
        this.lightSpot(this.lightCount, f10, f11);
        this.lightFalloff(this.lightCount, this.currentLightFalloffConstant, this.currentLightFalloffLinear, this.currentLightFalloffQuadratic);
        ++this.lightCount;
    }

    @Override
    public void lightFalloff(float f, float f2, float f3) {
        this.currentLightFalloffConstant = f;
        this.currentLightFalloffLinear = f2;
        this.currentLightFalloffQuadratic = f3;
    }

    @Override
    public void lightSpecular(float f, float f2, float f3) {
        this.colorCalc(f, f2, f3);
        this.currentLightSpecular[0] = this.calcR;
        this.currentLightSpecular[1] = this.calcG;
        this.currentLightSpecular[2] = this.calcB;
    }

    protected void enableLighting() {
        this.flush();
        this.lights = true;
    }

    protected void disableLighting() {
        this.flush();
        this.lights = false;
    }

    protected void lightPosition(int n, float f, float f2, float f3, boolean bl) {
        this.lightPosition[4 * n + 0] = f * this.modelview.m00 + f2 * this.modelview.m01 + f3 * this.modelview.m02 + this.modelview.m03;
        this.lightPosition[4 * n + 1] = f * this.modelview.m10 + f2 * this.modelview.m11 + f3 * this.modelview.m12 + this.modelview.m13;
        this.lightPosition[4 * n + 2] = f * this.modelview.m20 + f2 * this.modelview.m21 + f3 * this.modelview.m22 + this.modelview.m23;
        this.lightPosition[4 * n + 3] = bl ? 0.0f : 1.0f;
    }

    protected void lightNormal(int n, float f, float f2, float f3) {
        float f4 = f * this.modelviewInv.m00 + f2 * this.modelviewInv.m10 + f3 * this.modelviewInv.m20;
        float f5 = f * this.modelviewInv.m01 + f2 * this.modelviewInv.m11 + f3 * this.modelviewInv.m21;
        float f6 = f * this.modelviewInv.m02 + f2 * this.modelviewInv.m12 + f3 * this.modelviewInv.m22;
        float f7 = PApplet.dist(0.0f, 0.0f, 0.0f, f4, f5, f6);
        if (0.0f < f7) {
            float f8 = 1.0f / f7;
            this.lightNormal[3 * n + 0] = f8 * f4;
            this.lightNormal[3 * n + 1] = f8 * f5;
            this.lightNormal[3 * n + 2] = f8 * f6;
        } else {
            this.lightNormal[3 * n + 0] = 0.0f;
            this.lightNormal[3 * n + 1] = 0.0f;
            this.lightNormal[3 * n + 2] = 0.0f;
        }
    }

    protected void lightAmbient(int n, float f, float f2, float f3) {
        this.colorCalc(f, f2, f3);
        this.lightAmbient[3 * n + 0] = this.calcR;
        this.lightAmbient[3 * n + 1] = this.calcG;
        this.lightAmbient[3 * n + 2] = this.calcB;
    }

    protected void noLightAmbient(int n) {
        this.lightAmbient[3 * n + 0] = 0.0f;
        this.lightAmbient[3 * n + 1] = 0.0f;
        this.lightAmbient[3 * n + 2] = 0.0f;
    }

    protected void lightDiffuse(int n, float f, float f2, float f3) {
        this.colorCalc(f, f2, f3);
        this.lightDiffuse[3 * n + 0] = this.calcR;
        this.lightDiffuse[3 * n + 1] = this.calcG;
        this.lightDiffuse[3 * n + 2] = this.calcB;
    }

    protected void noLightDiffuse(int n) {
        this.lightDiffuse[3 * n + 0] = 0.0f;
        this.lightDiffuse[3 * n + 1] = 0.0f;
        this.lightDiffuse[3 * n + 2] = 0.0f;
    }

    protected void lightSpecular(int n, float f, float f2, float f3) {
        this.lightSpecular[3 * n + 0] = f;
        this.lightSpecular[3 * n + 1] = f2;
        this.lightSpecular[3 * n + 2] = f3;
    }

    protected void noLightSpecular(int n) {
        this.lightSpecular[3 * n + 0] = 0.0f;
        this.lightSpecular[3 * n + 1] = 0.0f;
        this.lightSpecular[3 * n + 2] = 0.0f;
    }

    protected void lightFalloff(int n, float f, float f2, float f3) {
        this.lightFalloffCoefficients[3 * n + 0] = f;
        this.lightFalloffCoefficients[3 * n + 1] = f2;
        this.lightFalloffCoefficients[3 * n + 2] = f3;
    }

    protected void noLightFalloff(int n) {
        this.lightFalloffCoefficients[3 * n + 0] = 1.0f;
        this.lightFalloffCoefficients[3 * n + 1] = 0.0f;
        this.lightFalloffCoefficients[3 * n + 2] = 0.0f;
    }

    protected void lightSpot(int n, float f, float f2) {
        this.lightSpotParameters[2 * n + 0] = Math.max(0.0f, PApplet.cos(f));
        this.lightSpotParameters[2 * n + 1] = f2;
    }

    protected void noLightSpot(int n) {
        this.lightSpotParameters[2 * n + 0] = 0.0f;
        this.lightSpotParameters[2 * n + 1] = 0.0f;
    }

    @Override
    protected void backgroundImpl(PImage pImage) {
        this.backgroundImpl();
        this.set(0, 0, pImage);
        this.backgroundA = 1.0f;
        this.loaded = false;
    }

    @Override
    protected void backgroundImpl() {
        this.flush();
        this.pgl.clearBackground(this.backgroundR, this.backgroundG, this.backgroundB, this.backgroundA, !this.hints[5], true);
        this.loaded = false;
    }

    protected void report(String string) {
        int n;
        if (!this.hints[4] && (n = this.pgl.getError()) != 0) {
            String string2 = this.pgl.errorString(n);
            String string3 = "OpenGL error " + n + " at " + string + ": " + string2;
            PGraphics.showWarning(string3);
        }
    }

    @Override
    public boolean isGL() {
        return true;
    }

    @Override
    public void loadPixels() {
        if (this.primaryGraphics && this.sized) {
            return;
        }
        boolean bl = false;
        if (!this.drawing) {
            this.beginDraw();
            bl = true;
        }
        if (!this.loaded) {
            this.flush();
        }
        this.allocatePixels();
        if (!this.loaded) {
            this.readPixels();
        }
        this.loaded = true;
        if (bl) {
            this.endDraw();
        }
    }

    protected void allocatePixels() {
        this.updatePixelSize();
        if (this.pixels == null || this.pixels.length != this.pixelWidth * this.pixelHeight) {
            this.pixels = new int[this.pixelWidth * this.pixelHeight];
            this.pixelBuffer = PGL.allocateIntBuffer(this.pixels);
            this.loaded = false;
        }
    }

    protected void readPixels() {
        this.updatePixelSize();
        this.beginPixelsOp(1);
        try {
            this.pgl.readPixelsImpl(0, 0, this.pixelWidth, this.pixelHeight, PGL.RGBA, PGL.UNSIGNED_BYTE, this.pixelBuffer);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.endPixelsOp();
        try {
            PGL.getIntArray(this.pixelBuffer, this.pixels);
            PGL.nativeToJavaARGB(this.pixels, this.pixelWidth, this.pixelHeight);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    protected void drawPixels(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8 = (int)this.pgl.getPixelScale();
        int n9 = n8 * n3 * n8 * n4;
        if (this.nativePixels == null || this.nativePixels.length < n9) {
            this.nativePixels = new int[n9];
            this.nativePixelBuffer = PGL.allocateIntBuffer(this.nativePixels);
        }
        try {
            if (0 < n || 0 < n2 || n3 < this.width || n4 < this.height) {
                n7 = n8 * (n2 * this.width + n);
                n6 = 0;
                for (n5 = n8 * n2; n5 < n8 * (n2 + n4); ++n5) {
                    System.arraycopy(this.pixels, n7, this.nativePixels, n6, n8 * n3);
                    n7 += n8 * this.width;
                    n6 += n8 * n3;
                }
            } else {
                PApplet.arrayCopy(this.pixels, 0, this.nativePixels, 0, n9);
            }
            PGL.javaToNativeARGB(this.nativePixels, n8 * n3, n8 * n4);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        PGL.putIntArray(this.nativePixelBuffer, this.nativePixels);
        if (this.primaryGraphics && !this.pgl.isFBOBacked()) {
            this.loadTextureImpl(2, false);
        }
        int n10 = n7 = this.primaryGraphics && (!this.pgl.isFBOBacked() || this.pgl.isFBOBacked() && this.pgl.isMultisampled()) || this.offscreenMultisample ? 1 : 0;
        if (this.texture == null) {
            return;
        }
        if (n7 != 0) {
            n6 = PApplet.min(this.texture.glWidth - n8 * n, n8 * n3);
            n5 = PApplet.min(this.texture.glHeight - n8 * n2, n8 * n4);
            this.pgl.copyToTexture(this.texture.glTarget, this.texture.glFormat, this.texture.glName, n8 * n, n8 * n2, n6, n5, this.nativePixelBuffer);
            this.beginPixelsOp(2);
            this.drawTexture(n, n2, n3, n4);
            this.endPixelsOp();
        } else {
            this.pgl.copyToTexture(this.texture.glTarget, this.texture.glFormat, this.texture.glName, n8 * n, n8 * (this.height - (n2 + n4)), n8 * n3, n8 * n4, this.nativePixelBuffer);
        }
    }

    @Override
    public int get(int n, int n2) {
        this.loadPixels();
        return super.get(n, n2);
    }

    @Override
    protected void getImpl(int n, int n2, int n3, int n4, PImage pImage, int n5, int n6) {
        this.loadPixels();
        super.getImpl(n, n2, n3, n4, pImage, n5, n6);
    }

    @Override
    public void set(int n, int n2, int n3) {
        this.loadPixels();
        super.set(n, n2, n3);
    }

    @Override
    protected void setImpl(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6) {
        this.updatePixelSize();
        this.loadPixels();
        int n7 = n2 * pImage.pixelWidth + n;
        int n8 = n6 * this.pixelWidth + n5;
        for (int i = n2; i < n2 + n4; ++i) {
            System.arraycopy(pImage.pixels, n7, this.pixels, n8, n3);
            n7 += pImage.pixelWidth;
            n8 += this.pixelWidth;
        }
        this.copy(pImage, n, n2, n3, n4, n5, n6, n3, n4);
    }

    @Override
    public boolean save(String string) {
        return this.saveImpl(string);
    }

    @Override
    protected void processImageBeforeAsyncSave(PImage pImage) {
        if (pImage.format == -1) {
            PGL.nativeToJavaARGB(pImage.pixels, pImage.width, pImage.height);
            pImage.format = 2;
        } else if (pImage.format == -2) {
            PGL.nativeToJavaRGB(pImage.pixels, pImage.width, pImage.height);
            pImage.format = 1;
        }
    }

    protected static void completeFinishedPixelTransfers() {
        ongoingPixelTransfersIterable.addAll(ongoingPixelTransfers);
        for (AsyncPixelReader asyncPixelReader : ongoingPixelTransfersIterable) {
            if (!asyncPixelReader.calledThisFrame) {
                asyncPixelReader.completeFinishedTransfers();
            }
            asyncPixelReader.calledThisFrame = false;
        }
        ongoingPixelTransfersIterable.clear();
    }

    protected static void completeAllPixelTransfers() {
        ongoingPixelTransfersIterable.addAll(ongoingPixelTransfers);
        for (AsyncPixelReader asyncPixelReader : ongoingPixelTransfersIterable) {
            asyncPixelReader.completeAllTransfers();
        }
        ongoingPixelTransfersIterable.clear();
    }

    public void loadTexture() {
        boolean bl = false;
        if (!this.drawing) {
            this.beginDraw();
            bl = true;
        }
        this.flush();
        if (this.primaryGraphics) {
            this.updatePixelSize();
            if (this.pgl.isFBOBacked()) {
                this.pgl.syncBackTexture();
            } else {
                this.loadTextureImpl(2, false);
                if (this.nativePixels == null || this.nativePixels.length < this.pixelWidth * this.pixelHeight) {
                    this.nativePixels = new int[this.pixelWidth * this.pixelHeight];
                    this.nativePixelBuffer = PGL.allocateIntBuffer(this.nativePixels);
                }
                this.beginPixelsOp(1);
                try {
                    this.pgl.readPixelsImpl(0, 0, this.pixelWidth, this.pixelHeight, PGL.RGBA, PGL.UNSIGNED_BYTE, this.nativePixelBuffer);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                this.endPixelsOp();
                if (this.texture != null) {
                    this.texture.setNative(this.nativePixelBuffer, 0, 0, this.pixelWidth, this.pixelHeight);
                }
            }
        } else if (this.offscreenMultisample) {
            FrameBuffer frameBuffer = this.offscreenFramebuffer;
            FrameBuffer frameBuffer2 = this.multisampleFramebuffer;
            if (frameBuffer != null && frameBuffer2 != null) {
                frameBuffer2.copyColor(frameBuffer);
            }
        }
        if (bl) {
            this.endDraw();
        }
    }

    public void updateTexture() {
        if (this.texture != null) {
            this.texture.updateTexels();
        }
    }

    public void updateTexture(int n, int n2, int n3, int n4) {
        if (this.texture != null) {
            this.texture.updateTexels(n, n2, n3, n4);
        }
    }

    public void updateDisplay() {
        this.flush();
        this.beginPixelsOp(2);
        this.drawTexture();
        this.endPixelsOp();
    }

    protected void loadTextureImpl(int n, boolean bl) {
        this.updatePixelSize();
        if (this.pixelWidth == 0 || this.pixelHeight == 0) {
            return;
        }
        if (this.texture == null || this.texture.contextIsOutdated()) {
            Texture.Parameters parameters = new Texture.Parameters(2, n, bl);
            this.texture = new Texture(this, this.pixelWidth, this.pixelHeight, parameters);
            this.texture.invertedY(true);
            this.texture.colorBuffer(true);
            this.setCache(this, this.texture);
        }
    }

    protected void createPTexture() {
        this.updatePixelSize();
        if (this.texture != null) {
            this.ptexture = new Texture(this, this.pixelWidth, this.pixelHeight, this.texture.getParameters());
            this.ptexture.invertedY(true);
            this.ptexture.colorBuffer(true);
        }
    }

    protected void swapOffscreenTextures() {
        FrameBuffer frameBuffer = this.offscreenFramebuffer;
        if (this.texture != null && this.ptexture != null && frameBuffer != null) {
            int n = this.texture.glName;
            this.texture.glName = this.ptexture.glName;
            this.ptexture.glName = n;
            frameBuffer.setColorBuffer(this.texture);
        }
    }

    protected void drawTexture() {
        if (this.texture != null) {
            this.pgl.disable(PGL.BLEND);
            this.pgl.drawTexture(this.texture.glTarget, this.texture.glName, this.texture.glWidth, this.texture.glHeight, 0, 0, this.width, this.height);
            this.pgl.enable(PGL.BLEND);
        }
    }

    protected void drawTexture(int n, int n2, int n3, int n4) {
        if (this.texture != null) {
            this.pgl.disable(PGL.BLEND);
            this.pgl.drawTexture(this.texture.glTarget, this.texture.glName, this.texture.glWidth, this.texture.glHeight, 0, 0, this.width, this.height, n, n2, n + n3, n2 + n4, n, this.height - (n2 + n4), n + n3, this.height - n2);
            this.pgl.enable(PGL.BLEND);
        }
    }

    protected void drawPTexture() {
        if (this.ptexture != null) {
            this.pgl.disable(PGL.BLEND);
            this.pgl.drawTexture(this.ptexture.glTarget, this.ptexture.glName, this.ptexture.glWidth, this.ptexture.glHeight, 0, 0, this.width, this.height);
            this.pgl.enable(PGL.BLEND);
        }
    }

    @Override
    public void mask(PImage pImage) {
        this.updatePixelSize();
        if (pImage.width != this.pixelWidth || pImage.height != this.pixelHeight) {
            throw new RuntimeException("The PImage used with mask() must be the same size as the applet.");
        }
        PGraphicsOpenGL pGraphicsOpenGL = this.getPrimaryPG();
        if (pGraphicsOpenGL.maskShader == null) {
            pGraphicsOpenGL.maskShader = new PShader(this.parent, defTextureShaderVertURL, maskShaderFragURL);
        }
        pGraphicsOpenGL.maskShader.set("mask", pImage);
        this.filter(pGraphicsOpenGL.maskShader);
    }

    @Override
    public void filter(int n) {
        PImage pImage = this.get();
        pImage.filter(n);
        this.set(0, 0, pImage);
    }

    @Override
    public void filter(int n, float f) {
        PImage pImage = this.get();
        pImage.filter(n, f);
        this.set(0, 0, pImage);
    }

    @Override
    public void filter(PShader pShader) {
        if (!pShader.isPolyShader()) {
            PGraphics.showWarning(INVALID_FILTER_SHADER_ERROR);
            return;
        }
        boolean bl = false;
        if (this.primaryGraphics) {
            this.pgl.enableFBOLayer();
        } else if (!this.drawing) {
            this.beginDraw();
            bl = true;
        }
        this.loadTexture();
        if (this.filterTexture == null || this.filterTexture.contextIsOutdated()) {
            this.filterTexture = new Texture(this, this.texture.width, this.texture.height, this.texture.getParameters());
            this.filterTexture.invertedY(true);
            this.filterImage = this.wrapTexture(this.filterTexture);
        }
        this.filterTexture.set(this.texture);
        this.pgl.depthMask(false);
        this.pgl.disable(PGL.DEPTH_TEST);
        this.begin2D();
        boolean bl2 = this.lights;
        this.lights = false;
        int n = this.textureMode;
        this.textureMode = 1;
        boolean bl3 = this.stroke;
        this.stroke = false;
        int n2 = this.blendMode;
        this.blendMode(0);
        PShader pShader2 = this.polyShader;
        this.polyShader = pShader;
        this.beginShape(17);
        this.texture(this.filterImage);
        this.vertex(0.0f, 0.0f, 0.0f, 0.0f);
        this.vertex(this.width, 0.0f, 1.0f, 0.0f);
        this.vertex(this.width, this.height, 1.0f, 1.0f);
        this.vertex(0.0f, this.height, 0.0f, 1.0f);
        this.endShape();
        this.end2D();
        this.polyShader = pShader2;
        this.stroke = bl3;
        this.lights = bl2;
        this.textureMode = n;
        this.blendMode(n2);
        if (!this.hints[2]) {
            this.pgl.enable(PGL.DEPTH_TEST);
        }
        if (!this.hints[5]) {
            this.pgl.depthMask(true);
        }
        if (bl) {
            this.endDraw();
        }
    }

    @Override
    public void copy(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (this.primaryGraphics) {
            this.pgl.enableFBOLayer();
        }
        this.loadTexture();
        if (this.filterTexture == null || this.filterTexture.contextIsOutdated()) {
            this.filterTexture = new Texture(this, this.texture.width, this.texture.height, this.texture.getParameters());
            this.filterTexture.invertedY(true);
            this.filterImage = this.wrapTexture(this.filterTexture);
        }
        this.filterTexture.put(this.texture, n, this.height - (n2 + n4), n3, this.height - n2);
        this.copy(this.filterImage, n, n2, n3, n4, n5, n6, n7, n8);
    }

    @Override
    public void copy(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        boolean bl = false;
        if (!this.drawing) {
            this.beginDraw();
            bl = true;
        }
        this.flush();
        Texture texture = this.getTexture(pImage);
        boolean bl2 = texture.invertedX();
        boolean bl3 = texture.invertedY();
        if (bl2) {
            n14 = n5 + n7;
            n13 = n5;
        } else {
            n14 = n5;
            n13 = n5 + n7;
        }
        int n15 = n;
        int n16 = n + n3;
        if (bl3) {
            n12 = this.height - (n6 + n8);
            n11 = this.height - n6;
            n10 = texture.height - (n2 + n4);
            n9 = texture.height - n2;
        } else {
            n12 = this.height - n6;
            n11 = this.height - (n6 + n8);
            n10 = n2;
            n9 = n2 + n4;
        }
        this.pgl.drawTexture(texture.glTarget, texture.glName, texture.glWidth, texture.glHeight, 0, 0, this.width, this.height, n15, n10, n16, n9, n14, n12, n13, n11);
        if (bl) {
            this.endDraw();
        }
    }

    @Override
    protected void blendModeImpl() {
        if (this.blendMode != this.lastBlendMode) {
            this.flush();
        }
        this.pgl.enable(PGL.BLEND);
        if (this.blendMode == 0) {
            if (blendEqSupported) {
                this.pgl.blendEquation(PGL.FUNC_ADD);
            }
            this.pgl.blendFunc(PGL.ONE, PGL.ZERO);
        } else if (this.blendMode == 1) {
            if (blendEqSupported) {
                this.pgl.blendEquationSeparate(PGL.FUNC_ADD, PGL.FUNC_ADD);
            }
            this.pgl.blendFuncSeparate(PGL.SRC_ALPHA, PGL.ONE_MINUS_SRC_ALPHA, PGL.ONE, PGL.ONE);
        } else if (this.blendMode == 2) {
            if (blendEqSupported) {
                this.pgl.blendEquationSeparate(PGL.FUNC_ADD, PGL.FUNC_ADD);
            }
            this.pgl.blendFuncSeparate(PGL.SRC_ALPHA, PGL.ONE, PGL.ONE, PGL.ONE);
        } else if (this.blendMode == 4) {
            if (blendEqSupported) {
                this.pgl.blendEquationSeparate(PGL.FUNC_REVERSE_SUBTRACT, PGL.FUNC_ADD);
                this.pgl.blendFuncSeparate(PGL.SRC_ALPHA, PGL.ONE, PGL.ONE, PGL.ONE);
            } else {
                PGraphics.showWarning(BLEND_DRIVER_ERROR, "SUBTRACT");
            }
        } else if (this.blendMode == 8) {
            if (blendEqSupported) {
                this.pgl.blendEquationSeparate(PGL.FUNC_MAX, PGL.FUNC_ADD);
                this.pgl.blendFuncSeparate(PGL.ONE, PGL.ONE, PGL.ONE, PGL.ONE);
            } else {
                PGraphics.showWarning(BLEND_DRIVER_ERROR, "LIGHTEST");
            }
        } else if (this.blendMode == 16) {
            if (blendEqSupported) {
                this.pgl.blendEquationSeparate(PGL.FUNC_MIN, PGL.FUNC_ADD);
                this.pgl.blendFuncSeparate(PGL.ONE, PGL.ONE, PGL.ONE, PGL.ONE);
            } else {
                PGraphics.showWarning(BLEND_DRIVER_ERROR, "DARKEST");
            }
        } else if (this.blendMode == 64) {
            if (blendEqSupported) {
                this.pgl.blendEquationSeparate(PGL.FUNC_ADD, PGL.FUNC_ADD);
            }
            this.pgl.blendFuncSeparate(PGL.ONE_MINUS_DST_COLOR, PGL.ONE_MINUS_SRC_COLOR, PGL.ONE, PGL.ONE);
        } else if (this.blendMode == 128) {
            if (blendEqSupported) {
                this.pgl.blendEquationSeparate(PGL.FUNC_ADD, PGL.FUNC_ADD);
            }
            this.pgl.blendFuncSeparate(PGL.ZERO, PGL.SRC_COLOR, PGL.ONE, PGL.ONE);
        } else if (this.blendMode == 256) {
            if (blendEqSupported) {
                this.pgl.blendEquationSeparate(PGL.FUNC_ADD, PGL.FUNC_ADD);
            }
            this.pgl.blendFuncSeparate(PGL.ONE_MINUS_DST_COLOR, PGL.ONE, PGL.ONE, PGL.ONE);
        } else if (this.blendMode == 32) {
            PGraphics.showWarning(BLEND_RENDERER_ERROR, "DIFFERENCE");
        } else if (this.blendMode == 512) {
            PGraphics.showWarning(BLEND_RENDERER_ERROR, "OVERLAY");
        } else if (this.blendMode == 1024) {
            PGraphics.showWarning(BLEND_RENDERER_ERROR, "HARD_LIGHT");
        } else if (this.blendMode == 2048) {
            PGraphics.showWarning(BLEND_RENDERER_ERROR, "SOFT_LIGHT");
        } else if (this.blendMode == 4096) {
            PGraphics.showWarning(BLEND_RENDERER_ERROR, "DODGE");
        } else if (this.blendMode == 8192) {
            PGraphics.showWarning(BLEND_RENDERER_ERROR, "BURN");
        }
        this.lastBlendMode = this.blendMode;
    }

    public Texture getTexture() {
        return this.getTexture(true);
    }

    public Texture getTexture(boolean bl) {
        if (bl) {
            this.loadTexture();
        }
        return this.texture;
    }

    public Texture getTexture(PImage pImage) {
        Texture texture = (Texture)this.initCache(pImage);
        if (texture == null) {
            return null;
        }
        if (pImage.isModified()) {
            if (pImage.width != texture.width || pImage.height != texture.height) {
                texture.init(pImage.width, pImage.height);
            }
            this.updateTexture(pImage, texture);
        }
        if (texture.hasBuffers()) {
            texture.bufferUpdate();
        }
        this.checkTexture(texture);
        return texture;
    }

    public FrameBuffer getFrameBuffer() {
        return this.getFrameBuffer(false);
    }

    public FrameBuffer getFrameBuffer(boolean bl) {
        if (bl) {
            return this.multisampleFramebuffer;
        }
        return this.offscreenFramebuffer;
    }

    protected Object initCache(PImage pImage) {
        if (!this.checkGLThread()) {
            return null;
        }
        Texture texture = (Texture)this.getCache(pImage);
        if ((texture == null || texture.contextIsOutdated()) && (texture = this.addTexture(pImage)) != null) {
            pImage.loadPixels();
            texture.set(pImage.pixels, pImage.format);
            pImage.setModified();
        }
        return texture;
    }

    protected void bindFrontTexture() {
        if (this.primaryGraphics) {
            this.pgl.bindFrontTexture();
        } else {
            if (this.ptexture == null) {
                this.createPTexture();
            }
            this.ptexture.bind();
        }
    }

    protected void unbindFrontTexture() {
        if (this.primaryGraphics) {
            this.pgl.unbindFrontTexture();
        } else {
            this.ptexture.unbind();
        }
    }

    protected Texture addTexture(PImage pImage) {
        Texture.Parameters parameters = new Texture.Parameters(2, this.textureSampling, this.getHint(-8), this.textureWrap);
        return this.addTexture(pImage, parameters);
    }

    protected Texture addTexture(PImage pImage, Texture.Parameters parameters) {
        if (pImage.width == 0 || pImage.height == 0) {
            return null;
        }
        if (pImage.parent == null) {
            pImage.parent = this.parent;
        }
        Texture texture = new Texture(this, pImage.pixelWidth, pImage.pixelHeight, parameters);
        this.setCache(pImage, texture);
        return texture;
    }

    protected void checkTexture(Texture texture) {
        if (!(texture.colorBuffer() || texture.usingMipmaps != this.hints[8] && texture.currentSampling() == this.textureSampling)) {
            if (this.hints[8]) {
                texture.usingMipmaps(false, this.textureSampling);
            } else {
                texture.usingMipmaps(true, this.textureSampling);
            }
        }
        if (texture.usingRepeat && this.textureWrap == 0 || !texture.usingRepeat && this.textureWrap == 1) {
            if (this.textureWrap == 0) {
                texture.usingRepeat(false);
            } else {
                texture.usingRepeat(true);
            }
        }
    }

    protected PImage wrapTexture(Texture texture) {
        PImage pImage = new PImage();
        pImage.parent = this.parent;
        pImage.width = texture.width;
        pImage.height = texture.height;
        pImage.format = 2;
        this.setCache(pImage, texture);
        return pImage;
    }

    protected void updateTexture(PImage pImage, Texture texture) {
        if (texture != null && pImage.isModified()) {
            int n = pImage.getModifiedX1();
            int n2 = pImage.getModifiedY1();
            int n3 = pImage.getModifiedX2() - n;
            int n4 = pImage.getModifiedY2() - n2;
            texture.set(pImage.pixels, n, n2, n3, n4, pImage.format);
        }
        pImage.setModified(false);
    }

    protected void deleteSurfaceTextures() {
        if (this.texture != null) {
            this.texture.dispose();
        }
        if (this.ptexture != null) {
            this.ptexture.dispose();
        }
        if (this.filterTexture != null) {
            this.filterTexture.dispose();
        }
    }

    protected boolean checkGLThread() {
        if (this.pgl.threadIsCurrent()) {
            return true;
        }
        PGraphics.showWarning(OPENGL_THREAD_ERROR);
        return false;
    }

    @Override
    public void resize(int n, int n2) {
        PGraphics.showMethodWarning("resize");
    }

    protected void initPrimary() {
        this.pgl.initSurface(this.smooth);
        if (this.texture != null) {
            this.removeCache(this);
            this.texture = null;
            this.ptexture = null;
        }
        this.initialized = true;
    }

    protected void beginOnscreenDraw() {
        this.updatePixelSize();
        this.pgl.beginRender();
        if (this.drawFramebuffer == null) {
            this.drawFramebuffer = new FrameBuffer(this, this.pixelWidth, this.pixelHeight, true);
        }
        this.drawFramebuffer.setFBO(this.pgl.getDrawFramebuffer());
        if (this.readFramebuffer == null) {
            this.readFramebuffer = new FrameBuffer(this, this.pixelWidth, this.pixelHeight, true);
        }
        this.readFramebuffer.setFBO(this.pgl.getReadFramebuffer());
        if (this.currentFramebuffer == null) {
            this.setFramebuffer(this.drawFramebuffer);
        }
        if (this.pgl.isFBOBacked()) {
            this.texture = this.pgl.wrapBackTexture(this.texture);
            this.ptexture = this.pgl.wrapFrontTexture(this.ptexture);
        }
    }

    protected void endOnscreenDraw() {
        this.pgl.endRender(this.parent.sketchWindowColor());
    }

    protected void initOffscreen() {
        boolean bl;
        this.loadTextureImpl(this.textureSampling, false);
        FrameBuffer frameBuffer = this.offscreenFramebuffer;
        FrameBuffer frameBuffer2 = this.multisampleFramebuffer;
        if (frameBuffer != null) {
            frameBuffer.dispose();
            frameBuffer = null;
        }
        if (frameBuffer2 != null) {
            frameBuffer2.dispose();
            frameBuffer2 = null;
        }
        boolean bl2 = bl = depthBits == 24 && stencilBits == 8 && packedDepthStencilSupported;
        if (fboMultisampleSupported && 1 < PGL.smoothToSamples(this.smooth)) {
            frameBuffer2 = new FrameBuffer(this, this.texture.glWidth, this.texture.glHeight, PGL.smoothToSamples(this.smooth), 0, depthBits, stencilBits, bl, false);
            frameBuffer2.clear();
            this.multisampleFramebuffer = frameBuffer2;
            this.offscreenMultisample = true;
            frameBuffer = this.hints[10] ? new FrameBuffer(this, this.texture.glWidth, this.texture.glHeight, 1, 1, depthBits, stencilBits, bl, false) : new FrameBuffer(this, this.texture.glWidth, this.texture.glHeight, 1, 1, 0, 0, false, false);
        } else {
            this.smooth = 0;
            frameBuffer = new FrameBuffer(this, this.texture.glWidth, this.texture.glHeight, 1, 1, depthBits, stencilBits, bl, false);
            this.offscreenMultisample = false;
        }
        frameBuffer.setColorBuffer(this.texture);
        frameBuffer.clear();
        this.offscreenFramebuffer = frameBuffer;
        this.initialized = true;
    }

    protected void beginOffscreenDraw() {
        FrameBuffer frameBuffer;
        if (!this.initialized) {
            this.initOffscreen();
        } else {
            boolean bl;
            frameBuffer = this.offscreenFramebuffer;
            FrameBuffer frameBuffer2 = this.multisampleFramebuffer;
            boolean bl2 = frameBuffer != null && frameBuffer.contextIsOutdated();
            boolean bl3 = bl = frameBuffer2 != null && frameBuffer2.contextIsOutdated();
            if (bl2 || bl) {
                this.restartPGL();
                this.initOffscreen();
            } else {
                this.swapOffscreenTextures();
            }
        }
        this.pushFramebuffer();
        if (this.offscreenMultisample) {
            frameBuffer = this.multisampleFramebuffer;
            if (frameBuffer != null) {
                this.setFramebuffer(frameBuffer);
            }
        } else {
            frameBuffer = this.offscreenFramebuffer;
            if (frameBuffer != null) {
                this.setFramebuffer(frameBuffer);
            }
        }
        this.drawPTexture();
        if (this.clip) {
            this.pgl.enable(PGL.SCISSOR_TEST);
            this.pgl.scissor(this.clipRect[0], this.clipRect[1], this.clipRect[2], this.clipRect[3]);
        } else {
            this.pgl.disable(PGL.SCISSOR_TEST);
        }
    }

    protected void endOffscreenDraw() {
        if (this.offscreenMultisample) {
            FrameBuffer frameBuffer = this.offscreenFramebuffer;
            FrameBuffer frameBuffer2 = this.multisampleFramebuffer;
            if (frameBuffer != null && frameBuffer2 != null) {
                frameBuffer2.copyColor(frameBuffer);
            }
        }
        this.popFramebuffer();
        if (this.backgroundA == 1.0f) {
            this.pgl.colorMask(false, false, false, true);
            this.pgl.clearColor(0.0f, 0.0f, 0.0f, this.backgroundA);
            this.pgl.clear(PGL.COLOR_BUFFER_BIT);
            this.pgl.colorMask(true, true, true, true);
        }
        if (this.texture != null) {
            this.texture.updateTexels();
        }
        this.getPrimaryPG().restoreGL();
    }

    protected void setViewport() {
        this.viewport.put(0, 0);
        this.viewport.put(1, 0);
        this.viewport.put(2, this.width);
        this.viewport.put(3, this.height);
        this.pgl.viewport(this.viewport.get(0), this.viewport.get(1), this.viewport.get(2), this.viewport.get(3));
    }

    @Override
    protected void checkSettings() {
        super.checkSettings();
        this.setGLSettings();
    }

    protected void setGLSettings() {
        this.inGeo.clear();
        this.tessGeo.clear();
        this.texCache.clear();
        super.noTexture();
        this.blendModeImpl();
        if (this.hints[2]) {
            this.pgl.disable(PGL.DEPTH_TEST);
        } else {
            this.pgl.enable(PGL.DEPTH_TEST);
        }
        this.pgl.depthFunc(PGL.LEQUAL);
        this.flushMode = this.hints[6] ? 0 : 1;
        if (this.primaryGraphics) {
            // empty if block
        }
        if (this.smooth < 1) {
            this.pgl.disable(PGL.MULTISAMPLE);
        } else if (!OPENGL_RENDERER.equals("VideoCore IV HW")) {
            this.pgl.enable(PGL.MULTISAMPLE);
        }
        if (!OPENGL_RENDERER.equals("VideoCore IV HW")) {
            this.pgl.disable(PGL.POLYGON_SMOOTH);
        }
        if (this.sized) {
            if (this.primaryGraphics) {
                this.background(this.backgroundColor);
            } else {
                this.background(0 | this.backgroundColor & 0xFFFFFF);
            }
            this.defaultPerspective();
            this.defaultCamera();
            this.sized = false;
        } else {
            this.modelview.set(this.camera);
            this.modelviewInv.set(this.cameraInv);
            this.updateProjmodelview();
        }
        if (this.is3D()) {
            this.noLights();
            this.lightFalloff(1.0f, 0.0f, 0.0f);
            this.lightSpecular(0.0f, 0.0f, 0.0f);
        }
        this.pgl.frontFace(PGL.CW);
        this.pgl.disable(PGL.CULL_FACE);
        this.pgl.activeTexture(PGL.TEXTURE0);
        this.normalY = 0.0f;
        this.normalX = 0.0f;
        this.normalZ = 1.0f;
        this.pgl.clearDepthStencil();
        this.pgl.depthMask(true);
        this.pgl.clearDepth(1.0f);
        this.pgl.clearStencil(0);
        this.pgl.clear(PGL.DEPTH_BUFFER_BIT | PGL.STENCIL_BUFFER_BIT);
        if (this.hints[5]) {
            this.pgl.depthMask(false);
        } else {
            this.pgl.depthMask(true);
        }
        this.pixelsOp = 0;
        this.modified = false;
        this.loaded = false;
    }

    protected void getGLParameters() {
        OPENGL_VENDOR = this.pgl.getString(PGL.VENDOR);
        OPENGL_RENDERER = this.pgl.getString(PGL.RENDERER);
        OPENGL_VERSION = this.pgl.getString(PGL.VERSION);
        OPENGL_EXTENSIONS = this.pgl.getString(PGL.EXTENSIONS);
        GLSL_VERSION = this.pgl.getString(PGL.SHADING_LANGUAGE_VERSION);
        npotTexSupported = this.pgl.hasNpotTexSupport();
        autoMipmapGenSupported = this.pgl.hasAutoMipmapGenSupport();
        fboMultisampleSupported = this.pgl.hasFboMultisampleSupport();
        packedDepthStencilSupported = this.pgl.hasPackedDepthStencilSupport();
        anisoSamplingSupported = this.pgl.hasAnisoSamplingSupport();
        readBufferSupported = this.pgl.hasReadBuffer();
        drawBufferSupported = this.pgl.hasDrawBuffer();
        try {
            this.pgl.blendEquation(PGL.FUNC_ADD);
            blendEqSupported = true;
        }
        catch (Exception exception) {
            blendEqSupported = false;
        }
        depthBits = this.pgl.getDepthBits();
        stencilBits = this.pgl.getStencilBits();
        this.pgl.getIntegerv(PGL.MAX_TEXTURE_SIZE, intBuffer);
        maxTextureSize = intBuffer.get(0);
        if (!OPENGL_RENDERER.equals("VideoCore IV HW")) {
            this.pgl.getIntegerv(PGL.MAX_SAMPLES, intBuffer);
            maxSamples = intBuffer.get(0);
        }
        if (anisoSamplingSupported) {
            this.pgl.getFloatv(PGL.MAX_TEXTURE_MAX_ANISOTROPY, floatBuffer);
            maxAnisoAmount = floatBuffer.get(0);
        }
        if (OPENGL_RENDERER.equals("VideoCore IV HW") || OPENGL_RENDERER.equals("Gallium 0.4 on VC4")) {
            defLightShaderVertURL = PGraphicsOpenGL.class.getResource("/processing/opengl/shaders/LightVert-vc4.glsl");
            defTexlightShaderVertURL = PGraphicsOpenGL.class.getResource("/processing/opengl/shaders/TexLightVert-vc4.glsl");
        }
        glParamsRead = true;
    }

    @Override
    public PShader loadShader(String string) {
        if (string == null || string.equals("")) {
            PGraphics.showWarning(MISSING_FRAGMENT_SHADER);
            return null;
        }
        int n = PShader.getShaderType(this.parent.loadStrings(string), 2);
        PShader pShader = new PShader(this.parent);
        pShader.setType(n);
        pShader.setFragmentShader(string);
        if (n == 0) {
            String[] stringArray = this.pgl.loadVertexShader(defPointShaderVertURL);
            pShader.setVertexShader(stringArray);
        } else if (n == 1) {
            String[] stringArray = this.pgl.loadVertexShader(defLineShaderVertURL);
            pShader.setVertexShader(stringArray);
        } else if (n == 6) {
            String[] stringArray = this.pgl.loadVertexShader(defTexlightShaderVertURL);
            pShader.setVertexShader(stringArray);
        } else if (n == 4) {
            String[] stringArray = this.pgl.loadVertexShader(defLightShaderVertURL);
            pShader.setVertexShader(stringArray);
        } else if (n == 5) {
            String[] stringArray = this.pgl.loadVertexShader(defTextureShaderVertURL);
            pShader.setVertexShader(stringArray);
        } else if (n == 3) {
            String[] stringArray = this.pgl.loadVertexShader(defColorShaderVertURL);
            pShader.setVertexShader(stringArray);
        } else {
            String[] stringArray = this.pgl.loadVertexShader(defTextureShaderVertURL);
            pShader.setVertexShader(stringArray);
        }
        return pShader;
    }

    @Override
    public PShader loadShader(String string, String string2) {
        PShader pShader = null;
        if (string == null || string.equals("")) {
            PGraphics.showWarning(MISSING_FRAGMENT_SHADER);
        } else if (string2 == null || string2.equals("")) {
            PGraphics.showWarning(MISSING_VERTEX_SHADER);
        } else {
            pShader = new PShader(this.parent, string2, string);
        }
        return pShader;
    }

    @Override
    public void shader(PShader pShader) {
        this.flush();
        if (pShader != null) {
            pShader.init();
        }
        if (pShader.isPolyShader()) {
            this.polyShader = pShader;
        } else if (pShader.isLineShader()) {
            this.lineShader = pShader;
        } else if (pShader.isPointShader()) {
            this.pointShader = pShader;
        } else {
            PGraphics.showWarning(UNKNOWN_SHADER_KIND_ERROR);
        }
    }

    @Override
    public void shader(PShader pShader, int n) {
        this.flush();
        if (pShader != null) {
            pShader.init();
        }
        if (n == 9) {
            this.polyShader = pShader;
        } else if (n == 5) {
            this.lineShader = pShader;
        } else if (n == 3) {
            this.pointShader = pShader;
        } else {
            PGraphics.showWarning(UNKNOWN_SHADER_KIND_ERROR);
        }
    }

    @Override
    public void resetShader() {
        this.resetShader(9);
    }

    @Override
    public void resetShader(int n) {
        this.flush();
        if (n == 9 || n == 17 || n == 20) {
            this.polyShader = null;
        } else if (n == 5) {
            this.lineShader = null;
        } else if (n == 3) {
            this.pointShader = null;
        } else {
            PGraphics.showWarning(UNKNOWN_SHADER_KIND_ERROR);
        }
    }

    protected PShader getPolyShader(boolean bl, boolean bl2) {
        PShader pShader;
        boolean bl3;
        PGraphicsOpenGL pGraphicsOpenGL = this.getPrimaryPG();
        boolean bl4 = bl3 = this.polyShader == null;
        if (this.polyShader != null) {
            this.polyShader.setRenderer(this);
            this.polyShader.loadAttributes();
            this.polyShader.loadUniforms();
        }
        if (bl) {
            if (bl2) {
                if (bl3 || !this.polyShader.checkPolyType(6)) {
                    if (pGraphicsOpenGL.defTexlightShader == null) {
                        String[] stringArray = this.pgl.loadVertexShader(defTexlightShaderVertURL);
                        String[] stringArray2 = this.pgl.loadFragmentShader(defTexlightShaderFragURL);
                        pGraphicsOpenGL.defTexlightShader = new PShader(this.parent, stringArray, stringArray2);
                    }
                    pShader = pGraphicsOpenGL.defTexlightShader;
                } else {
                    pShader = this.polyShader;
                }
            } else if (bl3 || !this.polyShader.checkPolyType(4)) {
                if (pGraphicsOpenGL.defLightShader == null) {
                    String[] stringArray = this.pgl.loadVertexShader(defLightShaderVertURL);
                    String[] stringArray3 = this.pgl.loadFragmentShader(defLightShaderFragURL);
                    pGraphicsOpenGL.defLightShader = new PShader(this.parent, stringArray, stringArray3);
                }
                pShader = pGraphicsOpenGL.defLightShader;
            } else {
                pShader = this.polyShader;
            }
        } else {
            if (this.polyShader != null && this.polyShader.accessLightAttribs()) {
                PGraphics.showWarning(SHADER_NEED_LIGHT_ATTRIBS);
                bl3 = true;
            }
            if (bl2) {
                if (bl3 || !this.polyShader.checkPolyType(5)) {
                    if (pGraphicsOpenGL.defTextureShader == null) {
                        String[] stringArray = this.pgl.loadVertexShader(defTextureShaderVertURL);
                        String[] stringArray4 = this.pgl.loadFragmentShader(defTextureShaderFragURL);
                        pGraphicsOpenGL.defTextureShader = new PShader(this.parent, stringArray, stringArray4);
                    }
                    pShader = pGraphicsOpenGL.defTextureShader;
                } else {
                    pShader = this.polyShader;
                }
            } else if (bl3 || !this.polyShader.checkPolyType(3)) {
                if (pGraphicsOpenGL.defColorShader == null) {
                    String[] stringArray = this.pgl.loadVertexShader(defColorShaderVertURL);
                    String[] stringArray5 = this.pgl.loadFragmentShader(defColorShaderFragURL);
                    pGraphicsOpenGL.defColorShader = new PShader(this.parent, stringArray, stringArray5);
                }
                pShader = pGraphicsOpenGL.defColorShader;
            } else {
                pShader = this.polyShader;
            }
        }
        if (pShader != this.polyShader) {
            pShader.setRenderer(this);
            pShader.loadAttributes();
            pShader.loadUniforms();
        }
        return pShader;
    }

    protected PShader getLineShader() {
        PShader pShader;
        PGraphicsOpenGL pGraphicsOpenGL = this.getPrimaryPG();
        if (this.lineShader == null) {
            if (pGraphicsOpenGL.defLineShader == null) {
                String[] stringArray = this.pgl.loadVertexShader(defLineShaderVertURL);
                String[] stringArray2 = this.pgl.loadFragmentShader(defLineShaderFragURL);
                pGraphicsOpenGL.defLineShader = new PShader(this.parent, stringArray, stringArray2);
            }
            pShader = pGraphicsOpenGL.defLineShader;
        } else {
            pShader = this.lineShader;
        }
        pShader.setRenderer(this);
        pShader.loadAttributes();
        pShader.loadUniforms();
        return pShader;
    }

    protected PShader getPointShader() {
        PShader pShader;
        PGraphicsOpenGL pGraphicsOpenGL = this.getPrimaryPG();
        if (this.pointShader == null) {
            if (pGraphicsOpenGL.defPointShader == null) {
                String[] stringArray = this.pgl.loadVertexShader(defPointShaderVertURL);
                String[] stringArray2 = this.pgl.loadFragmentShader(defPointShaderFragURL);
                pGraphicsOpenGL.defPointShader = new PShader(this.parent, stringArray, stringArray2);
            }
            pShader = pGraphicsOpenGL.defPointShader;
        } else {
            pShader = this.pointShader;
        }
        pShader.setRenderer(this);
        pShader.loadAttributes();
        pShader.loadUniforms();
        return pShader;
    }

    protected static int expandArraySize(int n, int n2) {
        int n3;
        for (n3 = n; n3 < n2; n3 <<= 1) {
        }
        return n3;
    }

    protected static AttributeMap newAttributeMap() {
        return new AttributeMap();
    }

    protected static InGeometry newInGeometry(PGraphicsOpenGL pGraphicsOpenGL, AttributeMap attributeMap, int n) {
        return new InGeometry(pGraphicsOpenGL, attributeMap, n);
    }

    protected static TessGeometry newTessGeometry(PGraphicsOpenGL pGraphicsOpenGL, AttributeMap attributeMap, int n) {
        return new TessGeometry(pGraphicsOpenGL, attributeMap, n);
    }

    protected static TexCache newTexCache(PGraphicsOpenGL pGraphicsOpenGL) {
        return new TexCache(pGraphicsOpenGL);
    }

    static {
        defColorShaderVertURL = PGraphicsOpenGL.class.getResource("/processing/opengl/shaders/ColorVert.glsl");
        defTextureShaderVertURL = PGraphicsOpenGL.class.getResource("/processing/opengl/shaders/TexVert.glsl");
        defLightShaderVertURL = PGraphicsOpenGL.class.getResource("/processing/opengl/shaders/LightVert.glsl");
        defTexlightShaderVertURL = PGraphicsOpenGL.class.getResource("/processing/opengl/shaders/TexLightVert.glsl");
        defColorShaderFragURL = PGraphicsOpenGL.class.getResource("/processing/opengl/shaders/ColorFrag.glsl");
        defTextureShaderFragURL = PGraphicsOpenGL.class.getResource("/processing/opengl/shaders/TexFrag.glsl");
        defLightShaderFragURL = PGraphicsOpenGL.class.getResource("/processing/opengl/shaders/LightFrag.glsl");
        defTexlightShaderFragURL = PGraphicsOpenGL.class.getResource("/processing/opengl/shaders/TexLightFrag.glsl");
        defLineShaderVertURL = PGraphicsOpenGL.class.getResource("/processing/opengl/shaders/LineVert.glsl");
        defLineShaderFragURL = PGraphicsOpenGL.class.getResource("/processing/opengl/shaders/LineFrag.glsl");
        defPointShaderVertURL = PGraphicsOpenGL.class.getResource("/processing/opengl/shaders/PointVert.glsl");
        defPointShaderFragURL = PGraphicsOpenGL.class.getResource("/processing/opengl/shaders/PointFrag.glsl");
        maskShaderFragURL = PGraphicsOpenGL.class.getResource("/processing/opengl/shaders/MaskFrag.glsl");
        ongoingPixelTransfers = new HashSet<AsyncPixelReader>();
        ongoingPixelTransfersIterable = new ArrayList<AsyncPixelReader>();
        identity = new PMatrix3D();
        QUAD_POINT_SIGNS = new float[][]{{-1.0f, 1.0f}, {-1.0f, -1.0f}, {1.0f, -1.0f}, {1.0f, 1.0f}};
    }

    protected static class DepthSorter {
        static final int X = 0;
        static final int Y = 1;
        static final int Z = 2;
        static final int W = 3;
        static final int X0 = 0;
        static final int Y0 = 1;
        static final int Z0 = 2;
        static final int X1 = 3;
        static final int Y1 = 4;
        static final int Z1 = 5;
        static final int X2 = 6;
        static final int Y2 = 7;
        static final int Z2 = 8;
        int[] triangleIndices = new int[0];
        int[] texMap = new int[0];
        int[] voffsetMap = new int[0];
        float[] minXBuffer = new float[0];
        float[] minYBuffer = new float[0];
        float[] minZBuffer = new float[0];
        float[] maxXBuffer = new float[0];
        float[] maxYBuffer = new float[0];
        float[] maxZBuffer = new float[0];
        float[] screenVertices = new float[0];
        float[] triA = new float[9];
        float[] triB = new float[9];
        BitSet marked = new BitSet();
        BitSet swapped = new BitSet();
        PGraphicsOpenGL pg;

        DepthSorter(PGraphicsOpenGL pGraphicsOpenGL) {
            this.pg = pGraphicsOpenGL;
        }

        void checkIndexBuffers(int n) {
            if (this.triangleIndices.length < n) {
                int n2 = (n / 4 + 1) * 5;
                this.triangleIndices = new int[n2];
                this.texMap = new int[n2];
                this.voffsetMap = new int[n2];
                this.minXBuffer = new float[n2];
                this.minYBuffer = new float[n2];
                this.minZBuffer = new float[n2];
                this.maxXBuffer = new float[n2];
                this.maxYBuffer = new float[n2];
                this.maxZBuffer = new float[n2];
            }
        }

        void checkVertexBuffer(int n) {
            int n2 = 3 * n;
            if (this.screenVertices.length < n2) {
                int n3 = (n2 / 4 + 1) * 5;
                this.screenVertices = new float[n3];
            }
        }

        void sort(TessGeometry tessGeometry) {
            int n;
            int n2;
            float f;
            float f2;
            int n3;
            int n4 = tessGeometry.polyIndexCount / 3;
            this.checkIndexBuffers(n4);
            int[] nArray = this.triangleIndices;
            int[] nArray2 = this.texMap;
            int[] nArray3 = this.voffsetMap;
            for (int i = 0; i < n4; ++i) {
                nArray[i] = i;
            }
            TexCache texCache = this.pg.texCache;
            Object object = tessGeometry.polyIndexCache;
            for (int i = 0; i < texCache.size; ++i) {
                int n5 = texCache.firstCache[i];
                n3 = texCache.lastCache[i];
                for (int j = n5; j <= n3; ++j) {
                    int n6 = j == n5 ? texCache.firstIndex[i] : ((IndexCache)object).indexOffset[j];
                    int n7 = j == n3 ? texCache.lastIndex[i] - n6 + 1 : ((IndexCache)object).indexOffset[j] + ((IndexCache)object).indexCount[j] - n6;
                    for (int k = n6 / 3; k < (n6 + n7) / 3; ++k) {
                        nArray2[k] = i;
                        nArray3[k] = j;
                    }
                }
            }
            int n8 = tessGeometry.polyVertexCount;
            this.checkVertexBuffer(n8);
            object = this.screenVertices;
            Object[] objectArray = tessGeometry.polyVertices;
            Object object2 = this.pg.projection;
            for (n3 = 0; n3 < n8; ++n3) {
                float f3 = objectArray[4 * n3 + 0];
                float f4 = objectArray[4 * n3 + 1];
                float f5 = objectArray[4 * n3 + 2];
                float f6 = objectArray[4 * n3 + 3];
                float f7 = ((PMatrix3D)object2).m00 * f3 + ((PMatrix3D)object2).m01 * f4 + ((PMatrix3D)object2).m02 * f5 + ((PMatrix3D)object2).m03 * f6;
                float f8 = ((PMatrix3D)object2).m10 * f3 + ((PMatrix3D)object2).m11 * f4 + ((PMatrix3D)object2).m12 * f5 + ((PMatrix3D)object2).m13 * f6;
                f2 = ((PMatrix3D)object2).m20 * f3 + ((PMatrix3D)object2).m21 * f4 + ((PMatrix3D)object2).m22 * f5 + ((PMatrix3D)object2).m23 * f6;
                f = ((PMatrix3D)object2).m30 * f3 + ((PMatrix3D)object2).m31 * f4 + ((PMatrix3D)object2).m32 * f5 + ((PMatrix3D)object2).m33 * f6;
                if (PGraphicsOpenGL.nonZero(f)) {
                    f7 /= f;
                    f8 /= f;
                    f2 /= f;
                }
                object[3 * n3 + 0] = f7;
                object[3 * n3 + 1] = f8;
                object[3 * n3 + 2] = -f2;
            }
            float[] fArray = this.screenVertices;
            object = tessGeometry.polyIndexCache.vertexOffset;
            objectArray = tessGeometry.polyIndices;
            object2 = this.triA;
            float[] fArray2 = this.triB;
            for (n2 = 0; n2 < n4; ++n2) {
                DepthSorter.fetchTriCoords((float[])object2, n2, (int[])object, nArray3, fArray, (short[])objectArray);
                this.minXBuffer[n2] = PApplet.min((float)object2[0], (float)object2[3], (float)object2[6]);
                this.maxXBuffer[n2] = PApplet.max((float)object2[0], (float)object2[3], (float)object2[6]);
                this.minYBuffer[n2] = PApplet.min((float)object2[1], (float)object2[4], (float)object2[7]);
                this.maxYBuffer[n2] = PApplet.max((float)object2[1], (float)object2[4], (float)object2[7]);
                this.minZBuffer[n2] = PApplet.min((float)object2[2], (float)object2[5], (float)object2[8]);
                this.maxZBuffer[n2] = PApplet.max((float)object2[2], (float)object2[5], (float)object2[8]);
            }
            DepthSorter.sortByMinZ(0, n4 - 1, nArray, this.minZBuffer);
            BitSet bitSet = this.marked;
            BitSet bitSet2 = this.swapped;
            bitSet.clear();
            for (n2 = 0; n2 < n4; ++n2) {
                int n9 = n2 + 1;
                boolean bl = false;
                bitSet2.clear();
                int n10 = nArray[n2];
                f2 = this.minXBuffer[n10];
                f = this.maxXBuffer[n10];
                float f9 = this.minYBuffer[n10];
                float f10 = this.maxYBuffer[n10];
                float f11 = this.maxZBuffer[n10];
                DepthSorter.fetchTriCoords((float[])object2, n10, (int[])object, nArray3, fArray, (short[])objectArray);
                while (!bl && n9 < n4) {
                    n = nArray[n9];
                    if (f11 <= this.minZBuffer[n] && !bitSet.get(n)) {
                        bl = true;
                        continue;
                    }
                    if (f <= this.minXBuffer[n] || f10 <= this.minYBuffer[n] || f2 >= this.maxXBuffer[n] || f9 >= this.maxYBuffer[n]) {
                        ++n9;
                        continue;
                    }
                    DepthSorter.fetchTriCoords(fArray2, n, (int[])object, nArray3, fArray, (short[])objectArray);
                    if (DepthSorter.side(fArray2, (float[])object2, -1.0f) > 0) {
                        ++n9;
                        continue;
                    }
                    if (DepthSorter.side((float[])object2, fArray2, 1.0f) > 0) {
                        ++n9;
                        continue;
                    }
                    if (!bitSet2.get(n)) {
                        bitSet2.set(n10);
                        bitSet.set(n);
                        DepthSorter.rotateRight(nArray, n2, n9);
                        n10 = n;
                        System.arraycopy(fArray2, 0, object2, 0, 9);
                        f2 = this.minXBuffer[n10];
                        f = this.maxXBuffer[n10];
                        f9 = this.minYBuffer[n10];
                        f10 = this.maxYBuffer[n10];
                        f11 = this.maxZBuffer[n10];
                        n9 = n2 + 1;
                        continue;
                    }
                    ++n9;
                }
            }
            for (int i = 0; i < n4; ++i) {
                int n11 = nArray[i];
                if (i == n11) continue;
                float f12 = objectArray[3 * i + 0];
                float f13 = objectArray[3 * i + 1];
                float f14 = objectArray[3 * i + 2];
                int n12 = nArray2[i];
                int n13 = nArray3[i];
                int n14 = i;
                n = n11;
                do {
                    nArray[n14] = n14;
                    objectArray[3 * n14 + 0] = objectArray[3 * n + 0];
                    objectArray[3 * n14 + 1] = objectArray[3 * n + 1];
                    objectArray[3 * n14 + 2] = objectArray[3 * n + 2];
                    nArray2[n14] = nArray2[n];
                    nArray3[n14] = nArray3[n];
                    n14 = n;
                } while ((n = nArray[n]) != i);
                nArray[n14] = n14;
                objectArray[3 * n14 + 0] = f12;
                objectArray[3 * n14 + 1] = f13;
                objectArray[3 * n14 + 2] = f14;
                nArray2[n14] = n12;
                nArray3[n14] = n13;
            }
        }

        static void fetchTriCoords(float[] fArray, int n, int[] nArray, int[] nArray2, float[] fArray2, short[] sArray) {
            int n2 = nArray[nArray2[n]];
            int n3 = 3 * (n2 + sArray[3 * n + 0]);
            int n4 = 3 * (n2 + sArray[3 * n + 1]);
            int n5 = 3 * (n2 + sArray[3 * n + 2]);
            fArray[0] = fArray2[n3 + 0];
            fArray[1] = fArray2[n3 + 1];
            fArray[2] = fArray2[n3 + 2];
            fArray[3] = fArray2[n4 + 0];
            fArray[4] = fArray2[n4 + 1];
            fArray[5] = fArray2[n4 + 2];
            fArray[6] = fArray2[n5 + 0];
            fArray[7] = fArray2[n5 + 1];
            fArray[8] = fArray2[n5 + 2];
        }

        static void sortByMinZ(int n, int n2, int[] nArray, float[] fArray) {
            DepthSorter.swap(nArray, n, (n + n2) / 2);
            int n3 = n;
            float f = fArray[nArray[n]];
            for (int i = n + 1; i <= n2; ++i) {
                float f2 = fArray[nArray[i]];
                if (!(f2 < f)) continue;
                DepthSorter.swap(nArray, ++n3, i);
            }
            DepthSorter.swap(nArray, n, n3);
            if (n < n3 - 1) {
                DepthSorter.sortByMinZ(n, n3 - 1, nArray, fArray);
            }
            if (n3 + 1 < n2) {
                DepthSorter.sortByMinZ(n3 + 1, n2, nArray, fArray);
            }
        }

        static int side(float[] fArray, float[] fArray2, float f) {
            boolean bl;
            float f2;
            float f3 = fArray[3] - fArray[0];
            float f4 = fArray[6] - fArray[0];
            float f5 = fArray[4] - fArray[1];
            float f6 = fArray[7] - fArray[1];
            float f7 = fArray[5] - fArray[2];
            float f8 = fArray[8] - fArray[2];
            float f9 = f5 * f8 - f7 * f6;
            float f10 = f7 * f4 - f3 * f8;
            float f11 = f3 * f6 - f5 * f4;
            float f12 = 1.0f / (float)Math.sqrt(f9 * f9 + f10 * f10 + f11 * f11);
            float f13 = -DepthSorter.dot(f9 *= f12, f10 *= f12, f11 *= f12, fArray[0], fArray[1], fArray[2]);
            f3 = DepthSorter.dot(f9, f10, f11, fArray[0], fArray[1], fArray[2] + 100.0f * f) + f13;
            f4 = DepthSorter.dot(f9, f10, f11, fArray2[0], fArray2[1], fArray2[2]) + f13;
            f5 = DepthSorter.dot(f9, f10, f11, fArray2[3], fArray2[4], fArray2[5]) + f13;
            f6 = DepthSorter.dot(f9, f10, f11, fArray2[6], fArray2[7], fArray2[8]) + f13;
            f7 = PApplet.abs(f4);
            float f14 = (f7 < (f2 = PApplet.max(f7, f8 = PApplet.abs(f5), f12 = PApplet.abs(f6)) * 0.1f) ? 0.0f : f4) * f3;
            float f15 = (f8 < f2 ? 0.0f : f5) * f3;
            float f16 = (f12 < f2 ? 0.0f : f6) * f3;
            boolean bl2 = f14 >= 0.0f && f15 >= 0.0f && f16 >= 0.0f;
            boolean bl3 = bl = f14 <= 0.0f && f15 <= 0.0f && f16 <= 0.0f;
            return bl2 ? 1 : (bl ? -1 : 0);
        }

        static float dot(float f, float f2, float f3, float f4, float f5, float f6) {
            return f * f4 + f2 * f5 + f3 * f6;
        }

        static void swap(int[] nArray, int n, int n2) {
            int n3 = nArray[n];
            nArray[n] = nArray[n2];
            nArray[n2] = n3;
        }

        static void rotateRight(int[] nArray, int n, int n2) {
            if (n == n2) {
                return;
            }
            int n3 = nArray[n2];
            System.arraycopy(nArray, n, nArray, n + 1, n2 - n);
            nArray[n] = n3;
        }
    }

    protected static class Tessellator {
        InGeometry in;
        TessGeometry tess;
        TexCache texCache;
        PImage prevTexImage;
        PImage newTexImage;
        int firstTexIndex;
        int firstTexCache;
        PGL.Tessellator gluTess;
        TessellatorCallback callback;
        boolean fill;
        boolean stroke;
        int strokeColor;
        float strokeWeight;
        int strokeJoin;
        int strokeCap;
        boolean accurate2DStrokes = true;
        PMatrix transform = null;
        float transformScale;
        boolean is2D = false;
        boolean is3D = true;
        protected PGraphicsOpenGL pg;
        int[] rawIndices = new int[512];
        int rawSize;
        int[] dupIndices;
        int dupCount;
        int firstPolyIndexCache;
        int lastPolyIndexCache;
        int firstLineIndexCache;
        int lastLineIndexCache;
        int firstPointIndexCache;
        int lastPointIndexCache;
        float[] strokeVertices;
        int[] strokeColors;
        float[] strokeWeights;
        int pathVertexCount;
        float[] pathVertices;
        int[] pathColors;
        float[] pathWeights;
        int beginPath;

        void initGluTess() {
            if (this.gluTess == null) {
                this.callback = new TessellatorCallback(this.tess.polyAttribs);
                this.gluTess = this.pg.pgl.createTessellator(this.callback);
            }
        }

        void setInGeometry(InGeometry inGeometry) {
            this.in = inGeometry;
            this.firstPolyIndexCache = -1;
            this.lastPolyIndexCache = -1;
            this.firstLineIndexCache = -1;
            this.lastLineIndexCache = -1;
            this.firstPointIndexCache = -1;
            this.lastPointIndexCache = -1;
        }

        void setTessGeometry(TessGeometry tessGeometry) {
            this.tess = tessGeometry;
        }

        void setFill(boolean bl) {
            this.fill = bl;
        }

        void setTexCache(TexCache texCache, PImage pImage) {
            this.texCache = texCache;
            this.newTexImage = pImage;
        }

        void setStroke(boolean bl) {
            this.stroke = bl;
        }

        void setStrokeColor(int n) {
            this.strokeColor = PGL.javaToNativeARGB(n);
        }

        void setStrokeWeight(float f) {
            this.strokeWeight = f;
        }

        void setStrokeCap(int n) {
            this.strokeCap = n;
        }

        void setStrokeJoin(int n) {
            this.strokeJoin = n;
        }

        void setAccurate2DStrokes(boolean bl) {
            this.accurate2DStrokes = bl;
        }

        protected void setRenderer(PGraphicsOpenGL pGraphicsOpenGL) {
            this.pg = pGraphicsOpenGL;
        }

        void set3D(boolean bl) {
            if (bl) {
                this.is2D = false;
                this.is3D = true;
            } else {
                this.is2D = true;
                this.is3D = false;
            }
        }

        void setTransform(PMatrix pMatrix) {
            this.transform = pMatrix;
            this.transformScale = -1.0f;
        }

        void resetCurveVertexCount() {
            this.pg.curveVertexCount = 0;
        }

        void tessellatePoints() {
            if (this.strokeCap == 2) {
                this.tessellateRoundPoints();
            } else {
                this.tessellateSquarePoints();
            }
        }

        void tessellateRoundPoints() {
            int n = this.in.vertexCount;
            if (this.stroke && 1 <= n) {
                int n2 = PApplet.min(200, PApplet.max(20, (int)((float)Math.PI * 2 * this.strokeWeight / 10.0f))) + 1;
                if (PGL.MAX_VERTEX_INDEX1 <= n2) {
                    throw new RuntimeException("Error in point tessellation.");
                }
                this.updateTex();
                int n3 = n2 * n;
                int n4 = 3 * (n2 - 1) * n;
                if (this.is3D) {
                    this.tessellateRoundPoints3D(n3, n4, n2);
                } else if (this.is2D) {
                    this.beginNoTex();
                    this.tessellateRoundPoints2D(n3, n4, n2);
                    this.endNoTex();
                }
            }
        }

        void tessellateRoundPoints3D(int n, int n2, int n3) {
            int n4;
            int n5 = n3 - 1;
            this.tess.pointVertexCheck(n);
            this.tess.pointIndexCheck(n2);
            int n6 = this.tess.firstPointVertex;
            int n7 = this.tess.firstPointVertex;
            int n8 = this.tess.firstPointIndex;
            IndexCache indexCache = this.tess.pointIndexCache;
            this.firstPointIndexCache = n4 = this.in.renderMode == 1 ? indexCache.addNew() : indexCache.getLast();
            for (int i = 0; i < this.in.vertexCount; ++i) {
                int n9;
                int n10 = indexCache.vertexCount[n4];
                if (PGL.MAX_VERTEX_INDEX1 <= n10 + n3) {
                    n4 = indexCache.addNew();
                    n10 = 0;
                }
                for (int j = 0; j < n3; ++j) {
                    this.tess.setPointVertex(n6, this.in, i);
                    ++n6;
                }
                this.tess.pointOffsets[2 * n7 + 0] = 0.0f;
                this.tess.pointOffsets[2 * n7 + 1] = 0.0f;
                ++n7;
                float f = 0.0f;
                float f2 = 720.0f / (float)n5;
                for (n9 = 0; n9 < n5; ++n9) {
                    this.tess.pointOffsets[2 * n7 + 0] = 0.5f * cosLUT[(int)f] * this.transformScale() * this.strokeWeight;
                    this.tess.pointOffsets[2 * n7 + 1] = 0.5f * sinLUT[(int)f] * this.transformScale() * this.strokeWeight;
                    f = (f + f2) % 720.0f;
                    ++n7;
                }
                for (n9 = 1; n9 < n3 - 1; ++n9) {
                    this.tess.pointIndices[n8++] = (short)(n10 + 0);
                    this.tess.pointIndices[n8++] = (short)(n10 + n9);
                    this.tess.pointIndices[n8++] = (short)(n10 + n9 + 1);
                }
                this.tess.pointIndices[n8++] = (short)(n10 + 0);
                this.tess.pointIndices[n8++] = (short)(n10 + 1);
                this.tess.pointIndices[n8++] = (short)(n10 + n3 - 1);
                indexCache.incCounts(n4, 3 * (n3 - 1), n3);
            }
            this.lastPointIndexCache = n4;
        }

        void tessellateRoundPoints2D(int n, int n2, int n3) {
            int n4;
            int n5 = n3 - 1;
            this.tess.polyVertexCheck(n);
            this.tess.polyIndexCheck(n2);
            int n6 = this.tess.firstPolyVertex;
            int n7 = this.tess.firstPolyIndex;
            IndexCache indexCache = this.tess.polyIndexCache;
            this.firstPointIndexCache = n4 = this.in.renderMode == 1 ? indexCache.addNew() : indexCache.getLast();
            if (this.firstPolyIndexCache == -1) {
                this.firstPolyIndexCache = n4;
            }
            for (int i = 0; i < this.in.vertexCount; ++i) {
                int n8;
                int n9 = indexCache.vertexCount[n4];
                if (PGL.MAX_VERTEX_INDEX1 <= n9 + n3) {
                    n4 = indexCache.addNew();
                    n9 = 0;
                }
                float f = this.in.vertices[3 * i + 0];
                float f2 = this.in.vertices[3 * i + 1];
                int n10 = this.in.strokeColors[i];
                float f3 = 0.0f;
                float f4 = 720.0f / (float)n5;
                this.tess.setPolyVertex(n6, f, f2, 0.0f, n10, false);
                ++n6;
                for (n8 = 0; n8 < n5; ++n8) {
                    this.tess.setPolyVertex(n6, f + 0.5f * cosLUT[(int)f3] * this.strokeWeight, f2 + 0.5f * sinLUT[(int)f3] * this.strokeWeight, 0.0f, n10, false);
                    ++n6;
                    f3 = (f3 + f4) % 720.0f;
                }
                for (n8 = 1; n8 < n3 - 1; ++n8) {
                    this.tess.polyIndices[n7++] = (short)(n9 + 0);
                    this.tess.polyIndices[n7++] = (short)(n9 + n8);
                    this.tess.polyIndices[n7++] = (short)(n9 + n8 + 1);
                }
                this.tess.polyIndices[n7++] = (short)(n9 + 0);
                this.tess.polyIndices[n7++] = (short)(n9 + 1);
                this.tess.polyIndices[n7++] = (short)(n9 + n3 - 1);
                indexCache.incCounts(n4, 3 * (n3 - 1), n3);
            }
            this.lastPointIndexCache = this.lastPolyIndexCache = n4;
        }

        void tessellateSquarePoints() {
            int n = this.in.vertexCount;
            if (this.stroke && 1 <= n) {
                this.updateTex();
                int n2 = n;
                int n3 = 5 * n2;
                int n4 = 12 * n2;
                if (this.is3D) {
                    this.tessellateSquarePoints3D(n3, n4);
                } else if (this.is2D) {
                    this.beginNoTex();
                    this.tessellateSquarePoints2D(n3, n4);
                    this.endNoTex();
                }
            }
        }

        void tessellateSquarePoints3D(int n, int n2) {
            int n3;
            this.tess.pointVertexCheck(n);
            this.tess.pointIndexCheck(n2);
            int n4 = this.tess.firstPointVertex;
            int n5 = this.tess.firstPointVertex;
            int n6 = this.tess.firstPointIndex;
            IndexCache indexCache = this.tess.pointIndexCache;
            this.firstPointIndexCache = n3 = this.in.renderMode == 1 ? indexCache.addNew() : indexCache.getLast();
            for (int i = 0; i < this.in.vertexCount; ++i) {
                int n7;
                int n8 = indexCache.vertexCount[n3];
                int n9 = 5;
                if (PGL.MAX_VERTEX_INDEX1 <= n8 + n9) {
                    n3 = indexCache.addNew();
                    n8 = 0;
                }
                for (n7 = 0; n7 < n9; ++n7) {
                    this.tess.setPointVertex(n4, this.in, i);
                    ++n4;
                }
                this.tess.pointOffsets[2 * n5 + 0] = 0.0f;
                this.tess.pointOffsets[2 * n5 + 1] = 0.0f;
                ++n5;
                for (n7 = 0; n7 < 4; ++n7) {
                    this.tess.pointOffsets[2 * n5 + 0] = 0.5f * QUAD_POINT_SIGNS[n7][0] * this.transformScale() * this.strokeWeight;
                    this.tess.pointOffsets[2 * n5 + 1] = 0.5f * QUAD_POINT_SIGNS[n7][1] * this.transformScale() * this.strokeWeight;
                    ++n5;
                }
                for (n7 = 1; n7 < n9 - 1; ++n7) {
                    this.tess.pointIndices[n6++] = (short)(n8 + 0);
                    this.tess.pointIndices[n6++] = (short)(n8 + n7);
                    this.tess.pointIndices[n6++] = (short)(n8 + n7 + 1);
                }
                this.tess.pointIndices[n6++] = (short)(n8 + 0);
                this.tess.pointIndices[n6++] = (short)(n8 + 1);
                this.tess.pointIndices[n6++] = (short)(n8 + n9 - 1);
                indexCache.incCounts(n3, 12, 5);
            }
            this.lastPointIndexCache = n3;
        }

        void tessellateSquarePoints2D(int n, int n2) {
            int n3;
            this.tess.polyVertexCheck(n);
            this.tess.polyIndexCheck(n2);
            boolean bl = this.clampSquarePoints2D();
            int n4 = this.tess.firstPolyVertex;
            int n5 = this.tess.firstPolyIndex;
            IndexCache indexCache = this.tess.polyIndexCache;
            this.firstPointIndexCache = n3 = this.in.renderMode == 1 ? indexCache.addNew() : indexCache.getLast();
            if (this.firstPolyIndexCache == -1) {
                this.firstPolyIndexCache = n3;
            }
            for (int i = 0; i < this.in.vertexCount; ++i) {
                int n6;
                int n7 = indexCache.vertexCount[n3];
                int n8 = 5;
                if (PGL.MAX_VERTEX_INDEX1 <= n7 + n8) {
                    n3 = indexCache.addNew();
                    n7 = 0;
                }
                float f = this.in.vertices[3 * i + 0];
                float f2 = this.in.vertices[3 * i + 1];
                int n9 = this.in.strokeColors[i];
                this.tess.setPolyVertex(n4, f, f2, 0.0f, n9, bl);
                ++n4;
                for (n6 = 0; n6 < n8 - 1; ++n6) {
                    this.tess.setPolyVertex(n4, f + 0.5f * QUAD_POINT_SIGNS[n6][0] * this.strokeWeight, f2 + 0.5f * QUAD_POINT_SIGNS[n6][1] * this.strokeWeight, 0.0f, n9, bl);
                    ++n4;
                }
                for (n6 = 1; n6 < n8 - 1; ++n6) {
                    this.tess.polyIndices[n5++] = (short)(n7 + 0);
                    this.tess.polyIndices[n5++] = (short)(n7 + n6);
                    this.tess.polyIndices[n5++] = (short)(n7 + n6 + 1);
                }
                this.tess.polyIndices[n5++] = (short)(n7 + 0);
                this.tess.polyIndices[n5++] = (short)(n7 + 1);
                this.tess.polyIndices[n5++] = (short)(n7 + n8 - 1);
                indexCache.incCounts(n3, 12, 5);
            }
            this.lastPointIndexCache = this.lastPolyIndexCache = n3;
        }

        boolean clamp2D() {
            return this.is2D && this.tess.renderMode == 0 && PGraphicsOpenGL.zero(this.pg.modelview.m01) && PGraphicsOpenGL.zero(this.pg.modelview.m10);
        }

        boolean clampSquarePoints2D() {
            return this.clamp2D();
        }

        void tessellateLines() {
            int n = this.in.vertexCount;
            if (this.stroke && 2 <= n) {
                this.strokeVertices = this.in.vertices;
                this.strokeColors = this.in.strokeColors;
                this.strokeWeights = this.in.strokeWeights;
                this.updateTex();
                int n2 = n / 2;
                if (this.is3D) {
                    this.tessellateLines3D(n2);
                } else if (this.is2D) {
                    this.beginNoTex();
                    this.tessellateLines2D(n2);
                    this.endNoTex();
                }
            }
        }

        void tessellateLines3D(int n) {
            int n2;
            int n3 = n * 4;
            int n4 = n * 2 * 3;
            int n5 = this.tess.lineVertexCount;
            int n6 = this.tess.lineIndexCount;
            this.tess.lineVertexCheck(n3);
            this.tess.lineIndexCheck(n4);
            this.firstLineIndexCache = n2 = this.in.renderMode == 1 ? this.tess.lineIndexCache.addNew() : this.tess.lineIndexCache.getLast();
            int[] nArray = new int[]{0, 0};
            this.tess.lineIndexCache.setCounter(nArray);
            for (int i = 0; i < n; ++i) {
                int n7 = 2 * i + 0;
                int n8 = 2 * i + 1;
                n2 = this.addLineSegment3D(n7, n8, n7 - 2, n8 - 1, n2, null, false);
            }
            this.tess.lineIndexCache.setCounter(null);
            this.tess.lineIndexCount = n6 + nArray[0];
            this.tess.lineVertexCount = n5 + nArray[1];
            this.lastLineIndexCache = n2;
        }

        void tessellateLines2D(int n) {
            int n2 = n * 4;
            int n3 = n * 2 * 3;
            if (this.noCapsJoins(n2)) {
                int n4;
                this.tess.polyVertexCheck(n2);
                this.tess.polyIndexCheck(n3);
                this.firstLineIndexCache = n4 = this.in.renderMode == 1 ? this.tess.polyIndexCache.addNew() : this.tess.polyIndexCache.getLast();
                if (this.firstPolyIndexCache == -1) {
                    this.firstPolyIndexCache = n4;
                }
                boolean bl = this.clampLines2D(n);
                for (int i = 0; i < n; ++i) {
                    int n5 = 2 * i + 0;
                    int n6 = 2 * i + 1;
                    n4 = this.addLineSegment2D(n5, n6, n4, false, bl);
                }
                this.lastLineIndexCache = this.lastPolyIndexCache = n4;
            } else {
                LinePath linePath = new LinePath(1);
                for (int i = 0; i < n; ++i) {
                    int n7 = 2 * i + 0;
                    int n8 = 2 * i + 1;
                    linePath.moveTo(this.in.vertices[3 * n7 + 0], this.in.vertices[3 * n7 + 1], this.in.strokeColors[n7]);
                    linePath.lineTo(this.in.vertices[3 * n8 + 0], this.in.vertices[3 * n8 + 1], this.in.strokeColors[n8]);
                }
                this.tessellateLinePath(linePath);
            }
        }

        boolean clampLines2D(int n) {
            boolean bl = this.clamp2D();
            if (bl) {
                int n2;
                int n3;
                for (int i = 0; i < n && (bl = this.segmentIsAxisAligned(n3 = 2 * i + 0, n2 = 2 * i + 1)); ++i) {
                }
            }
            return bl;
        }

        void tessellateLineStrip() {
            int n = this.in.vertexCount;
            if (this.stroke && 2 <= n) {
                this.strokeVertices = this.in.vertices;
                this.strokeColors = this.in.strokeColors;
                this.strokeWeights = this.in.strokeWeights;
                this.updateTex();
                int n2 = n - 1;
                if (this.is3D) {
                    this.tessellateLineStrip3D(n2);
                } else if (this.is2D) {
                    this.beginNoTex();
                    this.tessellateLineStrip2D(n2);
                    this.endNoTex();
                }
            }
        }

        void tessellateLineStrip3D(int n) {
            int n2;
            int n3 = this.noCapsJoins() ? 0 : n - 1;
            int n4 = n * 4 + n3 * 3;
            int n5 = n * 2 * 3 + n3 * 2 * 3;
            int n6 = this.tess.lineVertexCount;
            int n7 = this.tess.lineIndexCount;
            this.tess.lineVertexCheck(n4);
            this.tess.lineIndexCheck(n5);
            this.firstLineIndexCache = n2 = this.in.renderMode == 1 ? this.tess.lineIndexCache.addNew() : this.tess.lineIndexCache.getLast();
            int n8 = 0;
            short[] sArray = new short[]{-1, -1};
            int[] nArray = new int[]{0, 0};
            this.tess.lineIndexCache.setCounter(nArray);
            for (int i = 0; i < n; ++i) {
                int n9 = i + 1;
                n2 = 0 < n3 ? this.addLineSegment3D(n8, n9, n9 - 2, n9 - 1, n2, sArray, false) : this.addLineSegment3D(n8, n9, n9 - 2, n9 - 1, n2, null, false);
                n8 = n9;
            }
            this.tess.lineIndexCache.setCounter(null);
            this.tess.lineIndexCount = n7 + nArray[0];
            this.tess.lineVertexCount = n6 + nArray[1];
            this.lastLineIndexCache = n2;
        }

        void tessellateLineStrip2D(int n) {
            int n2 = n * 4;
            int n3 = n * 2 * 3;
            if (this.noCapsJoins(n2)) {
                int n4;
                this.tess.polyVertexCheck(n2);
                this.tess.polyIndexCheck(n3);
                this.firstLineIndexCache = n4 = this.in.renderMode == 1 ? this.tess.polyIndexCache.addNew() : this.tess.polyIndexCache.getLast();
                if (this.firstPolyIndexCache == -1) {
                    this.firstPolyIndexCache = n4;
                }
                int n5 = 0;
                boolean bl = this.clampLineStrip2D(n);
                for (int i = 0; i < n; ++i) {
                    int n6 = i + 1;
                    n4 = this.addLineSegment2D(n5, n6, n4, false, bl);
                    n5 = n6;
                }
                this.lastLineIndexCache = this.lastPolyIndexCache = n4;
            } else {
                LinePath linePath = new LinePath(1);
                linePath.moveTo(this.in.vertices[0], this.in.vertices[1], this.in.strokeColors[0]);
                for (int i = 0; i < n; ++i) {
                    int n7 = i + 1;
                    linePath.lineTo(this.in.vertices[3 * n7 + 0], this.in.vertices[3 * n7 + 1], this.in.strokeColors[n7]);
                }
                this.tessellateLinePath(linePath);
            }
        }

        boolean clampLineStrip2D(int n) {
            boolean bl = this.clamp2D();
            if (bl) {
                for (int i = 0; i < n && (bl = this.segmentIsAxisAligned(0, i + 1)); ++i) {
                }
            }
            return bl;
        }

        void tessellateLineLoop() {
            int n = this.in.vertexCount;
            if (this.stroke && 2 <= n) {
                this.strokeVertices = this.in.vertices;
                this.strokeColors = this.in.strokeColors;
                this.strokeWeights = this.in.strokeWeights;
                this.updateTex();
                int n2 = n;
                if (this.is3D) {
                    this.tessellateLineLoop3D(n2);
                } else if (this.is2D) {
                    this.beginNoTex();
                    this.tessellateLineLoop2D(n2);
                    this.endNoTex();
                }
            }
        }

        void tessellateLineLoop3D(int n) {
            int n2;
            int n3 = this.noCapsJoins() ? 0 : n;
            int n4 = n * 4 + n3 * 3;
            int n5 = n * 2 * 3 + n3 * 2 * 3;
            int n6 = this.tess.lineVertexCount;
            int n7 = this.tess.lineIndexCount;
            this.tess.lineVertexCheck(n4);
            this.tess.lineIndexCheck(n5);
            this.firstLineIndexCache = n2 = this.in.renderMode == 1 ? this.tess.lineIndexCache.addNew() : this.tess.lineIndexCache.getLast();
            int n8 = 0;
            int n9 = -1;
            short[] sArray = new short[]{-1, -1};
            int[] nArray = new int[]{0, 0};
            this.tess.lineIndexCache.setCounter(nArray);
            for (int i = 0; i < n - 1; ++i) {
                n9 = i + 1;
                n2 = 0 < n3 ? this.addLineSegment3D(n8, n9, n9 - 2, n9 - 1, n2, sArray, false) : this.addLineSegment3D(n8, n9, n9 - 2, n9 - 1, n2, null, false);
                n8 = n9;
            }
            n2 = this.addLineSegment3D(this.in.vertexCount - 1, 0, n9 - 2, n9 - 1, n2, sArray, false);
            if (0 < n3) {
                n2 = this.addBevel3D(0, 1, this.in.vertexCount - 1, 0, n2, sArray, false);
            }
            this.tess.lineIndexCache.setCounter(null);
            this.tess.lineIndexCount = n7 + nArray[0];
            this.tess.lineVertexCount = n6 + nArray[1];
            this.lastLineIndexCache = n2;
        }

        void tessellateLineLoop2D(int n) {
            int n2 = n * 4;
            int n3 = n * 2 * 3;
            if (this.noCapsJoins(n2)) {
                int n4;
                this.tess.polyVertexCheck(n2);
                this.tess.polyIndexCheck(n3);
                this.firstLineIndexCache = n4 = this.in.renderMode == 1 ? this.tess.polyIndexCache.addNew() : this.tess.polyIndexCache.getLast();
                if (this.firstPolyIndexCache == -1) {
                    this.firstPolyIndexCache = n4;
                }
                int n5 = 0;
                boolean bl = this.clampLineLoop2D(n);
                for (int i = 0; i < n - 1; ++i) {
                    int n6 = i + 1;
                    n4 = this.addLineSegment2D(n5, n6, n4, false, bl);
                    n5 = n6;
                }
                this.lastLineIndexCache = this.lastPolyIndexCache = (n4 = this.addLineSegment2D(0, this.in.vertexCount - 1, n4, false, bl));
            } else {
                LinePath linePath = new LinePath(1);
                linePath.moveTo(this.in.vertices[0], this.in.vertices[1], this.in.strokeColors[0]);
                for (int i = 0; i < n - 1; ++i) {
                    int n7 = i + 1;
                    linePath.lineTo(this.in.vertices[3 * n7 + 0], this.in.vertices[3 * n7 + 1], this.in.strokeColors[n7]);
                }
                linePath.closePath();
                this.tessellateLinePath(linePath);
            }
        }

        boolean clampLineLoop2D(int n) {
            boolean bl = this.clamp2D();
            if (bl) {
                for (int i = 0; i < n && (bl = this.segmentIsAxisAligned(0, i + 1)); ++i) {
                }
            }
            return bl;
        }

        void tessellateEdges() {
            if (this.stroke) {
                if (this.in.edgeCount == 0) {
                    return;
                }
                this.strokeVertices = this.in.vertices;
                this.strokeColors = this.in.strokeColors;
                this.strokeWeights = this.in.strokeWeights;
                if (this.is3D) {
                    this.tessellateEdges3D();
                } else if (this.is2D) {
                    this.beginNoTex();
                    this.tessellateEdges2D();
                    this.endNoTex();
                }
            }
        }

        void tessellateEdges3D() {
            int n;
            boolean bl = !this.noCapsJoins();
            int n2 = this.in.getNumEdgeVertices(bl);
            int n3 = this.in.getNumEdgeIndices(bl);
            int n4 = this.tess.lineVertexCount;
            int n5 = this.tess.lineIndexCount;
            this.tess.lineVertexCheck(n2);
            this.tess.lineIndexCheck(n3);
            this.firstLineIndexCache = n = this.in.renderMode == 1 ? this.tess.lineIndexCache.addNew() : this.tess.lineIndexCache.getLast();
            int n6 = 0;
            int n7 = 0;
            short[] sArray = new short[]{-1, -1};
            int n8 = -1;
            int n9 = -1;
            int[] nArray = new int[]{0, 0};
            this.tess.lineIndexCache.setCounter(nArray);
            for (int i = 0; i <= this.in.edgeCount - 1; ++i) {
                int[] nArray2 = this.in.edges[i];
                int n10 = nArray2[0];
                int n11 = nArray2[1];
                if (bl) {
                    n = nArray2[2] == -1 ? this.addBevel3D(n6, n7, n8, n9, n, sArray, false) : this.addLineSegment3D(n10, n11, n8, n9, n, sArray, false);
                } else if (nArray2[2] != -1) {
                    n = this.addLineSegment3D(n10, n11, n8, n9, n, null, false);
                }
                if (nArray2[2] == 1) {
                    n6 = n10;
                    n7 = n11;
                }
                if (nArray2[2] == 2 || nArray2[2] == 3 || nArray2[2] == -1) {
                    sArray[1] = -1;
                    sArray[0] = -1;
                    n8 = -1;
                    n9 = -1;
                    continue;
                }
                n8 = n10;
                n9 = n11;
            }
            this.tess.lineIndexCache.setCounter(null);
            this.tess.lineIndexCount = n5 + nArray[0];
            this.tess.lineVertexCount = n4 + nArray[1];
            this.lastLineIndexCache = n;
        }

        void tessellateEdges2D() {
            int n = this.in.getNumEdgeVertices(false);
            if (this.noCapsJoins(n)) {
                int n2;
                int n3 = this.in.getNumEdgeIndices(false);
                this.tess.polyVertexCheck(n);
                this.tess.polyIndexCheck(n3);
                this.firstLineIndexCache = n2 = this.in.renderMode == 1 ? this.tess.polyIndexCache.addNew() : this.tess.polyIndexCache.getLast();
                if (this.firstPolyIndexCache == -1) {
                    this.firstPolyIndexCache = n2;
                }
                boolean bl = this.clampEdges2D();
                for (int i = 0; i <= this.in.edgeCount - 1; ++i) {
                    int[] nArray = this.in.edges[i];
                    if (nArray[2] == -1) continue;
                    int n4 = nArray[0];
                    int n5 = nArray[1];
                    n2 = this.addLineSegment2D(n4, n5, n2, false, bl);
                }
                this.lastLineIndexCache = this.lastPolyIndexCache = n2;
            } else {
                LinePath linePath = new LinePath(1);
                block8: for (int i = 0; i <= this.in.edgeCount - 1; ++i) {
                    int[] nArray = this.in.edges[i];
                    int n6 = nArray[0];
                    int n7 = nArray[1];
                    switch (nArray[2]) {
                        case 0: {
                            linePath.lineTo(this.strokeVertices[3 * n7 + 0], this.strokeVertices[3 * n7 + 1], this.strokeColors[n7]);
                            continue block8;
                        }
                        case 1: {
                            linePath.moveTo(this.strokeVertices[3 * n6 + 0], this.strokeVertices[3 * n6 + 1], this.strokeColors[n6]);
                            linePath.lineTo(this.strokeVertices[3 * n7 + 0], this.strokeVertices[3 * n7 + 1], this.strokeColors[n7]);
                            continue block8;
                        }
                        case 2: {
                            linePath.lineTo(this.strokeVertices[3 * n7 + 0], this.strokeVertices[3 * n7 + 1], this.strokeColors[n7]);
                            linePath.moveTo(this.strokeVertices[3 * n7 + 0], this.strokeVertices[3 * n7 + 1], this.strokeColors[n7]);
                            continue block8;
                        }
                        case 3: {
                            linePath.moveTo(this.strokeVertices[3 * n6 + 0], this.strokeVertices[3 * n6 + 1], this.strokeColors[n6]);
                            linePath.lineTo(this.strokeVertices[3 * n7 + 0], this.strokeVertices[3 * n7 + 1], this.strokeColors[n7]);
                            linePath.moveTo(this.strokeVertices[3 * n7 + 0], this.strokeVertices[3 * n7 + 1], this.strokeColors[n7]);
                            continue block8;
                        }
                        case -1: {
                            linePath.closePath();
                        }
                    }
                }
                this.tessellateLinePath(linePath);
            }
        }

        boolean clampEdges2D() {
            boolean bl = this.clamp2D();
            if (bl) {
                int n;
                int n2;
                int[] nArray;
                for (int i = 0; i <= this.in.edgeCount - 1 && ((nArray = this.in.edges[i])[2] == -1 || (bl = this.segmentIsAxisAligned(this.strokeVertices, n2 = nArray[0], n = nArray[1]))); ++i) {
                }
            }
            return bl;
        }

        int addLineSegment3D(int n, int n2, int n3, int n4, int n5, short[] sArray, boolean bl) {
            IndexCache indexCache = this.tess.lineIndexCache;
            int n6 = indexCache.vertexCount[n5];
            boolean bl2 = sArray != null && -1 < sArray[0] && -1 < sArray[1];
            boolean bl3 = false;
            if (PGL.MAX_VERTEX_INDEX1 <= n6 + 4 + (bl2 ? 1 : 0)) {
                n5 = indexCache.addNew();
                n6 = 0;
                bl3 = true;
            }
            int n7 = indexCache.indexOffset[n5] + indexCache.indexCount[n5];
            int n8 = indexCache.vertexOffset[n5] + indexCache.vertexCount[n5];
            int n9 = bl ? this.strokeColor : this.strokeColors[n];
            int n10 = n9;
            float f = bl ? this.strokeWeight : this.strokeWeights[n];
            this.tess.setLineVertex(n8++, this.strokeVertices, n, n2, n9, (f *= this.transformScale()) / 2.0f);
            this.tess.lineIndices[n7++] = (short)(n6 + 0);
            this.tess.setLineVertex(n8++, this.strokeVertices, n, n2, n9, -f / 2.0f);
            this.tess.lineIndices[n7++] = (short)(n6 + 1);
            n9 = bl ? this.strokeColor : this.strokeColors[n2];
            f = bl ? this.strokeWeight : this.strokeWeights[n2];
            this.tess.setLineVertex(n8++, this.strokeVertices, n2, n, n9, -(f *= this.transformScale()) / 2.0f);
            this.tess.lineIndices[n7++] = (short)(n6 + 2);
            this.tess.lineIndices[n7++] = (short)(n6 + 2);
            this.tess.lineIndices[n7++] = (short)(n6 + 1);
            this.tess.setLineVertex(n8++, this.strokeVertices, n2, n, n9, f / 2.0f);
            this.tess.lineIndices[n7++] = (short)(n6 + 3);
            indexCache.incCounts(n5, 6, 4);
            if (sArray != null) {
                if (-1 < sArray[0] && -1 < sArray[1]) {
                    if (bl3) {
                        if (-1 < n3 && -1 < n4) {
                            n9 = bl ? this.strokeColor : this.strokeColors[n3];
                            f = bl ? this.strokeWeight : this.strokeWeights[n3];
                            this.tess.setLineVertex(n8++, this.strokeVertices, n4, n9);
                            this.tess.setLineVertex(n8++, this.strokeVertices, n4, n3, n9, -(f *= this.transformScale()) / 2.0f);
                            this.tess.setLineVertex(n8, this.strokeVertices, n4, n3, n9, f / 2.0f);
                            this.tess.lineIndices[n7++] = (short)(n6 + 4);
                            this.tess.lineIndices[n7++] = (short)(n6 + 5);
                            this.tess.lineIndices[n7++] = (short)(n6 + 0);
                            this.tess.lineIndices[n7++] = (short)(n6 + 4);
                            this.tess.lineIndices[n7++] = (short)(n6 + 6);
                            this.tess.lineIndices[n7] = (short)(n6 + 1);
                            indexCache.incCounts(n5, 6, 3);
                        }
                    } else {
                        this.tess.setLineVertex(n8, this.strokeVertices, n, n10);
                        this.tess.lineIndices[n7++] = (short)(n6 + 4);
                        this.tess.lineIndices[n7++] = sArray[0];
                        this.tess.lineIndices[n7++] = (short)(n6 + 0);
                        this.tess.lineIndices[n7++] = (short)(n6 + 4);
                        this.tess.lineIndices[n7++] = sArray[1];
                        this.tess.lineIndices[n7] = (short)(n6 + 1);
                        indexCache.incCounts(n5, 6, 1);
                    }
                }
                sArray[0] = (short)(n6 + 2);
                sArray[1] = (short)(n6 + 3);
            }
            return n5;
        }

        int addBevel3D(int n, int n2, int n3, int n4, int n5, short[] sArray, boolean bl) {
            IndexCache indexCache = this.tess.lineIndexCache;
            int n6 = indexCache.vertexCount[n5];
            boolean bl2 = false;
            if (PGL.MAX_VERTEX_INDEX1 <= n6 + 3) {
                n5 = indexCache.addNew();
                n6 = 0;
                bl2 = true;
            }
            int n7 = indexCache.indexOffset[n5] + indexCache.indexCount[n5];
            int n8 = indexCache.vertexOffset[n5] + indexCache.vertexCount[n5];
            int n9 = bl ? this.strokeColor : this.strokeColors[n];
            float f = bl ? this.strokeWeight : this.strokeWeights[n];
            this.tess.setLineVertex(n8++, this.strokeVertices, n, n9);
            this.tess.setLineVertex(n8++, this.strokeVertices, n, n2, n9, (f *= this.transformScale()) / 2.0f);
            this.tess.setLineVertex(n8++, this.strokeVertices, n, n2, n9, -f / 2.0f);
            int n10 = 0;
            if (bl2 && -1 < n3 && -1 < n4) {
                n9 = bl ? this.strokeColor : this.strokeColors[n4];
                f = bl ? this.strokeWeight : this.strokeWeights[n4];
                this.tess.setLineVertex(n8++, this.strokeVertices, n4, n3, n9, -(f *= this.transformScale()) / 2.0f);
                this.tess.setLineVertex(n8, this.strokeVertices, n4, n3, n9, f / 2.0f);
                sArray[0] = (short)(n6 + 3);
                sArray[1] = (short)(n6 + 4);
                n10 = 2;
            }
            this.tess.lineIndices[n7++] = (short)(n6 + 0);
            this.tess.lineIndices[n7++] = sArray[0];
            this.tess.lineIndices[n7++] = (short)(n6 + 1);
            this.tess.lineIndices[n7++] = (short)(n6 + 0);
            this.tess.lineIndices[n7++] = (short)(n6 + 2);
            this.tess.lineIndices[n7] = sArray[1];
            indexCache.incCounts(n5, 6, 3 + n10);
            return n5;
        }

        int addLineSegment2D(int n, int n2, int n3, boolean bl, boolean bl2) {
            float f;
            float f2;
            float f3;
            float f4;
            float f5;
            IndexCache indexCache = this.tess.polyIndexCache;
            int n4 = indexCache.vertexCount[n3];
            if (PGL.MAX_VERTEX_INDEX1 <= n4 + 4) {
                n3 = indexCache.addNew();
                n4 = 0;
            }
            int n5 = indexCache.indexOffset[n3] + indexCache.indexCount[n3];
            int n6 = indexCache.vertexOffset[n3] + indexCache.vertexCount[n3];
            int n7 = bl ? this.strokeColor : this.strokeColors[n];
            float f6 = f5 = bl ? this.strokeWeight : this.strokeWeights[n];
            if (this.subPixelStroke(f5)) {
                bl2 = false;
            }
            float f7 = this.strokeVertices[3 * n + 0];
            float f8 = this.strokeVertices[3 * n + 1];
            float f9 = this.strokeVertices[3 * n2 + 0];
            float f10 = this.strokeVertices[3 * n2 + 1];
            float f11 = f9 - f7;
            float f12 = f10 - f8;
            float f13 = PApplet.sqrt(f11 * f11 + f12 * f12);
            float f14 = 0.0f;
            float f15 = 0.0f;
            float f16 = 0.0f;
            float f17 = 0.0f;
            if (PGraphicsOpenGL.nonZero(f13)) {
                f14 = -f12 / f13;
                f15 = f11 / f13;
                f16 = f11 / f13 * PApplet.min(0.75f, f5 / 2.0f);
                f17 = f12 / f13 * PApplet.min(0.75f, f5 / 2.0f);
            }
            float f18 = f14 * f5 / 2.0f;
            float f19 = f15 * f5 / 2.0f;
            this.tess.setPolyVertex(n6++, f7 + f18 - f16, f8 + f19 - f17, 0.0f, n7, bl2);
            this.tess.polyIndices[n5++] = (short)(n4 + 0);
            this.tess.setPolyVertex(n6++, f7 - f18 - f16, f8 - f19 - f17, 0.0f, n7, bl2);
            this.tess.polyIndices[n5++] = (short)(n4 + 1);
            if (bl2) {
                f4 = this.tess.polyVertices[4 * (n6 - 2) + 0];
                f3 = this.tess.polyVertices[4 * (n6 - 2) + 1];
                f2 = this.tess.polyVertices[4 * (n6 - 1) + 0];
                f = this.tess.polyVertices[4 * (n6 - 1) + 1];
                if (PGraphicsOpenGL.same(f4, f2) && PGraphicsOpenGL.same(f3, f)) {
                    this.unclampLine2D(n6 - 2, f7 + f18 - f16, f8 + f19 - f17);
                    this.unclampLine2D(n6 - 1, f7 - f18 - f16, f8 - f19 - f17);
                }
            }
            if (!bl) {
                n7 = this.strokeColors[n2];
                f5 = this.strokeWeights[n2];
                f18 = f14 * f5 / 2.0f;
                f19 = f15 * f5 / 2.0f;
                if (this.subPixelStroke(f5)) {
                    bl2 = false;
                }
            }
            this.tess.setPolyVertex(n6++, f9 - f18 + f16, f10 - f19 + f17, 0.0f, n7, bl2);
            this.tess.polyIndices[n5++] = (short)(n4 + 2);
            this.tess.polyIndices[n5++] = (short)(n4 + 2);
            this.tess.polyIndices[n5++] = (short)(n4 + 0);
            this.tess.setPolyVertex(n6++, f9 + f18 + f16, f10 + f19 + f17, 0.0f, n7, bl2);
            this.tess.polyIndices[n5++] = (short)(n4 + 3);
            if (bl2) {
                f4 = this.tess.polyVertices[4 * (n6 - 2) + 0];
                f3 = this.tess.polyVertices[4 * (n6 - 2) + 1];
                f2 = this.tess.polyVertices[4 * (n6 - 1) + 0];
                f = this.tess.polyVertices[4 * (n6 - 1) + 1];
                if (PGraphicsOpenGL.same(f4, f2) && PGraphicsOpenGL.same(f3, f)) {
                    this.unclampLine2D(n6 - 2, f9 - f18 + f16, f10 - f19 + f17);
                    this.unclampLine2D(n6 - 1, f9 + f18 + f16, f10 + f19 + f17);
                }
            }
            indexCache.incCounts(n3, 6, 4);
            return n3;
        }

        void unclampLine2D(int n, float f, float f2) {
            PMatrix3D pMatrix3D = this.pg.modelview;
            int n2 = 4 * n;
            this.tess.polyVertices[n2++] = f * pMatrix3D.m00 + f2 * pMatrix3D.m01 + pMatrix3D.m03;
            this.tess.polyVertices[n2++] = f * pMatrix3D.m10 + f2 * pMatrix3D.m11 + pMatrix3D.m13;
        }

        boolean noCapsJoins(int n) {
            if (!this.accurate2DStrokes) {
                return true;
            }
            if (PGL.MAX_CAPS_JOINS_LENGTH <= n) {
                return true;
            }
            return this.noCapsJoins();
        }

        boolean subPixelStroke(float f) {
            float f2 = this.transformScale() * f;
            return PApplet.abs(f2 - (float)((int)f2)) > 0.0f;
        }

        boolean noCapsJoins() {
            return this.tess.renderMode == 0 && this.transformScale() * this.strokeWeight < PGL.MIN_CAPS_JOINS_WEIGHT;
        }

        float transformScale() {
            if (-1.0f < this.transformScale) {
                return this.transformScale;
            }
            this.transformScale = PGraphicsOpenGL.matrixScale(this.transform);
            return this.transformScale;
        }

        boolean segmentIsAxisAligned(int n, int n2) {
            return PGraphicsOpenGL.zero(this.in.vertices[3 * n + 0] - this.in.vertices[3 * n2 + 0]) || PGraphicsOpenGL.zero(this.in.vertices[3 * n + 1] - this.in.vertices[3 * n2 + 1]);
        }

        boolean segmentIsAxisAligned(float[] fArray, int n, int n2) {
            return PGraphicsOpenGL.zero(fArray[3 * n + 0] - fArray[3 * n2 + 0]) || PGraphicsOpenGL.zero(fArray[3 * n + 1] - fArray[3 * n2 + 1]);
        }

        void tessellateTriangles() {
            this.beginTex();
            int n = this.in.vertexCount / 3;
            if (this.fill && 1 <= n) {
                int n2 = 3 * n;
                this.setRawSize(n2);
                int n3 = 0;
                boolean bl = this.clampTriangles();
                int n4 = 0;
                while (n4 < 3 * n) {
                    this.rawIndices[n3++] = n4++;
                }
                this.splitRawIndices(bl);
            }
            this.endTex();
            this.tessellateEdges();
        }

        boolean clampTriangles() {
            boolean bl = this.clamp2D();
            if (bl) {
                int n = this.in.vertexCount / 3;
                for (int i = 0; i < n; ++i) {
                    int n2 = 3 * i + 0;
                    int n3 = 3 * i + 1;
                    int n4 = 3 * i + 2;
                    int n5 = 0;
                    if (this.segmentIsAxisAligned(n2, n3)) {
                        ++n5;
                    }
                    if (this.segmentIsAxisAligned(n2, n4)) {
                        ++n5;
                    }
                    if (this.segmentIsAxisAligned(n3, n4)) {
                        ++n5;
                    }
                    boolean bl2 = bl = 1 < n5;
                    if (!bl) break;
                }
            }
            return bl;
        }

        void tessellateTriangles(int[] nArray) {
            this.beginTex();
            int n = this.in.vertexCount;
            if (this.fill && 3 <= n) {
                int n2 = nArray.length;
                this.setRawSize(n2);
                PApplet.arrayCopy(nArray, this.rawIndices, n2);
                boolean bl = this.clampTriangles(nArray);
                this.splitRawIndices(bl);
            }
            this.endTex();
            this.tessellateEdges();
        }

        boolean clampTriangles(int[] nArray) {
            boolean bl = this.clamp2D();
            if (bl) {
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int n2 = nArray[3 * i + 0];
                    int n3 = nArray[3 * i + 1];
                    int n4 = nArray[3 * i + 2];
                    int n5 = 0;
                    if (this.segmentIsAxisAligned(n2, n3)) {
                        ++n5;
                    }
                    if (this.segmentIsAxisAligned(n2, n4)) {
                        ++n5;
                    }
                    if (this.segmentIsAxisAligned(n3, n4)) {
                        ++n5;
                    }
                    boolean bl2 = bl = 1 < n5;
                    if (!bl) break;
                }
            }
            return bl;
        }

        void tessellateTriangleFan() {
            this.beginTex();
            int n = this.in.vertexCount;
            if (this.fill && 3 <= n) {
                int n2 = 3 * (n - 2);
                this.setRawSize(n2);
                int n3 = 0;
                boolean bl = this.clampTriangleFan();
                for (int i = 1; i < this.in.vertexCount - 1; ++i) {
                    this.rawIndices[n3++] = 0;
                    this.rawIndices[n3++] = i;
                    this.rawIndices[n3++] = i + 1;
                }
                this.splitRawIndices(bl);
            }
            this.endTex();
            this.tessellateEdges();
        }

        boolean clampTriangleFan() {
            boolean bl = this.clamp2D();
            if (bl) {
                for (int i = 1; i < this.in.vertexCount - 1; ++i) {
                    int n = 0;
                    int n2 = i;
                    int n3 = i + 1;
                    int n4 = 0;
                    if (this.segmentIsAxisAligned(n, n2)) {
                        ++n4;
                    }
                    if (this.segmentIsAxisAligned(n, n3)) {
                        ++n4;
                    }
                    if (this.segmentIsAxisAligned(n2, n3)) {
                        ++n4;
                    }
                    boolean bl2 = bl = 1 < n4;
                    if (!bl) break;
                }
            }
            return bl;
        }

        void tessellateTriangleStrip() {
            this.beginTex();
            int n = this.in.vertexCount;
            if (this.fill && 3 <= n) {
                int n2 = 3 * (n - 2);
                this.setRawSize(n2);
                int n3 = 0;
                boolean bl = this.clampTriangleStrip();
                for (int i = 1; i < this.in.vertexCount - 1; ++i) {
                    this.rawIndices[n3++] = i;
                    if (i % 2 == 0) {
                        this.rawIndices[n3++] = i - 1;
                        this.rawIndices[n3++] = i + 1;
                        continue;
                    }
                    this.rawIndices[n3++] = i + 1;
                    this.rawIndices[n3++] = i - 1;
                }
                this.splitRawIndices(bl);
            }
            this.endTex();
            this.tessellateEdges();
        }

        boolean clampTriangleStrip() {
            boolean bl = this.clamp2D();
            if (bl) {
                for (int i = 1; i < this.in.vertexCount - 1; ++i) {
                    int n;
                    int n2;
                    int n3 = i;
                    if (i % 2 == 0) {
                        n2 = i - 1;
                        n = i + 1;
                    } else {
                        n2 = i + 1;
                        n = i - 1;
                    }
                    int n4 = 0;
                    if (this.segmentIsAxisAligned(n3, n2)) {
                        ++n4;
                    }
                    if (this.segmentIsAxisAligned(n3, n)) {
                        ++n4;
                    }
                    if (this.segmentIsAxisAligned(n2, n)) {
                        ++n4;
                    }
                    boolean bl2 = bl = 1 < n4;
                    if (!bl) break;
                }
            }
            return bl;
        }

        void tessellateQuads() {
            this.beginTex();
            int n = this.in.vertexCount / 4;
            if (this.fill && 1 <= n) {
                int n2 = 6 * n;
                this.setRawSize(n2);
                int n3 = 0;
                boolean bl = this.clampQuads(n);
                for (int i = 0; i < n; ++i) {
                    int n4 = 4 * i + 0;
                    int n5 = 4 * i + 1;
                    int n6 = 4 * i + 2;
                    int n7 = 4 * i + 3;
                    this.rawIndices[n3++] = n4;
                    this.rawIndices[n3++] = n5;
                    this.rawIndices[n3++] = n6;
                    this.rawIndices[n3++] = n6;
                    this.rawIndices[n3++] = n7;
                    this.rawIndices[n3++] = n4;
                }
                this.splitRawIndices(bl);
            }
            this.endTex();
            this.tessellateEdges();
        }

        boolean clampQuads(int n) {
            boolean bl = this.clamp2D();
            if (bl) {
                for (int i = 0; i < n; ++i) {
                    int n2 = 4 * i + 0;
                    int n3 = 4 * i + 1;
                    int n4 = 4 * i + 2;
                    int n5 = 4 * i + 3;
                    boolean bl2 = bl = this.segmentIsAxisAligned(n2, n3) && this.segmentIsAxisAligned(n3, n4) && this.segmentIsAxisAligned(n4, n5);
                    if (!bl) break;
                }
            }
            return bl;
        }

        void tessellateQuadStrip() {
            this.beginTex();
            int n = this.in.vertexCount / 2 - 1;
            if (this.fill && 1 <= n) {
                int n2 = 6 * n;
                this.setRawSize(n2);
                int n3 = 0;
                boolean bl = this.clampQuadStrip(n);
                for (int i = 1; i < n + 1; ++i) {
                    int n4 = 2 * (i - 1);
                    int n5 = 2 * (i - 1) + 1;
                    int n6 = 2 * i + 1;
                    int n7 = 2 * i;
                    this.rawIndices[n3++] = n4;
                    this.rawIndices[n3++] = n5;
                    this.rawIndices[n3++] = n7;
                    this.rawIndices[n3++] = n5;
                    this.rawIndices[n3++] = n6;
                    this.rawIndices[n3++] = n7;
                }
                this.splitRawIndices(bl);
            }
            this.endTex();
            this.tessellateEdges();
        }

        boolean clampQuadStrip(int n) {
            boolean bl = this.clamp2D();
            if (bl) {
                for (int i = 1; i < n + 1; ++i) {
                    int n2 = 2 * (i - 1);
                    int n3 = 2 * (i - 1) + 1;
                    int n4 = 2 * i + 1;
                    int n5 = 2 * i;
                    boolean bl2 = bl = this.segmentIsAxisAligned(n2, n3) && this.segmentIsAxisAligned(n3, n4) && this.segmentIsAxisAligned(n4, n5);
                    if (!bl) break;
                }
            }
            return bl;
        }

        void splitRawIndices(boolean bl) {
            int n;
            this.tess.polyIndexCheck(this.rawSize);
            int n2 = this.tess.firstPolyIndex;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = n5;
            int n8 = -1;
            this.dupCount = 0;
            IndexCache indexCache = this.tess.polyIndexCache;
            this.firstPolyIndexCache = n = this.in.renderMode == 1 ? indexCache.addNew() : indexCache.getLast();
            int n9 = this.rawSize / 3;
            for (int i = 0; i < n9; ++i) {
                int n10;
                int n11;
                int n12;
                if (n == -1) {
                    n = indexCache.addNew();
                }
                int n13 = this.rawIndices[3 * i + 0];
                int n14 = this.rawIndices[3 * i + 1];
                int n15 = this.rawIndices[3 * i + 2];
                int n16 = n13 - n7;
                int n17 = n14 - n7;
                int n18 = n15 - n7;
                int n19 = indexCache.vertexCount[n];
                if (n16 < 0) {
                    this.addDupIndex(n16);
                    n12 = n16;
                } else {
                    n12 = n19 + n16;
                }
                if (n17 < 0) {
                    this.addDupIndex(n17);
                    n11 = n17;
                } else {
                    n11 = n19 + n17;
                }
                if (n18 < 0) {
                    this.addDupIndex(n18);
                    n10 = n18;
                } else {
                    n10 = n19 + n18;
                }
                this.tess.polyIndices[n2 + 3 * i + 0] = (short)n12;
                this.tess.polyIndices[n2 + 3 * i + 1] = (short)n11;
                this.tess.polyIndices[n2 + 3 * i + 2] = (short)n10;
                n4 = 3 * i + 2;
                n6 = PApplet.max(n6, PApplet.max(n13, n14, n15));
                n5 = PApplet.min(n5, PApplet.min(n13, n14, n15));
                n8 = PApplet.max(n8, PApplet.max(n12, n11, n10));
                if ((PGL.MAX_VERTEX_INDEX1 - 3 > n8 + this.dupCount || n8 + this.dupCount >= PGL.MAX_VERTEX_INDEX1) && i != n9 - 1) continue;
                int n20 = 0;
                if (0 < this.dupCount) {
                    int n21;
                    for (n21 = n3; n21 <= n4; ++n21) {
                        short s = this.tess.polyIndices[n2 + n21];
                        if (s >= 0) continue;
                        this.tess.polyIndices[n2 + n21] = (short)(n8 + 1 + this.dupIndexPos(s));
                    }
                    if (n7 <= n6) {
                        this.tess.addPolyVertices(this.in, n7, n6, bl);
                        n20 = n6 - n7 + 1;
                    }
                    for (n21 = 0; n21 < this.dupCount; ++n21) {
                        this.tess.addPolyVertex(this.in, this.dupIndices[n21] + n7, bl);
                    }
                } else {
                    this.tess.addPolyVertices(this.in, n5, n6, bl);
                    n20 = n6 - n5 + 1;
                }
                indexCache.incCounts(n, n4 - n3 + 1, n20 + this.dupCount);
                this.lastPolyIndexCache = n;
                n = -1;
                n8 = -1;
                n5 = n7 = n6 + 1;
                n3 = n4 + 1;
                if (this.dupIndices != null) {
                    Arrays.fill(this.dupIndices, 0, this.dupCount, 0);
                }
                this.dupCount = 0;
            }
        }

        void addDupIndex(int n) {
            int n2;
            if (this.dupIndices == null) {
                this.dupIndices = new int[16];
            }
            if (this.dupIndices.length == this.dupCount) {
                n2 = this.dupCount << 1;
                int[] nArray = new int[n2];
                PApplet.arrayCopy(this.dupIndices, 0, nArray, 0, this.dupCount);
                this.dupIndices = nArray;
            }
            if (n < this.dupIndices[0]) {
                for (n2 = this.dupCount; n2 > 0; --n2) {
                    this.dupIndices[n2] = this.dupIndices[n2 - 1];
                }
                this.dupIndices[0] = n;
                ++this.dupCount;
            } else if (this.dupIndices[this.dupCount - 1] < n) {
                this.dupIndices[this.dupCount] = n;
                ++this.dupCount;
            } else {
                for (n2 = 0; n2 < this.dupCount - 1 && this.dupIndices[n2] != n; ++n2) {
                    if (this.dupIndices[n2] >= n || n >= this.dupIndices[n2 + 1]) continue;
                    for (int i = this.dupCount; i > n2 + 1; --i) {
                        this.dupIndices[i] = this.dupIndices[i - 1];
                    }
                    this.dupIndices[n2 + 1] = n;
                    ++this.dupCount;
                    break;
                }
            }
        }

        int dupIndexPos(int n) {
            for (int i = 0; i < this.dupCount; ++i) {
                if (this.dupIndices[i] != n) continue;
                return i;
            }
            return 0;
        }

        void setRawSize(int n) {
            int n2 = this.rawIndices.length;
            if (n2 < n) {
                int n3 = PGraphicsOpenGL.expandArraySize(n2, n);
                this.expandRawIndices(n3);
            }
            this.rawSize = n;
        }

        void expandRawIndices(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.rawIndices, 0, nArray, 0, this.rawSize);
            this.rawIndices = nArray;
        }

        void beginTex() {
            this.setFirstTexIndex(this.tess.polyIndexCount, this.tess.polyIndexCache.size - 1);
        }

        void endTex() {
            this.setLastTexIndex(this.tess.lastPolyIndex, this.tess.polyIndexCache.size - 1);
        }

        void beginNoTex() {
            this.newTexImage = null;
            this.setFirstTexIndex(this.tess.polyIndexCount, this.tess.polyIndexCache.size - 1);
        }

        void endNoTex() {
            this.setLastTexIndex(this.tess.lastPolyIndex, this.tess.polyIndexCache.size - 1);
        }

        void updateTex() {
            this.beginTex();
            this.endTex();
        }

        void setFirstTexIndex(int n, int n2) {
            if (this.texCache != null) {
                this.firstTexIndex = n;
                this.firstTexCache = PApplet.max(0, n2);
            }
        }

        void setLastTexIndex(int n, int n2) {
            if (this.texCache != null) {
                if (this.prevTexImage != this.newTexImage || this.texCache.size == 0) {
                    this.texCache.addTexture(this.newTexImage, this.firstTexIndex, this.firstTexCache, n, n2);
                } else {
                    this.texCache.setLastIndex(n, n2);
                }
                this.prevTexImage = this.newTexImage;
            }
        }

        void tessellatePolygon(boolean bl, boolean bl2, boolean bl3) {
            this.beginTex();
            int n = this.in.vertexCount;
            if (3 <= n) {
                this.firstPolyIndexCache = -1;
                this.initGluTess();
                boolean bl4 = this.clampPolygon();
                this.callback.init(this.in.renderMode == 1, false, bl3, bl4);
                if (this.fill) {
                    this.gluTess.beginPolygon();
                    if (bl) {
                        this.gluTess.setWindingRule(PGL.TESS_WINDING_NONZERO);
                    } else {
                        this.gluTess.setWindingRule(PGL.TESS_WINDING_ODD);
                    }
                    this.gluTess.beginContour();
                }
                if (this.stroke) {
                    this.beginPolygonStroke();
                    this.beginStrokePath();
                }
                int n2 = 0;
                int n3 = 0;
                while (n2 < this.in.vertexCount) {
                    int n4 = 0;
                    boolean bl5 = false;
                    if (this.in.codes != null && n3 < this.in.codeCount && (n4 = this.in.codes[n3++]) == 4 && n3 < this.in.codeCount) {
                        bl5 = true;
                        n4 = this.in.codes[n3++];
                    }
                    if (bl5) {
                        if (this.stroke) {
                            this.endStrokePath(bl2);
                            this.beginStrokePath();
                        }
                        if (this.fill) {
                            this.gluTess.endContour();
                            this.gluTess.beginContour();
                        }
                    }
                    if (n4 == 1) {
                        this.addBezierVertex(n2);
                        n2 += 3;
                        continue;
                    }
                    if (n4 == 2) {
                        this.addQuadraticVertex(n2);
                        n2 += 2;
                        continue;
                    }
                    if (n4 == 3) {
                        this.addCurveVertex(n2);
                        ++n2;
                        continue;
                    }
                    this.addVertex(n2);
                    ++n2;
                }
                if (this.stroke) {
                    this.endStrokePath(bl2);
                    this.endPolygonStroke();
                }
                if (this.fill) {
                    this.gluTess.endContour();
                    this.gluTess.endPolygon();
                }
            }
            this.endTex();
            if (this.stroke) {
                this.tessellateStrokePath();
            }
        }

        void addBezierVertex(int n) {
            this.pg.curveVertexCount = 0;
            this.pg.bezierInitCheck();
            this.pg.bezierVertexCheck(20, n);
            PMatrix3D pMatrix3D = this.pg.bezierDrawMatrix;
            int n2 = n - 1;
            float f = this.in.vertices[3 * n2 + 0];
            float f2 = this.in.vertices[3 * n2 + 1];
            float f3 = this.in.vertices[3 * n2 + 2];
            int n3 = 0;
            float f4 = 0.0f;
            if (this.stroke) {
                n3 = this.in.strokeColors[n];
                f4 = this.in.strokeWeights[n];
            }
            double[] dArray = this.fill ? this.collectVertexAttributes(n) : null;
            float f5 = this.in.vertices[3 * n + 0];
            float f6 = this.in.vertices[3 * n + 1];
            float f7 = this.in.vertices[3 * n + 2];
            float f8 = this.in.vertices[3 * (n + 1) + 0];
            float f9 = this.in.vertices[3 * (n + 1) + 1];
            float f10 = this.in.vertices[3 * (n + 1) + 2];
            float f11 = this.in.vertices[3 * (n + 2) + 0];
            float f12 = this.in.vertices[3 * (n + 2) + 1];
            float f13 = this.in.vertices[3 * (n + 2) + 2];
            float f14 = pMatrix3D.m10 * f + pMatrix3D.m11 * f5 + pMatrix3D.m12 * f8 + pMatrix3D.m13 * f11;
            float f15 = pMatrix3D.m20 * f + pMatrix3D.m21 * f5 + pMatrix3D.m22 * f8 + pMatrix3D.m23 * f11;
            float f16 = pMatrix3D.m30 * f + pMatrix3D.m31 * f5 + pMatrix3D.m32 * f8 + pMatrix3D.m33 * f11;
            float f17 = pMatrix3D.m10 * f2 + pMatrix3D.m11 * f6 + pMatrix3D.m12 * f9 + pMatrix3D.m13 * f12;
            float f18 = pMatrix3D.m20 * f2 + pMatrix3D.m21 * f6 + pMatrix3D.m22 * f9 + pMatrix3D.m23 * f12;
            float f19 = pMatrix3D.m30 * f2 + pMatrix3D.m31 * f6 + pMatrix3D.m32 * f9 + pMatrix3D.m33 * f12;
            float f20 = pMatrix3D.m10 * f3 + pMatrix3D.m11 * f7 + pMatrix3D.m12 * f10 + pMatrix3D.m13 * f13;
            float f21 = pMatrix3D.m20 * f3 + pMatrix3D.m21 * f7 + pMatrix3D.m22 * f10 + pMatrix3D.m23 * f13;
            float f22 = pMatrix3D.m30 * f3 + pMatrix3D.m31 * f7 + pMatrix3D.m32 * f10 + pMatrix3D.m33 * f13;
            for (int i = 0; i < this.pg.bezierDetail; ++i) {
                f += f14;
                f14 += f15;
                f15 += f16;
                f2 += f17;
                f17 += f18;
                f18 += f19;
                f3 += f20;
                f20 += f21;
                f21 += f22;
                if (this.fill) {
                    double[] dArray2 = Arrays.copyOf(dArray, dArray.length);
                    dArray2[0] = f;
                    dArray2[1] = f2;
                    dArray2[2] = f3;
                    this.gluTess.addVertex(dArray2);
                }
                if (!this.stroke) continue;
                this.addStrokeVertex(f, f2, f3, n3, f4);
            }
        }

        void addQuadraticVertex(int n) {
            this.pg.curveVertexCount = 0;
            this.pg.bezierInitCheck();
            this.pg.bezierVertexCheck(20, n);
            PMatrix3D pMatrix3D = this.pg.bezierDrawMatrix;
            int n2 = n - 1;
            float f = this.in.vertices[3 * n2 + 0];
            float f2 = this.in.vertices[3 * n2 + 1];
            float f3 = this.in.vertices[3 * n2 + 2];
            int n3 = 0;
            float f4 = 0.0f;
            if (this.stroke) {
                n3 = this.in.strokeColors[n];
                f4 = this.in.strokeWeights[n];
            }
            double[] dArray = this.fill ? this.collectVertexAttributes(n) : null;
            float f5 = this.in.vertices[3 * n + 0];
            float f6 = this.in.vertices[3 * n + 1];
            float f7 = this.in.vertices[3 * n + 2];
            float f8 = this.in.vertices[3 * (n + 1) + 0];
            float f9 = this.in.vertices[3 * (n + 1) + 1];
            float f10 = this.in.vertices[3 * (n + 1) + 2];
            float f11 = f + (f5 - f) * 2.0f / 3.0f;
            float f12 = f2 + (f6 - f2) * 2.0f / 3.0f;
            float f13 = f3 + (f7 - f3) * 2.0f / 3.0f;
            float f14 = f8 + (f5 - f8) * 2.0f / 3.0f;
            float f15 = f9 + (f6 - f9) * 2.0f / 3.0f;
            float f16 = f10 + (f7 - f10) * 2.0f / 3.0f;
            float f17 = f8;
            float f18 = f9;
            float f19 = f10;
            float f20 = pMatrix3D.m10 * f + pMatrix3D.m11 * f11 + pMatrix3D.m12 * f14 + pMatrix3D.m13 * f17;
            float f21 = pMatrix3D.m20 * f + pMatrix3D.m21 * f11 + pMatrix3D.m22 * f14 + pMatrix3D.m23 * f17;
            float f22 = pMatrix3D.m30 * f + pMatrix3D.m31 * f11 + pMatrix3D.m32 * f14 + pMatrix3D.m33 * f17;
            float f23 = pMatrix3D.m10 * f2 + pMatrix3D.m11 * f12 + pMatrix3D.m12 * f15 + pMatrix3D.m13 * f18;
            float f24 = pMatrix3D.m20 * f2 + pMatrix3D.m21 * f12 + pMatrix3D.m22 * f15 + pMatrix3D.m23 * f18;
            float f25 = pMatrix3D.m30 * f2 + pMatrix3D.m31 * f12 + pMatrix3D.m32 * f15 + pMatrix3D.m33 * f18;
            float f26 = pMatrix3D.m10 * f3 + pMatrix3D.m11 * f13 + pMatrix3D.m12 * f16 + pMatrix3D.m13 * f19;
            float f27 = pMatrix3D.m20 * f3 + pMatrix3D.m21 * f13 + pMatrix3D.m22 * f16 + pMatrix3D.m23 * f19;
            float f28 = pMatrix3D.m30 * f3 + pMatrix3D.m31 * f13 + pMatrix3D.m32 * f16 + pMatrix3D.m33 * f19;
            for (int i = 0; i < this.pg.bezierDetail; ++i) {
                f += f20;
                f20 += f21;
                f21 += f22;
                f2 += f23;
                f23 += f24;
                f24 += f25;
                f3 += f26;
                f26 += f27;
                f27 += f28;
                if (this.fill) {
                    double[] dArray2 = Arrays.copyOf(dArray, dArray.length);
                    dArray2[0] = f;
                    dArray2[1] = f2;
                    dArray2[2] = f3;
                    this.gluTess.addVertex(dArray2);
                }
                if (!this.stroke) continue;
                this.addStrokeVertex(f, f2, f3, n3, f4);
            }
        }

        void addCurveVertex(int n) {
            float[] fArray;
            this.pg.curveVertexCheck(20);
            float[] fArray2 = this.pg.curveVertices[this.pg.curveVertexCount];
            fArray2[0] = this.in.vertices[3 * n + 0];
            fArray2[1] = this.in.vertices[3 * n + 1];
            fArray2[2] = this.in.vertices[3 * n + 2];
            this.pg.curveVertexCount++;
            if (this.pg.curveVertexCount == 3) {
                fArray = this.pg.curveVertices[this.pg.curveVertexCount - 2];
                this.addCurveInitialVertex(n, fArray[0], fArray[1], fArray[2]);
            }
            if (this.pg.curveVertexCount > 3) {
                fArray = this.pg.curveVertices[this.pg.curveVertexCount - 4];
                float[] fArray3 = this.pg.curveVertices[this.pg.curveVertexCount - 3];
                float[] fArray4 = this.pg.curveVertices[this.pg.curveVertexCount - 2];
                float[] fArray5 = this.pg.curveVertices[this.pg.curveVertexCount - 1];
                this.addCurveVertexSegment(n, fArray[0], fArray[1], fArray[2], fArray3[0], fArray3[1], fArray3[2], fArray4[0], fArray4[1], fArray4[2], fArray5[0], fArray5[1], fArray5[2]);
            }
        }

        void addCurveInitialVertex(int n, float f, float f2, float f3) {
            if (this.fill) {
                double[] dArray = this.collectVertexAttributes(n);
                dArray[0] = f;
                dArray[1] = f2;
                dArray[2] = f3;
                this.gluTess.addVertex(dArray);
            }
            if (this.stroke) {
                this.addStrokeVertex(f, f2, f3, this.in.strokeColors[n], this.strokeWeight);
            }
        }

        void addCurveVertexSegment(int n, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
            int n2 = 0;
            float f13 = 0.0f;
            if (this.stroke) {
                n2 = this.in.strokeColors[n];
                f13 = this.in.strokeWeights[n];
            }
            double[] dArray = this.fill ? this.collectVertexAttributes(n) : null;
            float f14 = f4;
            float f15 = f5;
            float f16 = f6;
            PMatrix3D pMatrix3D = this.pg.curveDrawMatrix;
            float f17 = pMatrix3D.m10 * f + pMatrix3D.m11 * f4 + pMatrix3D.m12 * f7 + pMatrix3D.m13 * f10;
            float f18 = pMatrix3D.m20 * f + pMatrix3D.m21 * f4 + pMatrix3D.m22 * f7 + pMatrix3D.m23 * f10;
            float f19 = pMatrix3D.m30 * f + pMatrix3D.m31 * f4 + pMatrix3D.m32 * f7 + pMatrix3D.m33 * f10;
            float f20 = pMatrix3D.m10 * f2 + pMatrix3D.m11 * f5 + pMatrix3D.m12 * f8 + pMatrix3D.m13 * f11;
            float f21 = pMatrix3D.m20 * f2 + pMatrix3D.m21 * f5 + pMatrix3D.m22 * f8 + pMatrix3D.m23 * f11;
            float f22 = pMatrix3D.m30 * f2 + pMatrix3D.m31 * f5 + pMatrix3D.m32 * f8 + pMatrix3D.m33 * f11;
            float f23 = pMatrix3D.m10 * f3 + pMatrix3D.m11 * f6 + pMatrix3D.m12 * f9 + pMatrix3D.m13 * f12;
            float f24 = pMatrix3D.m20 * f3 + pMatrix3D.m21 * f6 + pMatrix3D.m22 * f9 + pMatrix3D.m23 * f12;
            float f25 = pMatrix3D.m30 * f3 + pMatrix3D.m31 * f6 + pMatrix3D.m32 * f9 + pMatrix3D.m33 * f12;
            for (int i = 0; i < this.pg.curveDetail; ++i) {
                f14 += f17;
                f17 += f18;
                f18 += f19;
                f15 += f20;
                f20 += f21;
                f21 += f22;
                f16 += f23;
                f23 += f24;
                f24 += f25;
                if (this.fill) {
                    double[] dArray2 = Arrays.copyOf(dArray, dArray.length);
                    dArray2[0] = f14;
                    dArray2[1] = f15;
                    dArray2[2] = f16;
                    this.gluTess.addVertex(dArray2);
                }
                if (!this.stroke) continue;
                this.addStrokeVertex(f14, f15, f16, n2, f13);
            }
        }

        void addVertex(int n) {
            this.pg.curveVertexCount = 0;
            float f = this.in.vertices[3 * n + 0];
            float f2 = this.in.vertices[3 * n + 1];
            float f3 = this.in.vertices[3 * n + 2];
            if (this.fill) {
                double[] dArray = this.collectVertexAttributes(n);
                dArray[0] = f;
                dArray[1] = f2;
                dArray[2] = f3;
                this.gluTess.addVertex(dArray);
            }
            if (this.stroke) {
                this.addStrokeVertex(f, f2, f3, this.in.strokeColors[n], this.in.strokeWeights[n]);
            }
        }

        double[] collectVertexAttributes(int n) {
            double[] dArray = this.in.getAttribVector(n);
            double[] dArray2 = new double[25 + dArray.length];
            int n2 = 3;
            int n3 = this.in.colors[n];
            dArray2[n2++] = n3 >> 24 & 0xFF;
            dArray2[n2++] = n3 >> 16 & 0xFF;
            dArray2[n2++] = n3 >> 8 & 0xFF;
            dArray2[n2++] = n3 >> 0 & 0xFF;
            dArray2[n2++] = this.in.normals[3 * n + 0];
            dArray2[n2++] = this.in.normals[3 * n + 1];
            dArray2[n2++] = this.in.normals[3 * n + 2];
            dArray2[n2++] = this.in.texcoords[2 * n + 0];
            dArray2[n2++] = this.in.texcoords[2 * n + 1];
            int n4 = this.in.ambient[n];
            dArray2[n2++] = n4 >> 24 & 0xFF;
            dArray2[n2++] = n4 >> 16 & 0xFF;
            dArray2[n2++] = n4 >> 8 & 0xFF;
            dArray2[n2++] = n4 >> 0 & 0xFF;
            int n5 = this.in.specular[n];
            dArray2[n2++] = n5 >> 24 & 0xFF;
            dArray2[n2++] = n5 >> 16 & 0xFF;
            dArray2[n2++] = n5 >> 8 & 0xFF;
            dArray2[n2++] = n5 >> 0 & 0xFF;
            int n6 = this.in.emissive[n];
            dArray2[n2++] = n6 >> 24 & 0xFF;
            dArray2[n2++] = n6 >> 16 & 0xFF;
            dArray2[n2++] = n6 >> 8 & 0xFF;
            dArray2[n2++] = n6 >> 0 & 0xFF;
            dArray2[n2++] = this.in.shininess[n];
            System.arraycopy(dArray, 0, dArray2, n2, dArray.length);
            return dArray2;
        }

        void beginPolygonStroke() {
            this.pathVertexCount = 0;
            if (this.pathVertices == null) {
                this.pathVertices = new float[3 * PGL.DEFAULT_IN_VERTICES];
                this.pathColors = new int[PGL.DEFAULT_IN_VERTICES];
                this.pathWeights = new float[PGL.DEFAULT_IN_VERTICES];
            }
        }

        void endPolygonStroke() {
        }

        void beginStrokePath() {
            this.beginPath = this.pathVertexCount;
        }

        void endStrokePath(boolean bl) {
            int n = this.pathVertexCount;
            if (this.beginPath + 1 < n) {
                boolean bl2 = this.beginPath == n - 2;
                boolean bl3 = bl2 || !bl;
                this.in.addEdge(n - 2, n - 1, bl2, bl3);
                if (!bl3) {
                    this.in.addEdge(n - 1, this.beginPath, false, false);
                    this.in.closeEdge(n - 1, this.beginPath);
                }
            }
        }

        void addStrokeVertex(float f, float f2, float f3, int n, float f4) {
            int n2 = this.pathVertexCount;
            if (this.beginPath + 1 < n2) {
                this.in.addEdge(n2 - 2, n2 - 1, this.beginPath == n2 - 2, false);
            }
            if (this.pathVertexCount == this.pathVertices.length / 3) {
                int n3 = this.pathVertexCount << 1;
                float[] fArray = new float[3 * n3];
                PApplet.arrayCopy(this.pathVertices, 0, fArray, 0, 3 * this.pathVertexCount);
                this.pathVertices = fArray;
                int[] nArray = new int[n3];
                PApplet.arrayCopy(this.pathColors, 0, nArray, 0, this.pathVertexCount);
                this.pathColors = nArray;
                float[] fArray2 = new float[n3];
                PApplet.arrayCopy(this.pathWeights, 0, fArray2, 0, this.pathVertexCount);
                this.pathWeights = fArray2;
            }
            this.pathVertices[3 * n2 + 0] = f;
            this.pathVertices[3 * n2 + 1] = f2;
            this.pathVertices[3 * n2 + 2] = f3;
            this.pathColors[n2] = n;
            this.pathWeights[n2] = f4;
            ++this.pathVertexCount;
        }

        void tessellateStrokePath() {
            if (this.in.edgeCount == 0) {
                return;
            }
            this.strokeVertices = this.pathVertices;
            this.strokeColors = this.pathColors;
            this.strokeWeights = this.pathWeights;
            if (this.is3D) {
                this.tessellateEdges3D();
            } else if (this.is2D) {
                this.beginNoTex();
                this.tessellateEdges2D();
                this.endNoTex();
            }
        }

        boolean clampPolygon() {
            return false;
        }

        public void tessellateLinePath(LinePath linePath) {
            int n;
            this.initGluTess();
            boolean bl = this.clampLinePath();
            this.callback.init(this.in.renderMode == 1, true, false, bl);
            int n2 = this.strokeCap == 2 ? 1 : (n = this.strokeCap == 4 ? 2 : 0);
            int n3 = this.strokeJoin == 2 ? 1 : (this.strokeJoin == 32 ? 2 : 0);
            LinePath linePath2 = LinePath.createStrokedPath(linePath, this.strokeWeight, n, n3);
            this.gluTess.beginPolygon();
            float[] fArray = new float[6];
            LinePath.PathIterator pathIterator = linePath2.getPathIterator();
            int n4 = pathIterator.getWindingRule();
            switch (n4) {
                case 0: {
                    this.gluTess.setWindingRule(PGL.TESS_WINDING_ODD);
                    break;
                }
                case 1: {
                    this.gluTess.setWindingRule(PGL.TESS_WINDING_NONZERO);
                }
            }
            while (!pathIterator.isDone()) {
                switch (pathIterator.currentSegment(fArray)) {
                    case 0: {
                        this.gluTess.beginContour();
                    }
                    case 1: {
                        double[] dArray = new double[]{fArray[0], fArray[1], 0.0, fArray[2], fArray[3], fArray[4], fArray[5], 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
                        this.gluTess.addVertex(dArray);
                        break;
                    }
                    case 2: {
                        this.gluTess.endContour();
                    }
                }
                pathIterator.next();
            }
            this.gluTess.endPolygon();
        }

        boolean clampLinePath() {
            return this.clamp2D() && this.strokeCap == 4 && this.strokeJoin == 32 && !this.subPixelStroke(this.strokeWeight);
        }

        protected class TessellatorCallback
        implements PGL.TessellatorCallback {
            AttributeMap attribs;
            boolean calcNormals;
            boolean strokeTess;
            boolean clampXY;
            IndexCache cache;
            int cacheIndex;
            int vertFirst;
            int vertCount;
            int vertOffset;
            int primitive;

            public TessellatorCallback(AttributeMap attributeMap) {
                this.attribs = attributeMap;
            }

            public void init(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
                this.strokeTess = bl2;
                this.calcNormals = bl3;
                this.clampXY = bl4;
                this.cache = Tessellator.this.tess.polyIndexCache;
                if (bl) {
                    this.cache.addNew();
                }
            }

            @Override
            public void begin(int n) {
                this.cacheIndex = this.cache.getLast();
                if (Tessellator.this.firstPolyIndexCache == -1) {
                    Tessellator.this.firstPolyIndexCache = this.cacheIndex;
                }
                if (this.strokeTess && Tessellator.this.firstLineIndexCache == -1) {
                    Tessellator.this.firstLineIndexCache = this.cacheIndex;
                }
                this.vertFirst = this.cache.vertexCount[this.cacheIndex];
                this.vertOffset = this.cache.vertexOffset[this.cacheIndex];
                this.vertCount = 0;
                if (n == PGL.TRIANGLE_FAN) {
                    this.primitive = 11;
                } else if (n == PGL.TRIANGLE_STRIP) {
                    this.primitive = 10;
                } else if (n == PGL.TRIANGLES) {
                    this.primitive = 9;
                }
            }

            @Override
            public void end() {
                if (PGL.MAX_VERTEX_INDEX1 <= this.vertFirst + this.vertCount) {
                    this.cacheIndex = this.cache.addNew();
                    this.vertFirst = this.cache.vertexCount[this.cacheIndex];
                    this.vertOffset = this.cache.vertexOffset[this.cacheIndex];
                }
                int n = 0;
                switch (this.primitive) {
                    case 11: {
                        n = 3 * (this.vertCount - 2);
                        for (int i = 1; i < this.vertCount - 1; ++i) {
                            this.addIndex(0);
                            this.addIndex(i);
                            this.addIndex(i + 1);
                            if (!this.calcNormals) continue;
                            this.calcTriNormal(0, i, i + 1);
                        }
                        break;
                    }
                    case 10: {
                        n = 3 * (this.vertCount - 2);
                        for (int i = 1; i < this.vertCount - 1; ++i) {
                            if (i % 2 == 0) {
                                this.addIndex(i + 1);
                                this.addIndex(i);
                                this.addIndex(i - 1);
                                if (!this.calcNormals) continue;
                                this.calcTriNormal(i + 1, i, i - 1);
                                continue;
                            }
                            this.addIndex(i - 1);
                            this.addIndex(i);
                            this.addIndex(i + 1);
                            if (!this.calcNormals) continue;
                            this.calcTriNormal(i - 1, i, i + 1);
                        }
                        break;
                    }
                    case 9: {
                        int n2;
                        n = this.vertCount;
                        for (n2 = 0; n2 < this.vertCount; ++n2) {
                            this.addIndex(n2);
                        }
                        if (!this.calcNormals) break;
                        for (n2 = 0; n2 < this.vertCount / 3; ++n2) {
                            int n3 = 3 * n2 + 0;
                            int n4 = 3 * n2 + 1;
                            int n5 = 3 * n2 + 2;
                            this.calcTriNormal(n3, n4, n5);
                        }
                        break;
                    }
                }
                this.cache.incCounts(this.cacheIndex, n, this.vertCount);
                Tessellator.this.lastPolyIndexCache = this.cacheIndex;
                if (this.strokeTess) {
                    Tessellator.this.lastLineIndexCache = this.cacheIndex;
                }
            }

            protected void addIndex(int n) {
                Tessellator.this.tess.polyIndexCheck();
                Tessellator.this.tess.polyIndices[Tessellator.this.tess.polyIndexCount - 1] = (short)(this.vertFirst + n);
            }

            protected void calcTriNormal(int n, int n2, int n3) {
                Tessellator.this.tess.calcPolyNormal(this.vertFirst + this.vertOffset + n, this.vertFirst + this.vertOffset + n2, this.vertFirst + this.vertOffset + n3);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void vertex(Object object) {
                if (!(object instanceof double[])) throw new RuntimeException("TessCallback vertex() data not understood");
                double[] dArray = (double[])object;
                int n = dArray.length;
                if (n < 25) {
                    throw new RuntimeException("TessCallback vertex() data is too small");
                }
                if (this.vertCount >= PGL.MAX_VERTEX_INDEX1) throw new RuntimeException("The tessellator is generating too many vertices, reduce complexity of shape.");
                Tessellator.this.tess.addPolyVertex(dArray, this.clampXY);
                ++this.vertCount;
            }

            @Override
            public void error(int n) {
                String string = Tessellator.this.pg.pgl.tessError(n);
                PGraphics.showWarning(PGraphicsOpenGL.TESSELLATION_ERROR, string);
            }

            @Override
            public void combine(double[] dArray, Object[] objectArray, float[] fArray, Object[] objectArray2) {
                Object object;
                int n;
                int n2;
                int n3 = ((double[])objectArray[0]).length;
                double[] dArray2 = new double[n3];
                dArray2[0] = dArray[0];
                dArray2[1] = dArray[1];
                dArray2[2] = dArray[2];
                for (n2 = 3; n2 < n3; ++n2) {
                    dArray2[n2] = 0.0;
                    for (n = 0; n < 4; ++n) {
                        object = (double[])objectArray[n];
                        if (object == null) continue;
                        int n4 = n2;
                        dArray2[n4] = dArray2[n4] + (double)fArray[n] * object[n2];
                    }
                }
                this.normalize(dArray2, 7);
                if (25 < n3) {
                    n2 = 25;
                    for (n = 0; n < this.attribs.size(); ++n) {
                        object = this.attribs.get(n);
                        if (object.isNormal()) {
                            this.normalize(dArray2, n2);
                            n2 += 3;
                            continue;
                        }
                        n2 += object.size;
                    }
                }
                objectArray2[0] = dArray2;
            }

            private void normalize(double[] dArray, int n) {
                double d = dArray[n] * dArray[n] + dArray[n + 1] * dArray[n + 1] + dArray[n + 2] * dArray[n + 2];
                double d2 = Math.sqrt(d);
                if (0.0 < d2) {
                    int n2 = n;
                    dArray[n2] = dArray[n2] / d2;
                    int n3 = n + 1;
                    dArray[n3] = dArray[n3] / d2;
                    int n4 = n + 2;
                    dArray[n4] = dArray[n4] / d2;
                }
            }
        }
    }

    protected static class TessGeometry {
        int renderMode;
        PGraphicsOpenGL pg;
        AttributeMap polyAttribs;
        int polyVertexCount;
        int firstPolyVertex;
        int lastPolyVertex;
        FloatBuffer polyVerticesBuffer;
        IntBuffer polyColorsBuffer;
        FloatBuffer polyNormalsBuffer;
        FloatBuffer polyTexCoordsBuffer;
        IntBuffer polyAmbientBuffer;
        IntBuffer polySpecularBuffer;
        IntBuffer polyEmissiveBuffer;
        FloatBuffer polyShininessBuffer;
        HashMap<String, Buffer> polyAttribBuffers = new HashMap();
        int polyIndexCount;
        int firstPolyIndex;
        int lastPolyIndex;
        ShortBuffer polyIndicesBuffer;
        IndexCache polyIndexCache = new IndexCache();
        int lineVertexCount;
        int firstLineVertex;
        int lastLineVertex;
        FloatBuffer lineVerticesBuffer;
        IntBuffer lineColorsBuffer;
        FloatBuffer lineDirectionsBuffer;
        int lineIndexCount;
        int firstLineIndex;
        int lastLineIndex;
        ShortBuffer lineIndicesBuffer;
        IndexCache lineIndexCache = new IndexCache();
        int pointVertexCount;
        int firstPointVertex;
        int lastPointVertex;
        FloatBuffer pointVerticesBuffer;
        IntBuffer pointColorsBuffer;
        FloatBuffer pointOffsetsBuffer;
        int pointIndexCount;
        int firstPointIndex;
        int lastPointIndex;
        ShortBuffer pointIndicesBuffer;
        IndexCache pointIndexCache = new IndexCache();
        float[] polyVertices;
        int[] polyColors;
        float[] polyNormals;
        float[] polyTexCoords;
        int[] polyAmbient;
        int[] polySpecular;
        int[] polyEmissive;
        float[] polyShininess;
        short[] polyIndices;
        float[] lineVertices;
        int[] lineColors;
        float[] lineDirections;
        short[] lineIndices;
        float[] pointVertices;
        int[] pointColors;
        float[] pointOffsets;
        short[] pointIndices;
        HashMap<String, float[]> fpolyAttribs = new HashMap();
        HashMap<String, int[]> ipolyAttribs = new HashMap();
        HashMap<String, byte[]> bpolyAttribs = new HashMap();

        TessGeometry(PGraphicsOpenGL pGraphicsOpenGL, AttributeMap attributeMap, int n) {
            this.pg = pGraphicsOpenGL;
            this.polyAttribs = attributeMap;
            this.renderMode = n;
            this.allocate();
        }

        void allocate() {
            this.polyVertices = new float[4 * PGL.DEFAULT_TESS_VERTICES];
            this.polyColors = new int[PGL.DEFAULT_TESS_VERTICES];
            this.polyNormals = new float[3 * PGL.DEFAULT_TESS_VERTICES];
            this.polyTexCoords = new float[2 * PGL.DEFAULT_TESS_VERTICES];
            this.polyAmbient = new int[PGL.DEFAULT_TESS_VERTICES];
            this.polySpecular = new int[PGL.DEFAULT_TESS_VERTICES];
            this.polyEmissive = new int[PGL.DEFAULT_TESS_VERTICES];
            this.polyShininess = new float[PGL.DEFAULT_TESS_VERTICES];
            this.polyIndices = new short[PGL.DEFAULT_TESS_VERTICES];
            this.lineVertices = new float[4 * PGL.DEFAULT_TESS_VERTICES];
            this.lineColors = new int[PGL.DEFAULT_TESS_VERTICES];
            this.lineDirections = new float[4 * PGL.DEFAULT_TESS_VERTICES];
            this.lineIndices = new short[PGL.DEFAULT_TESS_VERTICES];
            this.pointVertices = new float[4 * PGL.DEFAULT_TESS_VERTICES];
            this.pointColors = new int[PGL.DEFAULT_TESS_VERTICES];
            this.pointOffsets = new float[2 * PGL.DEFAULT_TESS_VERTICES];
            this.pointIndices = new short[PGL.DEFAULT_TESS_VERTICES];
            this.polyVerticesBuffer = PGL.allocateFloatBuffer(this.polyVertices);
            this.polyColorsBuffer = PGL.allocateIntBuffer(this.polyColors);
            this.polyNormalsBuffer = PGL.allocateFloatBuffer(this.polyNormals);
            this.polyTexCoordsBuffer = PGL.allocateFloatBuffer(this.polyTexCoords);
            this.polyAmbientBuffer = PGL.allocateIntBuffer(this.polyAmbient);
            this.polySpecularBuffer = PGL.allocateIntBuffer(this.polySpecular);
            this.polyEmissiveBuffer = PGL.allocateIntBuffer(this.polyEmissive);
            this.polyShininessBuffer = PGL.allocateFloatBuffer(this.polyShininess);
            this.polyIndicesBuffer = PGL.allocateShortBuffer(this.polyIndices);
            this.lineVerticesBuffer = PGL.allocateFloatBuffer(this.lineVertices);
            this.lineColorsBuffer = PGL.allocateIntBuffer(this.lineColors);
            this.lineDirectionsBuffer = PGL.allocateFloatBuffer(this.lineDirections);
            this.lineIndicesBuffer = PGL.allocateShortBuffer(this.lineIndices);
            this.pointVerticesBuffer = PGL.allocateFloatBuffer(this.pointVertices);
            this.pointColorsBuffer = PGL.allocateIntBuffer(this.pointColors);
            this.pointOffsetsBuffer = PGL.allocateFloatBuffer(this.pointOffsets);
            this.pointIndicesBuffer = PGL.allocateShortBuffer(this.pointIndices);
            this.clear();
        }

        void initAttrib(VertexAttribute vertexAttribute) {
            if (vertexAttribute.type == PGL.FLOAT && !this.fpolyAttribs.containsKey(vertexAttribute.name)) {
                float[] fArray = new float[vertexAttribute.tessSize * PGL.DEFAULT_TESS_VERTICES];
                this.fpolyAttribs.put(vertexAttribute.name, fArray);
                this.polyAttribBuffers.put(vertexAttribute.name, PGL.allocateFloatBuffer(fArray));
            } else if (vertexAttribute.type == PGL.INT && !this.ipolyAttribs.containsKey(vertexAttribute.name)) {
                int[] nArray = new int[vertexAttribute.tessSize * PGL.DEFAULT_TESS_VERTICES];
                this.ipolyAttribs.put(vertexAttribute.name, nArray);
                this.polyAttribBuffers.put(vertexAttribute.name, PGL.allocateIntBuffer(nArray));
            } else if (vertexAttribute.type == PGL.BOOL && !this.bpolyAttribs.containsKey(vertexAttribute.name)) {
                byte[] byArray = new byte[vertexAttribute.tessSize * PGL.DEFAULT_TESS_VERTICES];
                this.bpolyAttribs.put(vertexAttribute.name, byArray);
                this.polyAttribBuffers.put(vertexAttribute.name, PGL.allocateByteBuffer(byArray));
            }
        }

        void clear() {
            this.polyVertexCount = 0;
            this.lastPolyVertex = 0;
            this.firstPolyVertex = 0;
            this.polyIndexCount = 0;
            this.lastPolyIndex = 0;
            this.firstPolyIndex = 0;
            this.lineVertexCount = 0;
            this.lastLineVertex = 0;
            this.firstLineVertex = 0;
            this.lineIndexCount = 0;
            this.lastLineIndex = 0;
            this.firstLineIndex = 0;
            this.pointVertexCount = 0;
            this.lastPointVertex = 0;
            this.firstPointVertex = 0;
            this.pointIndexCount = 0;
            this.lastPointIndex = 0;
            this.firstPointIndex = 0;
            this.polyIndexCache.clear();
            this.lineIndexCache.clear();
            this.pointIndexCache.clear();
        }

        void polyVertexCheck() {
            if (this.polyVertexCount == this.polyVertices.length / 4) {
                int n = this.polyVertexCount << 1;
                this.expandPolyVertices(n);
                this.expandPolyColors(n);
                this.expandPolyNormals(n);
                this.expandPolyTexCoords(n);
                this.expandPolyAmbient(n);
                this.expandPolySpecular(n);
                this.expandPolyEmissive(n);
                this.expandPolyShininess(n);
                this.expandAttributes(n);
            }
            this.firstPolyVertex = this.polyVertexCount++;
            this.lastPolyVertex = this.polyVertexCount - 1;
        }

        void polyVertexCheck(int n) {
            int n2 = this.polyVertices.length / 4;
            if (this.polyVertexCount + n > n2) {
                int n3 = PGraphicsOpenGL.expandArraySize(n2, this.polyVertexCount + n);
                this.expandPolyVertices(n3);
                this.expandPolyColors(n3);
                this.expandPolyNormals(n3);
                this.expandPolyTexCoords(n3);
                this.expandPolyAmbient(n3);
                this.expandPolySpecular(n3);
                this.expandPolyEmissive(n3);
                this.expandPolyShininess(n3);
                this.expandAttributes(n3);
            }
            this.firstPolyVertex = this.polyVertexCount;
            this.polyVertexCount += n;
            this.lastPolyVertex = this.polyVertexCount - 1;
        }

        void polyIndexCheck(int n) {
            int n2 = this.polyIndices.length;
            if (this.polyIndexCount + n > n2) {
                int n3 = PGraphicsOpenGL.expandArraySize(n2, this.polyIndexCount + n);
                this.expandPolyIndices(n3);
            }
            this.firstPolyIndex = this.polyIndexCount;
            this.polyIndexCount += n;
            this.lastPolyIndex = this.polyIndexCount - 1;
        }

        void polyIndexCheck() {
            if (this.polyIndexCount == this.polyIndices.length) {
                int n = this.polyIndexCount << 1;
                this.expandPolyIndices(n);
            }
            this.firstPolyIndex = this.polyIndexCount++;
            this.lastPolyIndex = this.polyIndexCount - 1;
        }

        void lineVertexCheck(int n) {
            int n2 = this.lineVertices.length / 4;
            if (this.lineVertexCount + n > n2) {
                int n3 = PGraphicsOpenGL.expandArraySize(n2, this.lineVertexCount + n);
                this.expandLineVertices(n3);
                this.expandLineColors(n3);
                this.expandLineDirections(n3);
            }
            this.firstLineVertex = this.lineVertexCount;
            this.lineVertexCount += n;
            this.lastLineVertex = this.lineVertexCount - 1;
        }

        void lineIndexCheck(int n) {
            int n2 = this.lineIndices.length;
            if (this.lineIndexCount + n > n2) {
                int n3 = PGraphicsOpenGL.expandArraySize(n2, this.lineIndexCount + n);
                this.expandLineIndices(n3);
            }
            this.firstLineIndex = this.lineIndexCount;
            this.lineIndexCount += n;
            this.lastLineIndex = this.lineIndexCount - 1;
        }

        void pointVertexCheck(int n) {
            int n2 = this.pointVertices.length / 4;
            if (this.pointVertexCount + n > n2) {
                int n3 = PGraphicsOpenGL.expandArraySize(n2, this.pointVertexCount + n);
                this.expandPointVertices(n3);
                this.expandPointColors(n3);
                this.expandPointOffsets(n3);
            }
            this.firstPointVertex = this.pointVertexCount;
            this.pointVertexCount += n;
            this.lastPointVertex = this.pointVertexCount - 1;
        }

        void pointIndexCheck(int n) {
            int n2 = this.pointIndices.length;
            if (this.pointIndexCount + n > n2) {
                int n3 = PGraphicsOpenGL.expandArraySize(n2, this.pointIndexCount + n);
                this.expandPointIndices(n3);
            }
            this.firstPointIndex = this.pointIndexCount;
            this.pointIndexCount += n;
            this.lastPointIndex = this.pointIndexCount - 1;
        }

        boolean isFull() {
            return PGL.FLUSH_VERTEX_COUNT <= this.polyVertexCount || PGL.FLUSH_VERTEX_COUNT <= this.lineVertexCount || PGL.FLUSH_VERTEX_COUNT <= this.pointVertexCount;
        }

        void getPolyVertexMin(PVector pVector, int n, int n2) {
            for (int i = n; i <= n2; ++i) {
                int n3 = 4 * i;
                pVector.x = PApplet.min(pVector.x, this.polyVertices[n3++]);
                pVector.y = PApplet.min(pVector.y, this.polyVertices[n3++]);
                pVector.z = PApplet.min(pVector.z, this.polyVertices[n3]);
            }
        }

        void getLineVertexMin(PVector pVector, int n, int n2) {
            for (int i = n; i <= n2; ++i) {
                int n3 = 4 * i;
                pVector.x = PApplet.min(pVector.x, this.lineVertices[n3++]);
                pVector.y = PApplet.min(pVector.y, this.lineVertices[n3++]);
                pVector.z = PApplet.min(pVector.z, this.lineVertices[n3]);
            }
        }

        void getPointVertexMin(PVector pVector, int n, int n2) {
            for (int i = n; i <= n2; ++i) {
                int n3 = 4 * i;
                pVector.x = PApplet.min(pVector.x, this.pointVertices[n3++]);
                pVector.y = PApplet.min(pVector.y, this.pointVertices[n3++]);
                pVector.z = PApplet.min(pVector.z, this.pointVertices[n3]);
            }
        }

        void getPolyVertexMax(PVector pVector, int n, int n2) {
            for (int i = n; i <= n2; ++i) {
                int n3 = 4 * i;
                pVector.x = PApplet.max(pVector.x, this.polyVertices[n3++]);
                pVector.y = PApplet.max(pVector.y, this.polyVertices[n3++]);
                pVector.z = PApplet.max(pVector.z, this.polyVertices[n3]);
            }
        }

        void getLineVertexMax(PVector pVector, int n, int n2) {
            for (int i = n; i <= n2; ++i) {
                int n3 = 4 * i;
                pVector.x = PApplet.max(pVector.x, this.lineVertices[n3++]);
                pVector.y = PApplet.max(pVector.y, this.lineVertices[n3++]);
                pVector.z = PApplet.max(pVector.z, this.lineVertices[n3]);
            }
        }

        void getPointVertexMax(PVector pVector, int n, int n2) {
            for (int i = n; i <= n2; ++i) {
                int n3 = 4 * i;
                pVector.x = PApplet.max(pVector.x, this.pointVertices[n3++]);
                pVector.y = PApplet.max(pVector.y, this.pointVertices[n3++]);
                pVector.z = PApplet.max(pVector.z, this.pointVertices[n3]);
            }
        }

        int getPolyVertexSum(PVector pVector, int n, int n2) {
            for (int i = n; i <= n2; ++i) {
                int n3 = 4 * i;
                pVector.x += this.polyVertices[n3++];
                pVector.y += this.polyVertices[n3++];
                pVector.z += this.polyVertices[n3];
            }
            return n2 - n + 1;
        }

        int getLineVertexSum(PVector pVector, int n, int n2) {
            for (int i = n; i <= n2; ++i) {
                int n3 = 4 * i;
                pVector.x += this.lineVertices[n3++];
                pVector.y += this.lineVertices[n3++];
                pVector.z += this.lineVertices[n3];
            }
            return n2 - n + 1;
        }

        int getPointVertexSum(PVector pVector, int n, int n2) {
            for (int i = n; i <= n2; ++i) {
                int n3 = 4 * i;
                pVector.x += this.pointVertices[n3++];
                pVector.y += this.pointVertices[n3++];
                pVector.z += this.pointVertices[n3];
            }
            return n2 - n + 1;
        }

        protected void updatePolyVerticesBuffer() {
            this.updatePolyVerticesBuffer(0, this.polyVertexCount);
        }

        protected void updatePolyVerticesBuffer(int n, int n2) {
            PGL.updateFloatBuffer(this.polyVerticesBuffer, this.polyVertices, 4 * n, 4 * n2);
        }

        protected void updatePolyColorsBuffer() {
            this.updatePolyColorsBuffer(0, this.polyVertexCount);
        }

        protected void updatePolyColorsBuffer(int n, int n2) {
            PGL.updateIntBuffer(this.polyColorsBuffer, this.polyColors, n, n2);
        }

        protected void updatePolyNormalsBuffer() {
            this.updatePolyNormalsBuffer(0, this.polyVertexCount);
        }

        protected void updatePolyNormalsBuffer(int n, int n2) {
            PGL.updateFloatBuffer(this.polyNormalsBuffer, this.polyNormals, 3 * n, 3 * n2);
        }

        protected void updatePolyTexCoordsBuffer() {
            this.updatePolyTexCoordsBuffer(0, this.polyVertexCount);
        }

        protected void updatePolyTexCoordsBuffer(int n, int n2) {
            PGL.updateFloatBuffer(this.polyTexCoordsBuffer, this.polyTexCoords, 2 * n, 2 * n2);
        }

        protected void updatePolyAmbientBuffer() {
            this.updatePolyAmbientBuffer(0, this.polyVertexCount);
        }

        protected void updatePolyAmbientBuffer(int n, int n2) {
            PGL.updateIntBuffer(this.polyAmbientBuffer, this.polyAmbient, n, n2);
        }

        protected void updatePolySpecularBuffer() {
            this.updatePolySpecularBuffer(0, this.polyVertexCount);
        }

        protected void updatePolySpecularBuffer(int n, int n2) {
            PGL.updateIntBuffer(this.polySpecularBuffer, this.polySpecular, n, n2);
        }

        protected void updatePolyEmissiveBuffer() {
            this.updatePolyEmissiveBuffer(0, this.polyVertexCount);
        }

        protected void updatePolyEmissiveBuffer(int n, int n2) {
            PGL.updateIntBuffer(this.polyEmissiveBuffer, this.polyEmissive, n, n2);
        }

        protected void updatePolyShininessBuffer() {
            this.updatePolyShininessBuffer(0, this.polyVertexCount);
        }

        protected void updatePolyShininessBuffer(int n, int n2) {
            PGL.updateFloatBuffer(this.polyShininessBuffer, this.polyShininess, n, n2);
        }

        protected void updateAttribBuffer(String string) {
            this.updateAttribBuffer(string, 0, this.polyVertexCount);
        }

        protected void updateAttribBuffer(String string, int n, int n2) {
            VertexAttribute vertexAttribute = (VertexAttribute)this.polyAttribs.get(string);
            if (vertexAttribute.type == PGL.FLOAT) {
                FloatBuffer floatBuffer = (FloatBuffer)this.polyAttribBuffers.get(string);
                float[] fArray = this.fpolyAttribs.get(string);
                PGL.updateFloatBuffer(floatBuffer, fArray, vertexAttribute.tessSize * n, vertexAttribute.tessSize * n2);
            } else if (vertexAttribute.type == PGL.INT) {
                IntBuffer intBuffer = (IntBuffer)this.polyAttribBuffers.get(string);
                int[] nArray = this.ipolyAttribs.get(string);
                PGL.updateIntBuffer(intBuffer, nArray, vertexAttribute.tessSize * n, vertexAttribute.tessSize * n2);
            } else if (vertexAttribute.type == PGL.BOOL) {
                ByteBuffer byteBuffer = (ByteBuffer)this.polyAttribBuffers.get(string);
                byte[] byArray = this.bpolyAttribs.get(string);
                PGL.updateByteBuffer(byteBuffer, byArray, vertexAttribute.tessSize * n, vertexAttribute.tessSize * n2);
            }
        }

        protected void updatePolyIndicesBuffer() {
            this.updatePolyIndicesBuffer(0, this.polyIndexCount);
        }

        protected void updatePolyIndicesBuffer(int n, int n2) {
            PGL.updateShortBuffer(this.polyIndicesBuffer, this.polyIndices, n, n2);
        }

        protected void updateLineVerticesBuffer() {
            this.updateLineVerticesBuffer(0, this.lineVertexCount);
        }

        protected void updateLineVerticesBuffer(int n, int n2) {
            PGL.updateFloatBuffer(this.lineVerticesBuffer, this.lineVertices, 4 * n, 4 * n2);
        }

        protected void updateLineColorsBuffer() {
            this.updateLineColorsBuffer(0, this.lineVertexCount);
        }

        protected void updateLineColorsBuffer(int n, int n2) {
            PGL.updateIntBuffer(this.lineColorsBuffer, this.lineColors, n, n2);
        }

        protected void updateLineDirectionsBuffer() {
            this.updateLineDirectionsBuffer(0, this.lineVertexCount);
        }

        protected void updateLineDirectionsBuffer(int n, int n2) {
            PGL.updateFloatBuffer(this.lineDirectionsBuffer, this.lineDirections, 4 * n, 4 * n2);
        }

        protected void updateLineIndicesBuffer() {
            this.updateLineIndicesBuffer(0, this.lineIndexCount);
        }

        protected void updateLineIndicesBuffer(int n, int n2) {
            PGL.updateShortBuffer(this.lineIndicesBuffer, this.lineIndices, n, n2);
        }

        protected void updatePointVerticesBuffer() {
            this.updatePointVerticesBuffer(0, this.pointVertexCount);
        }

        protected void updatePointVerticesBuffer(int n, int n2) {
            PGL.updateFloatBuffer(this.pointVerticesBuffer, this.pointVertices, 4 * n, 4 * n2);
        }

        protected void updatePointColorsBuffer() {
            this.updatePointColorsBuffer(0, this.pointVertexCount);
        }

        protected void updatePointColorsBuffer(int n, int n2) {
            PGL.updateIntBuffer(this.pointColorsBuffer, this.pointColors, n, n2);
        }

        protected void updatePointOffsetsBuffer() {
            this.updatePointOffsetsBuffer(0, this.pointVertexCount);
        }

        protected void updatePointOffsetsBuffer(int n, int n2) {
            PGL.updateFloatBuffer(this.pointOffsetsBuffer, this.pointOffsets, 2 * n, 2 * n2);
        }

        protected void updatePointIndicesBuffer() {
            this.updatePointIndicesBuffer(0, this.pointIndexCount);
        }

        protected void updatePointIndicesBuffer(int n, int n2) {
            PGL.updateShortBuffer(this.pointIndicesBuffer, this.pointIndices, n, n2);
        }

        void expandPolyVertices(int n) {
            float[] fArray = new float[4 * n];
            PApplet.arrayCopy(this.polyVertices, 0, fArray, 0, 4 * this.polyVertexCount);
            this.polyVertices = fArray;
            this.polyVerticesBuffer = PGL.allocateFloatBuffer(this.polyVertices);
        }

        void expandPolyColors(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.polyColors, 0, nArray, 0, this.polyVertexCount);
            this.polyColors = nArray;
            this.polyColorsBuffer = PGL.allocateIntBuffer(this.polyColors);
        }

        void expandPolyNormals(int n) {
            float[] fArray = new float[3 * n];
            PApplet.arrayCopy(this.polyNormals, 0, fArray, 0, 3 * this.polyVertexCount);
            this.polyNormals = fArray;
            this.polyNormalsBuffer = PGL.allocateFloatBuffer(this.polyNormals);
        }

        void expandPolyTexCoords(int n) {
            float[] fArray = new float[2 * n];
            PApplet.arrayCopy(this.polyTexCoords, 0, fArray, 0, 2 * this.polyVertexCount);
            this.polyTexCoords = fArray;
            this.polyTexCoordsBuffer = PGL.allocateFloatBuffer(this.polyTexCoords);
        }

        void expandPolyAmbient(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.polyAmbient, 0, nArray, 0, this.polyVertexCount);
            this.polyAmbient = nArray;
            this.polyAmbientBuffer = PGL.allocateIntBuffer(this.polyAmbient);
        }

        void expandPolySpecular(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.polySpecular, 0, nArray, 0, this.polyVertexCount);
            this.polySpecular = nArray;
            this.polySpecularBuffer = PGL.allocateIntBuffer(this.polySpecular);
        }

        void expandPolyEmissive(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.polyEmissive, 0, nArray, 0, this.polyVertexCount);
            this.polyEmissive = nArray;
            this.polyEmissiveBuffer = PGL.allocateIntBuffer(this.polyEmissive);
        }

        void expandPolyShininess(int n) {
            float[] fArray = new float[n];
            PApplet.arrayCopy(this.polyShininess, 0, fArray, 0, this.polyVertexCount);
            this.polyShininess = fArray;
            this.polyShininessBuffer = PGL.allocateFloatBuffer(this.polyShininess);
        }

        void expandAttributes(int n) {
            for (String string : this.polyAttribs.keySet()) {
                VertexAttribute vertexAttribute = (VertexAttribute)this.polyAttribs.get(string);
                if (vertexAttribute.type == PGL.FLOAT) {
                    this.expandFloatAttribute(vertexAttribute, n);
                    continue;
                }
                if (vertexAttribute.type == PGL.INT) {
                    this.expandIntAttribute(vertexAttribute, n);
                    continue;
                }
                if (vertexAttribute.type != PGL.BOOL) continue;
                this.expandBoolAttribute(vertexAttribute, n);
            }
        }

        void expandFloatAttribute(VertexAttribute vertexAttribute, int n) {
            float[] fArray = this.fpolyAttribs.get(vertexAttribute.name);
            float[] fArray2 = new float[vertexAttribute.tessSize * n];
            PApplet.arrayCopy(fArray, 0, fArray2, 0, vertexAttribute.tessSize * this.polyVertexCount);
            this.fpolyAttribs.put(vertexAttribute.name, fArray2);
            this.polyAttribBuffers.put(vertexAttribute.name, PGL.allocateFloatBuffer(fArray2));
        }

        void expandIntAttribute(VertexAttribute vertexAttribute, int n) {
            int[] nArray = this.ipolyAttribs.get(vertexAttribute.name);
            int[] nArray2 = new int[vertexAttribute.tessSize * n];
            PApplet.arrayCopy(nArray, 0, nArray2, 0, vertexAttribute.tessSize * this.polyVertexCount);
            this.ipolyAttribs.put(vertexAttribute.name, nArray2);
            this.polyAttribBuffers.put(vertexAttribute.name, PGL.allocateIntBuffer(nArray2));
        }

        void expandBoolAttribute(VertexAttribute vertexAttribute, int n) {
            byte[] byArray = this.bpolyAttribs.get(vertexAttribute.name);
            byte[] byArray2 = new byte[vertexAttribute.tessSize * n];
            PApplet.arrayCopy(byArray, 0, byArray2, 0, vertexAttribute.tessSize * this.polyVertexCount);
            this.bpolyAttribs.put(vertexAttribute.name, byArray2);
            this.polyAttribBuffers.put(vertexAttribute.name, PGL.allocateByteBuffer(byArray2));
        }

        void expandPolyIndices(int n) {
            short[] sArray = new short[n];
            PApplet.arrayCopy(this.polyIndices, 0, sArray, 0, this.polyIndexCount);
            this.polyIndices = sArray;
            this.polyIndicesBuffer = PGL.allocateShortBuffer(this.polyIndices);
        }

        void expandLineVertices(int n) {
            float[] fArray = new float[4 * n];
            PApplet.arrayCopy(this.lineVertices, 0, fArray, 0, 4 * this.lineVertexCount);
            this.lineVertices = fArray;
            this.lineVerticesBuffer = PGL.allocateFloatBuffer(this.lineVertices);
        }

        void expandLineColors(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.lineColors, 0, nArray, 0, this.lineVertexCount);
            this.lineColors = nArray;
            this.lineColorsBuffer = PGL.allocateIntBuffer(this.lineColors);
        }

        void expandLineDirections(int n) {
            float[] fArray = new float[4 * n];
            PApplet.arrayCopy(this.lineDirections, 0, fArray, 0, 4 * this.lineVertexCount);
            this.lineDirections = fArray;
            this.lineDirectionsBuffer = PGL.allocateFloatBuffer(this.lineDirections);
        }

        void expandLineIndices(int n) {
            short[] sArray = new short[n];
            PApplet.arrayCopy(this.lineIndices, 0, sArray, 0, this.lineIndexCount);
            this.lineIndices = sArray;
            this.lineIndicesBuffer = PGL.allocateShortBuffer(this.lineIndices);
        }

        void expandPointVertices(int n) {
            float[] fArray = new float[4 * n];
            PApplet.arrayCopy(this.pointVertices, 0, fArray, 0, 4 * this.pointVertexCount);
            this.pointVertices = fArray;
            this.pointVerticesBuffer = PGL.allocateFloatBuffer(this.pointVertices);
        }

        void expandPointColors(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.pointColors, 0, nArray, 0, this.pointVertexCount);
            this.pointColors = nArray;
            this.pointColorsBuffer = PGL.allocateIntBuffer(this.pointColors);
        }

        void expandPointOffsets(int n) {
            float[] fArray = new float[2 * n];
            PApplet.arrayCopy(this.pointOffsets, 0, fArray, 0, 2 * this.pointVertexCount);
            this.pointOffsets = fArray;
            this.pointOffsetsBuffer = PGL.allocateFloatBuffer(this.pointOffsets);
        }

        void expandPointIndices(int n) {
            short[] sArray = new short[n];
            PApplet.arrayCopy(this.pointIndices, 0, sArray, 0, this.pointIndexCount);
            this.pointIndices = sArray;
            this.pointIndicesBuffer = PGL.allocateShortBuffer(this.pointIndices);
        }

        void trim() {
            if (0 < this.polyVertexCount && this.polyVertexCount < this.polyVertices.length / 4) {
                this.trimPolyVertices();
                this.trimPolyColors();
                this.trimPolyNormals();
                this.trimPolyTexCoords();
                this.trimPolyAmbient();
                this.trimPolySpecular();
                this.trimPolyEmissive();
                this.trimPolyShininess();
                this.trimPolyAttributes();
            }
            if (0 < this.polyIndexCount && this.polyIndexCount < this.polyIndices.length) {
                this.trimPolyIndices();
            }
            if (0 < this.lineVertexCount && this.lineVertexCount < this.lineVertices.length / 4) {
                this.trimLineVertices();
                this.trimLineColors();
                this.trimLineDirections();
            }
            if (0 < this.lineIndexCount && this.lineIndexCount < this.lineIndices.length) {
                this.trimLineIndices();
            }
            if (0 < this.pointVertexCount && this.pointVertexCount < this.pointVertices.length / 4) {
                this.trimPointVertices();
                this.trimPointColors();
                this.trimPointOffsets();
            }
            if (0 < this.pointIndexCount && this.pointIndexCount < this.pointIndices.length) {
                this.trimPointIndices();
            }
        }

        void trimPolyVertices() {
            float[] fArray = new float[4 * this.polyVertexCount];
            PApplet.arrayCopy(this.polyVertices, 0, fArray, 0, 4 * this.polyVertexCount);
            this.polyVertices = fArray;
            this.polyVerticesBuffer = PGL.allocateFloatBuffer(this.polyVertices);
        }

        void trimPolyColors() {
            int[] nArray = new int[this.polyVertexCount];
            PApplet.arrayCopy(this.polyColors, 0, nArray, 0, this.polyVertexCount);
            this.polyColors = nArray;
            this.polyColorsBuffer = PGL.allocateIntBuffer(this.polyColors);
        }

        void trimPolyNormals() {
            float[] fArray = new float[3 * this.polyVertexCount];
            PApplet.arrayCopy(this.polyNormals, 0, fArray, 0, 3 * this.polyVertexCount);
            this.polyNormals = fArray;
            this.polyNormalsBuffer = PGL.allocateFloatBuffer(this.polyNormals);
        }

        void trimPolyTexCoords() {
            float[] fArray = new float[2 * this.polyVertexCount];
            PApplet.arrayCopy(this.polyTexCoords, 0, fArray, 0, 2 * this.polyVertexCount);
            this.polyTexCoords = fArray;
            this.polyTexCoordsBuffer = PGL.allocateFloatBuffer(this.polyTexCoords);
        }

        void trimPolyAmbient() {
            int[] nArray = new int[this.polyVertexCount];
            PApplet.arrayCopy(this.polyAmbient, 0, nArray, 0, this.polyVertexCount);
            this.polyAmbient = nArray;
            this.polyAmbientBuffer = PGL.allocateIntBuffer(this.polyAmbient);
        }

        void trimPolySpecular() {
            int[] nArray = new int[this.polyVertexCount];
            PApplet.arrayCopy(this.polySpecular, 0, nArray, 0, this.polyVertexCount);
            this.polySpecular = nArray;
            this.polySpecularBuffer = PGL.allocateIntBuffer(this.polySpecular);
        }

        void trimPolyEmissive() {
            int[] nArray = new int[this.polyVertexCount];
            PApplet.arrayCopy(this.polyEmissive, 0, nArray, 0, this.polyVertexCount);
            this.polyEmissive = nArray;
            this.polyEmissiveBuffer = PGL.allocateIntBuffer(this.polyEmissive);
        }

        void trimPolyShininess() {
            float[] fArray = new float[this.polyVertexCount];
            PApplet.arrayCopy(this.polyShininess, 0, fArray, 0, this.polyVertexCount);
            this.polyShininess = fArray;
            this.polyShininessBuffer = PGL.allocateFloatBuffer(this.polyShininess);
        }

        void trimPolyAttributes() {
            for (String string : this.polyAttribs.keySet()) {
                VertexAttribute vertexAttribute = (VertexAttribute)this.polyAttribs.get(string);
                if (vertexAttribute.type == PGL.FLOAT) {
                    this.trimFloatAttribute(vertexAttribute);
                    continue;
                }
                if (vertexAttribute.type == PGL.INT) {
                    this.trimIntAttribute(vertexAttribute);
                    continue;
                }
                if (vertexAttribute.type != PGL.BOOL) continue;
                this.trimBoolAttribute(vertexAttribute);
            }
        }

        void trimFloatAttribute(VertexAttribute vertexAttribute) {
            float[] fArray = this.fpolyAttribs.get(vertexAttribute.name);
            float[] fArray2 = new float[vertexAttribute.tessSize * this.polyVertexCount];
            PApplet.arrayCopy(fArray, 0, fArray2, 0, vertexAttribute.tessSize * this.polyVertexCount);
            this.fpolyAttribs.put(vertexAttribute.name, fArray2);
            this.polyAttribBuffers.put(vertexAttribute.name, PGL.allocateFloatBuffer(fArray2));
        }

        void trimIntAttribute(VertexAttribute vertexAttribute) {
            int[] nArray = this.ipolyAttribs.get(vertexAttribute.name);
            int[] nArray2 = new int[vertexAttribute.tessSize * this.polyVertexCount];
            PApplet.arrayCopy(nArray, 0, nArray2, 0, vertexAttribute.tessSize * this.polyVertexCount);
            this.ipolyAttribs.put(vertexAttribute.name, nArray2);
            this.polyAttribBuffers.put(vertexAttribute.name, PGL.allocateIntBuffer(nArray2));
        }

        void trimBoolAttribute(VertexAttribute vertexAttribute) {
            byte[] byArray = this.bpolyAttribs.get(vertexAttribute.name);
            byte[] byArray2 = new byte[vertexAttribute.tessSize * this.polyVertexCount];
            PApplet.arrayCopy(byArray, 0, byArray2, 0, vertexAttribute.tessSize * this.polyVertexCount);
            this.bpolyAttribs.put(vertexAttribute.name, byArray2);
            this.polyAttribBuffers.put(vertexAttribute.name, PGL.allocateByteBuffer(byArray2));
        }

        void trimPolyIndices() {
            short[] sArray = new short[this.polyIndexCount];
            PApplet.arrayCopy(this.polyIndices, 0, sArray, 0, this.polyIndexCount);
            this.polyIndices = sArray;
            this.polyIndicesBuffer = PGL.allocateShortBuffer(this.polyIndices);
        }

        void trimLineVertices() {
            float[] fArray = new float[4 * this.lineVertexCount];
            PApplet.arrayCopy(this.lineVertices, 0, fArray, 0, 4 * this.lineVertexCount);
            this.lineVertices = fArray;
            this.lineVerticesBuffer = PGL.allocateFloatBuffer(this.lineVertices);
        }

        void trimLineColors() {
            int[] nArray = new int[this.lineVertexCount];
            PApplet.arrayCopy(this.lineColors, 0, nArray, 0, this.lineVertexCount);
            this.lineColors = nArray;
            this.lineColorsBuffer = PGL.allocateIntBuffer(this.lineColors);
        }

        void trimLineDirections() {
            float[] fArray = new float[4 * this.lineVertexCount];
            PApplet.arrayCopy(this.lineDirections, 0, fArray, 0, 4 * this.lineVertexCount);
            this.lineDirections = fArray;
            this.lineDirectionsBuffer = PGL.allocateFloatBuffer(this.lineDirections);
        }

        void trimLineIndices() {
            short[] sArray = new short[this.lineIndexCount];
            PApplet.arrayCopy(this.lineIndices, 0, sArray, 0, this.lineIndexCount);
            this.lineIndices = sArray;
            this.lineIndicesBuffer = PGL.allocateShortBuffer(this.lineIndices);
        }

        void trimPointVertices() {
            float[] fArray = new float[4 * this.pointVertexCount];
            PApplet.arrayCopy(this.pointVertices, 0, fArray, 0, 4 * this.pointVertexCount);
            this.pointVertices = fArray;
            this.pointVerticesBuffer = PGL.allocateFloatBuffer(this.pointVertices);
        }

        void trimPointColors() {
            int[] nArray = new int[this.pointVertexCount];
            PApplet.arrayCopy(this.pointColors, 0, nArray, 0, this.pointVertexCount);
            this.pointColors = nArray;
            this.pointColorsBuffer = PGL.allocateIntBuffer(this.pointColors);
        }

        void trimPointOffsets() {
            float[] fArray = new float[2 * this.pointVertexCount];
            PApplet.arrayCopy(this.pointOffsets, 0, fArray, 0, 2 * this.pointVertexCount);
            this.pointOffsets = fArray;
            this.pointOffsetsBuffer = PGL.allocateFloatBuffer(this.pointOffsets);
        }

        void trimPointIndices() {
            short[] sArray = new short[this.pointIndexCount];
            PApplet.arrayCopy(this.pointIndices, 0, sArray, 0, this.pointIndexCount);
            this.pointIndices = sArray;
            this.pointIndicesBuffer = PGL.allocateShortBuffer(this.pointIndices);
        }

        void incPolyIndices(int n, int n2, int n3) {
            int n4 = n;
            while (n4 <= n2) {
                int n5 = n4++;
                this.polyIndices[n5] = (short)(this.polyIndices[n5] + n3);
            }
        }

        void incLineIndices(int n, int n2, int n3) {
            int n4 = n;
            while (n4 <= n2) {
                int n5 = n4++;
                this.lineIndices[n5] = (short)(this.lineIndices[n5] + n3);
            }
        }

        void incPointIndices(int n, int n2, int n3) {
            int n4 = n;
            while (n4 <= n2) {
                int n5 = n4++;
                this.pointIndices[n5] = (short)(this.pointIndices[n5] + n3);
            }
        }

        void calcPolyNormal(int n, int n2, int n3) {
            int n4 = 4 * n;
            float f = this.polyVertices[n4++];
            float f2 = this.polyVertices[n4++];
            float f3 = this.polyVertices[n4];
            n4 = 4 * n2;
            float f4 = this.polyVertices[n4++];
            float f5 = this.polyVertices[n4++];
            float f6 = this.polyVertices[n4];
            n4 = 4 * n3;
            float f7 = this.polyVertices[n4++];
            float f8 = this.polyVertices[n4++];
            float f9 = this.polyVertices[n4];
            float f10 = f7 - f4;
            float f11 = f8 - f5;
            float f12 = f9 - f6;
            float f13 = f - f4;
            float f14 = f2 - f5;
            float f15 = f3 - f6;
            float f16 = f11 * f15 - f14 * f12;
            float f17 = f12 * f13 - f15 * f10;
            float f18 = f10 * f14 - f13 * f11;
            float f19 = PApplet.sqrt(f16 * f16 + f17 * f17 + f18 * f18);
            n4 = 3 * n;
            this.polyNormals[n4++] = f16 /= f19;
            this.polyNormals[n4++] = f17 /= f19;
            this.polyNormals[n4] = f18 /= f19;
            n4 = 3 * n2;
            this.polyNormals[n4++] = f16;
            this.polyNormals[n4++] = f17;
            this.polyNormals[n4] = f18;
            n4 = 3 * n3;
            this.polyNormals[n4++] = f16;
            this.polyNormals[n4++] = f17;
            this.polyNormals[n4] = f18;
        }

        void setPointVertex(int n, InGeometry inGeometry, int n2) {
            int n3 = 3 * n2;
            float f = inGeometry.vertices[n3++];
            float f2 = inGeometry.vertices[n3++];
            float f3 = inGeometry.vertices[n3];
            if (this.renderMode == 0 && this.pg.flushMode == 1) {
                PMatrix3D pMatrix3D = this.pg.modelview;
                n3 = 4 * n;
                this.pointVertices[n3++] = f * pMatrix3D.m00 + f2 * pMatrix3D.m01 + f3 * pMatrix3D.m02 + pMatrix3D.m03;
                this.pointVertices[n3++] = f * pMatrix3D.m10 + f2 * pMatrix3D.m11 + f3 * pMatrix3D.m12 + pMatrix3D.m13;
                this.pointVertices[n3++] = f * pMatrix3D.m20 + f2 * pMatrix3D.m21 + f3 * pMatrix3D.m22 + pMatrix3D.m23;
                this.pointVertices[n3] = f * pMatrix3D.m30 + f2 * pMatrix3D.m31 + f3 * pMatrix3D.m32 + pMatrix3D.m33;
            } else {
                n3 = 4 * n;
                this.pointVertices[n3++] = f;
                this.pointVertices[n3++] = f2;
                this.pointVertices[n3++] = f3;
                this.pointVertices[n3] = 1.0f;
            }
            this.pointColors[n] = inGeometry.strokeColors[n2];
        }

        void setLineVertex(int n, float[] fArray, int n2, int n3) {
            int n4 = 3 * n2;
            float f = fArray[n4++];
            float f2 = fArray[n4++];
            float f3 = fArray[n4];
            if (this.renderMode == 0 && this.pg.flushMode == 1) {
                PMatrix3D pMatrix3D = this.pg.modelview;
                n4 = 4 * n;
                this.lineVertices[n4++] = f * pMatrix3D.m00 + f2 * pMatrix3D.m01 + f3 * pMatrix3D.m02 + pMatrix3D.m03;
                this.lineVertices[n4++] = f * pMatrix3D.m10 + f2 * pMatrix3D.m11 + f3 * pMatrix3D.m12 + pMatrix3D.m13;
                this.lineVertices[n4++] = f * pMatrix3D.m20 + f2 * pMatrix3D.m21 + f3 * pMatrix3D.m22 + pMatrix3D.m23;
                this.lineVertices[n4] = f * pMatrix3D.m30 + f2 * pMatrix3D.m31 + f3 * pMatrix3D.m32 + pMatrix3D.m33;
            } else {
                n4 = 4 * n;
                this.lineVertices[n4++] = f;
                this.lineVertices[n4++] = f2;
                this.lineVertices[n4++] = f3;
                this.lineVertices[n4] = 1.0f;
            }
            this.lineColors[n] = n3;
            n4 = 4 * n;
            this.lineDirections[n4++] = 0.0f;
            this.lineDirections[n4++] = 0.0f;
            this.lineDirections[n4++] = 0.0f;
            this.lineDirections[n4] = 0.0f;
        }

        void setLineVertex(int n, float[] fArray, int n2, int n3, int n4, float f) {
            int n5 = 3 * n2;
            float f2 = fArray[n5++];
            float f3 = fArray[n5++];
            float f4 = fArray[n5];
            n5 = 3 * n3;
            float f5 = fArray[n5++];
            float f6 = fArray[n5++];
            float f7 = fArray[n5];
            float f8 = f5 - f2;
            float f9 = f6 - f3;
            float f10 = f7 - f4;
            if (this.renderMode == 0 && this.pg.flushMode == 1) {
                PMatrix3D pMatrix3D = this.pg.modelview;
                n5 = 4 * n;
                this.lineVertices[n5++] = f2 * pMatrix3D.m00 + f3 * pMatrix3D.m01 + f4 * pMatrix3D.m02 + pMatrix3D.m03;
                this.lineVertices[n5++] = f2 * pMatrix3D.m10 + f3 * pMatrix3D.m11 + f4 * pMatrix3D.m12 + pMatrix3D.m13;
                this.lineVertices[n5++] = f2 * pMatrix3D.m20 + f3 * pMatrix3D.m21 + f4 * pMatrix3D.m22 + pMatrix3D.m23;
                this.lineVertices[n5] = f2 * pMatrix3D.m30 + f3 * pMatrix3D.m31 + f4 * pMatrix3D.m32 + pMatrix3D.m33;
                n5 = 4 * n;
                this.lineDirections[n5++] = f8 * pMatrix3D.m00 + f9 * pMatrix3D.m01 + f10 * pMatrix3D.m02;
                this.lineDirections[n5++] = f8 * pMatrix3D.m10 + f9 * pMatrix3D.m11 + f10 * pMatrix3D.m12;
                this.lineDirections[n5] = f8 * pMatrix3D.m20 + f9 * pMatrix3D.m21 + f10 * pMatrix3D.m22;
            } else {
                n5 = 4 * n;
                this.lineVertices[n5++] = f2;
                this.lineVertices[n5++] = f3;
                this.lineVertices[n5++] = f4;
                this.lineVertices[n5] = 1.0f;
                n5 = 4 * n;
                this.lineDirections[n5++] = f8;
                this.lineDirections[n5++] = f9;
                this.lineDirections[n5] = f10;
            }
            this.lineColors[n] = n4;
            this.lineDirections[4 * n + 3] = f;
        }

        void addPolyVertex(double[] dArray, boolean bl) {
            int n = (int)dArray[3] << 24 | (int)dArray[4] << 16 | (int)dArray[5] << 8 | (int)dArray[6];
            int n2 = (int)dArray[12] << 24 | (int)dArray[13] << 16 | (int)dArray[14] << 8 | (int)dArray[15];
            int n3 = (int)dArray[16] << 24 | (int)dArray[17] << 16 | (int)dArray[18] << 8 | (int)dArray[19];
            int n4 = (int)dArray[20] << 24 | (int)dArray[21] << 16 | (int)dArray[22] << 8 | (int)dArray[23];
            this.addPolyVertex((float)dArray[0], (float)dArray[1], (float)dArray[2], n, (float)dArray[7], (float)dArray[8], (float)dArray[9], (float)dArray[10], (float)dArray[11], n2, n3, n4, (float)dArray[24], bl);
            if (25 < dArray.length) {
                PMatrix3D pMatrix3D = this.pg.modelview;
                PMatrix3D pMatrix3D2 = this.pg.modelviewInv;
                int n5 = this.polyVertexCount - 1;
                int n6 = 25;
                for (int i = 0; i < this.polyAttribs.size(); ++i) {
                    float f;
                    float f2;
                    VertexAttribute vertexAttribute = this.polyAttribs.get(i);
                    String string = vertexAttribute.name;
                    int n7 = vertexAttribute.tessSize * n5;
                    if (vertexAttribute.isColor()) {
                        int n8 = (int)dArray[n6 + 0] << 24 | (int)dArray[n6 + 1] << 16 | (int)dArray[n6 + 2] << 8 | (int)dArray[n6 + 3];
                        int[] nArray = this.ipolyAttribs.get(string);
                        nArray[n7] = n8;
                        n6 += 4;
                        continue;
                    }
                    if (vertexAttribute.isPosition()) {
                        float[] fArray = this.fpolyAttribs.get(string);
                        float f3 = (float)dArray[n6++];
                        f2 = (float)dArray[n6++];
                        f = (float)dArray[n6++];
                        if (this.renderMode == 0 && this.pg.flushMode == 1) {
                            if (bl) {
                                fArray[n7++] = PApplet.ceil(f3 * pMatrix3D.m00 + f2 * pMatrix3D.m01 + f * pMatrix3D.m02 + pMatrix3D.m03);
                                fArray[n7++] = PApplet.ceil(f3 * pMatrix3D.m10 + f2 * pMatrix3D.m11 + f * pMatrix3D.m12 + pMatrix3D.m13);
                            } else {
                                fArray[n7++] = f3 * pMatrix3D.m00 + f2 * pMatrix3D.m01 + f * pMatrix3D.m02 + pMatrix3D.m03;
                                fArray[n7++] = f3 * pMatrix3D.m10 + f2 * pMatrix3D.m11 + f * pMatrix3D.m12 + pMatrix3D.m13;
                            }
                            fArray[n7++] = f3 * pMatrix3D.m20 + f2 * pMatrix3D.m21 + f * pMatrix3D.m22 + pMatrix3D.m23;
                            fArray[n7] = f3 * pMatrix3D.m30 + f2 * pMatrix3D.m31 + f * pMatrix3D.m32 + pMatrix3D.m33;
                            continue;
                        }
                        fArray[n7++] = f3;
                        fArray[n7++] = f2;
                        fArray[n7++] = f;
                        fArray[n7] = 1.0f;
                        continue;
                    }
                    if (vertexAttribute.isNormal()) {
                        float[] fArray = this.fpolyAttribs.get(string);
                        float f4 = (float)dArray[n6 + 0];
                        f2 = (float)dArray[n6 + 1];
                        f = (float)dArray[n6 + 2];
                        if (this.renderMode == 0 && this.pg.flushMode == 1) {
                            fArray[n7++] = f4 * pMatrix3D2.m00 + f2 * pMatrix3D2.m10 + f * pMatrix3D2.m20;
                            fArray[n7++] = f4 * pMatrix3D2.m01 + f2 * pMatrix3D2.m11 + f * pMatrix3D2.m21;
                            fArray[n7] = f4 * pMatrix3D2.m02 + f2 * pMatrix3D2.m12 + f * pMatrix3D2.m22;
                        } else {
                            fArray[n7++] = f4;
                            fArray[n7++] = f2;
                            fArray[n7] = f;
                        }
                        n6 += 3;
                        continue;
                    }
                    if (vertexAttribute.isFloat()) {
                        float[] fArray = this.fpolyAttribs.get(string);
                        for (int j = 0; j < vertexAttribute.size; ++j) {
                            fArray[n7++] = (float)dArray[n6++];
                        }
                    } else if (vertexAttribute.isInt()) {
                        int[] nArray = this.ipolyAttribs.get(string);
                        for (int j = 0; j < vertexAttribute.size; ++j) {
                            nArray[n7++] = (int)dArray[n6++];
                        }
                    } else if (vertexAttribute.isBool()) {
                        byte[] byArray = this.bpolyAttribs.get(string);
                        for (int j = 0; j < vertexAttribute.size; ++j) {
                            byArray[n7++] = (byte)dArray[n6++];
                        }
                    }
                    n6 += vertexAttribute.size;
                }
            }
        }

        void addPolyVertex(float f, float f2, float f3, int n, float f4, float f5, float f6, float f7, float f8, int n2, int n3, int n4, float f9, boolean bl) {
            this.polyVertexCheck();
            int n5 = this.polyVertexCount - 1;
            this.setPolyVertex(n5, f, f2, f3, n, f4, f5, f6, f7, f8, n2, n3, n4, f9, bl);
        }

        void setPolyVertex(int n, float f, float f2, float f3, int n2, boolean bl) {
            this.setPolyVertex(n, f, f2, f3, n2, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0, 0, 0, 0.0f, bl);
        }

        void setPolyVertex(int n, float f, float f2, float f3, int n2, float f4, float f5, float f6, float f7, float f8, int n3, int n4, int n5, float f9, boolean bl) {
            int n6;
            if (this.renderMode == 0 && this.pg.flushMode == 1) {
                PMatrix3D pMatrix3D = this.pg.modelview;
                PMatrix3D pMatrix3D2 = this.pg.modelviewInv;
                n6 = 4 * n;
                if (bl) {
                    this.polyVertices[n6++] = PApplet.ceil(f * pMatrix3D.m00 + f2 * pMatrix3D.m01 + f3 * pMatrix3D.m02 + pMatrix3D.m03);
                    this.polyVertices[n6++] = PApplet.ceil(f * pMatrix3D.m10 + f2 * pMatrix3D.m11 + f3 * pMatrix3D.m12 + pMatrix3D.m13);
                } else {
                    this.polyVertices[n6++] = f * pMatrix3D.m00 + f2 * pMatrix3D.m01 + f3 * pMatrix3D.m02 + pMatrix3D.m03;
                    this.polyVertices[n6++] = f * pMatrix3D.m10 + f2 * pMatrix3D.m11 + f3 * pMatrix3D.m12 + pMatrix3D.m13;
                }
                this.polyVertices[n6++] = f * pMatrix3D.m20 + f2 * pMatrix3D.m21 + f3 * pMatrix3D.m22 + pMatrix3D.m23;
                this.polyVertices[n6] = f * pMatrix3D.m30 + f2 * pMatrix3D.m31 + f3 * pMatrix3D.m32 + pMatrix3D.m33;
                n6 = 3 * n;
                this.polyNormals[n6++] = f4 * pMatrix3D2.m00 + f5 * pMatrix3D2.m10 + f6 * pMatrix3D2.m20;
                this.polyNormals[n6++] = f4 * pMatrix3D2.m01 + f5 * pMatrix3D2.m11 + f6 * pMatrix3D2.m21;
                this.polyNormals[n6] = f4 * pMatrix3D2.m02 + f5 * pMatrix3D2.m12 + f6 * pMatrix3D2.m22;
            } else {
                n6 = 4 * n;
                this.polyVertices[n6++] = f;
                this.polyVertices[n6++] = f2;
                this.polyVertices[n6++] = f3;
                this.polyVertices[n6] = 1.0f;
                n6 = 3 * n;
                this.polyNormals[n6++] = f4;
                this.polyNormals[n6++] = f5;
                this.polyNormals[n6] = f6;
            }
            this.polyColors[n] = n2;
            n6 = 2 * n;
            this.polyTexCoords[n6++] = f7;
            this.polyTexCoords[n6] = f8;
            this.polyAmbient[n] = n3;
            this.polySpecular[n] = n4;
            this.polyEmissive[n] = n5;
            this.polyShininess[n] = f9;
        }

        void addPolyVertices(InGeometry inGeometry, boolean bl) {
            this.addPolyVertices(inGeometry, 0, inGeometry.vertexCount - 1, bl);
        }

        void addPolyVertex(InGeometry inGeometry, int n, boolean bl) {
            this.addPolyVertices(inGeometry, n, n, bl);
        }

        void addPolyVertices(InGeometry inGeometry, int n, int n2, boolean bl) {
            int n3 = 0;
            int n4 = n2 - n + 1;
            this.polyVertexCheck(n4);
            if (this.renderMode == 0 && this.pg.flushMode == 1) {
                this.modelviewCoords(inGeometry, n, n3, n4, bl);
            } else if (n4 <= PGL.MIN_ARRAYCOPY_SIZE) {
                this.copyFewCoords(inGeometry, n, n3, n4);
            } else {
                this.copyManyCoords(inGeometry, n, n3, n4);
            }
            if (n4 <= PGL.MIN_ARRAYCOPY_SIZE) {
                this.copyFewAttribs(inGeometry, n, n3, n4);
            } else {
                this.copyManyAttribs(inGeometry, n, n3, n4);
            }
        }

        private void modelviewCoords(InGeometry inGeometry, int n, int n2, int n3, boolean bl) {
            PMatrix3D pMatrix3D = this.pg.modelview;
            PMatrix3D pMatrix3D2 = this.pg.modelviewInv;
            for (int i = 0; i < n3; ++i) {
                int n4 = n + i;
                int n5 = this.firstPolyVertex + i;
                n2 = 3 * n4;
                float f = inGeometry.vertices[n2++];
                float f2 = inGeometry.vertices[n2++];
                float f3 = inGeometry.vertices[n2];
                n2 = 3 * n4;
                float f4 = inGeometry.normals[n2++];
                float f5 = inGeometry.normals[n2++];
                float f6 = inGeometry.normals[n2];
                n2 = 4 * n5;
                if (bl) {
                    this.polyVertices[n2++] = PApplet.ceil(f * pMatrix3D.m00 + f2 * pMatrix3D.m01 + f3 * pMatrix3D.m02 + pMatrix3D.m03);
                    this.polyVertices[n2++] = PApplet.ceil(f * pMatrix3D.m10 + f2 * pMatrix3D.m11 + f3 * pMatrix3D.m12 + pMatrix3D.m13);
                } else {
                    this.polyVertices[n2++] = f * pMatrix3D.m00 + f2 * pMatrix3D.m01 + f3 * pMatrix3D.m02 + pMatrix3D.m03;
                    this.polyVertices[n2++] = f * pMatrix3D.m10 + f2 * pMatrix3D.m11 + f3 * pMatrix3D.m12 + pMatrix3D.m13;
                }
                this.polyVertices[n2++] = f * pMatrix3D.m20 + f2 * pMatrix3D.m21 + f3 * pMatrix3D.m22 + pMatrix3D.m23;
                this.polyVertices[n2] = f * pMatrix3D.m30 + f2 * pMatrix3D.m31 + f3 * pMatrix3D.m32 + pMatrix3D.m33;
                n2 = 3 * n5;
                this.polyNormals[n2++] = f4 * pMatrix3D2.m00 + f5 * pMatrix3D2.m10 + f6 * pMatrix3D2.m20;
                this.polyNormals[n2++] = f4 * pMatrix3D2.m01 + f5 * pMatrix3D2.m11 + f6 * pMatrix3D2.m21;
                this.polyNormals[n2] = f4 * pMatrix3D2.m02 + f5 * pMatrix3D2.m12 + f6 * pMatrix3D2.m22;
                for (String string : this.polyAttribs.keySet()) {
                    VertexAttribute vertexAttribute = (VertexAttribute)this.polyAttribs.get(string);
                    if (vertexAttribute.isColor() || vertexAttribute.isOther()) continue;
                    float[] fArray = inGeometry.fattribs.get(string);
                    n2 = 3 * n4;
                    f = fArray[n2++];
                    f2 = fArray[n2++];
                    f3 = fArray[n2];
                    float[] fArray2 = this.fpolyAttribs.get(string);
                    if (vertexAttribute.isPosition()) {
                        n2 = 4 * n5;
                        if (bl) {
                            fArray2[n2++] = PApplet.ceil(f * pMatrix3D.m00 + f2 * pMatrix3D.m01 + f3 * pMatrix3D.m02 + pMatrix3D.m03);
                            fArray2[n2++] = PApplet.ceil(f * pMatrix3D.m10 + f2 * pMatrix3D.m11 + f3 * pMatrix3D.m12 + pMatrix3D.m13);
                        } else {
                            fArray2[n2++] = f * pMatrix3D.m00 + f2 * pMatrix3D.m01 + f3 * pMatrix3D.m02 + pMatrix3D.m03;
                            fArray2[n2++] = f * pMatrix3D.m10 + f2 * pMatrix3D.m11 + f3 * pMatrix3D.m12 + pMatrix3D.m13;
                        }
                        fArray2[n2++] = f * pMatrix3D.m20 + f2 * pMatrix3D.m21 + f3 * pMatrix3D.m22 + pMatrix3D.m23;
                        fArray2[n2] = f * pMatrix3D.m30 + f2 * pMatrix3D.m31 + f3 * pMatrix3D.m32 + pMatrix3D.m33;
                        continue;
                    }
                    n2 = 3 * n5;
                    fArray2[n2++] = f * pMatrix3D2.m00 + f2 * pMatrix3D2.m10 + f3 * pMatrix3D2.m20;
                    fArray2[n2++] = f * pMatrix3D2.m01 + f2 * pMatrix3D2.m11 + f3 * pMatrix3D2.m21;
                    fArray2[n2] = f * pMatrix3D2.m02 + f2 * pMatrix3D2.m12 + f3 * pMatrix3D2.m22;
                }
            }
        }

        private void copyFewCoords(InGeometry inGeometry, int n, int n2, int n3) {
            for (int i = 0; i < n3; ++i) {
                int n4 = n + i;
                int n5 = this.firstPolyVertex + i;
                n2 = 3 * n4;
                float f = inGeometry.vertices[n2++];
                float f2 = inGeometry.vertices[n2++];
                float f3 = inGeometry.vertices[n2];
                n2 = 3 * n4;
                float f4 = inGeometry.normals[n2++];
                float f5 = inGeometry.normals[n2++];
                float f6 = inGeometry.normals[n2];
                n2 = 4 * n5;
                this.polyVertices[n2++] = f;
                this.polyVertices[n2++] = f2;
                this.polyVertices[n2++] = f3;
                this.polyVertices[n2] = 1.0f;
                n2 = 3 * n5;
                this.polyNormals[n2++] = f4;
                this.polyNormals[n2++] = f5;
                this.polyNormals[n2] = f6;
                for (String string : this.polyAttribs.keySet()) {
                    VertexAttribute vertexAttribute = (VertexAttribute)this.polyAttribs.get(string);
                    if (vertexAttribute.isColor() || vertexAttribute.isOther()) continue;
                    float[] fArray = inGeometry.fattribs.get(string);
                    n2 = 3 * n4;
                    f = fArray[n2++];
                    f2 = fArray[n2++];
                    f3 = fArray[n2];
                    float[] fArray2 = this.fpolyAttribs.get(string);
                    if (vertexAttribute.isPosition()) {
                        n2 = 4 * n5;
                        fArray2[n2++] = f;
                        fArray2[n2++] = f2;
                        fArray2[n2++] = f3;
                        fArray2[n2] = 1.0f;
                        continue;
                    }
                    n2 = 3 * n5;
                    fArray2[n2++] = f;
                    fArray2[n2++] = f2;
                    fArray2[n2] = f3;
                }
            }
        }

        private void copyManyCoords(InGeometry inGeometry, int n, int n2, int n3) {
            for (int i = 0; i < n3; ++i) {
                int n4 = n + i;
                int n5 = this.firstPolyVertex + i;
                PApplet.arrayCopy(inGeometry.vertices, 3 * n4, this.polyVertices, 4 * n5, 3);
                this.polyVertices[4 * n5 + 3] = 1.0f;
                for (Object object : this.polyAttribs.keySet()) {
                    VertexAttribute vertexAttribute = (VertexAttribute)this.polyAttribs.get(object);
                    if (!vertexAttribute.isPosition()) continue;
                    float[] fArray = inGeometry.fattribs.get(object);
                    float[] fArray2 = this.fpolyAttribs.get(object);
                    PApplet.arrayCopy(fArray, 3 * n4, fArray2, 4 * n5, 3);
                    fArray2[4 * n5 + 3] = 1.0f;
                }
            }
            PApplet.arrayCopy(inGeometry.normals, 3 * n, this.polyNormals, 3 * this.firstPolyVertex, 3 * n3);
            for (String string : this.polyAttribs.keySet()) {
                Object object;
                VertexAttribute vertexAttribute = (VertexAttribute)this.polyAttribs.get(string);
                if (!vertexAttribute.isNormal()) continue;
                Object object2 = inGeometry.fattribs.get(string);
                object = this.fpolyAttribs.get(string);
                PApplet.arrayCopy(object2, 3 * n, object, 3 * this.firstPolyVertex, 3 * n3);
            }
        }

        private void copyFewAttribs(InGeometry inGeometry, int n, int n2, int n3) {
            for (int i = 0; i < n3; ++i) {
                int n4 = n + i;
                int n5 = this.firstPolyVertex + i;
                n2 = 2 * n4;
                float f = inGeometry.texcoords[n2++];
                float f2 = inGeometry.texcoords[n2];
                this.polyColors[n5] = inGeometry.colors[n4];
                n2 = 2 * n5;
                this.polyTexCoords[n2++] = f;
                this.polyTexCoords[n2] = f2;
                this.polyAmbient[n5] = inGeometry.ambient[n4];
                this.polySpecular[n5] = inGeometry.specular[n4];
                this.polyEmissive[n5] = inGeometry.emissive[n4];
                this.polyShininess[n5] = inGeometry.shininess[n4];
                for (String string : this.polyAttribs.keySet()) {
                    int n6;
                    Object[] objectArray;
                    Object[] objectArray2;
                    VertexAttribute vertexAttribute = (VertexAttribute)this.polyAttribs.get(string);
                    if (vertexAttribute.isPosition() || vertexAttribute.isNormal()) continue;
                    int n7 = vertexAttribute.size * n4;
                    int n8 = vertexAttribute.size * n5;
                    if (vertexAttribute.isFloat()) {
                        objectArray2 = inGeometry.fattribs.get(string);
                        objectArray = this.fpolyAttribs.get(string);
                        for (n6 = 0; n6 < vertexAttribute.size; ++n6) {
                            objectArray[n8++] = objectArray2[n7++];
                        }
                        continue;
                    }
                    if (vertexAttribute.isInt()) {
                        objectArray2 = inGeometry.iattribs.get(string);
                        objectArray = this.ipolyAttribs.get(string);
                        for (n6 = 0; n6 < vertexAttribute.size; ++n6) {
                            objectArray[n8++] = objectArray2[n7++];
                        }
                        continue;
                    }
                    if (!vertexAttribute.isBool()) continue;
                    objectArray2 = inGeometry.battribs.get(string);
                    objectArray = this.bpolyAttribs.get(string);
                    for (n6 = 0; n6 < vertexAttribute.size; ++n6) {
                        objectArray[n8++] = objectArray2[n7++];
                    }
                }
            }
        }

        private void copyManyAttribs(InGeometry inGeometry, int n, int n2, int n3) {
            PApplet.arrayCopy(inGeometry.colors, n, this.polyColors, this.firstPolyVertex, n3);
            PApplet.arrayCopy(inGeometry.texcoords, 2 * n, this.polyTexCoords, 2 * this.firstPolyVertex, 2 * n3);
            PApplet.arrayCopy(inGeometry.ambient, n, this.polyAmbient, this.firstPolyVertex, n3);
            PApplet.arrayCopy(inGeometry.specular, n, this.polySpecular, this.firstPolyVertex, n3);
            PApplet.arrayCopy(inGeometry.emissive, n, this.polyEmissive, this.firstPolyVertex, n3);
            PApplet.arrayCopy(inGeometry.shininess, n, this.polyShininess, this.firstPolyVertex, n3);
            for (String string : this.polyAttribs.keySet()) {
                VertexAttribute vertexAttribute = (VertexAttribute)this.polyAttribs.get(string);
                if (vertexAttribute.isPosition() || vertexAttribute.isNormal()) continue;
                Object[] objectArray = null;
                Object[] objectArray2 = null;
                if (vertexAttribute.isFloat()) {
                    objectArray = inGeometry.fattribs.get(string);
                    objectArray2 = this.fpolyAttribs.get(string);
                } else if (vertexAttribute.isInt()) {
                    objectArray = inGeometry.iattribs.get(string);
                    objectArray2 = this.ipolyAttribs.get(string);
                } else if (vertexAttribute.isBool()) {
                    objectArray = inGeometry.battribs.get(string);
                    objectArray2 = this.bpolyAttribs.get(string);
                }
                PApplet.arrayCopy(objectArray, vertexAttribute.size * n, objectArray2, vertexAttribute.tessSize * this.firstPolyVertex, vertexAttribute.size * n3);
            }
        }

        void applyMatrixOnPolyGeometry(PMatrix pMatrix, int n, int n2) {
            if (pMatrix instanceof PMatrix2D) {
                this.applyMatrixOnPolyGeometry((PMatrix2D)pMatrix, n, n2);
            } else if (pMatrix instanceof PMatrix3D) {
                this.applyMatrixOnPolyGeometry((PMatrix3D)pMatrix, n, n2);
            }
        }

        void applyMatrixOnLineGeometry(PMatrix pMatrix, int n, int n2) {
            if (pMatrix instanceof PMatrix2D) {
                this.applyMatrixOnLineGeometry((PMatrix2D)pMatrix, n, n2);
            } else if (pMatrix instanceof PMatrix3D) {
                this.applyMatrixOnLineGeometry((PMatrix3D)pMatrix, n, n2);
            }
        }

        void applyMatrixOnPointGeometry(PMatrix pMatrix, int n, int n2) {
            if (pMatrix instanceof PMatrix2D) {
                this.applyMatrixOnPointGeometry((PMatrix2D)pMatrix, n, n2);
            } else if (pMatrix instanceof PMatrix3D) {
                this.applyMatrixOnPointGeometry((PMatrix3D)pMatrix, n, n2);
            }
        }

        void applyMatrixOnPolyGeometry(PMatrix2D pMatrix2D, int n, int n2) {
            if (n < n2) {
                for (int i = n; i <= n2; ++i) {
                    int n3 = 4 * i;
                    float f = this.polyVertices[n3++];
                    float f2 = this.polyVertices[n3];
                    n3 = 3 * i;
                    float f3 = this.polyNormals[n3++];
                    float f4 = this.polyNormals[n3];
                    n3 = 4 * i;
                    this.polyVertices[n3++] = f * pMatrix2D.m00 + f2 * pMatrix2D.m01 + pMatrix2D.m02;
                    this.polyVertices[n3] = f * pMatrix2D.m10 + f2 * pMatrix2D.m11 + pMatrix2D.m12;
                    n3 = 3 * i;
                    this.polyNormals[n3++] = f3 * pMatrix2D.m00 + f4 * pMatrix2D.m01;
                    this.polyNormals[n3] = f3 * pMatrix2D.m10 + f4 * pMatrix2D.m11;
                    for (String string : this.polyAttribs.keySet()) {
                        VertexAttribute vertexAttribute = (VertexAttribute)this.polyAttribs.get(string);
                        if (vertexAttribute.isColor() || vertexAttribute.isOther()) continue;
                        float[] fArray = this.fpolyAttribs.get(string);
                        if (vertexAttribute.isPosition()) {
                            n3 = 4 * i;
                            f = fArray[n3++];
                            f2 = fArray[n3];
                            n3 = 4 * i;
                            fArray[n3++] = f * pMatrix2D.m00 + f2 * pMatrix2D.m01 + pMatrix2D.m02;
                            fArray[n3] = f * pMatrix2D.m10 + f2 * pMatrix2D.m11 + pMatrix2D.m12;
                            continue;
                        }
                        n3 = 3 * i;
                        f3 = fArray[n3++];
                        f4 = fArray[n3];
                        n3 = 3 * i;
                        fArray[n3++] = f3 * pMatrix2D.m00 + f4 * pMatrix2D.m01;
                        fArray[n3] = f3 * pMatrix2D.m10 + f4 * pMatrix2D.m11;
                    }
                }
            }
        }

        void applyMatrixOnLineGeometry(PMatrix2D pMatrix2D, int n, int n2) {
            if (n < n2) {
                float f = PGraphicsOpenGL.matrixScale(pMatrix2D);
                for (int i = n; i <= n2; ++i) {
                    int n3 = 4 * i;
                    float f2 = this.lineVertices[n3++];
                    float f3 = this.lineVertices[n3];
                    n3 = 4 * i;
                    float f4 = this.lineDirections[n3++];
                    float f5 = this.lineDirections[n3];
                    n3 = 4 * i;
                    this.lineVertices[n3++] = f2 * pMatrix2D.m00 + f3 * pMatrix2D.m01 + pMatrix2D.m02;
                    this.lineVertices[n3] = f2 * pMatrix2D.m10 + f3 * pMatrix2D.m11 + pMatrix2D.m12;
                    n3 = 4 * i;
                    this.lineDirections[n3++] = f4 * pMatrix2D.m00 + f5 * pMatrix2D.m01;
                    this.lineDirections[n3] = f4 * pMatrix2D.m10 + f5 * pMatrix2D.m11;
                    int n4 = n3 + 2;
                    this.lineDirections[n4] = this.lineDirections[n4] * f;
                }
            }
        }

        void applyMatrixOnPointGeometry(PMatrix2D pMatrix2D, int n, int n2) {
            if (n < n2) {
                float f = PGraphicsOpenGL.matrixScale(pMatrix2D);
                for (int i = n; i <= n2; ++i) {
                    int n3 = 4 * i;
                    float f2 = this.pointVertices[n3++];
                    float f3 = this.pointVertices[n3];
                    n3 = 4 * i;
                    this.pointVertices[n3++] = f2 * pMatrix2D.m00 + f3 * pMatrix2D.m01 + pMatrix2D.m02;
                    this.pointVertices[n3] = f2 * pMatrix2D.m10 + f3 * pMatrix2D.m11 + pMatrix2D.m12;
                    n3 = 2 * i;
                    int n4 = n3++;
                    this.pointOffsets[n4] = this.pointOffsets[n4] * f;
                    int n5 = n3;
                    this.pointOffsets[n5] = this.pointOffsets[n5] * f;
                }
            }
        }

        void applyMatrixOnPolyGeometry(PMatrix3D pMatrix3D, int n, int n2) {
            if (n < n2) {
                for (int i = n; i <= n2; ++i) {
                    int n3 = 4 * i;
                    float f = this.polyVertices[n3++];
                    float f2 = this.polyVertices[n3++];
                    float f3 = this.polyVertices[n3++];
                    float f4 = this.polyVertices[n3];
                    n3 = 3 * i;
                    float f5 = this.polyNormals[n3++];
                    float f6 = this.polyNormals[n3++];
                    float f7 = this.polyNormals[n3];
                    n3 = 4 * i;
                    this.polyVertices[n3++] = f * pMatrix3D.m00 + f2 * pMatrix3D.m01 + f3 * pMatrix3D.m02 + f4 * pMatrix3D.m03;
                    this.polyVertices[n3++] = f * pMatrix3D.m10 + f2 * pMatrix3D.m11 + f3 * pMatrix3D.m12 + f4 * pMatrix3D.m13;
                    this.polyVertices[n3++] = f * pMatrix3D.m20 + f2 * pMatrix3D.m21 + f3 * pMatrix3D.m22 + f4 * pMatrix3D.m23;
                    this.polyVertices[n3] = f * pMatrix3D.m30 + f2 * pMatrix3D.m31 + f3 * pMatrix3D.m32 + f4 * pMatrix3D.m33;
                    n3 = 3 * i;
                    this.polyNormals[n3++] = f5 * pMatrix3D.m00 + f6 * pMatrix3D.m01 + f7 * pMatrix3D.m02;
                    this.polyNormals[n3++] = f5 * pMatrix3D.m10 + f6 * pMatrix3D.m11 + f7 * pMatrix3D.m12;
                    this.polyNormals[n3] = f5 * pMatrix3D.m20 + f6 * pMatrix3D.m21 + f7 * pMatrix3D.m22;
                    for (String string : this.polyAttribs.keySet()) {
                        VertexAttribute vertexAttribute = (VertexAttribute)this.polyAttribs.get(string);
                        if (vertexAttribute.isColor() || vertexAttribute.isOther()) continue;
                        float[] fArray = this.fpolyAttribs.get(string);
                        if (vertexAttribute.isPosition()) {
                            n3 = 4 * i;
                            f = fArray[n3++];
                            f2 = fArray[n3++];
                            f3 = fArray[n3++];
                            f4 = fArray[n3];
                            n3 = 4 * i;
                            fArray[n3++] = f * pMatrix3D.m00 + f2 * pMatrix3D.m01 + f3 * pMatrix3D.m02 + f4 * pMatrix3D.m03;
                            fArray[n3++] = f * pMatrix3D.m10 + f2 * pMatrix3D.m11 + f3 * pMatrix3D.m12 + f4 * pMatrix3D.m13;
                            fArray[n3++] = f * pMatrix3D.m20 + f2 * pMatrix3D.m21 + f3 * pMatrix3D.m22 + f4 * pMatrix3D.m23;
                            fArray[n3] = f * pMatrix3D.m30 + f2 * pMatrix3D.m31 + f3 * pMatrix3D.m32 + f4 * pMatrix3D.m33;
                            continue;
                        }
                        n3 = 3 * i;
                        f5 = fArray[n3++];
                        f6 = fArray[n3++];
                        f7 = fArray[n3];
                        n3 = 3 * i;
                        fArray[n3++] = f5 * pMatrix3D.m00 + f6 * pMatrix3D.m01 + f7 * pMatrix3D.m02;
                        fArray[n3++] = f5 * pMatrix3D.m10 + f6 * pMatrix3D.m11 + f7 * pMatrix3D.m12;
                        fArray[n3] = f5 * pMatrix3D.m20 + f6 * pMatrix3D.m21 + f7 * pMatrix3D.m22;
                    }
                }
            }
        }

        void applyMatrixOnLineGeometry(PMatrix3D pMatrix3D, int n, int n2) {
            if (n < n2) {
                float f = PGraphicsOpenGL.matrixScale(pMatrix3D);
                for (int i = n; i <= n2; ++i) {
                    int n3 = 4 * i;
                    float f2 = this.lineVertices[n3++];
                    float f3 = this.lineVertices[n3++];
                    float f4 = this.lineVertices[n3++];
                    float f5 = this.lineVertices[n3];
                    n3 = 4 * i;
                    float f6 = this.lineDirections[n3++];
                    float f7 = this.lineDirections[n3++];
                    float f8 = this.lineDirections[n3];
                    n3 = 4 * i;
                    this.lineVertices[n3++] = f2 * pMatrix3D.m00 + f3 * pMatrix3D.m01 + f4 * pMatrix3D.m02 + f5 * pMatrix3D.m03;
                    this.lineVertices[n3++] = f2 * pMatrix3D.m10 + f3 * pMatrix3D.m11 + f4 * pMatrix3D.m12 + f5 * pMatrix3D.m13;
                    this.lineVertices[n3++] = f2 * pMatrix3D.m20 + f3 * pMatrix3D.m21 + f4 * pMatrix3D.m22 + f5 * pMatrix3D.m23;
                    this.lineVertices[n3] = f2 * pMatrix3D.m30 + f3 * pMatrix3D.m31 + f4 * pMatrix3D.m32 + f5 * pMatrix3D.m33;
                    n3 = 4 * i;
                    this.lineDirections[n3++] = f6 * pMatrix3D.m00 + f7 * pMatrix3D.m01 + f8 * pMatrix3D.m02;
                    this.lineDirections[n3++] = f6 * pMatrix3D.m10 + f7 * pMatrix3D.m11 + f8 * pMatrix3D.m12;
                    this.lineDirections[n3++] = f6 * pMatrix3D.m20 + f7 * pMatrix3D.m21 + f8 * pMatrix3D.m22;
                    int n4 = n3;
                    this.lineDirections[n4] = this.lineDirections[n4] * f;
                }
            }
        }

        void applyMatrixOnPointGeometry(PMatrix3D pMatrix3D, int n, int n2) {
            if (n < n2) {
                float f = PGraphicsOpenGL.matrixScale(pMatrix3D);
                for (int i = n; i <= n2; ++i) {
                    int n3 = 4 * i;
                    float f2 = this.pointVertices[n3++];
                    float f3 = this.pointVertices[n3++];
                    float f4 = this.pointVertices[n3++];
                    float f5 = this.pointVertices[n3];
                    n3 = 4 * i;
                    this.pointVertices[n3++] = f2 * pMatrix3D.m00 + f3 * pMatrix3D.m01 + f4 * pMatrix3D.m02 + f5 * pMatrix3D.m03;
                    this.pointVertices[n3++] = f2 * pMatrix3D.m10 + f3 * pMatrix3D.m11 + f4 * pMatrix3D.m12 + f5 * pMatrix3D.m13;
                    this.pointVertices[n3++] = f2 * pMatrix3D.m20 + f3 * pMatrix3D.m21 + f4 * pMatrix3D.m22 + f5 * pMatrix3D.m23;
                    this.pointVertices[n3] = f2 * pMatrix3D.m30 + f3 * pMatrix3D.m31 + f4 * pMatrix3D.m32 + f5 * pMatrix3D.m33;
                    n3 = 2 * i;
                    int n4 = n3++;
                    this.pointOffsets[n4] = this.pointOffsets[n4] * f;
                    int n5 = n3;
                    this.pointOffsets[n5] = this.pointOffsets[n5] * f;
                }
            }
        }
    }

    protected static class InGeometry {
        PGraphicsOpenGL pg;
        int renderMode;
        AttributeMap attribs;
        int vertexCount;
        int codeCount;
        int edgeCount;
        float[] vertices;
        int[] colors;
        float[] normals;
        float[] texcoords;
        int[] strokeColors;
        float[] strokeWeights;
        int[] codes;
        int[][] edges;
        int[] ambient;
        int[] specular;
        int[] emissive;
        float[] shininess;
        HashMap<String, float[]> fattribs;
        HashMap<String, int[]> iattribs;
        HashMap<String, byte[]> battribs;
        int fillColor;
        int strokeColor;
        float strokeWeight;
        int ambientColor;
        int specularColor;
        int emissiveColor;
        float shininessFactor;
        float normalX;
        float normalY;
        float normalZ;

        InGeometry(PGraphicsOpenGL pGraphicsOpenGL, AttributeMap attributeMap, int n) {
            this.pg = pGraphicsOpenGL;
            this.attribs = attributeMap;
            this.renderMode = n;
            this.allocate();
        }

        void clear() {
            this.vertexCount = 0;
            this.codeCount = 0;
            this.edgeCount = 0;
        }

        void clearEdges() {
            this.edgeCount = 0;
        }

        void allocate() {
            this.vertices = new float[3 * PGL.DEFAULT_IN_VERTICES];
            this.colors = new int[PGL.DEFAULT_IN_VERTICES];
            this.normals = new float[3 * PGL.DEFAULT_IN_VERTICES];
            this.texcoords = new float[2 * PGL.DEFAULT_IN_VERTICES];
            this.strokeColors = new int[PGL.DEFAULT_IN_VERTICES];
            this.strokeWeights = new float[PGL.DEFAULT_IN_VERTICES];
            this.ambient = new int[PGL.DEFAULT_IN_VERTICES];
            this.specular = new int[PGL.DEFAULT_IN_VERTICES];
            this.emissive = new int[PGL.DEFAULT_IN_VERTICES];
            this.shininess = new float[PGL.DEFAULT_IN_VERTICES];
            this.edges = new int[PGL.DEFAULT_IN_EDGES][3];
            this.fattribs = new HashMap();
            this.iattribs = new HashMap();
            this.battribs = new HashMap();
            this.clear();
        }

        void initAttrib(VertexAttribute vertexAttribute) {
            if (vertexAttribute.type == PGL.FLOAT) {
                float[] fArray = new float[vertexAttribute.size * PGL.DEFAULT_IN_VERTICES];
                this.fattribs.put(vertexAttribute.name, fArray);
            } else if (vertexAttribute.type == PGL.INT) {
                int[] nArray = new int[vertexAttribute.size * PGL.DEFAULT_IN_VERTICES];
                this.iattribs.put(vertexAttribute.name, nArray);
            } else if (vertexAttribute.type == PGL.BOOL) {
                byte[] byArray = new byte[vertexAttribute.size * PGL.DEFAULT_IN_VERTICES];
                this.battribs.put(vertexAttribute.name, byArray);
            }
        }

        void vertexCheck() {
            if (this.vertexCount == this.vertices.length / 3) {
                int n = this.vertexCount << 1;
                this.expandVertices(n);
                this.expandColors(n);
                this.expandNormals(n);
                this.expandTexCoords(n);
                this.expandStrokeColors(n);
                this.expandStrokeWeights(n);
                this.expandAmbient(n);
                this.expandSpecular(n);
                this.expandEmissive(n);
                this.expandShininess(n);
                this.expandAttribs(n);
            }
        }

        void codeCheck() {
            if (this.codeCount == this.codes.length) {
                int n = this.codeCount << 1;
                this.expandCodes(n);
            }
        }

        void edgeCheck() {
            if (this.edgeCount == this.edges.length) {
                int n = this.edgeCount << 1;
                this.expandEdges(n);
            }
        }

        float getVertexX(int n) {
            return this.vertices[3 * n + 0];
        }

        float getVertexY(int n) {
            return this.vertices[3 * n + 1];
        }

        float getVertexZ(int n) {
            return this.vertices[3 * n + 2];
        }

        float getLastVertexX() {
            return this.vertices[3 * (this.vertexCount - 1) + 0];
        }

        float getLastVertexY() {
            return this.vertices[3 * (this.vertexCount - 1) + 1];
        }

        float getLastVertexZ() {
            return this.vertices[3 * (this.vertexCount - 1) + 2];
        }

        int getNumEdgeClosures() {
            int n = 0;
            for (int i = 0; i < this.edgeCount; ++i) {
                if (this.edges[i][2] != -1) continue;
                ++n;
            }
            return n;
        }

        int getNumEdgeVertices(boolean bl) {
            int n = this.edgeCount;
            int n2 = 0;
            if (bl) {
                for (int i = 0; i < this.edgeCount; ++i) {
                    int[] nArray = this.edges[i];
                    if (nArray[2] == 0 || nArray[2] == 1) {
                        n2 += 3;
                    }
                    if (nArray[2] != -1) continue;
                    n2 += 5;
                    --n;
                }
            } else {
                n -= this.getNumEdgeClosures();
            }
            return 4 * n + n2;
        }

        int getNumEdgeIndices(boolean bl) {
            int n = this.edgeCount;
            int n2 = 0;
            if (bl) {
                for (int i = 0; i < this.edgeCount; ++i) {
                    int[] nArray = this.edges[i];
                    if (nArray[2] == 0 || nArray[2] == 1) {
                        ++n2;
                    }
                    if (nArray[2] != -1) continue;
                    ++n2;
                    --n;
                }
            } else {
                n -= this.getNumEdgeClosures();
            }
            return 6 * (n + n2);
        }

        void getVertexMin(PVector pVector) {
            for (int i = 0; i < this.vertexCount; ++i) {
                int n = 4 * i;
                pVector.x = PApplet.min(pVector.x, this.vertices[n++]);
                pVector.y = PApplet.min(pVector.y, this.vertices[n++]);
                pVector.z = PApplet.min(pVector.z, this.vertices[n]);
            }
        }

        void getVertexMax(PVector pVector) {
            for (int i = 0; i < this.vertexCount; ++i) {
                int n = 4 * i;
                pVector.x = PApplet.max(pVector.x, this.vertices[n++]);
                pVector.y = PApplet.max(pVector.y, this.vertices[n++]);
                pVector.z = PApplet.max(pVector.z, this.vertices[n]);
            }
        }

        int getVertexSum(PVector pVector) {
            for (int i = 0; i < this.vertexCount; ++i) {
                int n = 4 * i;
                pVector.x += this.vertices[n++];
                pVector.y += this.vertices[n++];
                pVector.z += this.vertices[n];
            }
            return this.vertexCount;
        }

        double[] getAttribVector(int n) {
            double[] dArray = new double[this.attribs.numComp];
            int n2 = 0;
            for (int i = 0; i < this.attribs.size(); ++i) {
                int n3;
                Object[] objectArray;
                VertexAttribute vertexAttribute = this.attribs.get(i);
                String string = vertexAttribute.name;
                int n4 = vertexAttribute.size * n;
                if (vertexAttribute.isColor()) {
                    objectArray = this.iattribs.get(string);
                    n3 = objectArray[n4];
                    dArray[n2++] = n3 >> 24 & 0xFF;
                    dArray[n2++] = n3 >> 16 & 0xFF;
                    dArray[n2++] = n3 >> 8 & 0xFF;
                    dArray[n2++] = n3 >> 0 & 0xFF;
                    continue;
                }
                if (vertexAttribute.isFloat()) {
                    objectArray = this.fattribs.get(string);
                    for (n3 = 0; n3 < vertexAttribute.size; ++n3) {
                        dArray[n2++] = objectArray[n4++];
                    }
                    continue;
                }
                if (vertexAttribute.isInt()) {
                    objectArray = this.iattribs.get(string);
                    for (n3 = 0; n3 < vertexAttribute.size; ++n3) {
                        dArray[n2++] = objectArray[n4++];
                    }
                    continue;
                }
                if (!vertexAttribute.isBool()) continue;
                objectArray = this.battribs.get(string);
                for (n3 = 0; n3 < vertexAttribute.size; ++n3) {
                    dArray[n2++] = objectArray[n4++];
                }
            }
            return dArray;
        }

        void expandVertices(int n) {
            float[] fArray = new float[3 * n];
            PApplet.arrayCopy(this.vertices, 0, fArray, 0, 3 * this.vertexCount);
            this.vertices = fArray;
        }

        void expandColors(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.colors, 0, nArray, 0, this.vertexCount);
            this.colors = nArray;
        }

        void expandNormals(int n) {
            float[] fArray = new float[3 * n];
            PApplet.arrayCopy(this.normals, 0, fArray, 0, 3 * this.vertexCount);
            this.normals = fArray;
        }

        void expandTexCoords(int n) {
            float[] fArray = new float[2 * n];
            PApplet.arrayCopy(this.texcoords, 0, fArray, 0, 2 * this.vertexCount);
            this.texcoords = fArray;
        }

        void expandStrokeColors(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.strokeColors, 0, nArray, 0, this.vertexCount);
            this.strokeColors = nArray;
        }

        void expandStrokeWeights(int n) {
            float[] fArray = new float[n];
            PApplet.arrayCopy(this.strokeWeights, 0, fArray, 0, this.vertexCount);
            this.strokeWeights = fArray;
        }

        void expandAmbient(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.ambient, 0, nArray, 0, this.vertexCount);
            this.ambient = nArray;
        }

        void expandSpecular(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.specular, 0, nArray, 0, this.vertexCount);
            this.specular = nArray;
        }

        void expandEmissive(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.emissive, 0, nArray, 0, this.vertexCount);
            this.emissive = nArray;
        }

        void expandShininess(int n) {
            float[] fArray = new float[n];
            PApplet.arrayCopy(this.shininess, 0, fArray, 0, this.vertexCount);
            this.shininess = fArray;
        }

        void expandAttribs(int n) {
            for (String string : this.attribs.keySet()) {
                VertexAttribute vertexAttribute = (VertexAttribute)this.attribs.get(string);
                if (vertexAttribute.type == PGL.FLOAT) {
                    this.expandFloatAttrib(vertexAttribute, n);
                    continue;
                }
                if (vertexAttribute.type == PGL.INT) {
                    this.expandIntAttrib(vertexAttribute, n);
                    continue;
                }
                if (vertexAttribute.type != PGL.BOOL) continue;
                this.expandBoolAttrib(vertexAttribute, n);
            }
        }

        void expandFloatAttrib(VertexAttribute vertexAttribute, int n) {
            float[] fArray = this.fattribs.get(vertexAttribute.name);
            float[] fArray2 = new float[vertexAttribute.size * n];
            PApplet.arrayCopy(fArray, 0, fArray2, 0, vertexAttribute.size * this.vertexCount);
            this.fattribs.put(vertexAttribute.name, fArray2);
        }

        void expandIntAttrib(VertexAttribute vertexAttribute, int n) {
            int[] nArray = this.iattribs.get(vertexAttribute.name);
            int[] nArray2 = new int[vertexAttribute.size * n];
            PApplet.arrayCopy(nArray, 0, nArray2, 0, vertexAttribute.size * this.vertexCount);
            this.iattribs.put(vertexAttribute.name, nArray2);
        }

        void expandBoolAttrib(VertexAttribute vertexAttribute, int n) {
            byte[] byArray = this.battribs.get(vertexAttribute.name);
            byte[] byArray2 = new byte[vertexAttribute.size * n];
            PApplet.arrayCopy(byArray, 0, byArray2, 0, vertexAttribute.size * this.vertexCount);
            this.battribs.put(vertexAttribute.name, byArray2);
        }

        void expandCodes(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.codes, 0, nArray, 0, this.codeCount);
            this.codes = nArray;
        }

        void expandEdges(int n) {
            int[][] nArray = new int[n][3];
            PApplet.arrayCopy(this.edges, 0, nArray, 0, this.edgeCount);
            this.edges = nArray;
        }

        void trim() {
            if (0 < this.vertexCount && this.vertexCount < this.vertices.length / 3) {
                this.trimVertices();
                this.trimColors();
                this.trimNormals();
                this.trimTexCoords();
                this.trimStrokeColors();
                this.trimStrokeWeights();
                this.trimAmbient();
                this.trimSpecular();
                this.trimEmissive();
                this.trimShininess();
                this.trimAttribs();
            }
            if (0 < this.codeCount && this.codeCount < this.codes.length) {
                this.trimCodes();
            }
            if (0 < this.edgeCount && this.edgeCount < this.edges.length) {
                this.trimEdges();
            }
        }

        void trimVertices() {
            float[] fArray = new float[3 * this.vertexCount];
            PApplet.arrayCopy(this.vertices, 0, fArray, 0, 3 * this.vertexCount);
            this.vertices = fArray;
        }

        void trimColors() {
            int[] nArray = new int[this.vertexCount];
            PApplet.arrayCopy(this.colors, 0, nArray, 0, this.vertexCount);
            this.colors = nArray;
        }

        void trimNormals() {
            float[] fArray = new float[3 * this.vertexCount];
            PApplet.arrayCopy(this.normals, 0, fArray, 0, 3 * this.vertexCount);
            this.normals = fArray;
        }

        void trimTexCoords() {
            float[] fArray = new float[2 * this.vertexCount];
            PApplet.arrayCopy(this.texcoords, 0, fArray, 0, 2 * this.vertexCount);
            this.texcoords = fArray;
        }

        void trimStrokeColors() {
            int[] nArray = new int[this.vertexCount];
            PApplet.arrayCopy(this.strokeColors, 0, nArray, 0, this.vertexCount);
            this.strokeColors = nArray;
        }

        void trimStrokeWeights() {
            float[] fArray = new float[this.vertexCount];
            PApplet.arrayCopy(this.strokeWeights, 0, fArray, 0, this.vertexCount);
            this.strokeWeights = fArray;
        }

        void trimAmbient() {
            int[] nArray = new int[this.vertexCount];
            PApplet.arrayCopy(this.ambient, 0, nArray, 0, this.vertexCount);
            this.ambient = nArray;
        }

        void trimSpecular() {
            int[] nArray = new int[this.vertexCount];
            PApplet.arrayCopy(this.specular, 0, nArray, 0, this.vertexCount);
            this.specular = nArray;
        }

        void trimEmissive() {
            int[] nArray = new int[this.vertexCount];
            PApplet.arrayCopy(this.emissive, 0, nArray, 0, this.vertexCount);
            this.emissive = nArray;
        }

        void trimShininess() {
            float[] fArray = new float[this.vertexCount];
            PApplet.arrayCopy(this.shininess, 0, fArray, 0, this.vertexCount);
            this.shininess = fArray;
        }

        void trimCodes() {
            int[] nArray = new int[this.codeCount];
            PApplet.arrayCopy(this.codes, 0, nArray, 0, this.codeCount);
            this.codes = nArray;
        }

        void trimEdges() {
            int[][] nArray = new int[this.edgeCount][3];
            PApplet.arrayCopy(this.edges, 0, nArray, 0, this.edgeCount);
            this.edges = nArray;
        }

        void trimAttribs() {
            for (String string : this.attribs.keySet()) {
                VertexAttribute vertexAttribute = (VertexAttribute)this.attribs.get(string);
                if (vertexAttribute.type == PGL.FLOAT) {
                    this.trimFloatAttrib(vertexAttribute);
                    continue;
                }
                if (vertexAttribute.type == PGL.INT) {
                    this.trimIntAttrib(vertexAttribute);
                    continue;
                }
                if (vertexAttribute.type != PGL.BOOL) continue;
                this.trimBoolAttrib(vertexAttribute);
            }
        }

        void trimFloatAttrib(VertexAttribute vertexAttribute) {
            float[] fArray = this.fattribs.get(vertexAttribute.name);
            float[] fArray2 = new float[vertexAttribute.size * this.vertexCount];
            PApplet.arrayCopy(fArray, 0, fArray2, 0, vertexAttribute.size * this.vertexCount);
            this.fattribs.put(vertexAttribute.name, fArray2);
        }

        void trimIntAttrib(VertexAttribute vertexAttribute) {
            int[] nArray = this.iattribs.get(vertexAttribute.name);
            int[] nArray2 = new int[vertexAttribute.size * this.vertexCount];
            PApplet.arrayCopy(nArray, 0, nArray2, 0, vertexAttribute.size * this.vertexCount);
            this.iattribs.put(vertexAttribute.name, nArray2);
        }

        void trimBoolAttrib(VertexAttribute vertexAttribute) {
            byte[] byArray = this.battribs.get(vertexAttribute.name);
            byte[] byArray2 = new byte[vertexAttribute.size * this.vertexCount];
            PApplet.arrayCopy(byArray, 0, byArray2, 0, vertexAttribute.size * this.vertexCount);
            this.battribs.put(vertexAttribute.name, byArray2);
        }

        int addVertex(float f, float f2, boolean bl) {
            return this.addVertex(f, f2, 0.0f, this.fillColor, this.normalX, this.normalY, this.normalZ, 0.0f, 0.0f, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininessFactor, 0, bl);
        }

        int addVertex(float f, float f2, int n, boolean bl) {
            return this.addVertex(f, f2, 0.0f, this.fillColor, this.normalX, this.normalY, this.normalZ, 0.0f, 0.0f, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininessFactor, n, bl);
        }

        int addVertex(float f, float f2, float f3, float f4, boolean bl) {
            return this.addVertex(f, f2, 0.0f, this.fillColor, this.normalX, this.normalY, this.normalZ, f3, f4, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininessFactor, 0, bl);
        }

        int addVertex(float f, float f2, float f3, float f4, int n, boolean bl) {
            return this.addVertex(f, f2, 0.0f, this.fillColor, this.normalX, this.normalY, this.normalZ, f3, f4, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininessFactor, n, bl);
        }

        int addVertex(float f, float f2, float f3, boolean bl) {
            return this.addVertex(f, f2, f3, this.fillColor, this.normalX, this.normalY, this.normalZ, 0.0f, 0.0f, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininessFactor, 0, bl);
        }

        int addVertex(float f, float f2, float f3, int n, boolean bl) {
            return this.addVertex(f, f2, f3, this.fillColor, this.normalX, this.normalY, this.normalZ, 0.0f, 0.0f, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininessFactor, n, bl);
        }

        int addVertex(float f, float f2, float f3, float f4, float f5, boolean bl) {
            return this.addVertex(f, f2, f3, this.fillColor, this.normalX, this.normalY, this.normalZ, f4, f5, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininessFactor, 0, bl);
        }

        int addVertex(float f, float f2, float f3, float f4, float f5, int n, boolean bl) {
            return this.addVertex(f, f2, f3, this.fillColor, this.normalX, this.normalY, this.normalZ, f4, f5, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininessFactor, n, bl);
        }

        int addVertex(float f, float f2, float f3, int n, float f4, float f5, float f6, float f7, float f8, int n2, float f9, int n3, int n4, int n5, float f10, int n6, boolean bl) {
            this.vertexCheck();
            int n7 = 3 * this.vertexCount;
            this.vertices[n7++] = f;
            this.vertices[n7++] = f2;
            this.vertices[n7] = f3;
            this.colors[this.vertexCount] = PGL.javaToNativeARGB(n);
            n7 = 3 * this.vertexCount;
            this.normals[n7++] = f4;
            this.normals[n7++] = f5;
            this.normals[n7] = f6;
            n7 = 2 * this.vertexCount;
            this.texcoords[n7++] = f7;
            this.texcoords[n7] = f8;
            this.strokeColors[this.vertexCount] = PGL.javaToNativeARGB(n2);
            this.strokeWeights[this.vertexCount] = f9;
            this.ambient[this.vertexCount] = PGL.javaToNativeARGB(n3);
            this.specular[this.vertexCount] = PGL.javaToNativeARGB(n4);
            this.emissive[this.vertexCount] = PGL.javaToNativeARGB(n5);
            this.shininess[this.vertexCount] = f10;
            for (String string : this.attribs.keySet()) {
                Object[] objectArray;
                VertexAttribute vertexAttribute = (VertexAttribute)this.attribs.get(string);
                n7 = vertexAttribute.size * this.vertexCount;
                if (vertexAttribute.type == PGL.FLOAT) {
                    objectArray = this.fattribs.get(string);
                    vertexAttribute.add((float[])objectArray, n7);
                    continue;
                }
                if (vertexAttribute.type == PGL.INT) {
                    objectArray = this.iattribs.get(string);
                    vertexAttribute.add((int[])objectArray, n7);
                    continue;
                }
                if (vertexAttribute.type != PGL.BOOL) continue;
                objectArray = this.battribs.get(string);
                vertexAttribute.add((byte[])objectArray, n7);
            }
            if (bl || n6 == 0 && this.codes != null || n6 == 1 || n6 == 2 || n6 == 3) {
                if (this.codes == null) {
                    this.codes = new int[PApplet.max(PGL.DEFAULT_IN_VERTICES, this.vertexCount)];
                    Arrays.fill(this.codes, 0, this.vertexCount, 0);
                    this.codeCount = this.vertexCount;
                }
                if (bl) {
                    this.codeCheck();
                    this.codes[this.codeCount] = 4;
                    ++this.codeCount;
                }
                if (n6 != -1) {
                    this.codeCheck();
                    this.codes[this.codeCount] = n6;
                    ++this.codeCount;
                }
            }
            ++this.vertexCount;
            return this.vertexCount - 1;
        }

        public void addBezierVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, boolean bl) {
            this.addVertex(f, f2, f3, 1, bl);
            this.addVertex(f4, f5, f6, -1, false);
            this.addVertex(f7, f8, f9, -1, false);
        }

        public void addQuadraticVertex(float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
            this.addVertex(f, f2, f3, 2, bl);
            this.addVertex(f4, f5, f6, -1, false);
        }

        public void addCurveVertex(float f, float f2, float f3, boolean bl) {
            this.addVertex(f, f2, f3, 3, bl);
        }

        float[][] getVertexData() {
            float[][] fArray = new float[this.vertexCount][37];
            for (int i = 0; i < this.vertexCount; ++i) {
                float[] fArray2 = fArray[i];
                fArray2[0] = this.vertices[3 * i + 0];
                fArray2[1] = this.vertices[3 * i + 1];
                fArray2[2] = this.vertices[3 * i + 2];
                fArray2[3] = (float)(this.colors[i] >> 16 & 0xFF) / 255.0f;
                fArray2[4] = (float)(this.colors[i] >> 8 & 0xFF) / 255.0f;
                fArray2[5] = (float)(this.colors[i] >> 0 & 0xFF) / 255.0f;
                fArray2[6] = (float)(this.colors[i] >> 24 & 0xFF) / 255.0f;
                fArray2[7] = this.texcoords[2 * i + 0];
                fArray2[8] = this.texcoords[2 * i + 1];
                fArray2[9] = this.normals[3 * i + 0];
                fArray2[10] = this.normals[3 * i + 1];
                fArray2[11] = this.normals[3 * i + 2];
                fArray2[13] = (float)(this.strokeColors[i] >> 16 & 0xFF) / 255.0f;
                fArray2[14] = (float)(this.strokeColors[i] >> 8 & 0xFF) / 255.0f;
                fArray2[15] = (float)(this.strokeColors[i] >> 0 & 0xFF) / 255.0f;
                fArray2[16] = (float)(this.strokeColors[i] >> 24 & 0xFF) / 255.0f;
                fArray2[17] = this.strokeWeights[i];
            }
            return fArray;
        }

        boolean hasBezierVertex() {
            for (int i = 0; i < this.codeCount; ++i) {
                if (this.codes[i] != 1) continue;
                return true;
            }
            return false;
        }

        boolean hasQuadraticVertex() {
            for (int i = 0; i < this.codeCount; ++i) {
                if (this.codes[i] != 2) continue;
                return true;
            }
            return false;
        }

        boolean hasCurveVertex() {
            for (int i = 0; i < this.codeCount; ++i) {
                if (this.codes[i] != 3) continue;
                return true;
            }
            return false;
        }

        int addEdge(int n, int n2, boolean bl, boolean bl2) {
            this.edgeCheck();
            int[] nArray = this.edges[this.edgeCount];
            nArray[0] = n;
            nArray[1] = n2;
            nArray[2] = (bl ? 1 : 0) + 2 * (bl2 ? 1 : 0);
            ++this.edgeCount;
            return this.edgeCount - 1;
        }

        int closeEdge(int n, int n2) {
            this.edgeCheck();
            int[] nArray = this.edges[this.edgeCount];
            nArray[0] = n;
            nArray[1] = n2;
            nArray[2] = -1;
            ++this.edgeCount;
            return this.edgeCount - 1;
        }

        void addTrianglesEdges() {
            for (int i = 0; i < this.vertexCount / 3; ++i) {
                int n = 3 * i + 0;
                int n2 = 3 * i + 1;
                int n3 = 3 * i + 2;
                this.addEdge(n, n2, true, false);
                this.addEdge(n2, n3, false, false);
                this.addEdge(n3, n, false, false);
                this.closeEdge(n3, n);
            }
        }

        void addTriangleFanEdges() {
            for (int i = 1; i < this.vertexCount - 1; ++i) {
                int n = 0;
                int n2 = i;
                int n3 = i + 1;
                this.addEdge(n, n2, true, false);
                this.addEdge(n2, n3, false, false);
                this.addEdge(n3, n, false, false);
                this.closeEdge(n3, n);
            }
        }

        void addTriangleStripEdges() {
            for (int i = 1; i < this.vertexCount - 1; ++i) {
                int n;
                int n2;
                int n3 = i;
                if (i % 2 == 0) {
                    n2 = i - 1;
                    n = i + 1;
                } else {
                    n2 = i + 1;
                    n = i - 1;
                }
                this.addEdge(n3, n2, true, false);
                this.addEdge(n2, n, false, false);
                this.addEdge(n, n3, false, false);
                this.closeEdge(n, n3);
            }
        }

        void addQuadsEdges() {
            for (int i = 0; i < this.vertexCount / 4; ++i) {
                int n = 4 * i + 0;
                int n2 = 4 * i + 1;
                int n3 = 4 * i + 2;
                int n4 = 4 * i + 3;
                this.addEdge(n, n2, true, false);
                this.addEdge(n2, n3, false, false);
                this.addEdge(n3, n4, false, false);
                this.addEdge(n4, n, false, false);
                this.closeEdge(n4, n);
            }
        }

        void addQuadStripEdges() {
            for (int i = 1; i < this.vertexCount / 2; ++i) {
                int n = 2 * (i - 1);
                int n2 = 2 * (i - 1) + 1;
                int n3 = 2 * i + 1;
                int n4 = 2 * i;
                this.addEdge(n, n2, true, false);
                this.addEdge(n2, n3, false, false);
                this.addEdge(n3, n4, false, false);
                this.addEdge(n4, n, false, false);
                this.closeEdge(n4, n);
            }
        }

        void calcTriangleNormal(int n, int n2, int n3) {
            int n4 = 3 * n;
            float f = this.vertices[n4++];
            float f2 = this.vertices[n4++];
            float f3 = this.vertices[n4];
            n4 = 3 * n2;
            float f4 = this.vertices[n4++];
            float f5 = this.vertices[n4++];
            float f6 = this.vertices[n4];
            n4 = 3 * n3;
            float f7 = this.vertices[n4++];
            float f8 = this.vertices[n4++];
            float f9 = this.vertices[n4];
            float f10 = f7 - f4;
            float f11 = f8 - f5;
            float f12 = f9 - f6;
            float f13 = f - f4;
            float f14 = f2 - f5;
            float f15 = f3 - f6;
            float f16 = f11 * f15 - f14 * f12;
            float f17 = f12 * f13 - f15 * f10;
            float f18 = f10 * f14 - f13 * f11;
            float f19 = PApplet.sqrt(f16 * f16 + f17 * f17 + f18 * f18);
            n4 = 3 * n;
            this.normals[n4++] = f16 /= f19;
            this.normals[n4++] = f17 /= f19;
            this.normals[n4] = f18 /= f19;
            n4 = 3 * n2;
            this.normals[n4++] = f16;
            this.normals[n4++] = f17;
            this.normals[n4] = f18;
            n4 = 3 * n3;
            this.normals[n4++] = f16;
            this.normals[n4++] = f17;
            this.normals[n4] = f18;
        }

        void calcTrianglesNormals() {
            for (int i = 0; i < this.vertexCount / 3; ++i) {
                int n = 3 * i + 0;
                int n2 = 3 * i + 1;
                int n3 = 3 * i + 2;
                this.calcTriangleNormal(n, n2, n3);
            }
        }

        void calcTriangleFanNormals() {
            for (int i = 1; i < this.vertexCount - 1; ++i) {
                int n = 0;
                int n2 = i;
                int n3 = i + 1;
                this.calcTriangleNormal(n, n2, n3);
            }
        }

        void calcTriangleStripNormals() {
            for (int i = 1; i < this.vertexCount - 1; ++i) {
                int n;
                int n2;
                int n3 = i;
                if (i % 2 == 1) {
                    n2 = i - 1;
                    n = i + 1;
                } else {
                    n2 = i + 1;
                    n = i - 1;
                }
                this.calcTriangleNormal(n2, n3, n);
            }
        }

        void calcQuadsNormals() {
            for (int i = 0; i < this.vertexCount / 4; ++i) {
                int n = 4 * i + 0;
                int n2 = 4 * i + 1;
                int n3 = 4 * i + 2;
                int n4 = 4 * i + 3;
                this.calcTriangleNormal(n, n2, n3);
                this.calcTriangleNormal(n3, n4, n);
            }
        }

        void calcQuadStripNormals() {
            for (int i = 1; i < this.vertexCount / 2; ++i) {
                int n = 2 * (i - 1);
                int n2 = 2 * (i - 1) + 1;
                int n3 = 2 * i;
                int n4 = 2 * i + 1;
                this.calcTriangleNormal(n, n2, n3);
                this.calcTriangleNormal(n3, n2, n4);
            }
        }

        void setMaterial(int n, int n2, float f, int n3, int n4, int n5, float f2) {
            this.fillColor = n;
            this.strokeColor = n2;
            this.strokeWeight = f;
            this.ambientColor = n3;
            this.specularColor = n4;
            this.emissiveColor = n5;
            this.shininessFactor = f2;
        }

        void setNormal(float f, float f2, float f3) {
            this.normalX = f;
            this.normalY = f2;
            this.normalZ = f3;
        }

        void addPoint(float f, float f2, float f3, boolean bl, boolean bl2) {
            this.addVertex(f, f2, f3, 0, true);
        }

        void addLine(float f, float f2, float f3, float f4, float f5, float f6, boolean bl, boolean bl2) {
            int n = this.addVertex(f, f2, f3, 0, true);
            int n2 = this.addVertex(f4, f5, f6, 0, false);
            if (bl2) {
                this.addEdge(n, n2, true, true);
            }
        }

        void addTriangle(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, boolean bl, boolean bl2) {
            int n = this.addVertex(f, f2, f3, 0, true);
            int n2 = this.addVertex(f4, f5, f6, 0, false);
            int n3 = this.addVertex(f7, f8, f9, 0, false);
            if (bl2) {
                this.addEdge(n, n2, true, false);
                this.addEdge(n2, n3, false, false);
                this.addEdge(n3, n, false, false);
                this.closeEdge(n3, n);
            }
        }

        void addQuad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, boolean bl) {
            int n = this.addVertex(f, f2, f3, 0.0f, 0.0f, 0, true);
            int n2 = this.addVertex(f4, f5, f6, 1.0f, 0.0f, 0, false);
            int n3 = this.addVertex(f7, f8, f9, 1.0f, 1.0f, 0, false);
            int n4 = this.addVertex(f10, f11, f12, 0.0f, 1.0f, 0, false);
            if (bl) {
                this.addEdge(n, n2, true, false);
                this.addEdge(n2, n3, false, false);
                this.addEdge(n3, n4, false, false);
                this.addEdge(n4, n, false, false);
                this.closeEdge(n4, n);
            }
        }

        void addRect(float f, float f2, float f3, float f4, boolean bl) {
            this.addQuad(f, f2, 0.0f, f3, f2, 0.0f, f3, f4, 0.0f, f, f4, 0.0f, bl);
        }

        void addRect(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, boolean bl) {
            if (PGraphicsOpenGL.nonZero(f6)) {
                this.addVertex(f3 - f6, f2, 0, true);
                this.addQuadraticVertex(f3, f2, 0.0f, f3, f2 + f6, 0.0f, false);
            } else {
                this.addVertex(f3, f2, 0, true);
            }
            if (PGraphicsOpenGL.nonZero(f7)) {
                this.addVertex(f3, f4 - f7, 0, false);
                this.addQuadraticVertex(f3, f4, 0.0f, f3 - f7, f4, 0.0f, false);
            } else {
                this.addVertex(f3, f4, 0, false);
            }
            if (PGraphicsOpenGL.nonZero(f8)) {
                this.addVertex(f + f8, f4, 0, false);
                this.addQuadraticVertex(f, f4, 0.0f, f, f4 - f8, 0.0f, false);
            } else {
                this.addVertex(f, f4, 0, false);
            }
            if (PGraphicsOpenGL.nonZero(f5)) {
                this.addVertex(f, f2 + f5, 0, false);
                this.addQuadraticVertex(f, f2, 0.0f, f + f5, f2, 0.0f, false);
            } else {
                this.addVertex(f, f2, 0, false);
            }
        }

        void addEllipse(float f, float f2, float f3, float f4, boolean bl, boolean bl2) {
            float f5 = f3 / 2.0f;
            float f6 = f4 / 2.0f;
            float f7 = f + f5;
            float f8 = f2 + f6;
            float f9 = this.pg.screenX(f, f2);
            float f10 = this.pg.screenY(f, f2);
            float f11 = this.pg.screenX(f + f3, f2 + f4);
            float f12 = this.pg.screenY(f + f3, f2 + f4);
            int n = PApplet.min(200, PApplet.max(20, (int)((float)Math.PI * 2 * PApplet.dist(f9, f10, f11, f12) / 10.0f)));
            float f13 = 720.0f / (float)n;
            if (bl) {
                this.addVertex(f7, f8, 0, true);
            }
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            float f14 = 0.0f;
            for (int i = 0; i < n; ++i) {
                n2 = this.addVertex(f7 + cosLUT[(int)f14] * f5, f8 + sinLUT[(int)f14] * f6, 0, i == 0 && !bl);
                f14 = (f14 + f13) % 720.0f;
                if (0 < i) {
                    if (bl2) {
                        this.addEdge(n3, n2, i == 1, false);
                    }
                } else {
                    n4 = n2;
                }
                n3 = n2;
            }
            this.addVertex(f7 + cosLUT[0] * f5, f8 + sinLUT[0] * f6, 0, false);
            if (bl2) {
                this.addEdge(n2, n4, false, false);
                this.closeEdge(n2, n4);
            }
        }

        void addArc(float f, float f2, float f3, float f4, float f5, float f6, boolean bl, boolean bl2, int n) {
            int n2;
            int n3;
            float f7;
            boolean bl3;
            float f8 = f3 / 2.0f;
            float f9 = f4 / 2.0f;
            float f10 = f + f8;
            float f11 = f2 + f9;
            int n4 = (int)(0.5f + f6 / ((float)Math.PI * 2) * 720.0f);
            int n5 = (int)(0.5f + f5 / ((float)Math.PI * 2) * 720.0f);
            int n6 = PApplet.constrain(n4 - n5, 0, 720);
            boolean bl4 = bl3 = n6 == 720;
            if (bl3 && n == 2) {
                --n6;
                --n4;
            }
            if ((n5 %= 720) < 0) {
                n5 += 720;
            }
            if ((n4 %= 720) < 0) {
                n4 += 720;
            }
            if (n == 2 || n == 1) {
                float f12 = (cosLUT[n5] + cosLUT[n4]) * 0.5f * f8;
                f7 = (sinLUT[n5] + sinLUT[n4]) * 0.5f * f9;
                n3 = this.addVertex(f10 + f12, f11 + f7, 0, true);
            } else {
                n3 = this.addVertex(f10, f11, 0, true);
            }
            f7 = this.pg.screenX(f, f2);
            float f13 = this.pg.screenY(f, f2);
            float f14 = this.pg.screenX(f + f3, f2 + f4);
            float f15 = this.pg.screenY(f + f3, f2 + f4);
            int n7 = PApplet.min(200, PApplet.max(20, (int)((float)Math.PI * 2 * PApplet.dist(f7, f13, f14, f15) / 10.0f)));
            int n8 = PApplet.max(1, 720 / n7);
            int n9 = n3;
            int n10 = -n8;
            do {
                n10 += n8;
                int n11 = n5 + (n10 = PApplet.min(n10, n6));
                if (n11 >= 720) {
                    n11 -= 720;
                }
                n2 = n9;
                n9 = this.addVertex(f10 + cosLUT[n11] * f8, f11 + sinLUT[n11] * f9, 0, n10 == 0 && !bl);
                if (!bl2) continue;
                if (n == 2 || n == 3) {
                    this.addEdge(n2, n9, n10 == 0, false);
                    continue;
                }
                if (0 >= n10) continue;
                this.addEdge(n2, n9, n10 == PApplet.min(n8, n6), n10 == n6 && !bl3);
            } while (n10 < n6);
            if (bl2) {
                if (n == 2 || n == 3) {
                    this.addEdge(n9, n3, false, false);
                    this.closeEdge(n9, n3);
                } else if (bl3) {
                    this.closeEdge(n2, n9);
                }
            }
        }

        void addBox(float f, float f2, float f3, boolean bl, boolean bl2) {
            boolean bl3 = f2 > 0.0f != f3 > 0.0f;
            boolean bl4 = f > 0.0f != f3 > 0.0f;
            boolean bl5 = f > 0.0f != f2 > 0.0f;
            int n = bl3 ? -1 : 1;
            int n2 = bl4 ? -1 : 1;
            int n3 = bl5 ? -1 : 1;
            float f4 = -f / 2.0f;
            float f5 = f / 2.0f;
            float f6 = -f2 / 2.0f;
            float f7 = f2 / 2.0f;
            float f8 = -f3 / 2.0f;
            float f9 = f3 / 2.0f;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            if (bl || bl2) {
                this.setNormal(0.0f, 0.0f, -n3);
                n4 = this.addVertex(f4, f6, f8, 0.0f, 0.0f, 0, true);
                n5 = this.addVertex(f4, f7, f8, 0.0f, 1.0f, 0, false);
                n6 = this.addVertex(f5, f7, f8, 1.0f, 1.0f, 0, false);
                n7 = this.addVertex(f5, f6, f8, 1.0f, 0.0f, 0, false);
                if (bl2) {
                    this.addEdge(n4, n5, true, false);
                    this.addEdge(n5, n6, false, false);
                    this.addEdge(n6, n7, false, false);
                    this.addEdge(n7, n4, false, false);
                    this.closeEdge(n7, n4);
                }
                this.setNormal(0.0f, 0.0f, n3);
                n4 = this.addVertex(f4, f7, f9, 1.0f, 1.0f, 0, false);
                n5 = this.addVertex(f4, f6, f9, 1.0f, 0.0f, 0, false);
                n6 = this.addVertex(f5, f6, f9, 0.0f, 0.0f, 0, false);
                n7 = this.addVertex(f5, f7, f9, 0.0f, 1.0f, 0, false);
                if (bl2) {
                    this.addEdge(n4, n5, true, false);
                    this.addEdge(n5, n6, false, false);
                    this.addEdge(n6, n7, false, false);
                    this.addEdge(n7, n4, false, false);
                    this.closeEdge(n7, n4);
                }
                this.setNormal(n, 0.0f, 0.0f);
                n4 = this.addVertex(f5, f6, f8, 0.0f, 0.0f, 0, false);
                n5 = this.addVertex(f5, f7, f8, 0.0f, 1.0f, 0, false);
                n6 = this.addVertex(f5, f7, f9, 1.0f, 1.0f, 0, false);
                n7 = this.addVertex(f5, f6, f9, 1.0f, 0.0f, 0, false);
                if (bl2) {
                    this.addEdge(n4, n5, true, false);
                    this.addEdge(n5, n6, false, false);
                    this.addEdge(n6, n7, false, false);
                    this.addEdge(n7, n4, false, false);
                    this.closeEdge(n7, n4);
                }
                this.setNormal(-n, 0.0f, 0.0f);
                n4 = this.addVertex(f4, f7, f8, 1.0f, 1.0f, 0, false);
                n5 = this.addVertex(f4, f6, f8, 1.0f, 0.0f, 0, false);
                n6 = this.addVertex(f4, f6, f9, 0.0f, 0.0f, 0, false);
                n7 = this.addVertex(f4, f7, f9, 0.0f, 1.0f, 0, false);
                if (bl2) {
                    this.addEdge(n4, n5, true, false);
                    this.addEdge(n5, n6, false, false);
                    this.addEdge(n6, n7, false, false);
                    this.addEdge(n7, n4, false, false);
                    this.closeEdge(n7, n4);
                }
                this.setNormal(0.0f, -n2, 0.0f);
                n4 = this.addVertex(f5, f6, f8, 1.0f, 1.0f, 0, false);
                n5 = this.addVertex(f5, f6, f9, 1.0f, 0.0f, 0, false);
                n6 = this.addVertex(f4, f6, f9, 0.0f, 0.0f, 0, false);
                n7 = this.addVertex(f4, f6, f8, 0.0f, 1.0f, 0, false);
                if (bl2) {
                    this.addEdge(n4, n5, true, false);
                    this.addEdge(n5, n6, false, false);
                    this.addEdge(n6, n7, false, false);
                    this.addEdge(n7, n4, false, false);
                    this.closeEdge(n7, n4);
                }
                this.setNormal(0.0f, n2, 0.0f);
                n4 = this.addVertex(f4, f7, f8, 0.0f, 0.0f, 0, false);
                n5 = this.addVertex(f4, f7, f9, 0.0f, 1.0f, 0, false);
                n6 = this.addVertex(f5, f7, f9, 1.0f, 1.0f, 0, false);
                n7 = this.addVertex(f5, f7, f8, 1.0f, 0.0f, 0, false);
                if (bl2) {
                    this.addEdge(n4, n5, true, false);
                    this.addEdge(n5, n6, false, false);
                    this.addEdge(n6, n7, false, false);
                    this.addEdge(n7, n4, false, false);
                    this.closeEdge(n7, n4);
                }
            }
        }

        int[] addSphere(float f, int n, int n2, boolean bl, boolean bl2) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7 = 3 * n + (6 * n + 3) * (n2 - 2) + 3 * n;
            int[] nArray = new int[n7];
            int n8 = 0;
            int n9 = 0;
            float f2 = 1.0f / (float)n;
            float f3 = 1.0f / (float)n2;
            float f4 = 1.0f;
            float f5 = 1.0f;
            for (n6 = 0; n6 < n; ++n6) {
                this.setNormal(0.0f, 1.0f, 0.0f);
                this.addVertex(0.0f, f, 0.0f, f4, f5, 0, true);
                f4 -= f2;
            }
            int n10 = n8 = n;
            f4 = 1.0f;
            f5 -= f3;
            for (n6 = 0; n6 < n; ++n6) {
                this.setNormal(this.pg.sphereX[n6], this.pg.sphereY[n6], this.pg.sphereZ[n6]);
                this.addVertex(f * this.pg.sphereX[n6], f * this.pg.sphereY[n6], f * this.pg.sphereZ[n6], f4, f5, 0, false);
                f4 -= f2;
            }
            n8 += n;
            int n11 = n8++;
            this.setNormal(this.pg.sphereX[0], this.pg.sphereY[0], this.pg.sphereZ[0]);
            this.addVertex(f * this.pg.sphereX[0], f * this.pg.sphereY[0], f * this.pg.sphereZ[0], f4, f5, 0, false);
            for (n6 = 0; n6 < n; ++n6) {
                n5 = n10 + n6;
                n4 = n10 + n6 - n;
                nArray[3 * n6 + 0] = n5;
                nArray[3 * n6 + 1] = n4;
                nArray[3 * n6 + 2] = n5 + 1;
                this.addEdge(n4, n5, true, true);
                this.addEdge(n5, n5 + 1, true, true);
            }
            n9 += 3 * n;
            n6 = 0;
            for (n5 = 2; n5 < n2; ++n5) {
                n6 += n;
                n10 = n8;
                f4 = 1.0f;
                f5 -= f3;
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n6 + n4;
                    this.setNormal(this.pg.sphereX[n3], this.pg.sphereY[n3], this.pg.sphereZ[n3]);
                    this.addVertex(f * this.pg.sphereX[n3], f * this.pg.sphereY[n3], f * this.pg.sphereZ[n3], f4, f5, 0, false);
                    f4 -= f2;
                }
                n8 += n;
                n11 = n8++;
                this.setNormal(this.pg.sphereX[n6], this.pg.sphereY[n6], this.pg.sphereZ[n6]);
                this.addVertex(f * this.pg.sphereX[n6], f * this.pg.sphereY[n6], f * this.pg.sphereZ[n6], f4, f5, 0, false);
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n10 + n4;
                    int n12 = n10 + n4 - n - 1;
                    nArray[n9 + 6 * n4 + 0] = n3;
                    nArray[n9 + 6 * n4 + 1] = n12;
                    nArray[n9 + 6 * n4 + 2] = n12 + 1;
                    nArray[n9 + 6 * n4 + 3] = n3;
                    nArray[n9 + 6 * n4 + 4] = n12 + 1;
                    nArray[n9 + 6 * n4 + 5] = n3 + 1;
                    this.addEdge(n12, n3, true, true);
                    this.addEdge(n3, n3 + 1, true, true);
                    this.addEdge(n12 + 1, n3, true, true);
                }
                nArray[(n9 += 6 * n) + 0] = n11;
                nArray[n9 + 1] = n11 - n;
                nArray[n9 + 2] = n11 - 1;
                n9 += 3;
            }
            f4 = 1.0f;
            f5 = 0.0f;
            for (n5 = 0; n5 < n; ++n5) {
                this.setNormal(0.0f, -1.0f, 0.0f);
                this.addVertex(0.0f, -f, 0.0f, f4, f5, 0, false);
                f4 -= f2;
            }
            n8 += n;
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n10 + n5;
                nArray[n9 + 3 * n5 + 0] = n3 = n10 + n5 + n + 1;
                nArray[n9 + 3 * n5 + 1] = n4;
                nArray[n9 + 3 * n5 + 2] = n4 + 1;
                this.addEdge(n4, n4 + 1, true, true);
                this.addEdge(n4, n3, true, true);
            }
            n9 += 3 * n;
            return nArray;
        }
    }

    protected static class IndexCache {
        int size;
        int[] indexCount;
        int[] indexOffset;
        int[] vertexCount;
        int[] vertexOffset;
        int[] counter;

        IndexCache() {
            this.allocate();
        }

        void allocate() {
            this.size = 0;
            this.indexCount = new int[2];
            this.indexOffset = new int[2];
            this.vertexCount = new int[2];
            this.vertexOffset = new int[2];
            this.counter = null;
        }

        void clear() {
            this.size = 0;
        }

        int addNew() {
            this.arrayCheck();
            this.init(this.size);
            ++this.size;
            return this.size - 1;
        }

        int addNew(int n) {
            this.arrayCheck();
            this.indexCount[this.size] = this.indexCount[n];
            this.indexOffset[this.size] = this.indexOffset[n];
            this.vertexCount[this.size] = this.vertexCount[n];
            this.vertexOffset[this.size] = this.vertexOffset[n];
            ++this.size;
            return this.size - 1;
        }

        int getLast() {
            if (this.size == 0) {
                this.arrayCheck();
                this.init(0);
                this.size = 1;
            }
            return this.size - 1;
        }

        void setCounter(int[] nArray) {
            this.counter = nArray;
        }

        void incCounts(int n, int n2, int n3) {
            int n4 = n;
            this.indexCount[n4] = this.indexCount[n4] + n2;
            int n5 = n;
            this.vertexCount[n5] = this.vertexCount[n5] + n3;
            if (this.counter != null) {
                this.counter[0] = this.counter[0] + n2;
                this.counter[1] = this.counter[1] + n3;
            }
        }

        void init(int n) {
            if (0 < n) {
                this.indexOffset[n] = this.indexOffset[n - 1] + this.indexCount[n - 1];
                this.vertexOffset[n] = this.vertexOffset[n - 1] + this.vertexCount[n - 1];
            } else {
                this.indexOffset[n] = 0;
                this.vertexOffset[n] = 0;
            }
            this.indexCount[n] = 0;
            this.vertexCount[n] = 0;
        }

        void arrayCheck() {
            if (this.size == this.indexCount.length) {
                int n = this.size << 1;
                this.expandIndexCount(n);
                this.expandIndexOffset(n);
                this.expandVertexCount(n);
                this.expandVertexOffset(n);
            }
        }

        void expandIndexCount(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.indexCount, 0, nArray, 0, this.size);
            this.indexCount = nArray;
        }

        void expandIndexOffset(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.indexOffset, 0, nArray, 0, this.size);
            this.indexOffset = nArray;
        }

        void expandVertexCount(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.vertexCount, 0, nArray, 0, this.size);
            this.vertexCount = nArray;
        }

        void expandVertexOffset(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.vertexOffset, 0, nArray, 0, this.size);
            this.vertexOffset = nArray;
        }
    }

    protected static class TexCache {
        PGraphicsOpenGL pg;
        int size;
        PImage[] textures;
        int[] firstIndex;
        int[] lastIndex;
        int[] firstCache;
        int[] lastCache;
        boolean hasTextures;

        TexCache(PGraphicsOpenGL pGraphicsOpenGL) {
            this.pg = pGraphicsOpenGL;
            this.allocate();
        }

        void allocate() {
            this.textures = new PImage[PGL.DEFAULT_IN_TEXTURES];
            this.firstIndex = new int[PGL.DEFAULT_IN_TEXTURES];
            this.lastIndex = new int[PGL.DEFAULT_IN_TEXTURES];
            this.firstCache = new int[PGL.DEFAULT_IN_TEXTURES];
            this.lastCache = new int[PGL.DEFAULT_IN_TEXTURES];
            this.size = 0;
            this.hasTextures = false;
        }

        void clear() {
            Arrays.fill(this.textures, 0, this.size, null);
            this.size = 0;
            this.hasTextures = false;
        }

        boolean containsTexture(PImage pImage) {
            for (int i = 0; i < this.size; ++i) {
                if (this.textures[i] != pImage) continue;
                return true;
            }
            return false;
        }

        PImage getTextureImage(int n) {
            return this.textures[n];
        }

        Texture getTexture(int n) {
            PImage pImage = this.textures[n];
            Texture texture = null;
            if (pImage != null) {
                texture = this.pg.getTexture(pImage);
            }
            return texture;
        }

        void addTexture(PImage pImage, int n, int n2, int n3, int n4) {
            this.arrayCheck();
            this.textures[this.size] = pImage;
            this.firstIndex[this.size] = n;
            this.lastIndex[this.size] = n3;
            this.firstCache[this.size] = n2;
            this.lastCache[this.size] = n4;
            this.hasTextures |= pImage != null;
            ++this.size;
        }

        void setLastIndex(int n, int n2) {
            this.lastIndex[this.size - 1] = n;
            this.lastCache[this.size - 1] = n2;
        }

        void arrayCheck() {
            if (this.size == this.textures.length) {
                int n = this.size << 1;
                this.expandTextures(n);
                this.expandFirstIndex(n);
                this.expandLastIndex(n);
                this.expandFirstCache(n);
                this.expandLastCache(n);
            }
        }

        void expandTextures(int n) {
            PImage[] pImageArray = new PImage[n];
            PApplet.arrayCopy(this.textures, 0, pImageArray, 0, this.size);
            this.textures = pImageArray;
        }

        void expandFirstIndex(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.firstIndex, 0, nArray, 0, this.size);
            this.firstIndex = nArray;
        }

        void expandLastIndex(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.lastIndex, 0, nArray, 0, this.size);
            this.lastIndex = nArray;
        }

        void expandFirstCache(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.firstCache, 0, nArray, 0, this.size);
            this.firstCache = nArray;
        }

        void expandLastCache(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.lastCache, 0, nArray, 0, this.size);
            this.lastCache = nArray;
        }
    }

    protected static class VertexAttribute {
        static final int POSITION = 0;
        static final int NORMAL = 1;
        static final int COLOR = 2;
        static final int OTHER = 3;
        PGraphicsOpenGL pg;
        String name;
        int kind;
        int type;
        int size;
        int tessSize;
        int elementSize;
        VertexBuffer buf;
        int glLoc;
        float[] fvalues;
        int[] ivalues;
        byte[] bvalues;
        boolean modified;
        int firstModified;
        int lastModified;
        boolean active;

        VertexAttribute(PGraphicsOpenGL pGraphicsOpenGL, String string, int n, int n2, int n3) {
            this.pg = pGraphicsOpenGL;
            this.name = string;
            this.kind = n;
            this.type = n2;
            this.size = n3;
            this.tessSize = n == 0 ? 4 : n3;
            if (n2 == PGL.FLOAT) {
                this.elementSize = PGL.SIZEOF_FLOAT;
                this.fvalues = new float[n3];
            } else if (n2 == PGL.INT) {
                this.elementSize = PGL.SIZEOF_INT;
                this.ivalues = new int[n3];
            } else if (n2 == PGL.BOOL) {
                this.elementSize = PGL.SIZEOF_INT;
                this.bvalues = new byte[n3];
            }
            this.buf = null;
            this.glLoc = -1;
            this.modified = false;
            this.firstModified = Integer.MAX_VALUE;
            this.lastModified = Integer.MIN_VALUE;
            this.active = true;
        }

        public boolean diff(VertexAttribute vertexAttribute) {
            return !this.name.equals(vertexAttribute.name) || this.kind != vertexAttribute.kind || this.type != vertexAttribute.type || this.size != vertexAttribute.size || this.tessSize != vertexAttribute.tessSize || this.elementSize != vertexAttribute.elementSize;
        }

        boolean isPosition() {
            return this.kind == 0;
        }

        boolean isNormal() {
            return this.kind == 1;
        }

        boolean isColor() {
            return this.kind == 2;
        }

        boolean isOther() {
            return this.kind == 3;
        }

        boolean isFloat() {
            return this.type == PGL.FLOAT;
        }

        boolean isInt() {
            return this.type == PGL.INT;
        }

        boolean isBool() {
            return this.type == PGL.BOOL;
        }

        boolean bufferCreated() {
            return this.buf != null && 0 < this.buf.glId;
        }

        void createBuffer(PGL pGL) {
            this.buf = new VertexBuffer(this.pg, PGL.ARRAY_BUFFER, this.size, this.elementSize, false);
        }

        void deleteBuffer(PGL pGL) {
            if (this.buf.glId != 0) {
                intBuffer.put(0, this.buf.glId);
                if (pGL.threadIsCurrent()) {
                    pGL.deleteBuffers(1, intBuffer);
                }
            }
        }

        void bind(PGL pGL) {
            pGL.enableVertexAttribArray(this.glLoc);
        }

        void unbind(PGL pGL) {
            pGL.disableVertexAttribArray(this.glLoc);
        }

        boolean active(PShader pShader) {
            if (this.active && this.glLoc == -1) {
                this.glLoc = pShader.getAttributeLoc(this.name);
                if (this.glLoc == -1) {
                    this.active = false;
                }
            }
            return this.active;
        }

        int sizeInBytes(int n) {
            return n * this.tessSize * this.elementSize;
        }

        void set(float f, float f2, float f3) {
            this.fvalues[0] = f;
            this.fvalues[1] = f2;
            this.fvalues[2] = f3;
        }

        void set(int n) {
            this.ivalues[0] = n;
        }

        void set(float[] fArray) {
            PApplet.arrayCopy(fArray, 0, this.fvalues, 0, this.size);
        }

        void set(int[] nArray) {
            PApplet.arrayCopy(nArray, 0, this.ivalues, 0, this.size);
        }

        void set(boolean[] blArray) {
            for (int i = 0; i < blArray.length; ++i) {
                this.bvalues[i] = (byte)(blArray[i] ? 1 : 0);
            }
        }

        void add(float[] fArray, int n) {
            PApplet.arrayCopy(this.fvalues, 0, fArray, n, this.size);
        }

        void add(int[] nArray, int n) {
            PApplet.arrayCopy(this.ivalues, 0, nArray, n, this.size);
        }

        void add(byte[] byArray, int n) {
            PApplet.arrayCopy(this.bvalues, 0, byArray, n, this.size);
        }
    }

    protected static class AttributeMap
    extends HashMap<String, VertexAttribute> {
        public ArrayList<String> names = new ArrayList();
        public int numComp = 0;

        protected AttributeMap() {
        }

        @Override
        public VertexAttribute put(String string, VertexAttribute vertexAttribute) {
            VertexAttribute vertexAttribute2 = super.put(string, vertexAttribute);
            this.names.add(string);
            this.numComp = vertexAttribute.kind == 2 ? (this.numComp += 4) : (this.numComp += vertexAttribute.size);
            return vertexAttribute2;
        }

        public VertexAttribute get(int n) {
            return (VertexAttribute)super.get(this.names.get(n));
        }
    }

    protected class AsyncPixelReader {
        static final int OPENGL_NATIVE = -1;
        static final int OPENGL_NATIVE_OPAQUE = -2;
        static final int BUFFER_COUNT = 3;
        int[] pbos;
        long[] fences;
        String[] filenames;
        int[] widths;
        int[] heights;
        int head;
        int tail;
        int size;
        boolean supportsAsyncTransfers;
        boolean calledThisFrame;

        public AsyncPixelReader() {
            boolean bl = this.supportsAsyncTransfers = PGraphicsOpenGL.this.pgl.hasPBOs() && PGraphicsOpenGL.this.pgl.hasSynchronization();
            if (this.supportsAsyncTransfers) {
                this.pbos = new int[3];
                this.fences = new long[3];
                this.filenames = new String[3];
                this.widths = new int[3];
                this.heights = new int[3];
                IntBuffer intBuffer = PGL.allocateIntBuffer(3);
                intBuffer.rewind();
                PGraphicsOpenGL.this.pgl.genBuffers(3, intBuffer);
                for (int i = 0; i < 3; ++i) {
                    this.pbos[i] = intBuffer.get(i);
                }
            }
        }

        public void dispose() {
            if (this.fences != null) {
                while (this.size > 0) {
                    PGraphicsOpenGL.this.pgl.deleteSync(this.fences[this.tail]);
                    --this.size;
                    this.tail = (this.tail + 1) % 3;
                }
                this.fences = null;
            }
            if (this.pbos != null) {
                for (int i = 0; i < 3; ++i) {
                    IntBuffer intBuffer = PGL.allocateIntBuffer(this.pbos);
                    PGraphicsOpenGL.this.pgl.deleteBuffers(3, intBuffer);
                }
                this.pbos = null;
            }
            this.filenames = null;
            this.widths = null;
            this.heights = null;
            this.size = 0;
            this.head = 0;
            this.tail = 0;
            this.calledThisFrame = false;
            ongoingPixelTransfers.remove(this);
        }

        public void readAndSaveAsync(String string) {
            if (this.size > 0) {
                boolean bl;
                boolean bl2 = bl = this.size == 3;
                if (!bl) {
                    bl = this.isLastTransferComplete();
                }
                if (bl) {
                    this.endTransfer();
                }
            } else {
                ongoingPixelTransfers.add(this);
            }
            this.beginTransfer(string);
            this.calledThisFrame = true;
        }

        public void completeFinishedTransfers() {
            if (this.size <= 0 || !asyncImageSaver.hasAvailableTarget()) {
                return;
            }
            boolean bl = false;
            if (!PGraphicsOpenGL.this.drawing) {
                PGraphicsOpenGL.this.beginDraw();
                bl = true;
            }
            while (asyncImageSaver.hasAvailableTarget() && this.isLastTransferComplete()) {
                this.endTransfer();
            }
            if (this.size <= 0) {
                ongoingPixelTransfers.remove(this);
            }
            if (bl) {
                PGraphicsOpenGL.this.endDraw();
            }
        }

        protected void completeAllTransfers() {
            if (this.size <= 0) {
                return;
            }
            boolean bl = false;
            if (!PGraphicsOpenGL.this.drawing) {
                PGraphicsOpenGL.this.beginDraw();
                bl = true;
            }
            while (this.size > 0) {
                this.endTransfer();
            }
            ongoingPixelTransfers.remove(this);
            if (bl) {
                PGraphicsOpenGL.this.endDraw();
            }
        }

        public boolean isLastTransferComplete() {
            if (this.size <= 0) {
                return false;
            }
            int n = PGraphicsOpenGL.this.pgl.clientWaitSync(this.fences[this.tail], 0, 0L);
            return n == PGL.ALREADY_SIGNALED || n == PGL.CONDITION_SATISFIED;
        }

        public void beginTransfer(String string) {
            if (this.widths[this.head] != PGraphicsOpenGL.this.pixelWidth || this.heights[this.head] != PGraphicsOpenGL.this.pixelHeight) {
                if (this.widths[this.head] * this.heights[this.head] != PGraphicsOpenGL.this.pixelWidth * PGraphicsOpenGL.this.pixelHeight) {
                    PGraphicsOpenGL.this.pgl.bindBuffer(PGL.PIXEL_PACK_BUFFER, this.pbos[this.head]);
                    PGraphicsOpenGL.this.pgl.bufferData(PGL.PIXEL_PACK_BUFFER, 4 * PGraphicsOpenGL.this.pixelWidth * PGraphicsOpenGL.this.pixelHeight, null, PGL.STREAM_READ);
                }
                this.widths[this.head] = PGraphicsOpenGL.this.pixelWidth;
                this.heights[this.head] = PGraphicsOpenGL.this.pixelHeight;
                PGraphicsOpenGL.this.pgl.bindBuffer(PGL.PIXEL_PACK_BUFFER, 0);
            }
            PGraphicsOpenGL.this.pgl.bindBuffer(PGL.PIXEL_PACK_BUFFER, this.pbos[this.head]);
            PGraphicsOpenGL.this.pgl.readPixels(0, 0, PGraphicsOpenGL.this.pixelWidth, PGraphicsOpenGL.this.pixelHeight, PGL.RGBA, PGL.UNSIGNED_BYTE, 0L);
            PGraphicsOpenGL.this.pgl.bindBuffer(PGL.PIXEL_PACK_BUFFER, 0);
            this.fences[this.head] = PGraphicsOpenGL.this.pgl.fenceSync(PGL.SYNC_GPU_COMMANDS_COMPLETE, 0);
            this.filenames[this.head] = string;
            this.head = (this.head + 1) % 3;
            ++this.size;
        }

        public void endTransfer() {
            PGraphicsOpenGL.this.pgl.deleteSync(this.fences[this.tail]);
            PGraphicsOpenGL.this.pgl.bindBuffer(PGL.PIXEL_PACK_BUFFER, this.pbos[this.tail]);
            ByteBuffer byteBuffer = PGraphicsOpenGL.this.pgl.mapBuffer(PGL.PIXEL_PACK_BUFFER, PGL.READ_ONLY);
            if (byteBuffer != null) {
                int n = PGraphicsOpenGL.this.primaryGraphics ? -2 : -1;
                PImage pImage = asyncImageSaver.getAvailableTarget(this.widths[this.tail], this.heights[this.tail], n);
                if (pImage == null) {
                    return;
                }
                byteBuffer.rewind();
                byteBuffer.asIntBuffer().get(pImage.pixels);
                PGraphicsOpenGL.this.pgl.unmapBuffer(PGL.PIXEL_PACK_BUFFER);
                asyncImageSaver.saveTargetAsync(PGraphicsOpenGL.this, pImage, this.filenames[this.tail]);
            }
            PGraphicsOpenGL.this.pgl.bindBuffer(PGL.PIXEL_PACK_BUFFER, 0);
            --this.size;
            this.tail = (this.tail + 1) % 3;
        }
    }

    protected static class GLResourceFrameBuffer
    extends WeakReference<FrameBuffer> {
        int glFbo;
        int glDepth;
        int glStencil;
        int glDepthStencil;
        int glMultisample;
        private PGL pgl;
        private int context;
        private static ReferenceQueue<FrameBuffer> refQueue = new ReferenceQueue();
        private static List<GLResourceFrameBuffer> refList = new ArrayList<GLResourceFrameBuffer>();

        static void drainRefQueueBounded() {
            GLResourceFrameBuffer gLResourceFrameBuffer;
            ReferenceQueue<FrameBuffer> referenceQueue = GLResourceFrameBuffer.referenceQueue();
            for (int i = 0; i < 10 && (gLResourceFrameBuffer = (GLResourceFrameBuffer)referenceQueue.poll()) != null; ++i) {
                gLResourceFrameBuffer.dispose();
            }
        }

        static ReferenceQueue<FrameBuffer> referenceQueue() {
            return refQueue;
        }

        public GLResourceFrameBuffer(FrameBuffer frameBuffer) {
            super(frameBuffer, refQueue);
            GLResourceFrameBuffer.drainRefQueueBounded();
            this.pgl = frameBuffer.pg.getPrimaryPGL();
            if (!frameBuffer.screenFb) {
                this.pgl.genFramebuffers(1, intBuffer);
                frameBuffer.glFbo = intBuffer.get(0);
                if (frameBuffer.multisample) {
                    this.pgl.genRenderbuffers(1, intBuffer);
                    frameBuffer.glMultisample = intBuffer.get(0);
                }
                if (frameBuffer.packedDepthStencil) {
                    this.pgl.genRenderbuffers(1, intBuffer);
                    frameBuffer.glDepthStencil = intBuffer.get(0);
                } else {
                    if (0 < frameBuffer.depthBits) {
                        this.pgl.genRenderbuffers(1, intBuffer);
                        frameBuffer.glDepth = intBuffer.get(0);
                    }
                    if (0 < frameBuffer.stencilBits) {
                        this.pgl.genRenderbuffers(1, intBuffer);
                        frameBuffer.glStencil = intBuffer.get(0);
                    }
                }
                this.glFbo = frameBuffer.glFbo;
                this.glDepth = frameBuffer.glDepth;
                this.glStencil = frameBuffer.glStencil;
                this.glDepthStencil = frameBuffer.glDepthStencil;
                this.glMultisample = frameBuffer.glMultisample;
            }
            this.context = frameBuffer.context;
            refList.add(this);
        }

        private void disposeNative() {
            if (this.pgl != null) {
                if (this.glFbo != 0) {
                    intBuffer.put(0, this.glFbo);
                    this.pgl.deleteFramebuffers(1, intBuffer);
                    this.glFbo = 0;
                }
                if (this.glDepth != 0) {
                    intBuffer.put(0, this.glDepth);
                    this.pgl.deleteRenderbuffers(1, intBuffer);
                    this.glDepth = 0;
                }
                if (this.glStencil != 0) {
                    intBuffer.put(0, this.glStencil);
                    this.pgl.deleteRenderbuffers(1, intBuffer);
                    this.glStencil = 0;
                }
                if (this.glDepthStencil != 0) {
                    intBuffer.put(0, this.glDepthStencil);
                    this.pgl.deleteRenderbuffers(1, intBuffer);
                    this.glDepthStencil = 0;
                }
                if (this.glMultisample != 0) {
                    intBuffer.put(0, this.glMultisample);
                    this.pgl.deleteRenderbuffers(1, intBuffer);
                    this.glMultisample = 0;
                }
                this.pgl = null;
            }
        }

        void dispose() {
            refList.remove(this);
            this.disposeNative();
        }

        public boolean equals(Object object) {
            GLResourceFrameBuffer gLResourceFrameBuffer = (GLResourceFrameBuffer)object;
            return gLResourceFrameBuffer.glFbo == this.glFbo && gLResourceFrameBuffer.glDepth == this.glDepth && gLResourceFrameBuffer.glStencil == this.glStencil && gLResourceFrameBuffer.glDepthStencil == this.glDepthStencil && gLResourceFrameBuffer.glMultisample == this.glMultisample && gLResourceFrameBuffer.context == this.context;
        }

        public int hashCode() {
            int n = 17;
            n = 31 * n + this.glFbo;
            n = 31 * n + this.glDepth;
            n = 31 * n + this.glStencil;
            n = 31 * n + this.glDepthStencil;
            n = 31 * n + this.glMultisample;
            n = 31 * n + this.context;
            return n;
        }
    }

    protected static class GLResourceShader
    extends WeakReference<PShader> {
        int glProgram;
        int glVertex;
        int glFragment;
        private PGL pgl;
        private int context;
        private static ReferenceQueue<PShader> refQueue = new ReferenceQueue();
        private static List<GLResourceShader> refList = new ArrayList<GLResourceShader>();

        static void drainRefQueueBounded() {
            GLResourceShader gLResourceShader;
            ReferenceQueue<PShader> referenceQueue = GLResourceShader.referenceQueue();
            for (int i = 0; i < 10 && (gLResourceShader = (GLResourceShader)referenceQueue.poll()) != null; ++i) {
                gLResourceShader.dispose();
            }
        }

        static ReferenceQueue<PShader> referenceQueue() {
            return refQueue;
        }

        public GLResourceShader(PShader pShader) {
            super(pShader, refQueue);
            GLResourceShader.drainRefQueueBounded();
            this.pgl = pShader.pgl.graphics.getPrimaryPGL();
            pShader.glProgram = this.pgl.createProgram();
            pShader.glVertex = this.pgl.createShader(PGL.VERTEX_SHADER);
            pShader.glFragment = this.pgl.createShader(PGL.FRAGMENT_SHADER);
            this.glProgram = pShader.glProgram;
            this.glVertex = pShader.glVertex;
            this.glFragment = pShader.glFragment;
            this.context = pShader.context;
            refList.add(this);
        }

        private void disposeNative() {
            if (this.pgl != null) {
                if (this.glFragment != 0) {
                    this.pgl.deleteShader(this.glFragment);
                    this.glFragment = 0;
                }
                if (this.glVertex != 0) {
                    this.pgl.deleteShader(this.glVertex);
                    this.glVertex = 0;
                }
                if (this.glProgram != 0) {
                    this.pgl.deleteProgram(this.glProgram);
                    this.glProgram = 0;
                }
                this.pgl = null;
            }
        }

        void dispose() {
            refList.remove(this);
            this.disposeNative();
        }

        public boolean equals(Object object) {
            GLResourceShader gLResourceShader = (GLResourceShader)object;
            return gLResourceShader.glProgram == this.glProgram && gLResourceShader.glVertex == this.glVertex && gLResourceShader.glFragment == this.glFragment && gLResourceShader.context == this.context;
        }

        public int hashCode() {
            int n = 17;
            n = 31 * n + this.glProgram;
            n = 31 * n + this.glVertex;
            n = 31 * n + this.glFragment;
            n = 31 * n + this.context;
            return n;
        }
    }

    protected static class GLResourceVertexBuffer
    extends WeakReference<VertexBuffer> {
        int glId;
        private PGL pgl;
        private int context;
        private static ReferenceQueue<VertexBuffer> refQueue = new ReferenceQueue();
        private static List<GLResourceVertexBuffer> refList = new ArrayList<GLResourceVertexBuffer>();

        static void drainRefQueueBounded() {
            GLResourceVertexBuffer gLResourceVertexBuffer;
            ReferenceQueue<VertexBuffer> referenceQueue = GLResourceVertexBuffer.referenceQueue();
            for (int i = 0; i < 10 && (gLResourceVertexBuffer = (GLResourceVertexBuffer)referenceQueue.poll()) != null; ++i) {
                gLResourceVertexBuffer.dispose();
            }
        }

        static ReferenceQueue<VertexBuffer> referenceQueue() {
            return refQueue;
        }

        public GLResourceVertexBuffer(VertexBuffer vertexBuffer) {
            super(vertexBuffer, refQueue);
            GLResourceVertexBuffer.drainRefQueueBounded();
            this.pgl = vertexBuffer.pgl.graphics.getPrimaryPGL();
            this.pgl.genBuffers(1, intBuffer);
            this.glId = vertexBuffer.glId = intBuffer.get(0);
            this.context = vertexBuffer.context;
            refList.add(this);
        }

        private void disposeNative() {
            if (this.pgl != null) {
                if (this.glId != 0) {
                    intBuffer.put(0, this.glId);
                    this.pgl.deleteBuffers(1, intBuffer);
                    this.glId = 0;
                }
                this.pgl = null;
            }
        }

        void dispose() {
            refList.remove(this);
            this.disposeNative();
        }

        public boolean equals(Object object) {
            GLResourceVertexBuffer gLResourceVertexBuffer = (GLResourceVertexBuffer)object;
            return gLResourceVertexBuffer.glId == this.glId && gLResourceVertexBuffer.context == this.context;
        }

        public int hashCode() {
            int n = 17;
            n = 31 * n + this.glId;
            n = 31 * n + this.context;
            return n;
        }
    }

    protected static class GLResourceTexture
    extends WeakReference<Texture> {
        int glName;
        private PGL pgl;
        private int context;
        private static ReferenceQueue<Texture> refQueue = new ReferenceQueue();
        private static List<GLResourceTexture> refList = new ArrayList<GLResourceTexture>();

        static void drainRefQueueBounded() {
            GLResourceTexture gLResourceTexture;
            ReferenceQueue<Texture> referenceQueue = GLResourceTexture.referenceQueue();
            for (int i = 0; i < 10 && (gLResourceTexture = (GLResourceTexture)referenceQueue.poll()) != null; ++i) {
                gLResourceTexture.dispose();
            }
        }

        static ReferenceQueue<Texture> referenceQueue() {
            return refQueue;
        }

        public GLResourceTexture(Texture texture) {
            super(texture, refQueue);
            GLResourceTexture.drainRefQueueBounded();
            this.pgl = texture.pg.getPrimaryPGL();
            this.pgl.genTextures(1, intBuffer);
            this.glName = texture.glName = intBuffer.get(0);
            this.context = texture.context;
            refList.add(this);
        }

        private void disposeNative() {
            if (this.pgl != null) {
                if (this.glName != 0) {
                    intBuffer.put(0, this.glName);
                    this.pgl.deleteTextures(1, intBuffer);
                    this.glName = 0;
                }
                this.pgl = null;
            }
        }

        void dispose() {
            refList.remove(this);
            this.disposeNative();
        }

        public boolean equals(Object object) {
            GLResourceTexture gLResourceTexture = (GLResourceTexture)object;
            return gLResourceTexture.glName == this.glName && gLResourceTexture.context == this.context;
        }

        public int hashCode() {
            int n = 17;
            n = 31 * n + this.glName;
            n = 31 * n + this.context;
            return n;
        }
    }
}

