/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import java.util.Arrays;
import java.util.HashMap;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.opengl.PGL;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.Texture;

class FontTexture
implements PConstants {
    protected PGL pgl;
    protected boolean is3D;
    protected int minSize;
    protected int maxSize;
    protected int offsetX;
    protected int offsetY;
    protected int lineHeight;
    protected Texture[] textures = null;
    protected PImage[] images = null;
    protected int lastTex;
    protected TextureInfo[] glyphTexinfos;
    protected HashMap<PFont.Glyph, TextureInfo> texinfoMap;

    public FontTexture(PGraphicsOpenGL pGraphicsOpenGL, PFont pFont, boolean bl) {
        this.pgl = pGraphicsOpenGL.pgl;
        this.is3D = bl;
        this.initTexture(pGraphicsOpenGL, pFont);
    }

    protected void allocate() {
    }

    protected void dispose() {
        for (int i = 0; i < this.textures.length; ++i) {
            this.textures[i].dispose();
        }
    }

    protected void initTexture(PGraphicsOpenGL pGraphicsOpenGL, PFont pFont) {
        this.lastTex = -1;
        int n = PGL.nextPowerOfTwo(pFont.getSize());
        this.minSize = PApplet.min(PGraphicsOpenGL.maxTextureSize, PApplet.max(PGL.MIN_FONT_TEX_SIZE, n));
        this.maxSize = PApplet.min(PGraphicsOpenGL.maxTextureSize, PApplet.max(PGL.MAX_FONT_TEX_SIZE, 2 * n));
        if (this.maxSize < n) {
            PGraphics.showWarning("The font size is too large to be properly displayed with OpenGL");
        }
        this.addTexture(pGraphicsOpenGL);
        this.offsetX = 0;
        this.offsetY = 0;
        this.lineHeight = 0;
        this.texinfoMap = new HashMap();
        this.glyphTexinfos = new TextureInfo[pFont.getGlyphCount()];
        this.addAllGlyphsToTexture(pGraphicsOpenGL, pFont);
    }

    public boolean addTexture(PGraphicsOpenGL pGraphicsOpenGL) {
        boolean bl;
        int n;
        int n2 = this.maxSize;
        if (-1 < this.lastTex && this.textures[this.lastTex].glHeight < this.maxSize) {
            n = PApplet.min(2 * this.textures[this.lastTex].glHeight, this.maxSize);
            bl = true;
        } else {
            n = this.minSize;
            bl = false;
        }
        Texture texture = this.is3D ? new Texture(pGraphicsOpenGL, n2, n, new Texture.Parameters(2, 4, false)) : new Texture(pGraphicsOpenGL, n2, n, new Texture.Parameters(2, 3, false));
        if (this.textures == null) {
            this.textures = new Texture[1];
            this.textures[0] = texture;
            this.images = new PImage[1];
            this.images[0] = pGraphicsOpenGL.wrapTexture(texture);
            this.lastTex = 0;
        } else if (bl) {
            Texture texture2 = this.textures[this.lastTex];
            texture.put(texture2);
            this.textures[this.lastTex] = texture;
            pGraphicsOpenGL.setCache(this.images[this.lastTex], texture);
            this.images[this.lastTex].width = texture.width;
            this.images[this.lastTex].height = texture.height;
        } else {
            this.lastTex = this.textures.length;
            Texture[] textureArray = new Texture[this.lastTex + 1];
            PApplet.arrayCopy(this.textures, textureArray, this.textures.length);
            textureArray[this.lastTex] = texture;
            this.textures = textureArray;
            PImage[] pImageArray = new PImage[this.textures.length];
            PApplet.arrayCopy(this.images, pImageArray, this.images.length);
            pImageArray[this.lastTex] = pGraphicsOpenGL.wrapTexture(texture);
            this.images = pImageArray;
        }
        texture.bind();
        return bl;
    }

    public void begin() {
    }

    public void end() {
        for (int i = 0; i < this.textures.length; ++i) {
            this.pgl.disableTexturing(this.textures[i].glTarget);
        }
    }

    public PImage getTexture(TextureInfo textureInfo) {
        return this.images[textureInfo.texIndex];
    }

    public void addAllGlyphsToTexture(PGraphicsOpenGL pGraphicsOpenGL, PFont pFont) {
        for (int i = 0; i < pFont.getGlyphCount(); ++i) {
            this.addToTexture(pGraphicsOpenGL, i, pFont.getGlyph(i));
        }
    }

    public void updateGlyphsTexCoords() {
        for (int i = 0; i < this.glyphTexinfos.length; ++i) {
            TextureInfo textureInfo = this.glyphTexinfos[i];
            if (textureInfo == null || textureInfo.texIndex != this.lastTex) continue;
            textureInfo.updateUV();
        }
    }

    public TextureInfo getTexInfo(PFont.Glyph glyph) {
        TextureInfo textureInfo = this.texinfoMap.get(glyph);
        return textureInfo;
    }

    public TextureInfo addToTexture(PGraphicsOpenGL pGraphicsOpenGL, PFont.Glyph glyph) {
        int n = this.glyphTexinfos.length;
        if (n == 0) {
            this.glyphTexinfos = new TextureInfo[1];
        }
        this.addToTexture(pGraphicsOpenGL, n, glyph);
        return this.glyphTexinfos[n];
    }

    public boolean contextIsOutdated() {
        int n;
        boolean bl = false;
        for (n = 0; n < this.textures.length; ++n) {
            if (!this.textures[n].contextIsOutdated()) continue;
            bl = true;
        }
        if (bl) {
            for (n = 0; n < this.textures.length; ++n) {
                this.textures[n].dispose();
            }
        }
        return bl;
    }

    protected void addToTexture(PGraphicsOpenGL pGraphicsOpenGL, int n, PFont.Glyph glyph) {
        int n2;
        int n3;
        int n4 = 1 + glyph.width + 1;
        int n5 = 1 + glyph.height + 1;
        int[] nArray = new int[n4 * n5];
        int n6 = 0;
        int n7 = 0;
        if (PGL.BIG_ENDIAN) {
            Arrays.fill(nArray, 0, n4, -256);
            n6 = n4;
            for (n3 = 0; n3 < glyph.height; ++n3) {
                nArray[n6++] = -256;
                for (n2 = 0; n2 < glyph.width; ++n2) {
                    nArray[n6++] = 0xFFFFFF00 | glyph.image.pixels[n7++];
                }
                nArray[n6++] = -256;
            }
            Arrays.fill(nArray, (n5 - 1) * n4, n5 * n4, -256);
        } else {
            Arrays.fill(nArray, 0, n4, 0xFFFFFF);
            n6 = n4;
            for (n3 = 0; n3 < glyph.height; ++n3) {
                nArray[n6++] = 0xFFFFFF;
                for (n2 = 0; n2 < glyph.width; ++n2) {
                    nArray[n6++] = glyph.image.pixels[n7++] << 24 | 0xFFFFFF;
                }
                nArray[n6++] = 0xFFFFFF;
            }
            Arrays.fill(nArray, (n5 - 1) * n4, n5 * n4, 0xFFFFFF);
        }
        if (this.offsetX + n4 > this.textures[this.lastTex].glWidth) {
            this.offsetX = 0;
            this.offsetY += this.lineHeight;
        }
        this.lineHeight = Math.max(this.lineHeight, n5);
        n3 = 0;
        if (this.offsetY + this.lineHeight > this.textures[this.lastTex].glHeight) {
            n3 = this.addTexture(pGraphicsOpenGL) ? 1 : 0;
            if (n3 != 0) {
                this.updateGlyphsTexCoords();
            } else {
                this.offsetX = 0;
                this.offsetY = 0;
                this.lineHeight = 0;
            }
        }
        TextureInfo textureInfo = new TextureInfo(this.lastTex, this.offsetX, this.offsetY, n4, n5, nArray);
        this.offsetX += n4;
        if (n == this.glyphTexinfos.length) {
            TextureInfo[] textureInfoArray = new TextureInfo[this.glyphTexinfos.length + 1];
            System.arraycopy(this.glyphTexinfos, 0, textureInfoArray, 0, this.glyphTexinfos.length);
            this.glyphTexinfos = textureInfoArray;
        }
        this.glyphTexinfos[n] = textureInfo;
        this.texinfoMap.put(glyph, textureInfo);
    }

    class TextureInfo {
        int texIndex;
        int width;
        int height;
        int[] crop;
        float u0;
        float u1;
        float v0;
        float v1;
        int[] pixels;

        TextureInfo(int n, int n2, int n3, int n4, int n5, int[] nArray) {
            this.texIndex = n;
            this.crop = new int[4];
            this.crop[0] = n2 + 1;
            this.crop[1] = n3 + 1 + n5 - 2;
            this.crop[2] = n4 - 2;
            this.crop[3] = -n5 + 2;
            this.pixels = nArray;
            this.updateUV();
            this.updateTex();
        }

        void updateUV() {
            this.width = FontTexture.this.textures[this.texIndex].glWidth;
            this.height = FontTexture.this.textures[this.texIndex].glHeight;
            this.u0 = (float)this.crop[0] / (float)this.width;
            this.u1 = this.u0 + (float)this.crop[2] / (float)this.width;
            this.v0 = (float)(this.crop[1] + this.crop[3]) / (float)this.height;
            this.v1 = this.v0 - (float)this.crop[3] / (float)this.height;
        }

        void updateTex() {
            FontTexture.this.textures[this.texIndex].setNative(this.pixels, this.crop[0] - 1, this.crop[1] + this.crop[3] - 1, this.crop[2] + 2, -this.crop[3] + 2);
        }
    }
}

