/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import processing.core.PApplet;
import processing.data.JSONObject;
import processing.data.Sort;
import processing.data.StringList;

public class StringDict {
    protected int count;
    protected String[] keys;
    protected String[] values;
    private HashMap<String, Integer> indices = new HashMap();

    public StringDict() {
        this.count = 0;
        this.keys = new String[10];
        this.values = new String[10];
    }

    public StringDict(int n) {
        this.count = 0;
        this.keys = new String[n];
        this.values = new String[n];
    }

    public StringDict(BufferedReader bufferedReader) {
        String[] stringArray = PApplet.loadStrings(bufferedReader);
        this.keys = new String[stringArray.length];
        this.values = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = PApplet.split(stringArray[i], '\t');
            if (stringArray2.length != 2) continue;
            this.keys[this.count] = stringArray2[0];
            this.values[this.count] = stringArray2[1];
            this.indices.put(this.keys[this.count], this.count);
            ++this.count;
        }
    }

    public StringDict(String[] stringArray, String[] stringArray2) {
        if (stringArray.length != stringArray2.length) {
            throw new IllegalArgumentException("key and value arrays must be the same length");
        }
        this.keys = stringArray;
        this.values = stringArray2;
        this.count = stringArray.length;
        for (int i = 0; i < this.count; ++i) {
            this.indices.put(stringArray[i], i);
        }
    }

    public StringDict(String[][] stringArray) {
        this.count = stringArray.length;
        this.keys = new String[this.count];
        this.values = new String[this.count];
        for (int i = 0; i < this.count; ++i) {
            this.keys[i] = stringArray[i][0];
            this.values[i] = stringArray[i][1];
            this.indices.put(this.keys[i], i);
        }
    }

    public int size() {
        return this.count;
    }

    public void clear() {
        this.count = 0;
        this.indices = new HashMap();
    }

    public Iterable<Entry> entries() {
        return new Iterable<Entry>(){

            @Override
            public Iterator<Entry> iterator() {
                return StringDict.this.entryIterator();
            }
        };
    }

    public Iterator<Entry> entryIterator() {
        return new Iterator<Entry>(){
            int index = -1;

            @Override
            public void remove() {
                StringDict.this.removeIndex(this.index);
                --this.index;
            }

            @Override
            public Entry next() {
                Entry entry = new Entry(StringDict.this.keys[this.index], StringDict.this.values[this.index]);
                ++this.index;
                return entry;
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < StringDict.this.size();
            }
        };
    }

    public String key(int n) {
        return this.keys[n];
    }

    protected void crop() {
        if (this.count != this.keys.length) {
            this.keys = PApplet.subset(this.keys, 0, this.count);
            this.values = PApplet.subset(this.values, 0, this.count);
        }
    }

    public Iterable<String> keys() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return StringDict.this.keyIterator();
            }
        };
    }

    public Iterator<String> keyIterator() {
        return new Iterator<String>(){
            int index = -1;

            @Override
            public void remove() {
                StringDict.this.removeIndex(this.index);
                --this.index;
            }

            @Override
            public String next() {
                return StringDict.this.key(++this.index);
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < StringDict.this.size();
            }
        };
    }

    public String[] keyArray() {
        this.crop();
        return this.keyArray(null);
    }

    public String[] keyArray(String[] stringArray) {
        if (stringArray == null || stringArray.length != this.count) {
            stringArray = new String[this.count];
        }
        System.arraycopy(this.keys, 0, stringArray, 0, this.count);
        return stringArray;
    }

    public String value(int n) {
        return this.values[n];
    }

    public Iterable<String> values() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return StringDict.this.valueIterator();
            }
        };
    }

    public Iterator<String> valueIterator() {
        return new Iterator<String>(){
            int index = -1;

            @Override
            public void remove() {
                StringDict.this.removeIndex(this.index);
                --this.index;
            }

            @Override
            public String next() {
                return StringDict.this.value(++this.index);
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < StringDict.this.size();
            }
        };
    }

    public String[] valueArray() {
        this.crop();
        return this.valueArray(null);
    }

    public String[] valueArray(String[] stringArray) {
        if (stringArray == null || stringArray.length != this.size()) {
            stringArray = new String[this.count];
        }
        System.arraycopy(this.values, 0, stringArray, 0, this.count);
        return stringArray;
    }

    public String get(String string) {
        int n = this.index(string);
        if (n == -1) {
            return null;
        }
        return this.values[n];
    }

    public String get(String string, String string2) {
        int n = this.index(string);
        if (n == -1) {
            return string2;
        }
        return this.values[n];
    }

    public void set(String string, String string2) {
        int n = this.index(string);
        if (n == -1) {
            this.create(string, string2);
        } else {
            this.values[n] = string2;
        }
    }

    public int index(String string) {
        Integer n = this.indices.get(string);
        return n == null ? -1 : n;
    }

    public boolean hasKey(String string) {
        return this.index(string) != -1;
    }

    protected void create(String string, String string2) {
        if (this.count == this.keys.length) {
            this.keys = PApplet.expand(this.keys);
            this.values = PApplet.expand(this.values);
        }
        this.indices.put(string, this.count);
        this.keys[this.count] = string;
        this.values[this.count] = string2;
        ++this.count;
    }

    public int remove(String string) {
        int n = this.index(string);
        if (n != -1) {
            this.removeIndex(n);
        }
        return n;
    }

    public String removeIndex(int n) {
        if (n < 0 || n >= this.count) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        String string = this.keys[n];
        this.indices.remove(string);
        for (int i = n; i < this.count - 1; ++i) {
            this.keys[i] = this.keys[i + 1];
            this.values[i] = this.values[i + 1];
            this.indices.put(this.keys[i], i);
        }
        --this.count;
        this.keys[this.count] = null;
        this.values[this.count] = null;
        return string;
    }

    public void swap(int n, int n2) {
        String string = this.keys[n];
        String string2 = this.values[n];
        this.keys[n] = this.keys[n2];
        this.values[n] = this.values[n2];
        this.keys[n2] = string;
        this.values[n2] = string2;
    }

    public void sortKeys() {
        this.sortImpl(true, false);
    }

    public void sortKeysReverse() {
        this.sortImpl(true, true);
    }

    public void sortValues() {
        this.sortImpl(false, false);
    }

    public void sortValuesReverse() {
        this.sortImpl(false, true);
    }

    protected void sortImpl(final boolean bl, final boolean bl2) {
        Sort sort = new Sort(){

            @Override
            public int size() {
                return StringDict.this.count;
            }

            @Override
            public float compare(int n, int n2) {
                int n3 = 0;
                if (bl) {
                    n3 = StringDict.this.keys[n].compareToIgnoreCase(StringDict.this.keys[n2]);
                    if (n3 == 0) {
                        n3 = StringDict.this.values[n].compareToIgnoreCase(StringDict.this.values[n2]);
                    }
                } else {
                    n3 = StringDict.this.values[n].compareToIgnoreCase(StringDict.this.values[n2]);
                    if (n3 == 0) {
                        n3 = StringDict.this.keys[n].compareToIgnoreCase(StringDict.this.keys[n2]);
                    }
                }
                return bl2 ? (float)(-n3) : (float)n3;
            }

            @Override
            public void swap(int n, int n2) {
                StringDict.this.swap(n, n2);
            }
        };
        sort.run();
        this.indices = new HashMap();
        for (int i = 0; i < this.count; ++i) {
            this.indices.put(this.keys[i], i);
        }
    }

    public StringDict copy() {
        StringDict stringDict = new StringDict(this.count);
        System.arraycopy(this.keys, 0, stringDict.keys, 0, this.count);
        System.arraycopy(this.values, 0, stringDict.values, 0, this.count);
        for (int i = 0; i < this.count; ++i) {
            stringDict.indices.put(this.keys[i], i);
        }
        stringDict.count = this.count;
        return stringDict;
    }

    public void print() {
        for (int i = 0; i < this.size(); ++i) {
            System.out.println(this.keys[i] + " = " + this.values[i]);
        }
    }

    public void write(PrintWriter printWriter) {
        for (int i = 0; i < this.count; ++i) {
            printWriter.println(this.keys[i] + "\t" + this.values[i]);
        }
        printWriter.flush();
    }

    public String toJSON() {
        StringList stringList = new StringList();
        for (int i = 0; i < this.count; ++i) {
            stringList.append(JSONObject.quote(this.keys[i]) + ": " + JSONObject.quote(this.values[i]));
        }
        return "{ " + stringList.join(", ") + " }";
    }

    public String toString() {
        return this.getClass().getSimpleName() + " size=" + this.size() + " " + this.toJSON();
    }

    public class Entry {
        public String key;
        public String value;

        Entry(String string, String string2) {
            this.key = string;
            this.value = string2;
        }
    }
}

