/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Random;
import processing.core.PApplet;
import processing.data.FloatList;
import processing.data.Sort;

public class IntList
implements Iterable<Integer> {
    protected int count;
    protected int[] data;

    public IntList() {
        this.data = new int[10];
    }

    public IntList(int n) {
        this.data = new int[n];
    }

    public IntList(int[] nArray) {
        this.count = nArray.length;
        this.data = new int[this.count];
        System.arraycopy(nArray, 0, this.data, 0, this.count);
    }

    public IntList(Iterable<Object> iterable) {
        this(10);
        for (Object object : iterable) {
            if (object == null) {
                this.append(0);
                continue;
            }
            if (object instanceof Number) {
                this.append(((Number)object).intValue());
                continue;
            }
            this.append(PApplet.parseInt(object.toString().trim()));
        }
        this.crop();
    }

    public IntList(Object ... objectArray) {
        this.count = objectArray.length;
        this.data = new int[this.count];
        int n = 0;
        for (Object object : objectArray) {
            int n2 = 0;
            if (object != null) {
                n2 = object instanceof Number ? ((Number)object).intValue() : PApplet.parseInt(object.toString().trim(), 0);
            }
            this.data[n++] = n2;
        }
    }

    public static IntList fromRange(int n) {
        return IntList.fromRange(0, n);
    }

    public static IntList fromRange(int n, int n2) {
        int n3 = n2 - n;
        IntList intList = new IntList(n3);
        for (int i = 0; i < n3; ++i) {
            intList.set(i, n + i);
        }
        return intList;
    }

    private void crop() {
        if (this.count != this.data.length) {
            this.data = PApplet.subset(this.data, 0, this.count);
        }
    }

    public int size() {
        return this.count;
    }

    public void resize(int n) {
        if (n > this.data.length) {
            int[] nArray = new int[n];
            System.arraycopy(this.data, 0, nArray, 0, this.count);
            this.data = nArray;
        } else if (n > this.count) {
            Arrays.fill(this.data, this.count, n, 0);
        }
        this.count = n;
    }

    public void clear() {
        this.count = 0;
    }

    public int get(int n) {
        if (n >= this.count) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.data[n];
    }

    public void set(int n, int n2) {
        if (n >= this.count) {
            this.data = PApplet.expand(this.data, n + 1);
            for (int i = this.count; i < n; ++i) {
                this.data[i] = 0;
            }
            this.count = n + 1;
        }
        this.data[n] = n2;
    }

    public void push(int n) {
        this.append(n);
    }

    public int pop() {
        if (this.count == 0) {
            throw new RuntimeException("Can't call pop() on an empty list");
        }
        int n = this.get(this.count - 1);
        --this.count;
        return n;
    }

    public int remove(int n) {
        if (n < 0 || n >= this.count) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.data[n];
        for (int i = n; i < this.count - 1; ++i) {
            this.data[i] = this.data[i + 1];
        }
        --this.count;
        return n2;
    }

    public int removeValue(int n) {
        int n2 = this.index(n);
        if (n2 != -1) {
            this.remove(n2);
            return n2;
        }
        return -1;
    }

    public int removeValues(int n) {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < this.count; ++n2) {
            if (this.data[n2] == n) continue;
            this.data[n3++] = this.data[n2];
        }
        n2 = this.count - n3;
        this.count = n3;
        return n2;
    }

    public void append(int n) {
        if (this.count == this.data.length) {
            this.data = PApplet.expand(this.data);
        }
        this.data[this.count++] = n;
    }

    public void append(int[] nArray) {
        for (int n : nArray) {
            this.append(n);
        }
    }

    public void append(IntList intList) {
        for (int n : intList.values()) {
            this.append(n);
        }
    }

    public void appendUnique(int n) {
        if (!this.hasValue(n)) {
            this.append(n);
        }
    }

    public void insert(int n, int n2) {
        this.insert(n, new int[]{n2});
    }

    public void insert(int n, int[] nArray) {
        if (n < 0) {
            throw new IllegalArgumentException("insert() index cannot be negative: it was " + n);
        }
        if (n >= this.data.length) {
            throw new IllegalArgumentException("insert() index " + n + " is past the end of this list");
        }
        int[] nArray2 = new int[this.count + nArray.length];
        System.arraycopy(this.data, 0, nArray2, 0, Math.min(this.count, n));
        System.arraycopy(nArray, 0, nArray2, n, nArray.length);
        System.arraycopy(this.data, n, nArray2, n + nArray.length, this.count - n);
        this.count += nArray.length;
        this.data = nArray2;
    }

    public void insert(int n, IntList intList) {
        this.insert(n, intList.values());
    }

    public int index(int n) {
        for (int i = 0; i < this.count; ++i) {
            if (this.data[i] != n) continue;
            return i;
        }
        return -1;
    }

    public boolean hasValue(int n) {
        for (int i = 0; i < this.count; ++i) {
            if (this.data[i] != n) continue;
            return true;
        }
        return false;
    }

    public void increment(int n) {
        if (this.count <= n) {
            this.resize(n + 1);
        }
        int n2 = n;
        this.data[n2] = this.data[n2] + 1;
    }

    private void boundsProblem(int n, String string) {
        String string2 = String.format("The list size is %d. You cannot %s() to element %d.", this.count, string, n);
        throw new ArrayIndexOutOfBoundsException(string2);
    }

    public void add(int n, int n2) {
        if (n < this.count) {
            int n3 = n;
            this.data[n3] = this.data[n3] + n2;
        } else {
            this.boundsProblem(n, "add");
        }
    }

    public void sub(int n, int n2) {
        if (n < this.count) {
            int n3 = n;
            this.data[n3] = this.data[n3] - n2;
        } else {
            this.boundsProblem(n, "sub");
        }
    }

    public void mult(int n, int n2) {
        if (n < this.count) {
            int n3 = n;
            this.data[n3] = this.data[n3] * n2;
        } else {
            this.boundsProblem(n, "mult");
        }
    }

    public void div(int n, int n2) {
        if (n < this.count) {
            int n3 = n;
            this.data[n3] = this.data[n3] / n2;
        } else {
            this.boundsProblem(n, "div");
        }
    }

    private void checkMinMax(String string) {
        if (this.count == 0) {
            String string2 = String.format("Cannot use %s() on an empty %s.", string, this.getClass().getSimpleName());
            throw new RuntimeException(string2);
        }
    }

    public int min() {
        this.checkMinMax("min");
        int n = this.data[0];
        for (int i = 1; i < this.count; ++i) {
            if (this.data[i] >= n) continue;
            n = this.data[i];
        }
        return n;
    }

    public int minIndex() {
        this.checkMinMax("minIndex");
        int n = this.data[0];
        int n2 = 0;
        for (int i = 1; i < this.count; ++i) {
            if (this.data[i] >= n) continue;
            n = this.data[i];
            n2 = i;
        }
        return n2;
    }

    public int max() {
        this.checkMinMax("max");
        int n = this.data[0];
        for (int i = 1; i < this.count; ++i) {
            if (this.data[i] <= n) continue;
            n = this.data[i];
        }
        return n;
    }

    public int maxIndex() {
        this.checkMinMax("maxIndex");
        int n = this.data[0];
        int n2 = 0;
        for (int i = 1; i < this.count; ++i) {
            if (this.data[i] <= n) continue;
            n = this.data[i];
            n2 = i;
        }
        return n2;
    }

    public int sum() {
        int n = 0;
        for (int i = 0; i < this.count; ++i) {
            n += this.data[i];
        }
        return n;
    }

    public void sort() {
        Arrays.sort(this.data, 0, this.count);
    }

    public void sortReverse() {
        new Sort(){

            @Override
            public int size() {
                return IntList.this.count;
            }

            @Override
            public float compare(int n, int n2) {
                return IntList.this.data[n2] - IntList.this.data[n];
            }

            @Override
            public void swap(int n, int n2) {
                int n3 = IntList.this.data[n];
                IntList.this.data[n] = IntList.this.data[n2];
                IntList.this.data[n2] = n3;
            }
        }.run();
    }

    public void reverse() {
        int n = this.count - 1;
        for (int i = 0; i < this.count / 2; ++i) {
            int n2 = this.data[i];
            this.data[i] = this.data[n];
            this.data[n] = n2;
            --n;
        }
    }

    public void shuffle() {
        Random random = new Random();
        int n = this.count;
        while (n > 1) {
            int n2 = random.nextInt(n);
            int n3 = this.data[--n];
            this.data[n] = this.data[n2];
            this.data[n2] = n3;
        }
    }

    public void shuffle(PApplet pApplet) {
        int n = this.count;
        while (n > 1) {
            int n2 = (int)pApplet.random(n);
            int n3 = this.data[--n];
            this.data[n] = this.data[n2];
            this.data[n2] = n3;
        }
    }

    public IntList copy() {
        IntList intList = new IntList(this.data);
        intList.count = this.count;
        return intList;
    }

    public int[] values() {
        this.crop();
        return this.data;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            int index = -1;

            @Override
            public void remove() {
                IntList.this.remove(this.index);
                --this.index;
            }

            @Override
            public Integer next() {
                return IntList.this.data[++this.index];
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < IntList.this.count;
            }
        };
    }

    public int[] array() {
        return this.array(null);
    }

    public int[] array(int[] nArray) {
        if (nArray == null || nArray.length != this.count) {
            nArray = new int[this.count];
        }
        System.arraycopy(this.data, 0, nArray, 0, this.count);
        return nArray;
    }

    public FloatList getPercent() {
        double d = 0.0;
        Object object = this.array();
        int n = ((int[])object).length;
        for (int i = 0; i < n; ++i) {
            float f = object[i];
            d += (double)f;
        }
        object = new FloatList(this.count);
        for (n = 0; n < this.count; ++n) {
            double d2 = (double)this.data[n] / d;
            ((FloatList)object).set(n, (float)d2);
        }
        return object;
    }

    public IntList getSubset(int n) {
        return this.getSubset(n, this.count - n);
    }

    public IntList getSubset(int n, int n2) {
        int[] nArray = new int[n2];
        System.arraycopy(this.data, n, nArray, 0, n2);
        return new IntList(nArray);
    }

    public String join(String string) {
        if (this.count == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.data[0]);
        for (int i = 1; i < this.count; ++i) {
            stringBuilder.append(string);
            stringBuilder.append(this.data[i]);
        }
        return stringBuilder.toString();
    }

    public void print() {
        for (int i = 0; i < this.count; ++i) {
            System.out.format("[%d] %d%n", i, this.data[i]);
        }
    }

    public String toJSON() {
        return "[ " + this.join(", ") + " ]";
    }

    public String toString() {
        return this.getClass().getSimpleName() + " size=" + this.size() + " " + this.toJSON();
    }
}

