/*
 * Decompiled with CFR 0.152.
 */
package processing.data;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import processing.core.PApplet;
import processing.data.FloatDict;
import processing.data.JSONObject;
import processing.data.Sort;
import processing.data.StringList;

public class IntDict {
    protected int count;
    protected String[] keys;
    protected int[] values;
    private HashMap<String, Integer> indices = new HashMap();

    public IntDict() {
        this.count = 0;
        this.keys = new String[10];
        this.values = new int[10];
    }

    public IntDict(int n) {
        this.count = 0;
        this.keys = new String[n];
        this.values = new int[n];
    }

    public IntDict(BufferedReader bufferedReader) {
        String[] stringArray = PApplet.loadStrings(bufferedReader);
        this.keys = new String[stringArray.length];
        this.values = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = PApplet.split(stringArray[i], '\t');
            if (stringArray2.length != 2) continue;
            this.keys[this.count] = stringArray2[0];
            this.values[this.count] = PApplet.parseInt(stringArray2[1]);
            this.indices.put(stringArray2[0], this.count);
            ++this.count;
        }
    }

    public IntDict(String[] stringArray, int[] nArray) {
        if (stringArray.length != nArray.length) {
            throw new IllegalArgumentException("key and value arrays must be the same length");
        }
        this.keys = stringArray;
        this.values = nArray;
        this.count = stringArray.length;
        for (int i = 0; i < this.count; ++i) {
            this.indices.put(stringArray[i], i);
        }
    }

    public IntDict(Object[][] objectArray) {
        this.count = objectArray.length;
        this.keys = new String[this.count];
        this.values = new int[this.count];
        for (int i = 0; i < this.count; ++i) {
            this.keys[i] = (String)objectArray[i][0];
            this.values[i] = (Integer)objectArray[i][1];
            this.indices.put(this.keys[i], i);
        }
    }

    public int size() {
        return this.count;
    }

    public void clear() {
        this.count = 0;
        this.indices = new HashMap();
    }

    public Iterable<Entry> entries() {
        return new Iterable<Entry>(){

            @Override
            public Iterator<Entry> iterator() {
                return IntDict.this.entryIterator();
            }
        };
    }

    public Iterator<Entry> entryIterator() {
        return new Iterator<Entry>(){
            int index = -1;

            @Override
            public void remove() {
                IntDict.this.removeIndex(this.index);
                --this.index;
            }

            @Override
            public Entry next() {
                Entry entry = new Entry(IntDict.this.keys[this.index], IntDict.this.values[this.index]);
                ++this.index;
                return entry;
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < IntDict.this.size();
            }
        };
    }

    public String key(int n) {
        return this.keys[n];
    }

    protected void crop() {
        if (this.count != this.keys.length) {
            this.keys = PApplet.subset(this.keys, 0, this.count);
            this.values = PApplet.subset(this.values, 0, this.count);
        }
    }

    public Iterable<String> keys() {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return IntDict.this.keyIterator();
            }
        };
    }

    public Iterator<String> keyIterator() {
        return new Iterator<String>(){
            int index = -1;

            @Override
            public void remove() {
                IntDict.this.removeIndex(this.index);
                --this.index;
            }

            @Override
            public String next() {
                return IntDict.this.key(++this.index);
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < IntDict.this.size();
            }
        };
    }

    public String[] keyArray() {
        this.crop();
        return this.keyArray(null);
    }

    public String[] keyArray(String[] stringArray) {
        if (stringArray == null || stringArray.length != this.count) {
            stringArray = new String[this.count];
        }
        System.arraycopy(this.keys, 0, stringArray, 0, this.count);
        return stringArray;
    }

    public int value(int n) {
        return this.values[n];
    }

    public Iterable<Integer> values() {
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return IntDict.this.valueIterator();
            }
        };
    }

    public Iterator<Integer> valueIterator() {
        return new Iterator<Integer>(){
            int index = -1;

            @Override
            public void remove() {
                IntDict.this.removeIndex(this.index);
                --this.index;
            }

            @Override
            public Integer next() {
                return IntDict.this.value(++this.index);
            }

            @Override
            public boolean hasNext() {
                return this.index + 1 < IntDict.this.size();
            }
        };
    }

    public int[] valueArray() {
        this.crop();
        return this.valueArray(null);
    }

    public int[] valueArray(int[] nArray) {
        if (nArray == null || nArray.length != this.size()) {
            nArray = new int[this.count];
        }
        System.arraycopy(this.values, 0, nArray, 0, this.count);
        return nArray;
    }

    public int get(String string) {
        int n = this.index(string);
        if (n == -1) {
            throw new IllegalArgumentException("No key named '" + string + "'");
        }
        return this.values[n];
    }

    public int get(String string, int n) {
        int n2 = this.index(string);
        if (n2 == -1) {
            return n;
        }
        return this.values[n2];
    }

    public void set(String string, int n) {
        int n2 = this.index(string);
        if (n2 == -1) {
            this.create(string, n);
        } else {
            this.values[n2] = n;
        }
    }

    public boolean hasKey(String string) {
        return this.index(string) != -1;
    }

    public void increment(String string) {
        this.add(string, 1);
    }

    public void increment(IntDict intDict) {
        for (int i = 0; i < intDict.count; ++i) {
            this.add(intDict.key(i), intDict.value(i));
        }
    }

    public void add(String string, int n) {
        int n2 = this.index(string);
        if (n2 == -1) {
            this.create(string, n);
        } else {
            int n3 = n2;
            this.values[n3] = this.values[n3] + n;
        }
    }

    public void sub(String string, int n) {
        this.add(string, -n);
    }

    public void mult(String string, int n) {
        int n2 = this.index(string);
        if (n2 != -1) {
            int n3 = n2;
            this.values[n3] = this.values[n3] * n;
        }
    }

    public void div(String string, int n) {
        int n2 = this.index(string);
        if (n2 != -1) {
            int n3 = n2;
            this.values[n3] = this.values[n3] / n;
        }
    }

    private void checkMinMax(String string) {
        if (this.count == 0) {
            String string2 = String.format("Cannot use %s() on an empty %s.", string, this.getClass().getSimpleName());
            throw new RuntimeException(string2);
        }
    }

    public int minIndex() {
        if (this.count == 0) {
            return -1;
        }
        int n = 0;
        int n2 = this.values[0];
        for (int i = 1; i < this.count; ++i) {
            if (this.values[i] >= n2) continue;
            n = i;
            n2 = this.values[i];
        }
        return n;
    }

    public String minKey() {
        this.checkMinMax("minKey");
        int n = this.minIndex();
        if (n == -1) {
            return null;
        }
        return this.keys[n];
    }

    public int minValue() {
        this.checkMinMax("minValue");
        return this.values[this.minIndex()];
    }

    public int maxIndex() {
        if (this.count == 0) {
            return -1;
        }
        int n = 0;
        int n2 = this.values[0];
        for (int i = 1; i < this.count; ++i) {
            if (this.values[i] <= n2) continue;
            n = i;
            n2 = this.values[i];
        }
        return n;
    }

    public String maxKey() {
        int n = this.maxIndex();
        if (n == -1) {
            return null;
        }
        return this.keys[n];
    }

    public int maxValue() {
        this.checkMinMax("maxIndex");
        return this.values[this.maxIndex()];
    }

    public int index(String string) {
        Integer n = this.indices.get(string);
        return n == null ? -1 : n;
    }

    protected void create(String string, int n) {
        if (this.count == this.keys.length) {
            this.keys = PApplet.expand(this.keys);
            this.values = PApplet.expand(this.values);
        }
        this.indices.put(string, this.count);
        this.keys[this.count] = string;
        this.values[this.count] = n;
        ++this.count;
    }

    public int remove(String string) {
        int n = this.index(string);
        if (n != -1) {
            this.removeIndex(n);
        }
        return n;
    }

    public String removeIndex(int n) {
        if (n < 0 || n >= this.count) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        String string = this.keys[n];
        this.indices.remove(this.keys[n]);
        for (int i = n; i < this.count - 1; ++i) {
            this.keys[i] = this.keys[i + 1];
            this.values[i] = this.values[i + 1];
            this.indices.put(this.keys[i], i);
        }
        --this.count;
        this.keys[this.count] = null;
        this.values[this.count] = 0;
        return string;
    }

    public void swap(int n, int n2) {
        String string = this.keys[n];
        int n3 = this.values[n];
        this.keys[n] = this.keys[n2];
        this.values[n] = this.values[n2];
        this.keys[n2] = string;
        this.values[n2] = n3;
    }

    public void sortKeys() {
        this.sortImpl(true, false, true);
    }

    public void sortKeysReverse() {
        this.sortImpl(true, true, true);
    }

    public void sortValues() {
        this.sortValues(true);
    }

    public void sortValues(boolean bl) {
        this.sortImpl(false, false, bl);
    }

    public void sortValuesReverse() {
        this.sortValuesReverse(true);
    }

    public void sortValuesReverse(boolean bl) {
        this.sortImpl(false, true, bl);
    }

    protected void sortImpl(final boolean bl, final boolean bl2, final boolean bl3) {
        Sort sort = new Sort(){

            @Override
            public int size() {
                return IntDict.this.count;
            }

            @Override
            public float compare(int n, int n2) {
                int n3 = 0;
                if (bl) {
                    n3 = IntDict.this.keys[n].compareToIgnoreCase(IntDict.this.keys[n2]);
                    if (n3 == 0) {
                        n3 = IntDict.this.values[n] - IntDict.this.values[n2];
                    }
                } else {
                    n3 = IntDict.this.values[n] - IntDict.this.values[n2];
                    if (n3 == 0 && bl3) {
                        n3 = IntDict.this.keys[n].compareToIgnoreCase(IntDict.this.keys[n2]);
                    }
                }
                return bl2 ? (float)(-n3) : (float)n3;
            }

            @Override
            public void swap(int n, int n2) {
                IntDict.this.swap(n, n2);
            }
        };
        sort.run();
        this.indices = new HashMap();
        for (int i = 0; i < this.count; ++i) {
            this.indices.put(this.keys[i], i);
        }
    }

    public FloatDict getPercent() {
        double d = 0.0;
        for (int i = 0; i < this.count; ++i) {
            d += (double)this.values[i];
        }
        FloatDict floatDict = new FloatDict();
        for (int i = 0; i < this.size(); ++i) {
            double d2 = (double)this.value(i) / d;
            floatDict.set(this.key(i), (float)d2);
        }
        return floatDict;
    }

    public IntDict copy() {
        IntDict intDict = new IntDict(this.count);
        System.arraycopy(this.keys, 0, intDict.keys, 0, this.count);
        System.arraycopy(this.values, 0, intDict.values, 0, this.count);
        for (int i = 0; i < this.count; ++i) {
            intDict.indices.put(this.keys[i], i);
        }
        intDict.count = this.count;
        return intDict;
    }

    public void print() {
        for (int i = 0; i < this.size(); ++i) {
            System.out.println(this.keys[i] + " = " + this.values[i]);
        }
    }

    public void write(PrintWriter printWriter) {
        for (int i = 0; i < this.count; ++i) {
            printWriter.println(this.keys[i] + "\t" + this.values[i]);
        }
        printWriter.flush();
    }

    public String toJSON() {
        StringList stringList = new StringList();
        for (int i = 0; i < this.count; ++i) {
            stringList.append(JSONObject.quote(this.keys[i]) + ": " + this.values[i]);
        }
        return "{ " + stringList.join(", ") + " }";
    }

    public String toString() {
        return this.getClass().getSimpleName() + " size=" + this.size() + " " + this.toJSON();
    }

    public class Entry {
        public String key;
        public int value;

        Entry(String string, int n) {
            this.key = string;
            this.value = n;
        }
    }
}

