/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.io.Serializable;
import processing.core.PApplet;

public class PVector
implements Serializable {
    private static final long serialVersionUID = -6717872085945400694L;
    public float x;
    public float y;
    public float z;
    protected transient float[] array;

    public PVector() {
    }

    public PVector(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public PVector(float f, float f2) {
        this.x = f;
        this.y = f2;
        this.z = 0.0f;
    }

    public void set(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public void set(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public void set(PVector pVector) {
        this.x = pVector.x;
        this.y = pVector.y;
        this.z = pVector.z;
    }

    public void set(float[] fArray) {
        if (fArray.length >= 2) {
            this.x = fArray[0];
            this.y = fArray[1];
        }
        if (fArray.length >= 3) {
            this.z = fArray[2];
        }
    }

    public static PVector random2D() {
        return PVector.random2D(null, null);
    }

    public static PVector random2D(PApplet pApplet) {
        return PVector.random2D(null, pApplet);
    }

    public static PVector random2D(PVector pVector) {
        return PVector.random2D(pVector, null);
    }

    public static PVector random2D(PVector pVector, PApplet pApplet) {
        if (pApplet == null) {
            return PVector.fromAngle((float)(Math.random() * Math.PI * 2.0), pVector);
        }
        return PVector.fromAngle(pApplet.random((float)Math.PI * 2), pVector);
    }

    public static PVector random3D() {
        return PVector.random3D(null, null);
    }

    public static PVector random3D(PApplet pApplet) {
        return PVector.random3D(null, pApplet);
    }

    public static PVector random3D(PVector pVector) {
        return PVector.random3D(pVector, null);
    }

    public static PVector random3D(PVector pVector, PApplet pApplet) {
        float f;
        float f2;
        if (pApplet == null) {
            f2 = (float)(Math.random() * Math.PI * 2.0);
            f = (float)(Math.random() * 2.0 - 1.0);
        } else {
            f2 = pApplet.random((float)Math.PI * 2);
            f = pApplet.random(-1.0f, 1.0f);
        }
        float f3 = (float)(Math.sqrt(1.0f - f * f) * Math.cos(f2));
        float f4 = (float)(Math.sqrt(1.0f - f * f) * Math.sin(f2));
        if (pVector == null) {
            pVector = new PVector(f3, f4, f);
        } else {
            pVector.set(f3, f4, f);
        }
        return pVector;
    }

    public static PVector fromAngle(float f) {
        return PVector.fromAngle(f, null);
    }

    public static PVector fromAngle(float f, PVector pVector) {
        if (pVector == null) {
            pVector = new PVector((float)Math.cos(f), (float)Math.sin(f), 0.0f);
        } else {
            pVector.set((float)Math.cos(f), (float)Math.sin(f), 0.0f);
        }
        return pVector;
    }

    public PVector get() {
        return new PVector(this.x, this.y, this.z);
    }

    public float[] get(float[] fArray) {
        if (fArray == null) {
            return new float[]{this.x, this.y, this.z};
        }
        if (fArray.length >= 2) {
            fArray[0] = this.x;
            fArray[1] = this.y;
        }
        if (fArray.length >= 3) {
            fArray[2] = this.z;
        }
        return fArray;
    }

    public float mag() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public float magSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public void add(PVector pVector) {
        this.x += pVector.x;
        this.y += pVector.y;
        this.z += pVector.z;
    }

    public void add(float f, float f2, float f3) {
        this.x += f;
        this.y += f2;
        this.z += f3;
    }

    public static PVector add(PVector pVector, PVector pVector2) {
        return PVector.add(pVector, pVector2, null);
    }

    public static PVector add(PVector pVector, PVector pVector2, PVector pVector3) {
        if (pVector3 == null) {
            pVector3 = new PVector(pVector.x + pVector2.x, pVector.y + pVector2.y, pVector.z + pVector2.z);
        } else {
            pVector3.set(pVector.x + pVector2.x, pVector.y + pVector2.y, pVector.z + pVector2.z);
        }
        return pVector3;
    }

    public void sub(PVector pVector) {
        this.x -= pVector.x;
        this.y -= pVector.y;
        this.z -= pVector.z;
    }

    public void sub(float f, float f2, float f3) {
        this.x -= f;
        this.y -= f2;
        this.z -= f3;
    }

    public static PVector sub(PVector pVector, PVector pVector2) {
        return PVector.sub(pVector, pVector2, null);
    }

    public static PVector sub(PVector pVector, PVector pVector2, PVector pVector3) {
        if (pVector3 == null) {
            pVector3 = new PVector(pVector.x - pVector2.x, pVector.y - pVector2.y, pVector.z - pVector2.z);
        } else {
            pVector3.set(pVector.x - pVector2.x, pVector.y - pVector2.y, pVector.z - pVector2.z);
        }
        return pVector3;
    }

    public void mult(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
    }

    public static PVector mult(PVector pVector, float f) {
        return PVector.mult(pVector, f, null);
    }

    public static PVector mult(PVector pVector, float f, PVector pVector2) {
        if (pVector2 == null) {
            pVector2 = new PVector(pVector.x * f, pVector.y * f, pVector.z * f);
        } else {
            pVector2.set(pVector.x * f, pVector.y * f, pVector.z * f);
        }
        return pVector2;
    }

    public void div(float f) {
        this.x /= f;
        this.y /= f;
        this.z /= f;
    }

    public static PVector div(PVector pVector, float f) {
        return PVector.div(pVector, f, null);
    }

    public static PVector div(PVector pVector, float f, PVector pVector2) {
        if (pVector2 == null) {
            pVector2 = new PVector(pVector.x / f, pVector.y / f, pVector.z / f);
        } else {
            pVector2.set(pVector.x / f, pVector.y / f, pVector.z / f);
        }
        return pVector2;
    }

    public float dist(PVector pVector) {
        float f = this.x - pVector.x;
        float f2 = this.y - pVector.y;
        float f3 = this.z - pVector.z;
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    public static float dist(PVector pVector, PVector pVector2) {
        float f = pVector.x - pVector2.x;
        float f2 = pVector.y - pVector2.y;
        float f3 = pVector.z - pVector2.z;
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    public float dot(PVector pVector) {
        return this.x * pVector.x + this.y * pVector.y + this.z * pVector.z;
    }

    public float dot(float f, float f2, float f3) {
        return this.x * f + this.y * f2 + this.z * f3;
    }

    public static float dot(PVector pVector, PVector pVector2) {
        return pVector.x * pVector2.x + pVector.y * pVector2.y + pVector.z * pVector2.z;
    }

    public PVector cross(PVector pVector) {
        return this.cross(pVector, null);
    }

    public PVector cross(PVector pVector, PVector pVector2) {
        float f = this.y * pVector.z - pVector.y * this.z;
        float f2 = this.z * pVector.x - pVector.z * this.x;
        float f3 = this.x * pVector.y - pVector.x * this.y;
        if (pVector2 == null) {
            pVector2 = new PVector(f, f2, f3);
        } else {
            pVector2.set(f, f2, f3);
        }
        return pVector2;
    }

    public static PVector cross(PVector pVector, PVector pVector2, PVector pVector3) {
        float f = pVector.y * pVector2.z - pVector2.y * pVector.z;
        float f2 = pVector.z * pVector2.x - pVector2.z * pVector.x;
        float f3 = pVector.x * pVector2.y - pVector2.x * pVector.y;
        if (pVector3 == null) {
            pVector3 = new PVector(f, f2, f3);
        } else {
            pVector3.set(f, f2, f3);
        }
        return pVector3;
    }

    public void normalize() {
        float f = this.mag();
        if (f != 0.0f && f != 1.0f) {
            this.div(f);
        }
    }

    public PVector normalize(PVector pVector) {
        float f;
        if (pVector == null) {
            pVector = new PVector();
        }
        if ((f = this.mag()) > 0.0f) {
            pVector.set(this.x / f, this.y / f, this.z / f);
        } else {
            pVector.set(this.x, this.y, this.z);
        }
        return pVector;
    }

    public void limit(float f) {
        if (this.magSq() > f * f) {
            this.normalize();
            this.mult(f);
        }
    }

    public void setMag(float f) {
        this.normalize();
        this.mult(f);
    }

    public PVector setMag(PVector pVector, float f) {
        pVector = this.normalize(pVector);
        pVector.mult(f);
        return pVector;
    }

    public float heading() {
        float f = (float)Math.atan2(-this.y, this.x);
        return -1.0f * f;
    }

    @Deprecated
    public float heading2D() {
        return this.heading();
    }

    public void rotate(float f) {
        float f2 = this.x;
        this.x = this.x * PApplet.cos(f) - this.y * PApplet.sin(f);
        this.y = f2 * PApplet.sin(f) + this.y * PApplet.cos(f);
    }

    public void lerp(PVector pVector, float f) {
        this.x = PApplet.lerp(this.x, pVector.x, f);
        this.y = PApplet.lerp(this.y, pVector.y, f);
        this.z = PApplet.lerp(this.z, pVector.z, f);
    }

    public static PVector lerp(PVector pVector, PVector pVector2, float f) {
        PVector pVector3 = pVector.get();
        pVector3.lerp(pVector2, f);
        return pVector3;
    }

    public void lerp(float f, float f2, float f3, float f4) {
        this.x = PApplet.lerp(this.x, f, f4);
        this.y = PApplet.lerp(this.y, f2, f4);
        this.z = PApplet.lerp(this.z, f3, f4);
    }

    public static float angleBetween(PVector pVector, PVector pVector2) {
        double d;
        if (pVector.x == 0.0f && pVector.y == 0.0f) {
            return 0.0f;
        }
        if (pVector2.x == 0.0f && pVector2.y == 0.0f) {
            return 0.0f;
        }
        double d2 = pVector.x * pVector2.x + pVector.y * pVector2.y + pVector.z * pVector2.z;
        double d3 = Math.sqrt(pVector.x * pVector.x + pVector.y * pVector.y + pVector.z * pVector.z);
        double d4 = d2 / (d3 * (d = Math.sqrt(pVector2.x * pVector2.x + pVector2.y * pVector2.y + pVector2.z * pVector2.z)));
        if (d4 <= -1.0) {
            return (float)Math.PI;
        }
        if (d4 >= 1.0) {
            return 0.0f;
        }
        return (float)Math.acos(d4);
    }

    public String toString() {
        return "[ " + this.x + ", " + this.y + ", " + this.z + " ]";
    }

    public float[] array() {
        if (this.array == null) {
            this.array = new float[3];
        }
        this.array[0] = this.x;
        this.array[1] = this.y;
        this.array[2] = this.z;
        return this.array;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PVector)) {
            return false;
        }
        PVector pVector = (PVector)object;
        return this.x == pVector.x && this.y == pVector.y && this.z == pVector.z;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Float.floatToIntBits(this.x);
        n = 31 * n + Float.floatToIntBits(this.y);
        n = 31 * n + Float.floatToIntBits(this.z);
        return n;
    }
}

