/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import android.graphics.Matrix;
import android.graphics.Shader;
import java.util.HashMap;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PGraphicsAndroid2D;
import processing.core.PMatrix2D;
import processing.core.PShape;
import processing.data.XML;

public class PShapeSVG
extends PShape {
    XML element;
    float opacity;
    float strokeOpacity;
    float fillOpacity;
    Gradient strokeGradient;
    Shader strokeGradientPaint;
    String strokeName;
    Gradient fillGradient;
    Shader fillGradientPaint;
    String fillName;

    public PShapeSVG(XML xML) {
        this(null, xML, true);
        Object object;
        if (!xML.getName().equals("svg")) {
            throw new RuntimeException("root is not <svg>, it's <" + xML.getName() + ">");
        }
        String string = xML.getString("viewBox");
        if (string != null) {
            object = PApplet.parseInt(PApplet.splitTokens(string));
            this.width = object[2];
            this.height = object[3];
        }
        object = xML.getString("width");
        String string2 = xML.getString("height");
        if (object != null) {
            this.width = PShapeSVG.parseUnitSize((String)object);
            this.height = PShapeSVG.parseUnitSize(string2);
        } else if (this.width == 0.0f || this.height == 0.0f) {
            PGraphics.showWarning("The width and/or height is not readable in the <svg> tag of this file.");
            this.width = 1.0f;
            this.height = 1.0f;
        }
    }

    protected PShapeSVG(PShapeSVG pShapeSVG, XML xML, boolean bl) {
        Object object;
        this.parent = pShapeSVG;
        if (pShapeSVG == null) {
            this.stroke = false;
            this.strokeColor = -16777216;
            this.strokeWeight = 1.0f;
            this.strokeCap = 1;
            this.strokeJoin = 8;
            this.strokeGradient = null;
            this.strokeGradientPaint = null;
            this.strokeName = null;
            this.fill = true;
            this.fillColor = -16777216;
            this.fillGradient = null;
            this.fillGradientPaint = null;
            this.fillName = null;
            this.strokeOpacity = 1.0f;
            this.fillOpacity = 1.0f;
            this.opacity = 1.0f;
        } else {
            this.stroke = pShapeSVG.stroke;
            this.strokeColor = pShapeSVG.strokeColor;
            this.strokeWeight = pShapeSVG.strokeWeight;
            this.strokeCap = pShapeSVG.strokeCap;
            this.strokeJoin = pShapeSVG.strokeJoin;
            this.strokeGradient = pShapeSVG.strokeGradient;
            this.strokeGradientPaint = pShapeSVG.strokeGradientPaint;
            this.strokeName = pShapeSVG.strokeName;
            this.fill = pShapeSVG.fill;
            this.fillColor = pShapeSVG.fillColor;
            this.fillGradient = pShapeSVG.fillGradient;
            this.fillGradientPaint = pShapeSVG.fillGradientPaint;
            this.fillName = pShapeSVG.fillName;
            this.opacity = pShapeSVG.opacity;
        }
        this.element = xML;
        this.name = xML.getString("id");
        if (this.name != null) {
            while ((object = PApplet.match(this.name, "_x([A-Za-z0-9]{2})_")) != null) {
                char c = (char)PApplet.unhex((String)object[1]);
                this.name = this.name.replace((CharSequence)object[0], "" + c);
            }
        }
        this.visible = !((String)(object = xML.getString("display", "inline"))).equals("none");
        String string = xML.getString("transform");
        if (string != null) {
            this.matrix = PShapeSVG.parseTransform(string);
        }
        if (bl) {
            this.parseColors(xML);
            this.parseChildren(xML);
        }
    }

    protected void parseChildren(XML xML) {
        XML[] xMLArray = xML.getChildren();
        this.children = new PShape[xMLArray.length];
        this.childCount = 0;
        for (XML xML2 : xMLArray) {
            PShape pShape = this.parseChild(xML2);
            if (pShape == null) continue;
            this.addChild(pShape);
        }
        this.children = (PShape[])PApplet.subset(this.children, 0, this.childCount);
    }

    protected PShape parseChild(XML xML) {
        String string = xML.getName();
        PShapeSVG pShapeSVG = null;
        if (string != null) {
            if (string.equals("g")) {
                pShapeSVG = new PShapeSVG(this, xML, true);
            } else if (string.equals("defs")) {
                pShapeSVG = new PShapeSVG(this, xML, true);
            } else if (string.equals("line")) {
                pShapeSVG = new PShapeSVG(this, xML, true);
                pShapeSVG.parseLine();
            } else if (string.equals("circle")) {
                pShapeSVG = new PShapeSVG(this, xML, true);
                pShapeSVG.parseEllipse(true);
            } else if (string.equals("ellipse")) {
                pShapeSVG = new PShapeSVG(this, xML, true);
                pShapeSVG.parseEllipse(false);
            } else if (string.equals("rect")) {
                pShapeSVG = new PShapeSVG(this, xML, true);
                pShapeSVG.parseRect();
            } else if (string.equals("polygon")) {
                pShapeSVG = new PShapeSVG(this, xML, true);
                pShapeSVG.parsePoly(true);
            } else if (string.equals("polyline")) {
                pShapeSVG = new PShapeSVG(this, xML, true);
                pShapeSVG.parsePoly(false);
            } else if (string.equals("path")) {
                pShapeSVG = new PShapeSVG(this, xML, true);
                pShapeSVG.parsePath();
            } else {
                if (string.equals("radialGradient")) {
                    return new RadialGradient(this, xML);
                }
                if (string.equals("linearGradient")) {
                    return new LinearGradient(this, xML);
                }
                if (string.equals("font")) {
                    return new Font(this, xML);
                }
                if (string.equals("metadata")) {
                    return null;
                }
                if (string.equals("text")) {
                    PGraphics.showWarning("Text and fonts in SVG files are not currently supported, convert text to outlines instead.");
                } else if (string.equals("filter")) {
                    PGraphics.showWarning("Filters are not supported.");
                } else if (string.equals("mask")) {
                    PGraphics.showWarning("Masks are not supported.");
                } else if (string.equals("pattern")) {
                    PGraphics.showWarning("Patterns are not supported.");
                } else if (!string.equals("stop") && !string.equals("sodipodi:namedview")) {
                    PGraphics.showWarning("Ignoring <" + string + "> tag.");
                }
            }
        }
        return pShapeSVG;
    }

    protected void parseLine() {
        this.kind = 4;
        this.family = 1;
        this.params = new float[]{PShapeSVG.getFloatWithUnit(this.element, "x1"), PShapeSVG.getFloatWithUnit(this.element, "y1"), PShapeSVG.getFloatWithUnit(this.element, "x2"), PShapeSVG.getFloatWithUnit(this.element, "y2")};
    }

    protected void parseEllipse(boolean bl) {
        float f;
        float f2;
        this.kind = 31;
        this.family = 1;
        this.params = new float[4];
        this.params[0] = PShapeSVG.getFloatWithUnit(this.element, "cx");
        this.params[1] = PShapeSVG.getFloatWithUnit(this.element, "cy");
        if (bl) {
            f = f2 = PShapeSVG.getFloatWithUnit(this.element, "r");
        } else {
            f = PShapeSVG.getFloatWithUnit(this.element, "rx");
            f2 = PShapeSVG.getFloatWithUnit(this.element, "ry");
        }
        this.params[0] = this.params[0] - f;
        this.params[1] = this.params[1] - f2;
        this.params[2] = f * 2.0f;
        this.params[3] = f2 * 2.0f;
    }

    protected void parseRect() {
        this.kind = 30;
        this.family = 1;
        this.params = new float[]{PShapeSVG.getFloatWithUnit(this.element, "x"), PShapeSVG.getFloatWithUnit(this.element, "y"), PShapeSVG.getFloatWithUnit(this.element, "width"), PShapeSVG.getFloatWithUnit(this.element, "height")};
    }

    protected void parsePoly(boolean bl) {
        this.family = 2;
        this.close = bl;
        String string = this.element.getString("points");
        if (string != null) {
            String[] stringArray = PApplet.splitTokens(string);
            this.vertexCount = stringArray.length;
            this.vertices = new float[this.vertexCount][2];
            for (int i = 0; i < this.vertexCount; ++i) {
                String[] stringArray2 = PApplet.split(stringArray[i], ',');
                this.vertices[i][0] = Float.valueOf(stringArray2[0]).floatValue();
                this.vertices[i][1] = Float.valueOf(stringArray2[1]).floatValue();
            }
        }
    }

    protected void parsePath() {
        this.family = 2;
        this.kind = 0;
        String string = this.element.getString("d");
        if (string == null || PApplet.trim(string).length() == 0) {
            return;
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            boolean bl2 = false;
            if (c == 'M' || c == 'm' || c == 'L' || c == 'l' || c == 'H' || c == 'h' || c == 'V' || c == 'v' || c == 'C' || c == 'c' || c == 'S' || c == 's' || c == 'Q' || c == 'q' || c == 'T' || c == 't' || c == 'Z' || c == 'z' || c == ',') {
                bl2 = true;
                if (i != 0) {
                    stringBuffer.append("|");
                }
            }
            if (c == 'Z' || c == 'z') {
                bl2 = false;
            }
            if (!(c != '-' || bl || i != 0 && cArray[i - 1] == 'e')) {
                stringBuffer.append("|");
            }
            if (c != ',') {
                stringBuffer.append(c);
            }
            if (bl2 && c != ',' && c != '-') {
                stringBuffer.append("|");
            }
            bl = bl2;
        }
        String[] stringArray = PApplet.splitTokens(stringBuffer.toString(), "| \t\n\r\f\u00a0");
        this.vertices = new float[stringArray.length][2];
        this.vertexCodes = new int[stringArray.length];
        float f = 0.0f;
        float f2 = 0.0f;
        int n = 0;
        int n2 = 0;
        boolean bl3 = false;
        float f3 = 0.0f;
        float f4 = 0.0f;
        block20: while (n < stringArray.length) {
            int n3 = stringArray[n].charAt(0);
            if ((n3 >= 48 && n3 <= 57 || n3 == 45) && n2 != 0) {
                n3 = n2;
                --n;
            } else {
                n2 = n3;
            }
            switch (n3) {
                case 77: {
                    f = PApplet.parseFloat(stringArray[n + 1]);
                    f2 = PApplet.parseFloat(stringArray[n + 2]);
                    f3 = f;
                    f4 = f2;
                    this.parsePathMoveto(f, f2);
                    n2 = 76;
                    n += 3;
                    continue block20;
                }
                case 109: {
                    this.parsePathMoveto(f += PApplet.parseFloat(stringArray[n + 1]), f2 += PApplet.parseFloat(stringArray[n + 2]));
                    n2 = 108;
                    n += 3;
                    continue block20;
                }
                case 76: {
                    f = PApplet.parseFloat(stringArray[n + 1]);
                    f2 = PApplet.parseFloat(stringArray[n + 2]);
                    this.parsePathLineto(f, f2);
                    n += 3;
                    continue block20;
                }
                case 108: {
                    this.parsePathLineto(f += PApplet.parseFloat(stringArray[n + 1]), f2 += PApplet.parseFloat(stringArray[n + 2]));
                    n += 3;
                    continue block20;
                }
                case 72: {
                    f = PApplet.parseFloat(stringArray[n + 1]);
                    this.parsePathLineto(f, f2);
                    n += 2;
                    continue block20;
                }
                case 104: {
                    this.parsePathLineto(f += PApplet.parseFloat(stringArray[n + 1]), f2);
                    n += 2;
                    continue block20;
                }
                case 86: {
                    f2 = PApplet.parseFloat(stringArray[n + 1]);
                    this.parsePathLineto(f, f2);
                    n += 2;
                    continue block20;
                }
                case 118: {
                    this.parsePathLineto(f, f2 += PApplet.parseFloat(stringArray[n + 1]));
                    n += 2;
                    continue block20;
                }
                case 67: {
                    float f5 = PApplet.parseFloat(stringArray[n + 1]);
                    float f6 = PApplet.parseFloat(stringArray[n + 2]);
                    float f7 = PApplet.parseFloat(stringArray[n + 3]);
                    float f8 = PApplet.parseFloat(stringArray[n + 4]);
                    float f9 = PApplet.parseFloat(stringArray[n + 5]);
                    float f10 = PApplet.parseFloat(stringArray[n + 6]);
                    this.parsePathCurveto(f5, f6, f7, f8, f9, f10);
                    f = f9;
                    f2 = f10;
                    n += 7;
                    bl3 = true;
                    continue block20;
                }
                case 99: {
                    float f5 = f + PApplet.parseFloat(stringArray[n + 1]);
                    float f6 = f2 + PApplet.parseFloat(stringArray[n + 2]);
                    float f7 = f + PApplet.parseFloat(stringArray[n + 3]);
                    float f8 = f2 + PApplet.parseFloat(stringArray[n + 4]);
                    float f9 = f + PApplet.parseFloat(stringArray[n + 5]);
                    float f10 = f2 + PApplet.parseFloat(stringArray[n + 6]);
                    this.parsePathCurveto(f5, f6, f7, f8, f9, f10);
                    f = f9;
                    f2 = f10;
                    n += 7;
                    bl3 = true;
                    continue block20;
                }
                case 83: {
                    float f11;
                    float f12;
                    float f8;
                    float f7;
                    float f6;
                    float f5;
                    if (!bl3) {
                        f12 = f;
                        f11 = f2;
                    } else {
                        f5 = this.vertices[this.vertexCount - 2][0];
                        f6 = this.vertices[this.vertexCount - 2][1];
                        f7 = this.vertices[this.vertexCount - 1][0];
                        f8 = this.vertices[this.vertexCount - 1][1];
                        f12 = f7 + (f7 - f5);
                        f11 = f8 + (f8 - f6);
                    }
                    f5 = PApplet.parseFloat(stringArray[n + 1]);
                    f6 = PApplet.parseFloat(stringArray[n + 2]);
                    f7 = PApplet.parseFloat(stringArray[n + 3]);
                    f8 = PApplet.parseFloat(stringArray[n + 4]);
                    this.parsePathCurveto(f12, f11, f5, f6, f7, f8);
                    f = f7;
                    f2 = f8;
                    n += 5;
                    bl3 = true;
                    continue block20;
                }
                case 115: {
                    float f11;
                    float f12;
                    float f8;
                    float f7;
                    float f6;
                    float f5;
                    if (!bl3) {
                        f12 = f;
                        f11 = f2;
                    } else {
                        f5 = this.vertices[this.vertexCount - 2][0];
                        f6 = this.vertices[this.vertexCount - 2][1];
                        f7 = this.vertices[this.vertexCount - 1][0];
                        f8 = this.vertices[this.vertexCount - 1][1];
                        f12 = f7 + (f7 - f5);
                        f11 = f8 + (f8 - f6);
                    }
                    f5 = f + PApplet.parseFloat(stringArray[n + 1]);
                    f6 = f2 + PApplet.parseFloat(stringArray[n + 2]);
                    f7 = f + PApplet.parseFloat(stringArray[n + 3]);
                    f8 = f2 + PApplet.parseFloat(stringArray[n + 4]);
                    this.parsePathCurveto(f12, f11, f5, f6, f7, f8);
                    f = f7;
                    f2 = f8;
                    n += 5;
                    bl3 = true;
                    continue block20;
                }
                case 81: {
                    float f12 = PApplet.parseFloat(stringArray[n + 1]);
                    float f11 = PApplet.parseFloat(stringArray[n + 2]);
                    float f5 = PApplet.parseFloat(stringArray[n + 3]);
                    float f6 = PApplet.parseFloat(stringArray[n + 4]);
                    this.parsePathQuadto(f12, f11, f5, f6);
                    f = f5;
                    f2 = f6;
                    n += 5;
                    bl3 = true;
                    continue block20;
                }
                case 113: {
                    float f12 = f + PApplet.parseFloat(stringArray[n + 1]);
                    float f11 = f2 + PApplet.parseFloat(stringArray[n + 2]);
                    float f5 = f + PApplet.parseFloat(stringArray[n + 3]);
                    float f6 = f2 + PApplet.parseFloat(stringArray[n + 4]);
                    this.parsePathQuadto(f12, f11, f5, f6);
                    f = f5;
                    f2 = f6;
                    n += 5;
                    bl3 = true;
                    continue block20;
                }
                case 84: {
                    float f11;
                    float f12;
                    float f8;
                    float f7;
                    float f6;
                    float f5;
                    if (!bl3) {
                        f12 = f;
                        f11 = f2;
                    } else {
                        f5 = this.vertices[this.vertexCount - 2][0];
                        f6 = this.vertices[this.vertexCount - 2][1];
                        f7 = this.vertices[this.vertexCount - 1][0];
                        f8 = this.vertices[this.vertexCount - 1][1];
                        f12 = f7 + (f7 - f5);
                        f11 = f8 + (f8 - f6);
                    }
                    f5 = PApplet.parseFloat(stringArray[n + 1]);
                    f6 = PApplet.parseFloat(stringArray[n + 2]);
                    this.parsePathQuadto(f12, f11, f5, f6);
                    f = f5;
                    f2 = f6;
                    n += 3;
                    bl3 = true;
                    continue block20;
                }
                case 116: {
                    float f11;
                    float f12;
                    float f8;
                    float f7;
                    float f6;
                    float f5;
                    if (!bl3) {
                        f12 = f;
                        f11 = f2;
                    } else {
                        f5 = this.vertices[this.vertexCount - 2][0];
                        f6 = this.vertices[this.vertexCount - 2][1];
                        f7 = this.vertices[this.vertexCount - 1][0];
                        f8 = this.vertices[this.vertexCount - 1][1];
                        f12 = f7 + (f7 - f5);
                        f11 = f8 + (f8 - f6);
                    }
                    f5 = f + PApplet.parseFloat(stringArray[n + 1]);
                    f6 = f2 + PApplet.parseFloat(stringArray[n + 2]);
                    this.parsePathQuadto(f12, f11, f5, f6);
                    f = f5;
                    f2 = f6;
                    n += 3;
                    bl3 = true;
                    continue block20;
                }
                case 90: 
                case 122: {
                    f = f3;
                    f2 = f4;
                    this.close = true;
                    ++n;
                    continue block20;
                }
            }
            String string2 = PApplet.join(PApplet.subset(stringArray, 0, n), ",");
            String string3 = PApplet.join(PApplet.subset(stringArray, n), ",");
            System.err.println("parsed: " + string2);
            System.err.println("unparsed: " + string3);
            if (stringArray[n].equals("a") || stringArray[n].equals("A")) {
                String string4 = "Sorry, elliptical arc support for SVG files is not yet implemented (See issue 130 for updates)";
                throw new RuntimeException(string4);
            }
            throw new RuntimeException("shape command not handled: " + stringArray[n]);
        }
    }

    private void parsePathVertex(float f, float f2) {
        if (this.vertexCount == this.vertices.length) {
            float[][] fArray = new float[this.vertexCount << 1][2];
            System.arraycopy(this.vertices, 0, fArray, 0, this.vertexCount);
            this.vertices = fArray;
        }
        this.vertices[this.vertexCount][0] = f;
        this.vertices[this.vertexCount][1] = f2;
        ++this.vertexCount;
    }

    private void parsePathCode(int n) {
        if (this.vertexCodeCount == this.vertexCodes.length) {
            this.vertexCodes = PApplet.expand(this.vertexCodes);
        }
        this.vertexCodes[this.vertexCodeCount++] = n;
    }

    private void parsePathMoveto(float f, float f2) {
        if (this.vertexCount > 0) {
            this.parsePathCode(4);
        }
        this.parsePathCode(0);
        this.parsePathVertex(f, f2);
    }

    private void parsePathLineto(float f, float f2) {
        this.parsePathCode(0);
        this.parsePathVertex(f, f2);
    }

    private void parsePathCurveto(float f, float f2, float f3, float f4, float f5, float f6) {
        this.parsePathCode(1);
        this.parsePathVertex(f, f2);
        this.parsePathVertex(f3, f4);
        this.parsePathVertex(f5, f6);
    }

    private void parsePathQuadto(float f, float f2, float f3, float f4) {
        this.parsePathCode(2);
        this.parsePathVertex(f, f2);
        this.parsePathVertex(f3, f4);
    }

    protected static PMatrix2D parseTransform(String string) {
        string = string.trim();
        PMatrix2D pMatrix2D = null;
        int n = 0;
        int n2 = -1;
        while ((n2 = string.indexOf(41, n)) != -1) {
            PMatrix2D pMatrix2D2 = PShapeSVG.parseSingleTransform(string.substring(n, n2 + 1));
            if (pMatrix2D == null) {
                pMatrix2D = pMatrix2D2;
            } else {
                pMatrix2D.apply(pMatrix2D2);
            }
            n = n2 + 1;
        }
        return pMatrix2D;
    }

    protected static PMatrix2D parseSingleTransform(String string) {
        String[] stringArray = PApplet.match(string, "[,\\s]*(\\w+)\\((.*)\\)");
        if (stringArray == null) {
            System.err.println("Could not parse transform " + string);
            return null;
        }
        float[] fArray = PApplet.parseFloat(PApplet.splitTokens(stringArray[2], ", "));
        if (stringArray[1].equals("matrix")) {
            return new PMatrix2D(fArray[0], fArray[2], fArray[4], fArray[1], fArray[3], fArray[5]);
        }
        if (stringArray[1].equals("translate")) {
            float f = fArray[0];
            float f2 = fArray.length == 2 ? fArray[1] : fArray[0];
            return new PMatrix2D(1.0f, 0.0f, f, 0.0f, 1.0f, f2);
        }
        if (stringArray[1].equals("scale")) {
            float f = fArray[0];
            float f3 = fArray.length == 2 ? fArray[1] : fArray[0];
            return new PMatrix2D(f, 0.0f, 0.0f, 0.0f, f3, 0.0f);
        }
        if (stringArray[1].equals("rotate")) {
            float f = fArray[0];
            if (fArray.length == 1) {
                float f4 = PApplet.cos(f);
                float f5 = PApplet.sin(f);
                return new PMatrix2D(f4, -f5, 0.0f, f5, f4, 0.0f);
            }
            if (fArray.length == 3) {
                PMatrix2D pMatrix2D = new PMatrix2D(0.0f, 1.0f, fArray[1], 1.0f, 0.0f, fArray[2]);
                pMatrix2D.rotate(fArray[0]);
                pMatrix2D.translate(-fArray[1], -fArray[2]);
                return pMatrix2D;
            }
        } else {
            if (stringArray[1].equals("skewX")) {
                return new PMatrix2D(1.0f, 0.0f, 1.0f, PApplet.tan(fArray[0]), 0.0f, 0.0f);
            }
            if (stringArray[1].equals("skewY")) {
                return new PMatrix2D(1.0f, 0.0f, 1.0f, 0.0f, PApplet.tan(fArray[0]), 0.0f);
            }
        }
        return null;
    }

    protected void parseColors(XML xML) {
        String string;
        if (xML.hasAttribute("opacity")) {
            string = xML.getString("opacity");
            this.setOpacity(string);
        }
        if (xML.hasAttribute("stroke")) {
            string = xML.getString("stroke");
            this.setColor(string, false);
        }
        if (xML.hasAttribute("stroke-opacity")) {
            string = xML.getString("stroke-opacity");
            this.setStrokeOpacity(string);
        }
        if (xML.hasAttribute("stroke-width")) {
            string = xML.getString("stroke-width");
            this.setStrokeWeight(string);
        }
        if (xML.hasAttribute("stroke-linejoin")) {
            string = xML.getString("stroke-linejoin");
            this.setStrokeJoin(string);
        }
        if (xML.hasAttribute("stroke-linecap")) {
            string = xML.getString("stroke-linecap");
            this.setStrokeCap(string);
        }
        if (xML.hasAttribute("fill")) {
            string = xML.getString("fill");
            this.setColor(string, true);
        }
        if (xML.hasAttribute("fill-opacity")) {
            string = xML.getString("fill-opacity");
            this.setFillOpacity(string);
        }
        if (xML.hasAttribute("style")) {
            string = xML.getString("style");
            String[] stringArray = PApplet.splitTokens(string, ";");
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = PApplet.splitTokens(stringArray[i], ":");
                stringArray2[0] = PApplet.trim(stringArray2[0]);
                if (stringArray2[0].equals("fill")) {
                    this.setColor(stringArray2[1], true);
                    continue;
                }
                if (stringArray2[0].equals("fill-opacity")) {
                    this.setFillOpacity(stringArray2[1]);
                    continue;
                }
                if (stringArray2[0].equals("stroke")) {
                    this.setColor(stringArray2[1], false);
                    continue;
                }
                if (stringArray2[0].equals("stroke-width")) {
                    this.setStrokeWeight(stringArray2[1]);
                    continue;
                }
                if (stringArray2[0].equals("stroke-linecap")) {
                    this.setStrokeCap(stringArray2[1]);
                    continue;
                }
                if (stringArray2[0].equals("stroke-linejoin")) {
                    this.setStrokeJoin(stringArray2[1]);
                    continue;
                }
                if (stringArray2[0].equals("stroke-opacity")) {
                    this.setStrokeOpacity(stringArray2[1]);
                    continue;
                }
                if (!stringArray2[0].equals("opacity")) continue;
                this.setOpacity(stringArray2[1]);
            }
        }
    }

    void setOpacity(String string) {
        this.opacity = PApplet.parseFloat(string);
        this.strokeColor = (int)(this.opacity * 255.0f) << 24 | this.strokeColor & 0xFFFFFF;
        this.fillColor = (int)(this.opacity * 255.0f) << 24 | this.fillColor & 0xFFFFFF;
    }

    void setStrokeWeight(String string) {
        this.strokeWeight = PShapeSVG.parseUnitSize(string);
    }

    void setStrokeOpacity(String string) {
        this.strokeOpacity = PApplet.parseFloat(string);
        this.strokeColor = (int)(this.strokeOpacity * 255.0f) << 24 | this.strokeColor & 0xFFFFFF;
    }

    void setStrokeJoin(String string) {
        if (!string.equals("inherit")) {
            if (string.equals("miter")) {
                this.strokeJoin = 8;
            } else if (string.equals("round")) {
                this.strokeJoin = 2;
            } else if (string.equals("bevel")) {
                this.strokeJoin = 32;
            }
        }
    }

    void setStrokeCap(String string) {
        if (!string.equals("inherit")) {
            if (string.equals("butt")) {
                this.strokeCap = 1;
            } else if (string.equals("round")) {
                this.strokeCap = 2;
            } else if (string.equals("square")) {
                this.strokeCap = 4;
            }
        }
    }

    void setFillOpacity(String string) {
        this.fillOpacity = PApplet.parseFloat(string);
        this.fillColor = (int)(this.fillOpacity * 255.0f) << 24 | this.fillColor & 0xFFFFFF;
    }

    void setColor(String string, boolean bl) {
        int n = this.fillColor & 0xFF000000;
        boolean bl2 = true;
        int n2 = 0;
        String string2 = "";
        Gradient gradient = null;
        Shader shader = null;
        if (string.equals("none")) {
            bl2 = false;
        } else if (string.equals("black")) {
            n2 = n;
        } else if (string.equals("white")) {
            n2 = n | 0xFFFFFF;
        } else if (string.startsWith("#")) {
            if (string.length() == 4) {
                string = string.replaceAll("^#(.)(.)(.)$", "#$1$1$2$2$3$3");
            }
            n2 = n | Integer.parseInt(string.substring(1), 16) & 0xFFFFFF;
        } else if (string.startsWith("rgb")) {
            n2 = n | PShapeSVG.parseRGB(string);
        } else if (string.startsWith("url(#")) {
            string2 = string.substring(5, string.length() - 1);
            PShape pShape = this.findChild(string2);
            if (pShape instanceof Gradient) {
                gradient = (Gradient)pShape;
                shader = this.calcGradientPaint(gradient);
            } else {
                System.err.println("url " + string2 + " refers to unexpected data: " + pShape);
            }
        }
        if (bl) {
            this.fill = bl2;
            this.fillColor = n2;
            this.fillName = string2;
            this.fillGradient = gradient;
            this.fillGradientPaint = shader;
        } else {
            this.stroke = bl2;
            this.strokeColor = n2;
            this.strokeName = string2;
            this.strokeGradient = gradient;
            this.strokeGradientPaint = shader;
        }
    }

    protected static int parseRGB(String string) {
        int n = string.indexOf(40) + 1;
        int n2 = string.indexOf(41);
        String string2 = string.substring(n, n2);
        int[] nArray = PApplet.parseInt(PApplet.splitTokens(string2, ", "));
        return nArray[0] << 16 | nArray[1] << 8 | nArray[2];
    }

    protected static HashMap<String, String> parseStyleAttributes(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = string.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split(":");
            hashMap.put(stringArray2[0], stringArray2[1]);
        }
        return hashMap;
    }

    protected static float getFloatWithUnit(XML xML, String string) {
        String string2 = xML.getString(string);
        return string2 == null ? 0.0f : PShapeSVG.parseUnitSize(string2);
    }

    protected static float parseUnitSize(String string) {
        int n = string.length() - 2;
        if (string.endsWith("pt")) {
            return PApplet.parseFloat(string.substring(0, n)) * 1.25f;
        }
        if (string.endsWith("pc")) {
            return PApplet.parseFloat(string.substring(0, n)) * 15.0f;
        }
        if (string.endsWith("mm")) {
            return PApplet.parseFloat(string.substring(0, n)) * 3.543307f;
        }
        if (string.endsWith("cm")) {
            return PApplet.parseFloat(string.substring(0, n)) * 35.43307f;
        }
        if (string.endsWith("in")) {
            return PApplet.parseFloat(string.substring(0, n)) * 90.0f;
        }
        if (string.endsWith("px")) {
            return PApplet.parseFloat(string.substring(0, n));
        }
        return PApplet.parseFloat(string);
    }

    protected Shader calcGradientPaint(Gradient gradient) {
        int[] nArray = new int[gradient.count];
        int n = (int)(this.opacity * 255.0f) << 24;
        for (int i = 0; i < gradient.count; ++i) {
            nArray[i] = n | gradient.color[i] & 0xFFFFFF;
        }
        if (gradient instanceof LinearGradient) {
            LinearGradient linearGradient = (LinearGradient)gradient;
            return new android.graphics.LinearGradient(linearGradient.x1, linearGradient.y1, linearGradient.x2, linearGradient.y2, nArray, linearGradient.offset, Shader.TileMode.CLAMP);
        }
        if (gradient instanceof RadialGradient) {
            RadialGradient radialGradient = (RadialGradient)gradient;
            return new android.graphics.RadialGradient(radialGradient.cx, radialGradient.cy, radialGradient.r, nArray, radialGradient.offset, Shader.TileMode.CLAMP);
        }
        return null;
    }

    @Override
    protected void styles(PGraphics pGraphics) {
        super.styles(pGraphics);
        if (pGraphics instanceof PGraphicsAndroid2D) {
            PGraphicsAndroid2D pGraphicsAndroid2D = (PGraphicsAndroid2D)pGraphics;
            if (this.strokeGradient != null) {
                pGraphicsAndroid2D.strokePaint.setShader(this.strokeGradientPaint);
            }
            if (this.fillGradient != null) {
                pGraphicsAndroid2D.fillPaint.setShader(this.fillGradientPaint);
            }
        }
    }

    @Override
    public PShape getChild(String string) {
        PShape pShape = super.getChild(string);
        if (pShape == null) {
            pShape = super.getChild(string.replace(' ', '_'));
        }
        if (pShape != null) {
            pShape.width = this.width;
            pShape.height = this.height;
        }
        return pShape;
    }

    public void print() {
        PApplet.println(this.element.toString());
    }

    public class FontGlyph
    extends PShapeSVG {
        public String name;
        char unicode;
        int horizAdvX;

        public FontGlyph(PShapeSVG pShapeSVG2, XML xML, Font font) {
            super(pShapeSVG2, xML, true);
            super.parsePath();
            this.name = xML.getString("glyph-name");
            String string = xML.getString("unicode");
            this.unicode = '\u0000';
            if (string != null) {
                if (string.length() == 1) {
                    this.unicode = string.charAt(0);
                } else {
                    System.err.println("unicode for " + this.name + " is more than one char: " + string);
                }
            }
            this.horizAdvX = xML.hasAttribute("horiz-adv-x") ? xML.getInt("horiz-adv-x") : font.horizAdvX;
        }

        protected boolean isLegit() {
            return this.vertexCount != 0;
        }
    }

    class FontFace
    extends PShapeSVG {
        int horizOriginX;
        int horizOriginY;
        int vertOriginX;
        int vertOriginY;
        int vertAdvY;
        String fontFamily;
        int fontWeight;
        String fontStretch;
        int unitsPerEm;
        int[] panose1;
        int ascent;
        int descent;
        int[] bbox;
        int underlineThickness;
        int underlinePosition;

        public FontFace(PShapeSVG pShapeSVG2, XML xML) {
            super(pShapeSVG2, xML, true);
            this.unitsPerEm = xML.getInt("units-per-em", 1000);
        }

        protected void drawShape() {
        }
    }

    public class Font
    extends PShapeSVG {
        public FontFace face;
        public HashMap<String, FontGlyph> namedGlyphs;
        public HashMap<Character, FontGlyph> unicodeGlyphs;
        public int glyphCount;
        public FontGlyph[] glyphs;
        public FontGlyph missingGlyph;
        int horizAdvX;

        public Font(PShapeSVG pShapeSVG2, XML xML) {
            super(pShapeSVG2, xML, false);
            XML[] xMLArray = xML.getChildren();
            this.horizAdvX = xML.getInt("horiz-adv-x", 0);
            this.namedGlyphs = new HashMap();
            this.unicodeGlyphs = new HashMap();
            this.glyphCount = 0;
            this.glyphs = new FontGlyph[xMLArray.length];
            for (int i = 0; i < xMLArray.length; ++i) {
                String string = xMLArray[i].getName();
                XML xML2 = xMLArray[i];
                if (string == null) continue;
                if (string.equals("glyph")) {
                    FontGlyph fontGlyph = new FontGlyph(this, xML2, this);
                    if (fontGlyph.isLegit()) {
                        if (fontGlyph.name != null) {
                            this.namedGlyphs.put(fontGlyph.name, fontGlyph);
                        }
                        if (fontGlyph.unicode != '\u0000') {
                            this.unicodeGlyphs.put(new Character(fontGlyph.unicode), fontGlyph);
                        }
                    }
                    this.glyphs[this.glyphCount++] = fontGlyph;
                    continue;
                }
                if (string.equals("missing-glyph")) {
                    this.missingGlyph = new FontGlyph(this, xML2, this);
                    continue;
                }
                if (string.equals("font-face")) {
                    this.face = (PShapeSVG)this.new FontFace(this, xML2);
                    continue;
                }
                System.err.println("Ignoring " + string + " inside <font>");
            }
        }

        protected void drawShape() {
        }

        public void drawString(PGraphics pGraphics, String string, float f, float f2, float f3) {
            pGraphics.pushMatrix();
            float f4 = f3 / (float)this.face.unitsPerEm;
            pGraphics.translate(f, f2);
            pGraphics.scale(f4, -f4);
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                FontGlyph fontGlyph = this.unicodeGlyphs.get(new Character(cArray[i]));
                if (fontGlyph != null) {
                    fontGlyph.draw(pGraphics);
                    pGraphics.translate(fontGlyph.horizAdvX, 0.0f);
                    continue;
                }
                System.err.println("'" + cArray[i] + "' not available.");
            }
            pGraphics.popMatrix();
        }

        public void drawChar(PGraphics pGraphics, char c, float f, float f2, float f3) {
            pGraphics.pushMatrix();
            float f4 = f3 / (float)this.face.unitsPerEm;
            pGraphics.translate(f, f2);
            pGraphics.scale(f4, -f4);
            FontGlyph fontGlyph = this.unicodeGlyphs.get(new Character(c));
            if (fontGlyph != null) {
                pGraphics.shape(fontGlyph);
            }
            pGraphics.popMatrix();
        }

        public float textWidth(String string, float f) {
            float f2 = 0.0f;
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                FontGlyph fontGlyph = this.unicodeGlyphs.get(new Character(cArray[i]));
                if (fontGlyph == null) continue;
                f2 += (float)fontGlyph.horizAdvX / (float)this.face.unitsPerEm;
            }
            return f2 * f;
        }
    }

    class RadialGradient
    extends Gradient {
        float cx;
        float cy;
        float r;

        public RadialGradient(PShapeSVG pShapeSVG2, XML xML) {
            super(pShapeSVG2, xML);
            this.cx = RadialGradient.getFloatWithUnit(xML, "cx");
            this.cy = RadialGradient.getFloatWithUnit(xML, "cy");
            this.r = RadialGradient.getFloatWithUnit(xML, "r");
            String string = xML.getString("gradientTransform");
            if (string != null) {
                float[] fArray = RadialGradient.parseTransform(string).get(null);
                this.transform = new Matrix();
                this.transform.setValues(new float[]{fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5], 0.0f, 0.0f, 1.0f});
                float[] fArray2 = new float[]{this.cx, this.cy};
                float[] fArray3 = new float[]{this.cx + this.r, this.cy};
                this.transform.mapPoints(fArray2);
                this.transform.mapPoints(fArray3);
                this.cx = fArray2[0];
                this.cy = fArray2[1];
                this.r = fArray3[0] - fArray2[0];
            }
        }
    }

    class LinearGradient
    extends Gradient {
        float x1;
        float y1;
        float x2;
        float y2;

        public LinearGradient(PShapeSVG pShapeSVG2, XML xML) {
            super(pShapeSVG2, xML);
            this.x1 = LinearGradient.getFloatWithUnit(xML, "x1");
            this.y1 = LinearGradient.getFloatWithUnit(xML, "y1");
            this.x2 = LinearGradient.getFloatWithUnit(xML, "x2");
            this.y2 = LinearGradient.getFloatWithUnit(xML, "y2");
            String string = xML.getString("gradientTransform");
            if (string != null) {
                float[] fArray = LinearGradient.parseTransform(string).get(null);
                this.transform = new Matrix();
                this.transform.setValues(new float[]{fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5], 0.0f, 0.0f, 1.0f});
                float[] fArray2 = new float[]{this.x1, this.y1};
                float[] fArray3 = new float[]{this.x2, this.y2};
                this.transform.mapPoints(fArray2);
                this.transform.mapPoints(fArray3);
                this.x1 = fArray2[0];
                this.y1 = fArray2[1];
                this.x2 = fArray3[0];
                this.y2 = fArray3[1];
            }
        }
    }

    static class Gradient
    extends PShapeSVG {
        Matrix transform;
        float[] offset;
        int[] color;
        int count;

        public Gradient(PShapeSVG pShapeSVG, XML xML) {
            super(pShapeSVG, xML, true);
            XML[] xMLArray = xML.getChildren();
            this.offset = new float[xMLArray.length];
            this.color = new int[xMLArray.length];
            for (int i = 0; i < xMLArray.length; ++i) {
                String string;
                XML xML2 = xMLArray[i];
                String string2 = xML2.getName();
                if (!string2.equals("stop")) continue;
                String string3 = xML2.getString("offset");
                float f = 1.0f;
                if (string3.endsWith("%")) {
                    f = 100.0f;
                    string3 = string3.substring(0, string3.length() - 1);
                }
                this.offset[this.count] = PApplet.parseFloat(string3) / f;
                String string4 = xML2.getString("style");
                HashMap<String, String> hashMap = Gradient.parseStyleAttributes(string4);
                String string5 = hashMap.get("stop-color");
                if (string5 == null) {
                    string5 = "#000000";
                }
                if ((string = hashMap.get("stop-opacity")) == null) {
                    string = "1";
                }
                int n = (int)(PApplet.parseFloat(string) * 255.0f);
                this.color[this.count] = n << 24 | Integer.parseInt(string5.substring(1), 16);
                ++this.count;
            }
            this.offset = PApplet.subset(this.offset, 0, this.count);
            this.color = PApplet.subset(this.color, 0, this.count);
        }
    }
}

