/*
 * Decompiled with CFR 0.152.
 */
package ketai.sensors;

import android.location.Criteria;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import ketai.sensors.Location;
import processing.core.PApplet;

public class KetaiLocation
implements LocationListener {
    private LocationManager locationManager = null;
    private PApplet parent;
    private Method onLocationEventMethod1arg;
    private Method onLocationEventMethod2arg;
    private Method onLocationEventMethod3arg;
    private Method onLocationEventMethod4arg;
    private String provider;
    private Location location;
    KetaiLocation me;
    private long minTime = 10000L;
    private float minDistance = 1.0f;
    static final String SERVICE_DESCRIPTION = "Android Location.";
    private Object callbackdelegate;

    public KetaiLocation(PApplet pParent) {
        this.parent = pParent;
        this.me = this;
        this.locationManager = (LocationManager)this.parent.getActivity().getApplicationContext().getSystemService("location");
        PApplet.println((String)("KetaiLocationManager instantiated:" + this.locationManager.toString()));
        this.findObjectIntentions(this.parent);
        this.start();
    }

    public void onLocationChanged(Location _location) {
        PApplet.println((String)("LocationChanged:" + _location.toString()));
        this.location = _location;
        if (this.onLocationEventMethod1arg != null) {
            try {
                this.onLocationEventMethod1arg.invoke(this.callbackdelegate, new Object[]{this.location});
                return;
            }
            catch (Exception e) {
                PApplet.println((String)("Disabling onLocationEvent() because of an error:" + e.getMessage()));
                e.printStackTrace();
                this.onLocationEventMethod1arg = null;
            }
        }
        if (this.onLocationEventMethod2arg != null) {
            try {
                this.onLocationEventMethod2arg.invoke(this.callbackdelegate, this.location.getLatitude(), this.location.getLongitude());
                return;
            }
            catch (Exception e) {
                PApplet.println((String)("Disabling onLocationEvent() because of an error:" + e.getMessage()));
                e.printStackTrace();
                this.onLocationEventMethod2arg = null;
            }
        }
        if (this.onLocationEventMethod3arg != null) {
            try {
                this.onLocationEventMethod3arg.invoke(this.callbackdelegate, this.location.getLatitude(), this.location.getLongitude(), this.location.getAltitude());
                return;
            }
            catch (Exception e) {
                PApplet.println((String)("Disabling onLocationEvent() because of an error:" + e.getMessage()));
                e.printStackTrace();
                this.onLocationEventMethod3arg = null;
            }
        }
        if (this.onLocationEventMethod4arg != null) {
            try {
                this.onLocationEventMethod4arg.invoke(this.callbackdelegate, this.location.getLatitude(), this.location.getLongitude(), this.location.getAltitude(), Float.valueOf(this.location.getAccuracy()));
                return;
            }
            catch (Exception e) {
                PApplet.println((String)("Disabling onLocationEvent() because of an error:" + e.getMessage()));
                e.printStackTrace();
                this.onLocationEventMethod4arg = null;
            }
        }
    }

    public Location getLocation() {
        return this.location;
    }

    public boolean isStarted() {
        return this.onLocationEventMethod4arg != null;
    }

    public void start() {
        PApplet.println((String)"KetaiLocationManager: start()...");
        List foo = this.locationManager.getAllProviders();
        PApplet.println((String)"KetaiLocationManager All Provider(s) list: ");
        for (String s : foo) {
            PApplet.println((String)("\t" + s));
        }
        if (!this.determineProvider()) {
            PApplet.println((String)"Error obtaining location provider.  Check your location settings.");
            this.provider = "none";
        }
        if (this.location == null) {
            foo = this.locationManager.getProviders(true);
            PApplet.println((String)"KetaiLocationManager Enabled Provider(s) list: ");
            for (String s : foo) {
                android.location.Location l;
                if (this.location != null || (l = this.locationManager.getLastKnownLocation(s)) == null) continue;
                this.location = new Location(l);
                PApplet.println((String)("\t" + s + " - lastLocation for provider:" + this.location.toString()));
            }
            if (this.location == null) {
                this.location = new Location("default");
            }
        }
        this.onLocationChanged(this.location);
    }

    public void stop() {
        PApplet.println((String)"KetaiLocationManager: Stop()....");
        this.locationManager.removeUpdates((LocationListener)this);
    }

    public void onProviderDisabled(String arg0) {
        PApplet.println((String)("LocationManager onProviderDisabled: " + arg0));
        this.determineProvider();
    }

    public void onProviderEnabled(String arg0) {
        PApplet.println((String)("LocationManager onProviderEnabled: " + arg0));
        this.determineProvider();
    }

    public void onStatusChanged(String arg0, int arg1, Bundle arg2) {
        PApplet.println((String)("LocationManager onStatusChanged: " + arg0 + ":" + arg1 + ":" + arg2.toString()));
        this.determineProvider();
    }

    public String getProvider() {
        return this.provider;
    }

    public Collection<? extends String> list() {
        Vector<String> list = new Vector<String>();
        list.add("Location");
        return list;
    }

    public void setUpdateRate(int millis, int meters) {
        this.minTime = millis;
        this.minDistance = meters;
        this.determineProvider();
    }

    private boolean determineProvider() {
        this.provider = this.locationManager.isProviderEnabled("gps") ? "gps" : this.locationManager.getBestProvider(new Criteria(), true);
        if (this.provider == null) {
            return false;
        }
        PApplet.println((String)("Requesting location updates from: " + this.provider));
        this.parent.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                KetaiLocation.this.locationManager.requestLocationUpdates(KetaiLocation.this.provider, KetaiLocation.this.minTime, KetaiLocation.this.minDistance, (LocationListener)KetaiLocation.this.me);
            }
        });
        return true;
    }

    private void findObjectIntentions(Object o) {
        this.callbackdelegate = o;
        try {
            this.onLocationEventMethod1arg = this.callbackdelegate.getClass().getMethod("onLocationEvent", Location.class);
            PApplet.println((String)"Found Advanced onLocationEventMethod(Location)...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.onLocationEventMethod2arg = this.callbackdelegate.getClass().getMethod("onLocationEvent", Double.TYPE, Double.TYPE);
            PApplet.println((String)"Found Advanced onLocationEventMethod(long, lat)...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.onLocationEventMethod3arg = this.callbackdelegate.getClass().getMethod("onLocationEvent", Double.TYPE, Double.TYPE, Double.TYPE);
            PApplet.println((String)"Found basic onLocationEventMethod(long,lat,alt)...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.onLocationEventMethod4arg = this.callbackdelegate.getClass().getMethod("onLocationEvent", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE);
            PApplet.println((String)"Found basic onLocationEventMethod(long,lat,alt, acc)...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void onLocationChanged(android.location.Location arg0) {
        this.onLocationChanged(new Location(arg0));
    }

    public void register(Object delegate) {
        boolean running = this.isStarted();
        if (running) {
            this.stop();
        }
        this.findObjectIntentions(delegate);
        if (running) {
            this.start();
        }
    }
}

