/*
 * Decompiled with CFR 0.152.
 */
package ketai.sensors;

import android.media.AudioRecord;
import android.os.Process;
import android.util.Log;
import java.lang.reflect.Method;
import processing.core.PApplet;

public class KetaiAudioInput
implements Runnable {
    private AudioRecord audioRecorder = null;
    private int bufferSize;
    private int samplesPerSec = 16000;
    private Thread thread = null;
    public Object callbackdelegate;
    private Method callbackMethod;
    private boolean isRecording;
    private String LOG_TAG = "KetaiAudioInput";

    public KetaiAudioInput(Object consumer) {
        this.register(consumer);
    }

    public void start() {
        this.bufferSize = AudioRecord.getMinBufferSize((int)this.samplesPerSec, (int)16, (int)2);
        if (this.bufferSize != -2 && this.bufferSize != -1) {
            PApplet.println((String)("Buffer size: " + this.bufferSize));
            this.audioRecorder = new AudioRecord(0, this.samplesPerSec, 16, 2, this.bufferSize * 10);
            if (this.audioRecorder != null && this.audioRecorder.getState() == 1) {
                Log.i((String)this.LOG_TAG, (String)"Audio Recorder created");
                PApplet.println((String)"Audio Recorder created");
                this.audioRecorder.startRecording();
                this.isRecording = true;
                this.thread = new Thread(this);
                this.thread.start();
            } else {
                Log.e((String)this.LOG_TAG, (String)"Unable to create AudioRecord instance");
                PApplet.println((String)"Unable to create AudioRecord instance");
            }
        } else {
            Log.e((String)this.LOG_TAG, (String)"Unable to get minimum buffer size");
        }
    }

    public void stop() {
        this.isRecording = false;
        if (this.audioRecorder != null) {
            if (this.audioRecorder.getRecordingState() == 3) {
                this.audioRecorder.stop();
            }
            if (this.audioRecorder.getState() == 1) {
                this.audioRecorder.release();
            }
        }
    }

    public boolean isActive() {
        return this.audioRecorder != null ? this.audioRecorder.getRecordingState() == 3 : false;
    }

    @Override
    public void run() {
        Process.setThreadPriority((int)-19);
        while (this.isRecording && this.audioRecorder.getRecordingState() == 3) {
            short[] buf = new short[this.bufferSize];
            this.audioRecorder.read(buf, 0, buf.length);
            try {
                this.callbackMethod.invoke(this.callbackdelegate, new Object[]{buf});
            }
            catch (Exception e) {
                PApplet.println((String)("OOps... onAudioEvent() because of an error:" + e.getMessage()));
                e.printStackTrace();
            }
        }
    }

    public void register(Object o) {
        this.callbackdelegate = o;
        try {
            this.callbackMethod = o.getClass().getMethod("onAudioEvent", short[].class);
            PApplet.println((String)"Found onAudioEvent callback method...");
        }
        catch (NoSuchMethodException e) {
            PApplet.println((String)"Failed to find onAudioEvent callback method...");
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        System.out.println("AudioCapturer finalizer");
        if (this.audioRecorder != null && this.audioRecorder.getState() == 1) {
            this.audioRecorder.stop();
            this.audioRecorder.release();
        }
        this.audioRecorder = null;
        this.thread = null;
    }
}

