/*
 * Decompiled with CFR 0.152.
 */
package ketai.net.wifidirect;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.net.wifi.p2p.WifiP2pConfig;
import android.net.wifi.p2p.WifiP2pDevice;
import android.net.wifi.p2p.WifiP2pDeviceList;
import android.net.wifi.p2p.WifiP2pInfo;
import android.net.wifi.p2p.WifiP2pManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import processing.core.PApplet;

public class KetaiWiFiDirect
extends BroadcastReceiver
implements WifiP2pManager.ChannelListener,
WifiP2pManager.ConnectionInfoListener,
WifiP2pManager.ActionListener,
WifiP2pManager.PeerListListener {
    PApplet parent;
    private WifiP2pManager manager;
    private boolean isWifiP2pEnabled = false;
    private boolean retryChannel = false;
    private List<WifiP2pDevice> peers = new ArrayList<WifiP2pDevice>();
    private final IntentFilter intentFilter = new IntentFilter();
    private WifiP2pManager.Channel channel;
    private String ip = "";

    public KetaiWiFiDirect(PApplet _parent) {
        this.parent = _parent;
        this.intentFilter.addAction("android.net.wifi.p2p.STATE_CHANGED");
        this.intentFilter.addAction("android.net.wifi.p2p.PEERS_CHANGED");
        this.intentFilter.addAction("android.net.wifi.p2p.CONNECTION_STATE_CHANGE");
        this.intentFilter.addAction("android.net.wifi.p2p.THIS_DEVICE_CHANGED");
        this.manager = (WifiP2pManager)this.parent.getActivity().getSystemService("wifip2p");
        this.channel = this.manager.initialize((Context)this.parent.getActivity(), this.parent.getActivity().getMainLooper(), (WifiP2pManager.ChannelListener)this);
        this.parent.getActivity().registerReceiver((BroadcastReceiver)this, this.intentFilter);
        this.parent.registerMethod("resume", (Object)this);
        this.parent.registerMethod("pause", (Object)this);
    }

    public void setIsWifiP2pEnabled(boolean isWifiP2pEnabled) {
        this.isWifiP2pEnabled = isWifiP2pEnabled;
    }

    public void resume() {
        this.parent.getActivity().registerReceiver((BroadcastReceiver)this, this.intentFilter);
    }

    public void pause() {
        this.parent.getActivity().unregisterReceiver((BroadcastReceiver)this);
    }

    private void connectToConfig(WifiP2pConfig config) {
        this.manager.connect(this.channel, config, new WifiP2pManager.ActionListener(){

            public void onSuccess() {
            }

            public void onFailure(int reason) {
                PApplet.println((String)("Connect failed. Retry." + reason));
            }
        });
    }

    public void disconnect() {
        this.manager.removeGroup(this.channel, new WifiP2pManager.ActionListener(){

            public void onFailure(int reasonCode) {
                PApplet.println((String)("Disconnect failed. Reason :" + reasonCode));
            }

            public void onSuccess() {
            }
        });
    }

    public void onChannelDisconnected() {
        if (this.manager != null && !this.retryChannel) {
            PApplet.println((String)"Channel lost. Trying again");
            this.retryChannel = true;
            this.manager.initialize((Context)this.parent.getActivity(), this.parent.getActivity().getMainLooper(), (WifiP2pManager.ChannelListener)this);
        } else {
            PApplet.println((String)"Severe! Channel is probably lost premanently. Try Disable/Re-Enable P2P.");
        }
    }

    public void cancelDisconnect() {
        if (this.manager != null) {
            this.manager.cancelConnect(this.channel, new WifiP2pManager.ActionListener(){

                public void onSuccess() {
                    PApplet.println((String)"Aborting connection");
                }

                public void onFailure(int reasonCode) {
                    PApplet.println((String)("Connect abort request failed. Reason Code: " + reasonCode));
                }
            });
        }
    }

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if ("android.net.wifi.p2p.STATE_CHANGED".equals(action)) {
            int state = intent.getIntExtra("wifi_p2p_state", -1);
            if (state == 2) {
                this.setIsWifiP2pEnabled(true);
            } else {
                this.setIsWifiP2pEnabled(false);
            }
            PApplet.println((String)("P2P state changed - " + state));
        } else if ("android.net.wifi.p2p.PEERS_CHANGED".equals(action)) {
            if (this.manager != null) {
                this.manager.requestPeers(this.channel, (WifiP2pManager.PeerListListener)this);
            }
            PApplet.println((String)"P2P peers changed");
        } else if ("android.net.wifi.p2p.CONNECTION_STATE_CHANGE".equals(action)) {
            if (this.manager == null) {
                return;
            }
            NetworkInfo networkInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
            if (networkInfo.isConnected()) {
                this.manager.requestConnectionInfo(this.channel, (WifiP2pManager.ConnectionInfoListener)this);
            }
        } else if ("android.net.wifi.p2p.THIS_DEVICE_CHANGED".equals(action)) {
            PApplet.println((String)("p2p device changed" + (WifiP2pDevice)intent.getParcelableExtra("wifiP2pDevice")));
        }
    }

    public void getConnectionInfo() {
        this.manager.requestConnectionInfo(this.channel, (WifiP2pManager.ConnectionInfoListener)this);
    }

    public void onConnectionInfoAvailable(WifiP2pInfo arg0) {
        WifiP2pInfo info = arg0;
        if (!arg0.groupFormed) {
            this.ip = "";
            return;
        }
        this.ip = info.groupOwnerAddress.getHostAddress();
        PApplet.println((String)("Connection info available for :" + arg0.toString() + "--" + info.groupOwnerAddress.getHostAddress()));
    }

    public String getIPAddress() {
        return this.ip;
    }

    public void discover() {
        if (this.manager != null) {
            this.manager.discoverPeers(this.channel, (WifiP2pManager.ActionListener)this);
        }
    }

    public void onFailure(int arg0) {
        switch (arg0) {
            case 0: {
                PApplet.println((String)("WifiDirect failed " + arg0));
                break;
            }
            case 1: {
                PApplet.println((String)("WifiDirect failed " + arg0));
                break;
            }
            case 2: {
                PApplet.println((String)("WifiDirect failed " + arg0));
                break;
            }
            default: {
                PApplet.println((String)("WifiDirect failed " + arg0));
            }
        }
    }

    public void onSuccess() {
        PApplet.println((String)"WifiDirect succeeded ");
    }

    public void onPeersAvailable(WifiP2pDeviceList arg0) {
        Collection list = arg0.getDeviceList();
        if (list.size() > 0) {
            this.peers.clear();
            Iterator i = list.iterator();
            while (i.hasNext()) {
                this.peers.add((WifiP2pDevice)i.next());
            }
            PApplet.println((String)"New KetaiWifiDirect peer list received:");
            for (WifiP2pDevice d : this.peers) {
                PApplet.println((String)("\t\t" + d.deviceName + ":" + d.deviceAddress));
            }
        }
    }

    public String getHardwareAddress() {
        WifiManager wm = (WifiManager)this.parent.getActivity().getSystemService("wifi");
        String mac = wm.getConnectionInfo().getMacAddress();
        return mac;
    }

    public void reset() {
        this.peers.clear();
        this.manager.cancelConnect(this.channel, (WifiP2pManager.ActionListener)this);
        this.manager.removeGroup(this.channel, (WifiP2pManager.ActionListener)this);
    }

    public ArrayList<String> getPeerNameList() {
        ArrayList<String> names = new ArrayList<String>();
        for (WifiP2pDevice d : this.peers) {
            names.add(d.deviceName);
        }
        return names;
    }

    public void connect(String deviceName) {
        WifiP2pDevice device = null;
        for (WifiP2pDevice d : this.peers) {
            if (d.deviceAddress != deviceName && d.deviceName != deviceName) continue;
            device = d;
        }
        WifiP2pConfig config = new WifiP2pConfig();
        config.deviceAddress = device != null ? device.deviceAddress : deviceName;
        this.manager.connect(this.channel, config, new WifiP2pManager.ActionListener(){

            public void onSuccess() {
            }

            public void onFailure(int reason) {
                PApplet.println((String)("Failed to connect to device (" + reason + ")"));
            }
        });
    }
}

