/*
 * Decompiled with CFR 0.152.
 */
package ketai.net.nfc.record;

import android.net.Uri;
import android.nfc.NdefRecord;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import ketai.net.nfc.record.ParsedNdefRecord;

public class UriRecord
implements ParsedNdefRecord {
    public static final String RECORD_TYPE = "UriRecord";
    private static final HashMap<Byte, String> URI_PREFIX_MAP = new HashMap<Byte, String>(){
        {
            this.put(new Byte(0), "");
            this.put(new Byte(1), "http://www.");
            this.put(new Byte(2), "https://www.");
            this.put(new Byte(3), "http://");
            this.put(new Byte(4), "https://");
            this.put(new Byte(5), "tel:");
            this.put(new Byte(6), "mailto:");
            this.put(new Byte(7), "ftp://anonymous:anonymous@");
            this.put(new Byte(8), "ftp://ftp.");
            this.put(new Byte(9), "ftps://");
            this.put(new Byte(10), "sftp://");
            this.put(new Byte(11), "smb://");
            this.put(new Byte(12), "nfs://");
            this.put(new Byte(13), "ftp://");
            this.put(new Byte(14), "dav://");
            this.put(new Byte(15), "news:");
            this.put(new Byte(16), "telnet://");
            this.put(new Byte(17), "imap:");
            this.put(new Byte(18), "rtsp://");
            this.put(new Byte(19), "urn:");
            this.put(new Byte(20), "pop:");
            this.put(new Byte(21), "sip:");
            this.put(new Byte(22), "sips:");
            this.put(new Byte(23), "tftp:");
            this.put(new Byte(24), "btspp://");
            this.put(new Byte(25), "btl2cap://");
            this.put(new Byte(26), "btgoep://");
            this.put(new Byte(27), "tcpobex://");
            this.put(new Byte(28), "irdaobex://");
            this.put(new Byte(29), "file://");
            this.put(new Byte(30), "urn:epc:id:");
            this.put(new Byte(31), "urn:epc:tag:");
            this.put(new Byte(32), "urn:epc:pat:");
            this.put(new Byte(33), "urn:epc:raw:");
            this.put(new Byte(34), "urn:epc:");
            this.put(new Byte(35), "urn:nfc:");
        }
    };
    private final Uri mUri;

    private UriRecord(Uri uri) {
        this.mUri = uri != null ? uri : Uri.EMPTY;
    }

    public Uri getUri() {
        return this.mUri;
    }

    public static UriRecord parse(NdefRecord record) {
        short tnf = record.getTnf();
        if (tnf == 1) {
            return UriRecord.parseWellKnown(record);
        }
        if (tnf == 3) {
            return UriRecord.parseAbsolute(record);
        }
        throw new IllegalArgumentException("Unknown TNF " + tnf);
    }

    private static UriRecord parseAbsolute(NdefRecord record) {
        byte[] payload = record.getPayload();
        Uri uri = Uri.parse((String)new String(payload, Charset.forName("UTF-8")));
        return new UriRecord(uri);
    }

    private static UriRecord parseWellKnown(NdefRecord record) {
        if (!Arrays.equals(record.getType(), NdefRecord.RTD_URI)) {
            return new UriRecord(Uri.EMPTY);
        }
        byte[] payload = record.getPayload();
        String prefix = URI_PREFIX_MAP.get(payload[0]);
        byte[] fullUri = Arrays.copyOf(prefix.getBytes(), prefix.getBytes(Charset.forName("UTF-8")).length + payload.length);
        int k = 0;
        int i = prefix.getBytes(Charset.forName("UTF-8")).length;
        while (i < prefix.getBytes(Charset.forName("UTF-8")).length + payload.length && k < payload.length) {
            fullUri[i] = payload[k];
            ++k;
            ++i;
        }
        Uri uri = Uri.parse((String)new String(fullUri, Charset.forName("UTF-8")));
        return new UriRecord(uri);
    }

    public static boolean isUri(NdefRecord record) {
        try {
            UriRecord.parse(record);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public String getTag() {
        return this.mUri.toString();
    }
}

