/*
 * Decompiled with CFR 0.152.
 */
package ketai.net.nfc.record;

import android.nfc.NdefRecord;
import java.io.UnsupportedEncodingException;
import ketai.net.nfc.record.ParsedNdefRecord;
import processing.core.PApplet;

public class TextRecord
implements ParsedNdefRecord {
    private final String mLanguageCode;
    private final String mText;

    private TextRecord(String languageCode, String text) {
        this.mLanguageCode = languageCode;
        this.mText = text;
    }

    public String getText() {
        return this.mText;
    }

    public String getLanguageCode() {
        return this.mLanguageCode;
    }

    public static TextRecord parse(NdefRecord record) {
        try {
            byte[] payload = record.getPayload();
            PApplet.println((String)("TextRecord parsed and NdefRecord with a payload of " + payload.length + " bytes."));
            String textEncoding = (payload[0] & 0x80) == 0 ? "UTF-8" : "UTF-16";
            int languageCodeLength = payload[0] & 0x3F;
            String languageCode = new String(payload, 1, languageCodeLength, "US-ASCII");
            String text = new String(payload, languageCodeLength + 1, payload.length - languageCodeLength - 1, textEncoding);
            PApplet.println((String)("TextRecord parsing: " + payload));
            PApplet.println((String)("\t parsed text:" + text));
            return new TextRecord(languageCode, text);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        catch (Exception x) {
            throw new IllegalArgumentException("Error parsing as a TextRecord: " + x.getMessage());
        }
    }

    public static boolean isText(NdefRecord record) {
        try {
            TextRecord.parse(record);
            PApplet.println((String)"TextRecord.isText is true!");
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    @Override
    public String getTag() {
        return this.getText();
    }
}

