/*
 * Decompiled with CFR 0.152.
 */
package ketai.net.nfc;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.nfc.FormatException;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.nfc.NfcAdapter;
import android.nfc.NfcEvent;
import android.nfc.Tag;
import android.nfc.tech.MifareUltralight;
import android.nfc.tech.Ndef;
import android.nfc.tech.NdefFormatable;
import android.nfc.tech.NfcA;
import android.nfc.tech.NfcF;
import android.os.Parcelable;
import android.util.Log;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import ketai.net.nfc.NdefMessageParser;
import ketai.net.nfc.record.ParsedNdefRecord;
import processing.core.PApplet;

public class KetaiNFC
implements NfcAdapter.CreateNdefMessageCallback,
NfcAdapter.OnNdefPushCompleteCallback {
    private PApplet parent;
    private Method onNFCEventMethod_String;
    private Method onNFCWriteMethod;
    private Method onNFCEventMethod_URI;
    private Method onNFCEventMethod_bArray;
    private IntentFilter[] mFilters;
    private String[][] mTechLists;
    private NfcAdapter mAdapter;
    private NdefMessage messageToWrite;
    private NdefMessage messageToBeam;
    private PendingIntent p;
    NdefFormatable tag;
    Ndef ndefTag;

    public KetaiNFC(PApplet pParent) {
        this.parent = pParent;
        Log.d((String)"KetaiNFC", (String)"KetaiNFC instantiated...");
        this.findParentIntentions();
        this.mAdapter = NfcAdapter.getDefaultAdapter((Context)this.parent.getActivity());
        if (this.mAdapter == null) {
            Log.i((String)"KetaiNFC", (String)"Failed to get NFC adapter...");
        } else {
            this.mAdapter.setNdefPushMessageCallback((NfcAdapter.CreateNdefMessageCallback)this, this.parent.getActivity(), new Activity[0]);
        }
        this.p = PendingIntent.getActivity((Context)this.parent.getActivity(), (int)0, (Intent)new Intent((Context)this.parent.getActivity(), this.parent.getClass()).addFlags(0x20000000), (int)0);
        IntentFilter ndef = new IntentFilter("android.nfc.action.NDEF_DISCOVERED");
        IntentFilter tech = new IntentFilter("android.nfc.action.TECH_DISCOVERED");
        IntentFilter tag = new IntentFilter("android.nfc.action.TAG_DISCOVERED");
        try {
            ndef.addDataType("*/*");
            tag.addDataType("*/*");
            tech.addDataType("*/*");
        }
        catch (IntentFilter.MalformedMimeTypeException e) {
            throw new RuntimeException("fail", e);
        }
        this.mFilters = new IntentFilter[]{ndef, tag, tech};
        this.mTechLists = new String[][]{{NfcA.class.getName()}, {MifareUltralight.class.getName()}, {NfcF.class.getName()}, {NdefFormatable.class.getName()}};
        this.parent.registerMethod("resume", (Object)this);
        this.parent.registerMethod("pause", (Object)this);
    }

    public void resume() {
        Log.i((String)"KetaiNFC", (String)"resuming...");
        if (this.mAdapter != null) {
            this.mAdapter.enableForegroundDispatch(this.parent.getActivity(), this.p, this.mFilters, this.mTechLists);
            Intent intent = this.parent.getActivity().getIntent();
            Log.i((String)"KetaiNFC", (String)("resuming...intent: " + intent.getAction()));
            this.mAdapter.setNdefPushMessageCallback((NfcAdapter.CreateNdefMessageCallback)this, this.parent.getActivity(), new Activity[0]);
            this.handleIntent(intent);
        } else {
            PApplet.println((String)"mAdapter was null in onResume()");
            this.mAdapter = NfcAdapter.getDefaultAdapter((Context)this.parent.getActivity());
        }
        if ("android.nfc.action.NDEF_DISCOVERED".equals(this.parent.getActivity().getIntent().getAction()) || "android.nfc.action.TAG_DISCOVERED".equals(this.parent.getActivity().getIntent().getAction()) || "android.nfc.action.TECH_DISCOVERED".equals(this.parent.getActivity().getIntent().getAction())) {
            this.handleIntent(this.parent.getActivity().getIntent());
        }
    }

    public void start(PendingIntent p) {
        p = PendingIntent.getActivity((Context)this.parent.getActivity(), (int)0, (Intent)new Intent((Context)this.parent.getActivity(), this.parent.getActivity().getClass()).addFlags(0x20000000), (int)0);
        this.mAdapter.enableForegroundDispatch(this.parent.getActivity(), p, this.mFilters, this.mTechLists);
    }

    public void pause() {
        Log.i((String)"KetaiNFC", (String)"pausing...");
        if (this.mAdapter != null) {
            this.mAdapter.disableForegroundDispatch(this.parent.getActivity());
        }
    }

    public void handleIntent(Intent intent) {
        NdefMessage[] msgs;
        if (this.mAdapter == null) {
            return;
        }
        Log.i((String)"KetaiNFC", (String)"processing intent...");
        String action = intent.getAction();
        String thingToReturn = "";
        Tag tag = null;
        if (!("android.nfc.action.TAG_DISCOVERED".equals(action) || "android.nfc.action.NDEF_DISCOVERED".equals(action) || "android.nfc.action.TECH_DISCOVERED".equals(action))) {
            return;
        }
        Parcelable[] rawMsgs = intent.getParcelableArrayExtra("android.nfc.extra.NDEF_MESSAGES");
        Parcelable pTag = intent.getParcelableExtra("android.nfc.extra.TAG");
        if (pTag != null && pTag.getClass() == Tag.class) {
            tag = (Tag)pTag;
            PApplet.println((String)("Found Tag object: " + tag.toString()));
            String foo = "";
            String[] stringArray = tag.getTechList();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String a = stringArray[n2];
                foo = String.valueOf(foo) + a + "\n";
                ++n2;
            }
            PApplet.println((String)("Supported Tag tech: " + foo + "\n"));
        } else {
            tag = null;
        }
        if (rawMsgs != null) {
            msgs = new NdefMessage[rawMsgs.length];
            int i = 0;
            while (i < rawMsgs.length) {
                msgs[i] = (NdefMessage)rawMsgs[i];
                ++i;
            }
        } else {
            byte[] empty = new byte[]{};
            NdefRecord record = new NdefRecord(5, empty, empty, empty);
            NdefMessage msg = new NdefMessage(new NdefRecord[]{record});
            msgs = new NdefMessage[]{msg};
        }
        if (tag != null && this.messageToWrite != null) {
            PApplet.println((String)"Attempting to write to Tag");
            this.writeNFCString(tag);
            return;
        }
        if (msgs == null || msgs.length == 0) {
            return;
        }
        String foo = new String(msgs[0].toByteArray());
        PApplet.println((String)("got nfc message:" + foo));
        List<ParsedNdefRecord> records = NdefMessageParser.parse(msgs[0]);
        int size = records.size();
        int i = 0;
        while (i < size) {
            ParsedNdefRecord record = records.get(i);
            thingToReturn = String.valueOf(thingToReturn) + record.getTag();
            ++i;
        }
        if (this.onNFCEventMethod_String != null) {
            try {
                this.onNFCEventMethod_String.invoke((Object)this.parent, thingToReturn);
            }
            catch (Exception e) {
                PApplet.println((String)("Disabling onNFCEvent() because of an error:" + e.getMessage()));
                e.printStackTrace();
            }
        }
    }

    public static NdefRecord newTextRecord(String text, Locale locale, boolean encodeInUtf8) {
        byte[] langBytes = locale.getLanguage().getBytes(Charset.forName("US-ASCII"));
        Charset utfEncoding = encodeInUtf8 ? Charset.forName("UTF-8") : Charset.forName("UTF-16");
        byte[] textBytes = text.getBytes(utfEncoding);
        int utfBit = encodeInUtf8 ? 0 : 128;
        char status = (char)(utfBit + langBytes.length);
        byte[] data = new byte[1 + langBytes.length + textBytes.length];
        data[0] = (byte)status;
        System.arraycopy(langBytes, 0, data, 1, langBytes.length);
        System.arraycopy(textBytes, 0, data, 1 + langBytes.length, textBytes.length);
        return new NdefRecord(1, NdefRecord.RTD_TEXT, new byte[0], data);
    }

    public void write(URI _url) {
        NdefRecord record = new NdefRecord(3, _url.toString().getBytes(Charset.forName("UTF-8")), new byte[0], new byte[0]);
        NdefRecord[] records = new NdefRecord[]{record};
        this.messageToWrite = new NdefMessage(records);
    }

    public void write(String textToWrite) {
        Locale locale = Locale.US;
        byte[] langBytes = locale.getLanguage().getBytes(Charset.forName("UTF-8"));
        byte[] textBytes = textToWrite.getBytes(Charset.forName("UTF-8"));
        boolean utfBit = false;
        char status = (char)(0 + langBytes.length);
        byte[] data = new byte[1 + langBytes.length + textBytes.length];
        data[0] = (byte)status;
        System.arraycopy(langBytes, 0, data, 1, langBytes.length);
        System.arraycopy(textBytes, 0, data, 1 + langBytes.length, textBytes.length);
        NdefRecord record = new NdefRecord(1, NdefRecord.RTD_TEXT, new byte[0], data);
        NdefRecord[] records = new NdefRecord[]{record};
        this.messageToWrite = new NdefMessage(records);
    }

    public void beam(String textToWrite) {
        Locale locale = Locale.US;
        byte[] langBytes = locale.getLanguage().getBytes(Charset.forName("UTF-8"));
        byte[] textBytes = textToWrite.getBytes(Charset.forName("UTF-8"));
        boolean utfBit = false;
        char status = (char)(0 + langBytes.length);
        byte[] data = new byte[1 + langBytes.length + textBytes.length];
        data[0] = (byte)status;
        System.arraycopy(langBytes, 0, data, 1, langBytes.length);
        System.arraycopy(textBytes, 0, data, 1 + langBytes.length, textBytes.length);
        NdefRecord record = new NdefRecord(1, NdefRecord.RTD_TEXT, new byte[0], data);
        NdefRecord[] records = new NdefRecord[]{record};
        this.messageToBeam = new NdefMessage(records);
    }

    public void write(byte[] _data) {
        PApplet.println((String)"NFC tag byte writing not yet implemented...");
    }

    public void cancelWrite() {
        this.messageToWrite = null;
    }

    private void writeNFCString(Tag t) {
        this.tag = NdefFormatable.get((Tag)t);
        this.ndefTag = null;
        if (this.tag == null) {
            PApplet.println((String)"Tag does not support writing (via NdefFormattable). Trying NDEF write...");
            this.ndefTag = Ndef.get((Tag)t);
            if (this.ndefTag != null) {
                if (this.ndefTag.isWritable()) {
                    PApplet.println((String)"KetaiNFC: Tag is NDEF writable.");
                    Log.i((String)"KetaiNFC", (String)"NDEFTag is writable");
                } else {
                    PApplet.println((String)"KetaiNFC: Tag is NOT writable");
                    Log.i((String)"KetaiNFC", (String)"Tag is NOT writable");
                    if (this.onNFCWriteMethod != null) {
                        try {
                            this.onNFCWriteMethod.invoke((Object)this.parent, false, "Tag is NOT writable");
                            return;
                        }
                        catch (Exception e) {
                            PApplet.println((String)(" onNFCWriteEvent()  error:" + e.getMessage()));
                            e.printStackTrace();
                            return;
                        }
                    }
                }
            } else {
                return;
            }
        }
        if (this.tag != null && this.messageToWrite != null) {
            this.parent.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    block7: {
                        try {
                            KetaiNFC.this.tag.connect();
                            PApplet.println((Object)KetaiNFC.this.messageToWrite.toByteArray());
                            if (KetaiNFC.this.tag.isConnected()) {
                                KetaiNFC.this.tag.format(KetaiNFC.this.messageToWrite);
                                KetaiNFC.this.messageToWrite = null;
                            } else {
                                PApplet.println((String)"Failed to connect to tag.");
                            }
                            KetaiNFC.this.tag.close();
                        }
                        catch (FormatException fx) {
                            fx.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            String errorMessage = e.getMessage();
                            PApplet.println((String)("Failed to write to tag.  Error: " + errorMessage));
                            if (KetaiNFC.this.onNFCWriteMethod == null) break block7;
                            try {
                                KetaiNFC.this.onNFCWriteMethod.invoke((Object)KetaiNFC.this.parent, false, errorMessage);
                            }
                            catch (Exception ex) {
                                PApplet.println((String)("Failed to write nfc tag because of an error:" + ex.getMessage()));
                                ex.printStackTrace();
                            }
                        }
                    }
                }
            });
        } else if (this.ndefTag != null) {
            this.parent.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    block10: {
                        try {
                            PApplet.println((Object)KetaiNFC.this.messageToWrite.toByteArray());
                            KetaiNFC.this.ndefTag.connect();
                            if (KetaiNFC.this.ndefTag.isConnected()) {
                                KetaiNFC.this.ndefTag.writeNdefMessage(KetaiNFC.this.messageToWrite);
                                KetaiNFC.this.messageToWrite = null;
                            } else {
                                PApplet.println((String)"Failed to connect to Tag for an NDef write.");
                            }
                            KetaiNFC.this.ndefTag.close();
                            if (KetaiNFC.this.onNFCWriteMethod != null) {
                                try {
                                    KetaiNFC.this.onNFCWriteMethod.invoke((Object)KetaiNFC.this.parent, true, "");
                                }
                                catch (Exception e) {
                                    PApplet.println((String)("Failed to notify sketch of an NFC write Tag operation: " + e.getMessage()));
                                }
                            }
                        }
                        catch (FormatException fx) {
                            fx.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            String errorMessage = e.getMessage();
                            PApplet.println((String)("Failed to write to tag.  Error: " + errorMessage));
                            if (KetaiNFC.this.onNFCWriteMethod == null) break block10;
                            try {
                                KetaiNFC.this.onNFCWriteMethod.invoke((Object)KetaiNFC.this.parent, false, errorMessage);
                            }
                            catch (Exception ex) {
                                PApplet.println((String)("Failed to write nfc tag & subsequently notify sketch, error:" + ex.getMessage()));
                                ex.printStackTrace();
                            }
                        }
                    }
                }
            });
        }
    }

    private void findParentIntentions() {
        try {
            this.onNFCEventMethod_String = this.parent.getClass().getMethod("onNFCEvent", String.class);
            Log.d((String)"KetaiNFC", (String)"Found onNFCEvent(String) callback...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.onNFCWriteMethod = this.parent.getClass().getMethod("onNFCWrite", Boolean.TYPE, String.class);
            Log.d((String)"KetaiNFC", (String)"Found onNFCWrite callback...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.onNFCEventMethod_URI = this.parent.getClass().getMethod("onNFCEvent", URI.class);
            Log.d((String)"KetaiNFC", (String)"Found onNFCEvent(URI) callback...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            this.onNFCEventMethod_bArray = this.parent.getClass().getMethod("onNFCEvent", byte[].class);
            Log.d((String)"KetaiNFC", (String)"Found onNFCEvent(byte[]) callback...");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void onNdefPushComplete(NfcEvent arg0) {
        PApplet.println((String)"Completed a beam! clearing out pending message.");
        this.messageToBeam = null;
    }

    public NdefMessage createNdefMessage(NfcEvent arg0) {
        if (this.messageToBeam == null) {
            this.beam("");
        }
        PApplet.println((String)("createNdefMessage callback called for beam, returning: " + this.messageToBeam.toString()));
        return this.messageToBeam;
    }
}

