/*
 * Decompiled with CFR 0.152.
 */
package ketai.net.bluetooth;

import android.bluetooth.BluetoothSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import ketai.net.bluetooth.KetaiBluetooth;
import processing.core.PApplet;

public class KBluetoothConnection
extends Thread {
    private final BluetoothSocket mmSocket;
    private final InputStream mmInStream;
    private final OutputStream mmOutStream;
    private boolean isConnected = false;
    private String address = "";
    private KetaiBluetooth btm;

    public KBluetoothConnection(KetaiBluetooth _btm, BluetoothSocket socket) {
        PApplet.println((String)("create Connection thread to " + socket.getRemoteDevice().getName()));
        this.btm = _btm;
        this.mmSocket = socket;
        InputStream tmpIn = null;
        OutputStream tmpOut = null;
        this.address = socket.getRemoteDevice().getAddress();
        try {
            tmpIn = socket.getInputStream();
            tmpOut = socket.getOutputStream();
        }
        catch (IOException e) {
            PApplet.println((String)("temp sockets not created: " + e.getMessage()));
        }
        this.mmInStream = tmpIn;
        this.mmOutStream = tmpOut;
        this.isConnected = true;
    }

    public String getAddress() {
        return this.address;
    }

    public String getDeviceName() {
        if (this.mmSocket == null) {
            return "";
        }
        return this.mmSocket.getRemoteDevice().getName();
    }

    @Override
    public void run() {
        PApplet.println((String)("BEGIN mConnectedThread to " + this.address));
        byte[] buffer = new byte[1024];
        try {
            while (true) {
                int bytes = this.mmInStream.read(buffer);
                byte[] data = Arrays.copyOfRange(buffer, 0, bytes);
                if (this.btm.onBluetoothDataEventMethod != null) {
                    try {
                        this.btm.onBluetoothDataEventMethod.invoke((Object)this.btm.parent, this.address, data);
                    }
                    catch (IllegalAccessException e) {
                        PApplet.println((String)("Error in reading connection data.:" + e.getMessage()));
                    }
                    catch (InvocationTargetException e) {
                        PApplet.println((String)("Error in reading connection data.:" + e.getMessage()));
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (IOException e) {
            this.btm.removeConnection(this);
            PApplet.println((String)(String.valueOf(this.getAddress()) + " disconnected" + e.getMessage()));
            this.isConnected = false;
            return;
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void write(byte[] buffer) {
        try {
            this.mmOutStream.write(buffer);
        }
        catch (IOException e) {
            PApplet.println((String)(String.valueOf(this.getAddress()) + ": Exception during write" + e.getMessage()));
            this.btm.removeConnection(this);
        }
    }

    public void cancel() {
        try {
            this.mmSocket.close();
        }
        catch (IOException e) {
            PApplet.println((String)("close() of connect socket failed" + e.getMessage()));
        }
    }
}

