/*
 * Decompiled with CFR 0.152.
 */
package ketai.data;

import android.content.Context;
import android.content.res.AssetManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import android.os.Environment;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import processing.core.PApplet;

public class KetaiSQLite {
    private String DATABASE_NAME = "data";
    private static final int DATABASE_VERSION = 1;
    private String DATA_ROOT_DIRECTORY = "_data";
    private Context context;
    private SQLiteDatabase db;
    private Cursor cursor;
    private SQLiteStatement sqlStatement;

    public KetaiSQLite(PApplet p) {
        this.context = p.getActivity().getApplicationContext();
        this.DATABASE_NAME = this.context.getPackageName();
        this.DATA_ROOT_DIRECTORY = this.context.getPackageName();
        PApplet.println((String)("data path" + this.context.getDatabasePath(this.context.getPackageName()).getAbsolutePath()));
        OpenHelper openHelper = new OpenHelper(this.context);
        this.db = openHelper.getWritableDatabase();
    }

    public KetaiSQLite(PApplet p, String dbname) {
        this.context = p.getActivity().getApplicationContext();
        this.DATABASE_NAME = dbname;
        OpenHelper openHelper = new OpenHelper(this.context, dbname);
        this.db = openHelper.getWritableDatabase();
    }

    public static boolean load(PApplet _context, String filename, String dbname) {
        InputStream myInput;
        block5: {
            AssetManager assets = _context.getActivity().getApplicationContext().getAssets();
            myInput = assets.open(filename);
            if (myInput != null) break block5;
            return false;
        }
        try {
            int length;
            String outFileName = _context.getActivity().getApplicationContext().getDatabasePath(dbname).getAbsolutePath();
            FileOutputStream myOutput = new FileOutputStream(outFileName);
            byte[] buffer = new byte[4096];
            while ((length = myInput.read(buffer)) > 0) {
                ((OutputStream)myOutput).write(buffer, 0, length);
            }
            myOutput.flush();
            ((OutputStream)myOutput).close();
            myInput.close();
            return true;
        }
        catch (FileNotFoundException e) {
            PApplet.println((String)("Failed to load SQLite file(not found): " + filename));
        }
        catch (IOException iox) {
            PApplet.println((String)("IO Error in copying SQLite database " + filename + ": " + iox.getMessage()));
        }
        return false;
    }

    public String getPath() {
        return this.db.getPath();
    }

    public SQLiteDatabase getDb() {
        return this.db;
    }

    public boolean connect() {
        return this.db.isOpen();
    }

    public void close() {
        if (this.db != null) {
            this.db.close();
        }
    }

    public void dispose() {
        this.close();
    }

    public boolean execute(String _sql) {
        try {
            this.db.execSQL(_sql);
            return true;
        }
        catch (SQLiteException x) {
            PApplet.println((String)("Error executing sql statement: " + x.getMessage()));
            return false;
        }
    }

    public boolean query(String _query) {
        try {
            this.cursor = this.db.rawQuery(_query, null);
            return true;
        }
        catch (SQLiteException x) {
            PApplet.println((String)("Error executing query: " + x.getMessage()));
            return false;
        }
    }

    public boolean next() {
        if (this.cursor == null) {
            return false;
        }
        return this.cursor.moveToNext();
    }

    public double getDouble(int _col) {
        if (_col < 0) {
            return 0.0;
        }
        return this.cursor.getDouble(_col);
    }

    public double getDouble(String field) {
        int i = this.cursor.getColumnIndex(field);
        return this.getDouble(i);
    }

    public float getFloat(int _col) {
        if (_col < 0) {
            return 0.0f;
        }
        return this.cursor.getFloat(_col);
    }

    public float getFloat(String field) {
        int i = this.cursor.getColumnIndex(field);
        return this.getFloat(i);
    }

    public int getInt(int _col) {
        if (_col < 0) {
            return 0;
        }
        return this.cursor.getInt(_col);
    }

    public int getInt(String field) {
        int i = this.cursor.getColumnIndex(field);
        return this.getInt(i);
    }

    public long getLong(int _col) {
        if (_col < 0) {
            return 0L;
        }
        return this.cursor.getLong(_col);
    }

    public long getLong(String field) {
        int i = this.cursor.getColumnIndex(field);
        return this.getLong(i);
    }

    public byte[] getBlob(int _col) {
        if (_col < 0) {
            return null;
        }
        return this.cursor.getBlob(_col);
    }

    public byte[] getBlob(String field) {
        int i = this.cursor.getColumnIndex(field);
        return this.getBlob(i);
    }

    public String getString(int _col) {
        if (_col < 0) {
            return null;
        }
        return this.cursor.getString(_col);
    }

    public String getString(String field) {
        int i = this.cursor.getColumnIndex(field);
        return this.getString(i);
    }

    public String[] getTables() {
        String s = "SELECT name FROM sqlite_master WHERE type='table' ORDER BY name;";
        ArrayList<String> tables = new ArrayList<String>();
        try {
            Cursor cursor = this.db.rawQuery(s, null);
            if (cursor.moveToFirst()) {
                do {
                    if (cursor.getString(0) == "android_metadata") continue;
                    tables.add(cursor.getString(0));
                } while (cursor.moveToNext());
            }
        }
        catch (SQLiteException x) {
            x.printStackTrace();
        }
        String[] strArray = new String[tables.size()];
        tables.toArray(strArray);
        return strArray;
    }

    public String[] getFields(String table) {
        String s = "PRAGMA table_info(" + table + ");";
        ArrayList<String> fields = new ArrayList<String>();
        try {
            Cursor cursor = this.db.rawQuery(s, null);
            if (cursor.moveToFirst()) {
                do {
                    fields.add(cursor.getString(1));
                } while (cursor.moveToNext());
            }
        }
        catch (SQLiteException x) {
            x.printStackTrace();
        }
        String[] strArray = new String[fields.size()];
        fields.toArray(strArray);
        return strArray;
    }

    public String getFieldMin(String table, String field) {
        String q = "SELECT MIN(" + field + ") FROM " + table;
        this.sqlStatement = this.db.compileStatement(q);
        String c = this.sqlStatement.simpleQueryForString();
        if (c == null) {
            return "0";
        }
        return c;
    }

    public String getFieldMax(String table, String field) {
        String q = "SELECT MAX(" + field + ") FROM " + table;
        this.sqlStatement = this.db.compileStatement(q);
        String c = this.sqlStatement.simpleQueryForString();
        if (c == null) {
            return "0";
        }
        return c;
    }

    public long getRecordCount(String table) {
        this.sqlStatement = this.db.compileStatement("SELECT COUNT(*) FROM " + table);
        long c = this.sqlStatement.simpleQueryForLong();
        return c;
    }

    public long getDataCount() {
        long count = 0L;
        try {
            Cursor cursor = this.db.rawQuery("select name from SQLite_Master", null);
            if (cursor.moveToFirst()) {
                do {
                    String tablename;
                    if ((tablename = cursor.getString(0)).equals("android_metadata")) continue;
                    this.sqlStatement = this.db.compileStatement("SELECT COUNT(*) FROM " + tablename);
                    long c = this.sqlStatement.simpleQueryForLong();
                    count += c;
                } while (cursor.moveToNext());
            }
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        catch (SQLiteException x) {
            x.printStackTrace();
        }
        return count;
    }

    public boolean tableExists(String _table) {
        Cursor cursor = this.db.rawQuery("select name from SQLite_Master", null);
        if (cursor.moveToFirst()) {
            do {
                PApplet.println((String)("DataManager found this table: " + cursor.getString(0)));
                if (!cursor.getString(0).equalsIgnoreCase(_table)) continue;
                return true;
            } while (cursor.moveToNext());
        }
        if (cursor != null && !cursor.isClosed()) {
            cursor.close();
        }
        return false;
    }

    public void exportData(String _targetDirectory) throws IOException {
        String directory = String.valueOf(System.currentTimeMillis());
        File dir = new File(Environment.getExternalStorageDirectory(), String.valueOf(this.DATA_ROOT_DIRECTORY) + "/" + directory);
        if (!dir.exists()) {
            if (dir.mkdirs()) {
                PApplet.println((String)("success making directory: " + dir.getAbsolutePath()));
            } else {
                PApplet.println((String)"Failed making directory. Check your sketch permissions or that your device is not connected in disk mode.");
                return;
            }
        }
        int rowCount = 0;
        try {
            Cursor cursor = this.db.rawQuery("select name from SQLite_Master", null);
            if (cursor.moveToFirst() && cursor.getCount() > 0) {
                String row = "";
                do {
                    Cursor c;
                    String tablename;
                    if ((tablename = cursor.getString(0)).equals("android_metadata") || !(c = this.db.rawQuery("SELECT * FROM " + tablename, null)).moveToFirst()) continue;
                    do {
                        int i = c.getColumnCount();
                        int j = 0;
                        while (j < i) {
                            row = String.valueOf(row) + c.getString(j) + "\t";
                            ++j;
                        }
                        row = String.valueOf(row) + "\n";
                        if (++rowCount <= 100) continue;
                        if (row.length() > 0) {
                            this.writeToFile(row, dir.getAbsolutePath(), tablename);
                        }
                        row = "";
                        rowCount = 0;
                    } while (c.moveToNext());
                    this.writeToFile(row, dir.getAbsolutePath(), tablename);
                    row = "";
                    rowCount = 0;
                } while (cursor.moveToNext());
            }
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
            this.deleteAllData();
        }
        catch (SQLiteException x) {
            x.printStackTrace();
        }
    }

    public void deleteAllData() {
        try {
            Cursor cursor = this.db.rawQuery("select name from SQLite_Master", null);
            if (cursor.moveToFirst()) {
                do {
                    String tablename;
                    if ((tablename = cursor.getString(0)).equals("android_metadata")) continue;
                    this.db.delete(tablename, null, null);
                } while (cursor.moveToNext());
            }
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        catch (SQLiteException x) {
            x.printStackTrace();
        }
    }

    private void writeToFile(String data, String _dir, String exportFileName) {
        try {
            PApplet.print((String)".");
            String fileToWrite = String.valueOf(_dir) + "/" + exportFileName + ".csv";
            FileWriter fw = new FileWriter(fileToWrite, true);
            BufferedWriter out = new BufferedWriter(fw);
            out.write(data);
            out.close();
            fw.close();
        }
        catch (Exception x) {
            PApplet.println((String)("Error exporting data. (" + x.getMessage() + ") Check the sketch permissions or that the device is not connected in disk mode."));
        }
    }

    private class OpenHelper
    extends SQLiteOpenHelper {
        OpenHelper(Context context) {
            super(context, KetaiSQLite.this.DATABASE_NAME, null, 1);
        }

        OpenHelper(Context context, String dbname) {
            super(context, dbname, null, 1);
        }

        public void onCreate(SQLiteDatabase db) {
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        }
    }
}

