/*
 * Decompiled with CFR 0.152.
 */
package ketai.cv.facedetector;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.media.FaceDetector;
import java.util.ArrayList;
import ketai.camera.KetaiCamera;
import ketai.cv.facedetector.KetaiSimpleFace;
import processing.core.PImage;

public class KetaiFaceDetector {
    public static KetaiSimpleFace[] findFaces(PImage _image, int MAX_FACES) {
        ArrayList<KetaiSimpleFace> foundFaces = new ArrayList<KetaiSimpleFace>();
        int numberOfFaces = 0;
        _image.loadPixels();
        Bitmap _bitmap = Bitmap.createBitmap((int[])_image.pixels, (int)_image.width, (int)_image.height, (Bitmap.Config)Bitmap.Config.RGB_565);
        if (_bitmap != null) {
            FaceDetector _detector = new FaceDetector(_image.width, _image.height, MAX_FACES);
            FaceDetector.Face[] faces = new FaceDetector.Face[MAX_FACES];
            numberOfFaces = _detector.findFaces(_bitmap, faces);
            int i = 0;
            while (i < numberOfFaces) {
                foundFaces.add(new KetaiSimpleFace(faces[i]));
                ++i;
            }
        }
        KetaiSimpleFace[] f = new KetaiSimpleFace[numberOfFaces];
        int i = 0;
        while (i < numberOfFaces) {
            f[i] = (KetaiSimpleFace)foundFaces.get(i);
            ++i;
        }
        return f;
    }

    public static KetaiSimpleFace[] findFaces(KetaiCamera _camera, int MAX_FACES) {
        ArrayList<KetaiSimpleFace> foundFaces = new ArrayList<KetaiSimpleFace>();
        int numberOfFaces = 0;
        _camera.loadPixels();
        Bitmap _bitmap = Bitmap.createBitmap((int[])_camera.pixels, (int)_camera.width, (int)_camera.height, (Bitmap.Config)Bitmap.Config.RGB_565);
        if (_camera.requestedPortraitImage) {
            Matrix matrix = new Matrix();
            matrix.postRotate(90.0f);
            Bitmap scaledBitmap = Bitmap.createScaledBitmap((Bitmap)_bitmap, (int)_camera.width, (int)_camera.height, (boolean)true);
            Bitmap rotatedBitmap = Bitmap.createBitmap((Bitmap)scaledBitmap, (int)0, (int)0, (int)scaledBitmap.getWidth(), (int)scaledBitmap.getHeight(), (Matrix)matrix, (boolean)true);
            if (rotatedBitmap != null) {
                FaceDetector _detector = new FaceDetector(rotatedBitmap.getWidth(), rotatedBitmap.getHeight(), MAX_FACES);
                FaceDetector.Face[] faces = new FaceDetector.Face[MAX_FACES];
                numberOfFaces = _detector.findFaces(rotatedBitmap, faces);
                int i = 0;
                while (i < numberOfFaces) {
                    foundFaces.add(new KetaiSimpleFace(faces[i], _camera.width, _camera.height));
                    ++i;
                }
            }
            KetaiSimpleFace[] f = new KetaiSimpleFace[numberOfFaces];
            int i = 0;
            while (i < numberOfFaces) {
                f[i] = (KetaiSimpleFace)foundFaces.get(i);
                ++i;
            }
            return f;
        }
        if (_bitmap != null) {
            FaceDetector _detector = new FaceDetector(_camera.width, _camera.height, MAX_FACES);
            FaceDetector.Face[] faces = new FaceDetector.Face[MAX_FACES];
            numberOfFaces = _detector.findFaces(_bitmap, faces);
            int i = 0;
            while (i < numberOfFaces) {
                foundFaces.add(new KetaiSimpleFace(faces[i]));
                ++i;
            }
        }
        KetaiSimpleFace[] f = new KetaiSimpleFace[numberOfFaces];
        int i = 0;
        while (i < numberOfFaces) {
            f[i] = (KetaiSimpleFace)foundFaces.get(i);
            ++i;
        }
        return f;
    }

    public static KetaiSimpleFace[] findFaces(KetaiCamera _image) {
        int DEFAULT_MAX_FACES = 5;
        return KetaiFaceDetector.findFaces(_image, DEFAULT_MAX_FACES);
    }
}

