/*
 * File:   main.c
 * Author: Sourav Gupta
 * By:- circuitdigest.com
 * Created on April 13, 2018, 2:26 PM
 */

// PIC16F877A Configuration Bit Settings

// 'C' source line config statements

// CONFIG
#pragma config FOSC = HS        // Oscillator Selection bits (HS oscillator)
#pragma config WDTE = OFF       // Watchdog Timer Enable bit (WDT disabled)
#pragma config PWRTE = OFF      // Power-up Timer Enable bit (PWRT disabled)
#pragma config BOREN = ON       // Brown-out Reset Enable bit (BOR enabled)
#pragma config LVP = OFF         // Low-Voltage (Single-Supply) In-Circuit Serial Programming Enable bit (RB3/PGM pin has PGM function; low-voltage programming enabled)
#pragma config CPD = OFF        // Data EEPROM Memory Code Protection bit (Data EEPROM code protection off)
#pragma config WRT = OFF        // Flash Program Memory Write Enable bits (Write protection off; all program memory may be written to by EECON control)
#pragma config CP = OFF         // Flash Program Memory Code Protection bit (Code protection off)



#include <xc.h>
#include <stdio.h>
#include <string.h>
#include "supporing_cfile/Keypad.h"
#define RF_TX PORTD

/*
 Hardware related definition
 */
#define _XTAL_FREQ 200000000 //Crystal Frequency, used in delay

/*
 Other Specific definition
 */
void system_init(void);     
void encode_rf_sender (char data);

void main(void){    
    system_init();
    char Key = 'n';        
    while(1){
        
          Key = switch_press_scan();
          encode_rf_sender(Key);                   
        
        
    }

}

/*
 *  System Init
 */


void system_init(void){
    TRISD = 0x00;
    RF_TX = 0x00;
    keyboard_initialization();
}
void encode_rf_sender (char data){    
    if(data=='1')
    RF_TX=0x10;
    if(data=='2')
    RF_TX=0x20;
    if(data=='3')
    RF_TX=0x30;
    if(data=='4')             
    RF_TX=0x40;
    if(data=='5')
    RF_TX=0x50;
    if(data=='6')
    RF_TX=0x60;
    if(data=='7')
    RF_TX=0x70;
    if(data=='8')             
    RF_TX=0x80;
    if(data=='9')
    RF_TX=0x90;
    if(data=='0')
    RF_TX=0x00;
    if(data=='*')
    RF_TX=0xa0;
    if(data=='#')            
    RF_TX=0xb0;
    if(data=='A')            
    RF_TX=0xc0;
    if(data=='B')            
    RF_TX=0xd0;
    if(data=='C')            
    RF_TX=0xe0;
    if(data=='D')            
    RF_TX=0xf0;
}