/*
Application for Bubble level
can be used with Arduino hardware

code by www.circuitdigest.com
coded on 25-05-2017
*/



//**Import the necessary header files**//
import android.content.Intent;
import android.os.Bundle;
import ketai.net.bluetooth.*;
import ketai.ui.*;
import ketai.net.*;
import android.bluetooth.BluetoothAdapter;
import android.view.KeyEvent;
//__End of imports__//
BluetoothAdapter bluetooth = BluetoothAdapter.getDefaultAdapter();

PImage V_bar, H_bar, H_bub, V_bub, logo, Temp;
KetaiBluetooth bt;
int info;
int data, i;
String cninfo = "";
String temp_info;
float angle;
boolean send_flag=true;
int color_val;

float x;
float y;
float temp;



//**To start BT when app is launched**// 
void onCreate(Bundle savedInstanceState) {
 super.onCreate(savedInstanceState);
 bt = new KetaiBluetooth(this);
}
void onActivityResult(int requestCode, int resultCode, Intent data) {
  bt.onActivityResult(requestCode, resultCode, data);
}
//__BT launched__//


//**To select bluetooth device if needed**// (not required for our program
void onKetaiListSelection(KetaiList klist)
{
 String selection = klist.getSelection();
 bt.connectToDeviceByName(selection);
 //dispose of list for now
 klist = null;
}
//__End of selection__//


//** To get data from blue tooth**/
void onBluetoothDataEvent(String who, byte[] data)
{
info = (data[0] & 0xFF) ;
}
//__data received_//


//**To get connection status**//
String getBluetoothInformation()
{
  String btInfo = "Connected to :";

  ArrayList<String> devices = bt.getConnectedDeviceNames();
  for (String device: devices)
  {
    btInfo+= device+"\n";
  }

  return btInfo;
}
//--connection status received_//


//**Settings for the Android Application**//
void settings()
{
 fullScreen(); //make the app for in full screen 
}
//__Settings completed__//


//**Executes only once**// (similar to arduino)
void setup() 
{
  textSize(31);
  bt.start(); //start listening for BT connections
  bt.getPairedDeviceNames();
  bt.connectToDeviceByName("HC-06"); //Connect to our HC-06 bluetooth module
  

  
//**Load all images from data file**//
  V_bar = loadImage("V_bar.jpg");
  H_bar = loadImage("H_bar.jpg");
  H_bub = loadImage("H_bub.png");
  V_bub = loadImage("V_bub.png");
  Temp = loadImage("temp.png");
  logo = loadImage("logo.png");
//End of loading images**//

}



//**Draw function**//
void draw() //The infinite loop
{
 background(0);
 imageMode(CENTER);
 image(logo, width/2, height/1.04, width, height/12);
 
  load_images();
  textfun();
  getval();
}
///__End of draw__//

void load_images()
{
 image(H_bar, width/2, height/6, width/1.5, height/6);
 image(H_bub, width/2+x, height/6, width/7, height/12);
 
 image(V_bar, width/6, height/1.5, width/4.5, height/2);
 image(V_bub, width/6, height/1.5+y, width/9, height/10);
 
 image(Temp, width/1.8, height/2, width/8, height/8);
}

void getval()
{
 // print(info);
  
  if (info<100 && info>0)
  x = map(info, 0, 100, -(width/1.5)/3, +(width/1.5)/3);//x = info;
  else if (info<200 && info>100)
  y = map(info, 100, 200, -(width/4.5)/0.8, +(width/4.5)/0.8);//y = info;
  else if (info>200)
  temp = info -200;
  
  println(temp,x,y);
    


}

void textfun()
{ 
 textSize(height/width * 50);
  textAlign(CENTER);
  fill(255);
  cninfo = getBluetoothInformation();    //get connection information status
  text(cninfo,width/2,height-height/1.03);
  text(x,width/2,height/6 - (height/6)/2);
  text(y,width/3 -(width/3)/2 ,height/1.5);
  text(temp,width/1.8+(width/8),height/2);
  noFill();
}