/*
Application for DIY- BlueBobBot
can be used with Arduino hardware

code by www.circuitdigest.com
coded on 25-05-2017
*/



//**Import the necessary header files**//
import android.content.Intent;
import android.os.Bundle;
import ketai.net.bluetooth.*;
import ketai.ui.*;
import ketai.net.*;
import android.bluetooth.BluetoothAdapter;
import android.view.KeyEvent;
//__End of imports__//
BluetoothAdapter bluetooth = BluetoothAdapter.getDefaultAdapter();

PImage needle, speedval, speedcover, neon, gloss,logo;
KetaiBluetooth bt;
int info,speed;
int data, i;
String cninfo = "";
String temp_info;
float angle;
boolean send_flag=true;
boolean click_flag=true;
int color_val;



//**To start BT when app is launched**// 
void onCreate(Bundle savedInstanceState) {
 super.onCreate(savedInstanceState);
 bt = new KetaiBluetooth(this);
}
void onActivityResult(int requestCode, int resultCode, Intent data) {
  bt.onActivityResult(requestCode, resultCode, data);
}
//__BT launched__//


//**To select bluetooth device if needed**// (not required for our program
void onKetaiListSelection(KetaiList klist)
{
 String selection = klist.getSelection();
 bt.connectToDeviceByName(selection);
 //dispose of list for now
 klist = null;
}
//__End of selection__//


//** To get data from blue tooth**/
void onBluetoothDataEvent(String who, byte[] data)
{
info = (data[0] & 0xFF) ;
}
//__data received_//


//**To get connection status**//
String getBluetoothInformation()
{
  String btInfo = "Connected to :";

  ArrayList<String> devices = bt.getConnectedDeviceNames();
  for (String device: devices)
  {
    btInfo+= device+"\n";
  }

  return btInfo;
}
//--connection status received_//


//**Settings for the Android Application**//
void settings()
{
 fullScreen(); //make the app for in full screen 
}
//__Settings completed__//


//**Executes only once**// (similar to arduino)
void setup() 
{
  textSize(31);
  bt.start(); //start listening for BT connections
  bt.getPairedDeviceNames();
  bt.connectToDeviceByName("HC-06"); //Connect to our HC-06 bluetooth module
  

  
//**Load all images from data file**//

  logo = loadImage("logo.png");
//End of loading images**//

}

void load_buttons()
{
  rectMode(CENTER);
  textAlign(CENTER,CENTER);
  noStroke();
  fill(55,255,100); 
  rect(width/2-width/4,height/2,width/4,height/12); fill(0); text("Dance 1",width/2-width/4,height/2); //button 3
  fill(55,255,101); 
  rect(width/2+width/4,height/2,width/4,height/12);fill(0); text("Dance 2",width/2+width/4,height/2,height/2); //button 4
  fill(55,255,102); 
  rect(width/2-width/4,height/2+height/8,width/4,height/12);fill(0); text("Say Hai!",width/2-width/4,height/2+height/8); //button 5
  fill(55,255,103); 
  rect(width/2+width/4,height/2+height/8,width/4,height/12);fill(0); text("Button 6",width/2+width/4,height/2+height/8); //button 6
  fill(55,255,104); 
  rect(width/2-width/4,height/2-height/8,width/4,height/12);fill(0); text("Walk Style 1",width/2-width/4,height/2-height/8); //button1
  fill(55,255,105); 
  rect(width/2+width/4,height/2-height/8,width/4,height/12);fill(0); text("Walk Style 2",width/2+width/4,height/2-height/8); //button 2
}

void read_buttons()
{
    if (mousePressed && click_flag==true) 
  {
  color_val = get(mouseX, mouseY);
  click_flag=false;
  println(color_val);
  if (color_val==-13107352)
  {byte[] data = {'2'};
   bt.broadcast(data);}
   
  if (color_val==-13107351)
  {byte[] data = {'3'};
   bt.broadcast(data);}
   
  if (color_val==-13107356)
  {byte[] data = {'4'};
   bt.broadcast(data);}
   
  if (color_val==-13107355)
  {byte[] data = {'5'};
   bt.broadcast(data);}
   
  if (color_val==-13107354)
  {byte[] data = {'1'};
   bt.broadcast(data);}
   
  if (color_val==-13107353)
  {byte[] data = {'6'};
   bt.broadcast(data);}
  
  
  color_val=0;
  }
  
}


void mouseReleased()
{
  click_flag=true;
}

//**Draw function**//
void draw() //The infinite loop
{
 background(#47FCDD);
 imageMode(CENTER);
 image(logo, width/2, height/1.04, width, height/12);
  load_buttons();
  read_buttons();
  textfun();
  getval();
  
  if (mousePressed && send_flag==true)
  {
byte[] data = {'1'};
bt.broadcast(data);
send_flag=false; 
  }

}
///__End of draw__//



void getval()
{
speed=info;
}

void textfun()
{ 
  textSize(30);
  textAlign(CENTER);
  fill(255);
  cninfo = getBluetoothInformation();    //get connection information status
  text(cninfo,width/2,height-height/1.03);
  noFill();
}