/*
Application for AC Control using TSOP
can be used with Arduino and HC05/HC06 hardware

Code by: Aswinth Raj
Dated: 27-10-2017
website: www.circuitdigest.com
*/



//**Import the necessary header files**//
import android.content.Intent;
import android.os.Bundle;
import ketai.net.bluetooth.*;
import ketai.ui.*;
import ketai.net.*;
import android.bluetooth.BluetoothAdapter;
import android.view.KeyEvent;
//__End of imports__//
BluetoothAdapter bluetooth = BluetoothAdapter.getDefaultAdapter();

PImage needle, speedval, speedcover, neon, gloss,logo;
KetaiBluetooth bt;
int info,speed;
int data, i;
String cninfo = "";
String temp_info;
float angle;
boolean send_flag=true;
boolean click_flag=true;
int color_val;



//**To start BT when app is launched**// 
void onCreate(Bundle savedInstanceState) {
 super.onCreate(savedInstanceState);
 bt = new KetaiBluetooth(this);
}
void onActivityResult(int requestCode, int resultCode, Intent data) {
  bt.onActivityResult(requestCode, resultCode, data);
}
//__BT launched__//


//**To select bluetooth device if needed**// (not required for our program
void onKetaiListSelection(KetaiList klist)
{
 String selection = klist.getSelection();
 bt.connectToDeviceByName(selection);
 //dispose of list for now
 klist = null;
}
//__End of selection__//


//** To get data from blue tooth**/
void onBluetoothDataEvent(String who, byte[] data)
{
info = (data[0] & 0xFF) ;
}
//__data received_//


//**To get connection status**//
String getBluetoothInformation()
{
  String btInfo = "Connected to :";

  ArrayList<String> devices = bt.getConnectedDeviceNames();
  for (String device: devices)
  {
    btInfo+= device+"\n";
  }

  return btInfo;
}
//--connection status received_//


//**Settings for the Android Application**//
void settings()
{
 fullScreen(); //make the app for in full screen 
}
//__Settings completed__//


//**Executes only once**// (similar to arduino)
void setup() 
{
  textSize(31);
  bt.start(); //start listening for BT connections
  bt.getPairedDeviceNames();
  bt.connectToDeviceByName("HC-06"); //Connect to our HC-06 bluetooth module
  

  
//**Load all images from data file**//
  logo = loadImage("logo.png");
//End of loading images**//

}

void load_buttons()
{
  rectMode(CENTER);
  textAlign(CENTER,CENTER); textSize(60);
  noStroke();
  fill(255,145,3); 
  rect(width/2-width/4,height/2,width/4,height/12); fill(255); text("25C",width/2-width/4,height/2); //button 5
  fill(255,150,3); 
  rect(width/2+width/4,height/2,width/4,height/12);fill(255); text("26C",width/2+width/4,height/2,height/2); //button 6
  
  fill(255,155,3); 
  rect(width/2-width/4,height/2+height/8,width/4,height/12);fill(255); text("27C",width/2-width/4,height/2+height/8); //button 7
  fill(255,160,3); 
  rect(width/2+width/4,height/2+height/8,width/4,height/12);fill(255); text("28C",width/2+width/4,height/2+height/8); //button 8
  
  fill(255,135,3); 
  rect(width/2-width/4,height/2-height/8,width/4,height/12);fill(255); text("23C",width/2-width/4,height/2-height/8); //button 3
  fill(255,140,3); 
  rect(width/2+width/4,height/2-height/8,width/4,height/12);fill(255); text("24C",width/2+width/4,height/2-height/8); //button 4
  
  fill(#30A217); 
  rect(width/2-width/4,height/2-height/4,width/4,height/12);fill(255); text("Turn ON",width/2-width/4,height/2-height/4); //button 1
  fill(#FF0313); 
  rect(width/2+width/4,height/2-height/4,width/4,height/12);fill(255); text("Turn OFF",width/2+width/4,height/2-height/4); //button 2
  
  fill(255,165,3); 
  rect(width/2-width/4,height/2+height/4,width/4,height/12);fill(255); text("29C",width/2-width/4,height/2+height/4); //button 9
  fill(255,170,3); 
  rect(width/2+width/4,height/2+height/4,width/4,height/12);fill(255); text("30C",width/2+width/4,height/2+height/4); //button 10
}

void read_buttons()
{
    if (mousePressed && click_flag==true) 
  {
  color_val = get(mouseX, mouseY);
  click_flag=false;
  println(color_val);
  if (color_val==-13589993)
  {byte[] data = {'0'};
   bt.broadcast(data);}
   
  if (color_val==-64749)
  {byte[] data = {'1'};
   bt.broadcast(data);}
   
  if (color_val==-30973)
  {byte[] data = {'2'};
   bt.broadcast(data);}
   
  if (color_val==-29693)
  {byte[] data = {'3'};
   bt.broadcast(data);}
   
  if (color_val==-28413)
  {byte[] data = {'4'};
   bt.broadcast(data);}
   
  if (color_val==-27133)
  {byte[] data = {'5'};
   bt.broadcast(data);}
   
  if (color_val==-25853)
  {byte[] data = {'6'};
   bt.broadcast(data);}
   
  if (color_val==-24573)
  {byte[] data = {'7'};
   bt.broadcast(data);}
   
  if (color_val==-23293)
  {byte[] data = {'8'};
   bt.broadcast(data);}
   
  if (color_val==-22013)
  {byte[] data = {'9'};
   bt.broadcast(data);}
  
  
  color_val=0;
  }
  
}


void mouseReleased()
{
  click_flag=true;
}

//**Draw function**//
void draw() //The infinite loop
{
 background(#2C39BF);
 imageMode(CENTER);
 image(logo, width/2, height/1.04, width, height/12);
 textSize(80); fill(#B705FF);
 text("Arduino based AC Remote",width/2,height/8);
  load_buttons();
  read_buttons();
  BT_info();
  
  if (mousePressed && send_flag==true)
   {send_flag=false; }
 

}
///__End of draw__//



void BT_info()
{ 
  textSize(30);
  textAlign(CENTER);
  fill(255);
  cninfo = getBluetoothInformation();    //get connection information status
  text(cninfo,width/2,height-height/1.03);
  noFill();
}